/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.ConcurrentDataModificationException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.exception.ReprojectionRuntimeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.LegendException;
import org.gvsig.fmap.mapcontext.rendering.legend.ZSort;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendContentsChangedListener;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.AbstractLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.DefaultFeatureDrawnNotification;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.DrawUtils;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.LegendDrawingException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.util.Callable;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVectorialLegend
extends AbstractLegend
implements IVectorLegend {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractVectorialLegend.class);
    private static final int DRAW_MAX_ATTEMPTS = 5;
    public static final String VECTORIAL_LEGEND_PERSISTENCE_DEFINITION_NAME = "VectorialLegend";
    private static final String FIELD_HAS_ZSORT = "hasZSort";
    private static final String FIELD_SHAPETYPE = "shapeType";
    private static final String FIELD_DEFAULT_SYMBOL = "defaultSymbol";
    private boolean drawSymbolInEeachPrimitive = true;
    protected ZSort zSort;

    protected AbstractVectorialLegend() {
    }

    public ZSort getZSort() {
        return this.zSort;
    }

    public void setZSort(ZSort zSort) {
        if (zSort == null) {
            this.removeLegendListener((LegendContentsChangedListener)this.zSort);
        }
        this.zSort = zSort;
        this.addLegendListener((LegendContentsChangedListener)zSort);
    }

    public void draw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, Map queryParameters, ICoordTrans coordTrans, FeatureStore featureStore) throws LegendException {
        double dpi = viewPort.getDPI();
        this.draw(image, g, viewPort, cancel, scale, queryParameters, coordTrans, featureStore, null, dpi);
    }

    public void draw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, Map queryParameters, ICoordTrans coordTrans, FeatureStore featureStore, FeatureQuery featureQuery) throws LegendException {
        double dpi = viewPort.getDPI();
        this.draw(image, g, viewPort, cancel, scale, queryParameters, coordTrans, featureStore, featureQuery, dpi);
    }

    public void print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, Map queryParameters, ICoordTrans coordTrans, FeatureStore featureStore, PrintAttributes properties) throws LegendException {
        this.print(g, viewPort, cancel, scale, queryParameters, coordTrans, featureStore, null, properties);
    }

    public void print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, Map queryParameters, ICoordTrans coordTrans, FeatureStore featureStore, FeatureQuery fquery, PrintAttributes properties) throws LegendException {
        double dpi = 72.0;
        int resolution = properties.getPrintQuality();
        if (resolution == 0 || resolution == 1 || resolution == 2) {
            dpi = PrintAttributes.PRINT_QUALITY_DPI[resolution];
        }
        FeatureSet featureSet = null;
        DisposableIterator it = null;
        try {
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            ZSort theZSort = this.getZSort();
            boolean useZSort = false;
            int mapLevelCount = 1;
            if (theZSort != null && (useZSort = theZSort.isUsingZSort())) {
                mapLevelCount = theZSort.getLevelCount();
            }
            for (int mapPass = 0; mapPass < mapLevelCount; ++mapPass) {
                IProjection store_crs;
                Envelope vp_env_in_store_crs;
                if (coordTrans != null) {
                    ICoordTrans inv = coordTrans.getInverted();
                    Envelope aux = viewPort.getAdjustedEnvelope();
                    vp_env_in_store_crs = aux.convert(inv);
                    store_crs = coordTrans.getPOrig();
                } else {
                    vp_env_in_store_crs = viewPort.getAdjustedEnvelope();
                    store_crs = viewPort.getProjection();
                }
                FeatureQuery feat_query = fquery;
                Envelope store_env = featureStore.getEnvelope();
                boolean use_intersection_cond = store_env == null ? true : !vp_env_in_store_crs.contains(store_env);
                if (use_intersection_cond) {
                    String[] fns;
                    Evaluator iee = SpatialEvaluatorsFactory.getInstance().intersects(vp_env_in_store_crs, store_crs, featureStore);
                    if (feat_query == null) {
                        feat_query = featureStore.createFeatureQuery();
                    }
                    for (String fn : fns = this.getRequiredFeatureAttributeNames(featureStore)) {
                        feat_query.addAttributeName(fn);
                    }
                    feat_query.addFilter(iee);
                }
                featureSet = feat_query == null ? featureStore.getFeatureSet() : featureStore.getFeatureSet(feat_query);
                it = featureSet.fastIterator();
                FilteredLogger logger = new FilteredLogger(LOG, "Drawing " + featureStore.getName(), 10);
                while (!cancel.isCanceled() && it.hasNext()) {
                    Feature feat = (Feature)it.next();
                    try {
                        int[] symLevels;
                        ISymbol sym;
                        Geometry geom = feat.getDefaultGeometry();
                        if (geom == null) continue;
                        if (coordTrans != null) {
                            geom = geom.cloneGeometry();
                            geom.reProject(coordTrans);
                        }
                        if ((sym = this.getSymbolByFeature(feat)) == null) continue;
                        if (useZSort && theZSort != null && (symLevels = theZSort.getLevels(sym)) != null) {
                            if (sym instanceof IMultiLayerSymbol) {
                                IMultiLayerSymbol mlSym = (IMultiLayerSymbol)sym;
                                for (int i = 0; i < mlSym.getLayerCount(); ++i) {
                                    ISymbol mySym = mlSym.getLayer(i);
                                    if (symLevels[i] != mapPass) continue;
                                    sym = mySym;
                                    break;
                                }
                            } else if (symLevels[0] != mapPass) continue;
                        }
                        CartographicSupport csSym = null;
                        int symbolType = sym.getSymbolType();
                        if (symbolType == 1 || geomManager.isSubtype(symbolType, 2) || sym instanceof CartographicSupport) {
                            csSym = (CartographicSupport)sym;
                        }
                        if (csSym == null) {
                            DrawUtils.drawInts(g, viewPort, sym, feat, geom);
                            continue;
                        }
                        DrawUtils.drawInts(g, viewPort, cancel, dpi, sym, feat, geom);
                    }
                    catch (Exception ex) {
                        FeatureReference ref = null;
                        if (feat != null) {
                            ref = feat.getReference();
                        }
                        logger.warn("Can't draw feature (" + ref + ").", (Throwable)ex);
                    }
                }
            }
        }
        catch (DataException e) {
            throw new LegendDrawingException(e);
        }
        finally {
            if (it != null) {
                it.dispose();
            }
            if (featureSet != null) {
                featureSet.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, Map queryParameters, ICoordTrans coordTrans, FeatureStore featureStore, FeatureQuery featureQuery, double dpi) throws LegendException {
        SimpleTaskStatus taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(featureStore.getName());
        taskStatus.add();
        try {
            FeatureStore featureStore2 = featureStore;
            synchronized (featureStore2) {
                this.internalDraw(image, g, viewPort, cancel, scale, queryParameters, coordTrans, featureStore, featureQuery, dpi, taskStatus);
            }
        }
        finally {
            taskStatus.terminate();
            taskStatus.remove();
        }
    }

    protected void internalDraw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, Map queryParameters, ICoordTrans coordTrans, FeatureStore featureStore, FeatureQuery featureQuery, double dpi, SimpleTaskStatus taskStatus) throws LegendDrawingException {
        boolean mustDisposeSelection;
        FeatureSelection selection;
        block23: {
            FeatureSet featureSet;
            DefaultFeatureDrawnNotification drawnNotification;
            block21: {
                block22: {
                    Envelope reprojectedViewPortEnvelope;
                    Envelope reprojectedDataEnvelope;
                    IProjection dataProjection;
                    Envelope dataEnvelope;
                    if (!this.getDefaultSymbol().isShapeVisible()) {
                        return;
                    }
                    if (cancel.isCanceled()) {
                        return;
                    }
                    Envelope viewPortEnvelope = viewPort.getAdjustedEnvelope();
                    try {
                        dataEnvelope = featureStore.getEnvelope();
                        if (coordTrans == null) {
                            dataProjection = featureStore.getDefaultFeatureType().getDefaultSRS();
                            if (dataProjection == null) {
                                dataProjection = viewPort.getProjection();
                            }
                            reprojectedDataEnvelope = dataEnvelope;
                            reprojectedViewPortEnvelope = viewPortEnvelope;
                        } else {
                            dataProjection = coordTrans.getPOrig();
                            reprojectedDataEnvelope = dataEnvelope != null && !dataEnvelope.isEmpty() ? dataEnvelope.convert(coordTrans) : dataEnvelope;
                            reprojectedViewPortEnvelope = viewPortEnvelope != null && !viewPortEnvelope.isEmpty() ? viewPortEnvelope.convert(coordTrans.getInverted()) : viewPortEnvelope;
                        }
                    }
                    catch (DataException e) {
                        throw new LegendDrawingException(e);
                    }
                    if (!(viewPortEnvelope != null && viewPortEnvelope.intersects(reprojectedDataEnvelope) || reprojectedViewPortEnvelope != null && reprojectedViewPortEnvelope.intersects(dataEnvelope))) {
                        return;
                    }
                    boolean containsAll = viewPortEnvelope.contains(reprojectedDataEnvelope) || reprojectedViewPortEnvelope != null && reprojectedViewPortEnvelope.contains(dataEnvelope);
                    drawnNotification = new DefaultFeatureDrawnNotification();
                    if (cancel.isCanceled()) {
                        return;
                    }
                    featureSet = null;
                    selection = null;
                    mustDisposeSelection = false;
                    taskStatus.message("Retrieve selection");
                    if (featureStore.isFeatureSelectionEmpty()) {
                        selection = featureStore.createMemoryFeatureSelection();
                        mustDisposeSelection = true;
                    } else {
                        selection = featureStore.getFeatureSelection();
                        mustDisposeSelection = false;
                    }
                    if (featureQuery == null) {
                        featureQuery = featureStore.createFeatureQuery();
                    }
                    this.completeQuery(featureStore, featureQuery, scale, queryParameters, coordTrans, dataProjection, viewPortEnvelope, containsAll);
                    taskStatus.message("Retrieve data");
                    featureSet = featureStore.getFeatureSet(featureQuery);
                    if (!cancel.isCanceled()) break block21;
                    if (featureSet == null) break block22;
                    featureSet.dispose();
                }
                if (mustDisposeSelection) {
                    DisposeUtils.disposeQuietly((Disposable)selection);
                }
                return;
            }
            try {
                taskStatus.message("Drawing");
                this.drawFeatures(image, g, viewPort, cancel, coordTrans, dpi, drawnNotification, featureSet, selection);
                if (featureSet == null) break block23;
            }
            catch (Throwable e) {
                try {
                    throw new LegendDrawingException(e);
                }
                catch (Throwable throwable) {
                    if (featureSet != null) {
                        featureSet.dispose();
                    }
                    if (mustDisposeSelection) {
                        DisposeUtils.disposeQuietly(selection);
                    }
                    throw throwable;
                }
            }
            featureSet.dispose();
        }
        if (mustDisposeSelection) {
            DisposeUtils.disposeQuietly((Disposable)selection);
        }
    }

    private FeatureQuery completeQuery(FeatureStore featureStore, FeatureQuery featureQuery, double scale, Map queryParameters, ICoordTrans coordTrans, IProjection dataProjection, Envelope viewPortEnvelope, boolean containsAll) throws DataException {
        String[] fieldNames;
        boolean retrievesAllAttributes = featureQuery.hasFilter() && !featureQuery.hasAttributeNames();
        featureQuery.setScale(scale);
        for (String fieldName : fieldNames = this.getRequiredFeatureAttributeNames(featureStore)) {
            if (!StringUtils.isNotBlank((CharSequence)fieldName)) continue;
            featureQuery.addAttributeName(fieldName);
        }
        if (!containsAll) {
            Envelope viewPortEnvelopeInMyProj = viewPortEnvelope;
            if (coordTrans != null) {
                viewPortEnvelopeInMyProj = viewPortEnvelope.convert(coordTrans.getInverted());
            }
            if (dataProjection == null) {
                throw new IllegalArgumentException("Error, the projection parameter value is null");
            }
            Evaluator iee = SpatialEvaluatorsFactory.getInstance().intersects(viewPortEnvelopeInMyProj, dataProjection, featureStore);
            featureQuery.addFilter(iee);
        } else {
            FeatureType ft = featureStore.getDefaultFeatureType();
            ExpressionBuilder expbuilder = ExpressionUtils.createExpressionBuilder();
            featureQuery.addFilter(expbuilder.not_is_null((ExpressionBuilder.Value)expbuilder.column(ft.getDefaultGeometryAttributeName())).toString());
        }
        if (queryParameters != null) {
            for (Map.Entry entry : queryParameters.entrySet()) {
                featureQuery.setQueryParameter((String)entry.getKey(), entry.getValue());
            }
        }
        if (retrievesAllAttributes) {
            featureQuery.retrievesAllAttributes();
        }
        return featureQuery;
    }

    protected void drawFeatures(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, ICoordTrans coordTrans, double dpi, DefaultFeatureDrawnNotification drawnNotification, FeatureSet featureSet, FeatureSelection selection) throws BaseException {
        if (this.isUseZSort()) {
            this.drawFeaturesMultiLayer(image, g, viewPort, cancel, coordTrans, dpi, drawnNotification, featureSet, selection);
        } else {
            this.drawFeaturesSingleLayer(image, g, viewPort, cancel, coordTrans, dpi, drawnNotification, featureSet, selection);
        }
    }

    private void drawFeaturesSingleLayer(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, ICoordTrans coordTrans, double dpi, DefaultFeatureDrawnNotification drawnNotification, FeatureSet featureSet, FeatureSelection selection) throws BaseException {
        try {
            featureSet.accept(obj -> {
                if (cancel.isCanceled()) {
                    throw new VisitCanceledException();
                }
                Feature feat = (Feature)obj;
                this.drawFeatureSingleLayer(image, g, viewPort, cancel, coordTrans, dpi, drawnNotification, feat, selection);
            });
        }
        catch (ConcurrentDataModificationException e) {
            cancel.setCanceled(true);
        }
    }

    private void drawFeatureSingleLayer(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, ICoordTrans coordTrans, double dpi, DefaultFeatureDrawnNotification drawnNotification, Feature feat, FeatureSelection selection) throws MapContextException, CreateGeometryException {
        Geometry geom = feat.getDefaultGeometry();
        if (geom == null) {
            return;
        }
        if (geom.getType() == 16) {
            return;
        }
        ISymbol sym = this.getSymbol(feat, selection, viewPort.getSelectionColor());
        if (sym == null) {
            return;
        }
        if (coordTrans != null) {
            geom = geom.cloneGeometry();
            try {
                geom.reProject(coordTrans);
            }
            catch (ReprojectionRuntimeException re) {
                LOG.warn("Can't reproject geometry " + geom.toString(), (Throwable)re);
                return;
            }
        }
        if (cancel.isCanceled()) {
            return;
        }
        this.drawGeometry(geom, image, feat, sym, viewPort, g, dpi, cancel);
        drawnNotification.setFeature(feat);
        drawnNotification.setDrawnGeometry(geom);
        this.notifyObservers(drawnNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawFeaturesMultiLayer(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, ICoordTrans coordTrans, double dpi, DefaultFeatureDrawnNotification drawnNotification, FeatureSet featureSet, FeatureSelection selection) throws MapContextException, CreateGeometryException, DataException {
        long time = System.currentTimeMillis();
        boolean bSymbolLevelError = false;
        int screenRefreshDelay = (int)(1.0 / (double)MapContext.getDrawFrameRate() * 3.0 * 1000.0);
        BufferedImage[] imageLevels = new BufferedImage[this.getZSort().getLevelCount()];
        Graphics2D[] graphics = new Graphics2D[imageLevels.length];
        for (int i = 0; !cancel.isCanceled() && i < imageLevels.length; ++i) {
            imageLevels[i] = CompatLocator.getGraphicsUtils().createBufferedImage(image.getWidth(), image.getHeight(), image.getType());
            graphics[i] = imageLevels[i].createGraphics();
            graphics[i].setTransform(g.getTransform());
            graphics[i].setRenderingHints(g.getRenderingHints());
        }
        DisposableIterator it = null;
        try {
            it = featureSet.fastIterator();
            while (it.hasNext()) {
                if (cancel.isCanceled()) {
                    return;
                }
                Feature feat = (Feature)it.next();
                bSymbolLevelError |= this.drawFeatureMultiLayer(image, g, viewPort, cancel, coordTrans, dpi, drawnNotification, selection, time, screenRefreshDelay, imageLevels, graphics, feat);
            }
        }
        catch (ConcurrentDataModificationException e) {
            cancel.setCanceled(true);
            return;
        }
        finally {
            DisposeUtils.dispose((Disposable)it);
        }
        g.drawImage((Image)image, 0, 0, null);
        Point2D offset = viewPort.getOffset();
        CompatLocator.getGraphicsUtils().translate(g, offset.getX(), offset.getY());
        for (int i = 0; !cancel.isCanceled() && i < imageLevels.length; ++i) {
            g.drawImage((Image)imageLevels[i], 0, 0, null);
            imageLevels[i] = null;
            graphics[i] = null;
        }
        CompatLocator.getGraphicsUtils().translate(g, -offset.getX(), -offset.getY());
        if (bSymbolLevelError) {
            this.setZSort(null);
        }
    }

    private boolean drawFeatureMultiLayer(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, ICoordTrans coordTrans, double dpi, DefaultFeatureDrawnNotification drawnNotification, FeatureSelection selection, long time, int screenRefreshDelay, BufferedImage[] imageLevels, Graphics2D[] graphics, Feature feat) throws MapContextException, CreateGeometryException {
        Geometry geom = feat.getDefaultGeometry();
        boolean bSymbolLevelError = false;
        long drawingTime = time;
        if (geom == null || geom.getType() == 16) {
            return false;
        }
        ISymbol sym = this.getSymbol(feat, selection, viewPort.getSelectionColor());
        if (sym == null) {
            return false;
        }
        if (coordTrans != null) {
            geom = geom.cloneGeometry();
            geom.reProject(coordTrans);
        }
        if (cancel.isCanceled()) {
            return false;
        }
        int[] symLevels = this.getZSort().getLevels(sym);
        if (sym instanceof IMultiLayerSymbol) {
            IMultiLayerSymbol mlSym = (IMultiLayerSymbol)sym;
            for (int i = 0; !cancel.isCanceled() && i < mlSym.getLayerCount(); ++i) {
                ISymbol mySym = mlSym.getLayer(i);
                int symbolLevel = 0;
                if (symLevels != null) {
                    symbolLevel = symLevels[i];
                } else {
                    bSymbolLevelError = true;
                }
                this.drawGeometry(geom, imageLevels[symbolLevel], feat, mySym, viewPort, graphics[symbolLevel], dpi, cancel);
            }
        } else {
            int symbolLevel = 0;
            if (symLevels != null) {
                symbolLevel = symLevels[0];
            }
            this.drawGeometry(geom, imageLevels[symbolLevel], feat, sym, viewPort, graphics[symbolLevel], dpi, cancel);
        }
        Point2D offset = viewPort.getOffset();
        if (offset.getX() == 0.0 && offset.getY() == 0.0 && System.currentTimeMillis() - drawingTime > (long)screenRefreshDelay) {
            BufferedImage virtualBim = CompatLocator.getGraphicsUtils().createBufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D virtualGraphics = virtualBim.createGraphics();
            virtualGraphics.drawImage((Image)image, 0, 0, null);
            for (int i = 0; !cancel.isCanceled() && i < imageLevels.length; ++i) {
                virtualGraphics.drawImage((Image)imageLevels[i], 0, 0, null);
            }
            g.clearRect(0, 0, image.getWidth(), image.getHeight());
            g.drawImage((Image)virtualBim, 0, 0, null);
            drawingTime = System.currentTimeMillis();
        }
        drawnNotification.setFeature(feat);
        drawnNotification.setDrawnGeometry(geom);
        this.notifyObservers(drawnNotification);
        return bSymbolLevelError;
    }

    private ISymbol getSymbol(Feature feat, FeatureSelection selection, Color selectionColor) throws MapContextException {
        ISymbol sym = this.getSymbolByFeature(feat);
        if (sym != null && selection.isSelected(feat)) {
            sym = sym.getSymbolForSelection(selectionColor);
        }
        return sym;
    }

    private boolean isUseZSort() {
        return this.getZSort() != null && this.getZSort().isUsingZSort();
    }

    private void drawGeometry(Geometry geom, BufferedImage image, Feature feature, ISymbol symbol, ViewPort viewPort, Graphics2D graphics, double dpi, Cancellable cancellable) throws CreateGeometryException {
        if (geom instanceof Aggregate && this.isDrawSymbolInEeachPrimitive()) {
            this.drawAggregate((Aggregate)geom, image, feature, symbol, viewPort, graphics, dpi, cancellable);
        } else {
            if (symbol instanceof CartographicSupport) {
                ((CartographicSupport)symbol).setCartographicContext(viewPort, dpi, geom);
            }
            symbol.draw(graphics, viewPort.getAffineTransform(), geom, feature, cancellable);
        }
    }

    private void drawAggregate(Aggregate aggregate, BufferedImage image, Feature feature, ISymbol symbol, ViewPort viewPort, Graphics2D graphics, double dpi, Cancellable cancellable) throws CreateGeometryException {
        for (int i = 0; i < aggregate.getPrimitivesNumber(); ++i) {
            Primitive prim = aggregate.getPrimitiveAt(i);
            this.drawGeometry((Geometry)prim, image, feature, symbol, viewPort, graphics, dpi, cancellable);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AbstractVectorialLegend clone = (AbstractVectorialLegend)super.clone();
        ZSort theZSort = this.getZSort();
        if (theZSort != null) {
            clone.setZSort(new ZSort((ILegend)clone));
        }
        return clone;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setShapeType(state.getInt(FIELD_SHAPETYPE));
        if (state.getBoolean(FIELD_HAS_ZSORT)) {
            this.setZSort(new ZSort((ILegend)this));
        }
        this.setDefaultSymbol((ISymbol)state.get(FIELD_DEFAULT_SYMBOL));
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_SHAPETYPE, this.getShapeType());
        state.set(FIELD_HAS_ZSORT, this.zSort != null);
        state.set(FIELD_DEFAULT_SYMBOL, (Persistent)this.getDefaultSymbol());
    }

    protected abstract String[] getRequiredFeatureAttributeNames(FeatureStore var1) throws DataException;

    public boolean isDrawSymbolInEeachPrimitive() {
        return this.drawSymbolInEeachPrimitive;
    }

    public void setDrawSymbolInEeachPrimitive(boolean drawSymbolInEeachPrimitive) {
        this.drawSymbolInEeachPrimitive = drawSymbolInEeachPrimitive;
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(AbstractVectorialLegend.VECTORIAL_LEGEND_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(AbstractVectorialLegend.class, AbstractVectorialLegend.VECTORIAL_LEGEND_PERSISTENCE_DEFINITION_NAME, "VectorialLegend persistence definition", null, null);
                definition.extend(manager.getDefinition("Legend"));
                definition.addDynFieldInt(AbstractVectorialLegend.FIELD_SHAPETYPE).setMandatory(true);
                definition.addDynFieldBoolean(AbstractVectorialLegend.FIELD_HAS_ZSORT).setMandatory(true);
                definition.addDynFieldObject(AbstractVectorialLegend.FIELD_DEFAULT_SYMBOL).setClassOfValue(ISymbol.class).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

