/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.rendering.legend.ISingleSymbolLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.AbstractVectorialLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.VectorialUniqueValueLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleSymbolLegend
extends AbstractVectorialLegend
implements ISingleSymbolLegend {
    private static final Logger LOGGER = LoggerFactory.getLogger(VectorialUniqueValueLegend.class);
    public static final String SINGLE_SYMBOL_PERSISTENCE_DEFINITION_NAME = "SimgleSymbolLegend";
    private ISymbol defaultSymbol;
    private int shapeType = 3;

    public SingleSymbolLegend() {
    }

    public SingleSymbolLegend(ISymbol style) {
        this.setDefaultSymbol(style);
    }

    public void setDefaultSymbol(ISymbol s) {
        if (s == null) {
            throw new NullPointerException("Default symbol cannot be null");
        }
        ISymbol old = this.defaultSymbol;
        this.defaultSymbol = s;
        this.fireDefaultSymbolChangedEvent(new SymbolLegendEvent(old, s));
    }

    public ISymbol getSymbol(int recordIndex) {
        return this.defaultSymbol;
    }

    public ISymbol getDefaultSymbol() {
        if (this.defaultSymbol == null) {
            this.defaultSymbol = this.getSymbolManager().createSymbol(this.shapeType);
        }
        return this.defaultSymbol;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public void setShapeType(int shapeType) {
        if (this.shapeType != shapeType) {
            if (this.defaultSymbol == null || this.defaultSymbol.getSymbolType() != shapeType) {
                this.defaultSymbol = this.getSymbolManager().createSymbol(shapeType);
            }
            this.shapeType = shapeType;
        }
    }

    public ISymbol getSymbolByFeature(Feature feat) {
        return this.getDefaultSymbol();
    }

    public void useDefaultSymbol(boolean b) {
        LOGGER.warn("TODO: SingleSymbolLegend.useDefaultSymbol");
    }

    public boolean isUseDefaultSymbol() {
        return true;
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public boolean isSuitableForShapeType(int shapeType) {
        return this.getShapeType() == shapeType;
    }

    public void setFeatureStore(FeatureStore fs) throws DataException {
        LOGGER.warn("TODO: SingleSymbolLegend.useDefaultSymbol");
    }

    @Override
    protected String[] getRequiredFeatureAttributeNames(FeatureStore featureStore) throws DataException {
        if (this.defaultSymbol instanceof AbstractSymbol) {
            return ((AbstractSymbol)this.defaultSymbol).getRequiredFeatureAttributeNames(featureStore);
        }
        return new String[]{featureStore.getDefaultFeatureType().getDefaultGeometryAttributeName()};
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SingleSymbolLegend clone = (SingleSymbolLegend)super.clone();
        if (this.defaultSymbol != null) {
            clone.defaultSymbol = (ISymbol)this.defaultSymbol.clone();
        }
        return clone;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
    }

    public static class RegisterLegend
    implements Callable {
        public Object call() throws Exception {
            MapContextManager manager = MapContextLocator.getMapContextManager();
            manager.registerLegend("SingleSymbol", SingleSymbolLegend.class);
            return true;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(SingleSymbolLegend.SINGLE_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(SingleSymbolLegend.class, SingleSymbolLegend.SINGLE_SYMBOL_PERSISTENCE_DEFINITION_NAME, "SimgleSymbolLegend Persistence definition", null, null);
                definition.extend(manager.getDefinition("VectorialLegend"));
            }
            return true;
        }
    }
}

