/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.fmap.dal.DataTypeUtils;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorialUniqueValueLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendClearEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendContentsChangedListener;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.AbstractClassifiedVectorLegend;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorialUniqueValueLegend
extends AbstractClassifiedVectorLegend
implements IVectorialUniqueValueLegend {
    private static final Logger LOG = LoggerFactory.getLogger(VectorialUniqueValueLegend.class);
    public static final String VECTORIAL_UNIQUE_VALUE_LEGEND_PERSISTENCE_DEFINITION_NAME = "VectorialUniqueValueLegend";
    private static final String FIELD_KEYS = "keys";
    private static final String FIELD_NULL_VALUE_SYMBOL = "nullValueSymbol";
    private static final String FIELD_SELECTED_COLORS = "selectedColors";
    private static final String FIELD_SYMBOLS = "symbols";
    private static final String FIELD_USE_DEFAULT_SYMBOL = "useDefaultSymbol";
    private Map<Object, ISymbol> symbols = this.createSymbolMap();
    private List<Object> keys = new ArrayList<Object>();
    private int shapeType;
    private boolean useDefaultSymbol = false;
    private Color[] selectedColors = null;
    private ISymbol nullValueSymbol = null;

    public VectorialUniqueValueLegend() {
    }

    public VectorialUniqueValueLegend(int shapeType) {
        this.setShapeType(shapeType);
    }

    public void setShapeType(int shapeType) {
        if (this.shapeType != shapeType) {
            if (this.nullValueSymbol == null || this.nullValueSymbol.getSymbolType() != shapeType) {
                ISymbol old = this.nullValueSymbol;
                this.nullValueSymbol = this.getSymbolManager().createSymbol(shapeType);
                this.fireDefaultSymbolChangedEvent(new SymbolLegendEvent(old, this.nullValueSymbol));
            }
            this.shapeType = shapeType;
        }
    }

    public void setValueSymbolByID(int id, ISymbol symbol) {
        ISymbol old = this.symbols.put(this.keys.get(id), symbol);
        this.fireClassifiedSymbolChangeEvent(new SymbolLegendEvent(old, symbol));
    }

    public Object[] getValues() {
        return this.symbols.keySet().toArray(new Object[0]);
    }

    public void addSymbol(Object key, ISymbol symbol) {
        ISymbol resul;
        if (key == null) {
            resul = this.nullValueSymbol;
            this.nullValueSymbol = symbol;
        } else {
            int[] dataTypes = this.getClassifyingFieldTypes();
            if (dataTypes == null) {
                throw new IllegalStateException("Classifying field types must be assigned before adding symbol");
            }
            try {
                DataTypeUtils.coerce((int)dataTypes[0], (Object)key);
            }
            catch (CoercionException ex) {
                throw new IllegalArgumentException("" + dataTypes[0] + " type key expected but received " + Objects.toString(key, "NULL"), ex);
            }
            resul = this.symbols.put(key, symbol);
            if (resul != null) {
                LOG.warn("Warning: the " + key + " key already existed. Resul = " + resul);
                LOG.warn("new symbol :" + symbol.getDescription() + " old symbol = " + resul.getDescription());
            } else {
                this.keys.add(key);
            }
        }
        this.fireClassifiedSymbolChangeEvent(new SymbolLegendEvent(resul, symbol));
    }

    public void delAllSymbols() {
        this.keys.clear();
        ISymbol[] olds = this.symbols.values().toArray(new ISymbol[0]);
        this.symbols.clear();
        this.fireLegendClearEvent(new LegendClearEvent(olds));
    }

    public void clear() {
        this.keys.clear();
        ISymbol[] olds = this.symbols.values().toArray(new ISymbol[0]);
        this.symbols.clear();
        this.removeLegendListener((LegendContentsChangedListener)this.getZSort());
        this.setZSort(null);
        this.fireLegendClearEvent(new LegendClearEvent(olds));
    }

    public String[] getDescriptions() {
        ISymbol[] auxSym = this.getSymbols();
        String[] descriptions = new String[auxSym.length];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = auxSym[i].getDescription();
        }
        return descriptions;
    }

    public ISymbol[] getSymbols() {
        if (this.nullValueSymbol == null || !this.isUseDefaultSymbol()) {
            ISymbol[] symbolList = new ISymbol[this.symbols.size()];
            return this.symbols.values().toArray(symbolList);
        }
        ISymbol[] symbolList = new ISymbol[this.symbols.size() + 1];
        symbolList[0] = this.nullValueSymbol;
        int i = 1;
        Iterator<ISymbol> iterator = this.symbols.values().iterator();
        while (iterator.hasNext()) {
            symbolList[i] = iterator.next();
            ++i;
        }
        return symbolList;
    }

    @Override
    public void setClassifyingFieldNames(String[] fNames) {
        super.setClassifyingFieldNames(fNames);
    }

    public ISymbol getSymbolByFeature(Feature feat) throws MapContextException {
        Object val = null;
        String classifyingFieldName = this.getClassifyingFieldNames()[0];
        try {
            val = feat.get(classifyingFieldName);
        }
        catch (Exception e) {
            LOG.info("Can't get value from field \"" + classifyingFieldName + "\". Return null or defaultSymbol", (Throwable)e);
        }
        ISymbol theSymbol = this.getSymbolByValue(val);
        if (theSymbol != null) {
            return theSymbol;
        }
        if (this.isUseDefaultSymbol()) {
            return this.getDefaultSymbol();
        }
        return null;
    }

    public ISymbol getDefaultSymbol() {
        if (this.nullValueSymbol == null) {
            this.nullValueSymbol = this.getSymbolManager().createSymbol(this.shapeType);
            this.fireDefaultSymbolChangedEvent(new SymbolLegendEvent(null, this.nullValueSymbol));
        }
        return this.nullValueSymbol;
    }

    public void setDefaultSymbol(ISymbol s) {
        ISymbol mySymbol = this.nullValueSymbol;
        if (s == null) {
            throw new NullPointerException("Default symbol cannot be null");
        }
        ISymbol old = mySymbol;
        this.nullValueSymbol = s;
        this.fireDefaultSymbolChangedEvent(new SymbolLegendEvent(old, s));
    }

    public ISymbol getSymbolByValue(Object key) {
        ISymbol symbol = null;
        symbol = key == null ? this.nullValueSymbol : this.symbols.get(key);
        if (symbol == null && this.useDefaultSymbol) {
            symbol = this.getDefaultSymbol();
        }
        return symbol;
    }

    public Object getSymbolKey(ISymbol symbol) {
        if (symbol != null) {
            for (Map.Entry<Object, ISymbol> entry : this.symbols.entrySet()) {
                if (!symbol.equals(entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public void useDefaultSymbol(boolean b) {
        this.useDefaultSymbol = b;
    }

    public boolean isUseDefaultSymbol() {
        return this.useDefaultSymbol;
    }

    public void delSymbol(Object key) {
        this.keys.remove(key);
        ISymbol removedSymbol = this.symbols.remove(key);
        if (removedSymbol != null) {
            this.fireClassifiedSymbolChangeEvent(new SymbolLegendEvent(removedSymbol, null));
        }
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public void replace(ISymbol oldSymbol, ISymbol newSymbol) {
        if (this.symbols.containsValue(oldSymbol)) {
            for (Object key : this.symbols.keySet()) {
                if (!this.symbols.get(key).equals(oldSymbol)) continue;
                this.fireClassifiedSymbolChangeEvent(new SymbolLegendEvent(this.symbols.put(key, newSymbol), newSymbol));
            }
        }
    }

    public Color[] getColorScheme() {
        return this.selectedColors;
    }

    public void setColorScheme(Color[] cc) {
        this.selectedColors = cc;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        VectorialUniqueValueLegend clone = (VectorialUniqueValueLegend)super.clone();
        if (this.nullValueSymbol != null) {
            clone.nullValueSymbol = (ISymbol)this.nullValueSymbol.clone();
        }
        clone.keys = new ArrayList<Object>();
        LegendContentsChangedListener[] list = this.getListeners();
        this.removeListeners(list);
        if (this.symbols != null) {
            clone.symbols = this.createSymbolMap();
            for (Map.Entry<Object, ISymbol> entry : this.symbols.entrySet()) {
                ISymbol symbolClone = (ISymbol)entry.getValue().clone();
                clone.addSymbol(entry.getKey(), symbolClone);
            }
        }
        this.addListeners(list);
        return clone;
    }

    private void addListeners(LegendContentsChangedListener[] list) {
        int len = list.length;
        for (int i = 0; i < len; ++i) {
            this.addLegendListener(list[i]);
        }
    }

    private void removeListeners(LegendContentsChangedListener[] list) {
        int len = list.length;
        for (int i = 0; i < len; ++i) {
            this.removeLegendListener(list[i]);
        }
    }

    @Override
    public void setClassifyingFieldTypes(int[] fieldTypes) {
        Class fieldClass = ToolsLocator.getDataTypesManager().getDefaultClass(fieldTypes[0]);
        if (!Comparable.class.isAssignableFrom(fieldClass)) {
            throw new IllegalArgumentException("Should be comparable");
        }
        super.setClassifyingFieldTypes(fieldTypes);
    }

    private Map<Object, ISymbol> createSymbolMap() {
        final MutableObject convert = new MutableObject();
        return new TreeMap<Object, ISymbol>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (convert.getValue() == null) {
                    int[] classifyingFieldTypes = VectorialUniqueValueLegend.this.getClassifyingFieldTypes();
                    if (classifyingFieldTypes == null) {
                        throw new RuntimeException("Symbols are being added to the legend before assigning classifying fields");
                    }
                    convert.setValue((Object)ToolsLocator.getDataTypesManager().getCoercion(classifyingFieldTypes[0]));
                }
                try {
                    return ObjectUtils.compare((Comparable)((Comparable)((Coercion)convert.getValue()).coerce(o1)), (Comparable)((Comparable)((Coercion)convert.getValue()).coerce(o2)));
                }
                catch (CoercionException ex) {
                    throw new RuntimeException("Not able to coerce values in symbol map");
                }
            }
        });
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.keys = new ArrayList<Object>((List)state.get(FIELD_KEYS));
        this.nullValueSymbol = (ISymbol)state.get(FIELD_NULL_VALUE_SYMBOL);
        this.selectedColors = (Color[])state.getArray(FIELD_SELECTED_COLORS, Color.class);
        Map persistedSymbolMap = (Map)state.get(FIELD_SYMBOLS);
        if (persistedSymbolMap != null) {
            this.symbols.putAll(persistedSymbolMap);
        }
        this.useDefaultSymbol(state.getBoolean(FIELD_USE_DEFAULT_SYMBOL));
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_KEYS, this.keys);
        state.set(FIELD_NULL_VALUE_SYMBOL, (Persistent)this.nullValueSymbol);
        state.set(FIELD_SELECTED_COLORS, (Object[])this.selectedColors);
        state.set(FIELD_USE_DEFAULT_SYMBOL, this.isUseDefaultSymbol());
        state.set(FIELD_SYMBOLS, this.symbols);
    }

    public static class RegisterLegend
    implements Callable {
        public Object call() throws Exception {
            MapContextManager manager = MapContextLocator.getMapContextManager();
            manager.registerLegend("VectorialUniqueValue", VectorialUniqueValueLegend.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(VectorialUniqueValueLegend.VECTORIAL_UNIQUE_VALUE_LEGEND_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(VectorialUniqueValueLegend.class, VectorialUniqueValueLegend.VECTORIAL_UNIQUE_VALUE_LEGEND_PERSISTENCE_DEFINITION_NAME, "VectorialUniqueValueLegend Persistence definition", null, null);
                definition.extend(manager.getDefinition("ClassifiedVectorLegend"));
                definition.addDynFieldList(VectorialUniqueValueLegend.FIELD_KEYS).setClassOfItems(Object.class);
                definition.addDynFieldObject(VectorialUniqueValueLegend.FIELD_NULL_VALUE_SYMBOL).setClassOfValue(ISymbol.class);
                definition.addDynFieldList(VectorialUniqueValueLegend.FIELD_SELECTED_COLORS).setClassOfItems(Color.class);
                definition.addDynFieldMap(VectorialUniqueValueLegend.FIELD_SYMBOLS).setClassOfItems(ISymbol.class);
                definition.addDynFieldBoolean(VectorialUniqueValueLegend.FIELD_USE_DEFAULT_SYMBOL);
            }
            return Boolean.TRUE;
        }
    }
}

