/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling;

import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingMethod;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.EvaluatorCreator;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.LabelClass;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.evaluator.AndEvaluator;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorWithDescriptions;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public class DefaultLabelingMethod
implements ILabelingMethod {
    private static final String FIELD_DEFAULT_LABEL = "defaultLabel";
    private static final String DEFAULT_LABELING_METHOD_PERSISTENCE_DEFINITION_NAME = "DefaultLabelingMethod";
    private ILabelClass defaultLabel;

    public DefaultLabelingMethod() {
    }

    public DefaultLabelingMethod(LabelClass defaultLabel) {
        this();
        this.defaultLabel = defaultLabel;
    }

    public void addLabelClass(ILabelClass lbl) {
        this.defaultLabel = lbl;
    }

    public void deleteLabelClass(ILabelClass lbl) {
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public boolean allowsMultipleClass() {
        return false;
    }

    public void renameLabelClass(ILabelClass lbl, String newName) {
    }

    public FeatureSet getFeatureIteratorByLabelClass(FLyrVect layer, ILabelClass lc, ViewPort viewPort, String[] usedFields) throws DataException {
        FeatureStore featureStore = layer.getFeatureStore();
        if (viewPort == null && usedFields == null) {
            return featureStore.getFeatureSet();
        }
        FeatureQuery featureQuery = featureStore.createFeatureQuery();
        if (usedFields != null) {
            featureQuery.setAttributeNames(usedFields);
        }
        Envelope viewPortEnvelope = viewPort.getAdjustedEnvelope();
        ICoordTrans coordTrans = layer.getCoordTrans();
        if (coordTrans != null) {
            Envelope envelopeConverted;
            viewPortEnvelope = envelopeConverted = viewPortEnvelope.convert(coordTrans.getInverted());
        }
        Evaluator eva = null;
        if (viewPort != null) {
            eva = SpatialEvaluatorsFactory.getInstance().intersects(viewPortEnvelope, layer.getProjection(), featureStore);
        }
        if (lc.getSQLQuery() != null && lc.getSQLQuery().trim().length() > 0) {
            Evaluator vp_eva = eva;
            AndEvaluator and_eva = new AndEvaluator(vp_eva);
            String sql_str = lc.getSQLQuery();
            EvaluatorWithDescriptions sql_eval = EvaluatorCreator.getEvaluator(sql_str);
            and_eva.addEvaluator((Evaluator)sql_eval);
            eva = and_eva;
        }
        featureQuery.setFilter(eva);
        return featureStore.getFeatureSet(featureQuery);
    }

    public boolean definesPriorities() {
        return false;
    }

    public void setDefinesPriorities(boolean flag) {
    }

    public ILabelClass getLabelClassByName(String labelName) {
        return this.defaultLabel;
    }

    public void clearAllClasses() {
        this.defaultLabel = null;
    }

    public ILabelClass[] getLabelClasses() {
        ILabelClass[] iLabelClassArray;
        if (this.defaultLabel == null) {
            iLabelClassArray = new ILabelClass[]{};
        } else {
            ILabelClass[] iLabelClassArray2 = new ILabelClass[1];
            iLabelClassArray = iLabelClassArray2;
            iLabelClassArray2[0] = this.defaultLabel;
        }
        return iLabelClassArray;
    }

    public ILabelingMethod cloneMethod() {
        return new DefaultLabelingMethod();
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.defaultLabel = (ILabelClass)state.get(FIELD_DEFAULT_LABEL);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(FIELD_DEFAULT_LABEL, (Persistent)this.defaultLabel);
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(DefaultLabelingMethod.DEFAULT_LABELING_METHOD_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(DefaultLabelingMethod.class, DefaultLabelingMethod.DEFAULT_LABELING_METHOD_PERSISTENCE_DEFINITION_NAME, "DefaultLabelingMethod Persistence definition", null, null);
                definition.addDynFieldObject(DefaultLabelingMethod.FIELD_DEFAULT_LABEL).setMandatory(false).setClassOfValue(ILabelClass.class);
            }
            return Boolean.TRUE;
        }
    }
}

