/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelClass;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelLocationMetrics;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ITextSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.ILabelStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractCartographicSupport;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.CartographicSupportToolkit;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.impl.SimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentContext;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.persistence.spi.PersistentContextServices;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelClass
extends AbstractCartographicSupport
implements ILabelClass {
    private static final String FIELD_REFERENCE_SYSTEM = "referenceSystem";
    private static final String FIELD_UNIT = "unit";
    private static final String FIELD_SQL_QUERY = "sqlQuery";
    private static final String FIELD_SCALE = "scale";
    private static final String FIELD_PRIORITY = "priority";
    private static final String FIELD_TEXTS = "texts";
    private static final String FIELD_LABEL_STYLE = "labelStyle";
    private static final String FIELD_VISIBLE = "visible";
    private static final String FIELD_LABEL_EXPRESSIONS = "labelExpressions";
    private static final String FIELD_TEXT_SYMBOL = "textSymbol";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_IS_USESQL = "useSQL";
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(GeometryManager.class);
    private static final String LABEL_CLASS_PERSISTENCE_DEFINITION_NAME = "LabelClass";
    private String theName = "";
    private ITextSymbol textSymbol;
    private String[] labelExpressions = new String[0];
    private boolean isVisible = true;
    private ILabelStyle labelStyle;
    private String[] texts;
    private int priority;
    private String sqlQuery;
    private boolean usesSQL;

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isVisible(double scale) {
        return this.isVisible();
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public String[] getLabelExpressions() {
        return this.labelExpressions;
    }

    public void setLabelExpressions(String[] lbl_exps) {
        this.labelExpressions = lbl_exps == null ? new String[0] : lbl_exps;
    }

    public ITextSymbol getTextSymbol() {
        if (this.textSymbol == null) {
            this.textSymbol = new SimpleTextSymbol();
        }
        return this.textSymbol;
    }

    private Dimension getSize() {
        if (this.labelStyle == null) {
            if (this.texts != null && this.texts.length > 0) {
                String t = "";
                for (String text : this.texts) {
                    t = t + text;
                }
                this.getTextSymbol().setText(t);
            }
            Rectangle bounds = this.getTextSymbol().getBounds();
            bounds.setLocation((int)Math.round(bounds.getX()), (int)Math.round(bounds.getY() + bounds.getHeight()));
            return new Dimension(bounds.width, bounds.height);
        }
        this.labelStyle.setTextFields(this.texts);
        return this.labelStyle.getSize();
    }

    public void setTextSymbol(ITextSymbol textSymbol) {
        this.textSymbol = textSymbol;
        if (textSymbol == null) {
            this.textSymbol = new SimpleTextSymbol();
        }
    }

    public void setLabelStyle(ILabelStyle labelStyle) {
        this.labelStyle = labelStyle;
    }

    public ILabelStyle getLabelStyle() {
        return this.labelStyle;
    }

    public String getName() {
        return this.theName;
    }

    public void setName(String name) {
        this.theName = name == null ? "" : name;
    }

    public String toString() {
        return this.getName();
    }

    public void setTexts(String[] texts) {
        this.texts = null;
        this.texts = texts;
    }

    public String[] getTexts() {
        return this.texts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D graphics, ILabelLocationMetrics llm, Geometry geom) {
        Dimension size;
        int width;
        if (this.labelStyle != null) {
            CartographicSupport.copyCartographicContext((CartographicSupport)this, (Object)this.labelStyle);
        }
        if ((width = (int)this.toCartographicUnits(Math.round((size = this.getSize()).getWidth()))) < 1) {
            return;
        }
        int height = (int)this.toCartographicUnits(Math.round(size.getHeight()));
        if (height < 1) {
            return;
        }
        Rectangle r = new Rectangle(0, 0, width, height);
        try {
            Point anchor = geomManager.createPoint(llm.getAnchor().getX(), llm.getAnchor().getY(), 0);
            double xAnchor = anchor.getX();
            double yAnchor = anchor.getY();
            double theta = llm.getRotation();
            graphics.translate(xAnchor, yAnchor);
            graphics.rotate(theta);
            LabelClass labelClass = this;
            synchronized (labelClass) {
                CartographicSupport.copyCartographicContext((CartographicSupport)this, (Object)this.textSymbol);
                float fontSizeBefore = this.textSymbol.getFont().getSize2D();
                try {
                    this.drawInsideRectangle(graphics, r);
                }
                catch (SymbolDrawingException e) {
                    logger.warn("Error drawing", (Throwable)e);
                }
            }
            graphics.rotate(-theta);
            graphics.translate(-xAnchor, -yAnchor);
        }
        catch (CreateGeometryException e1) {
            logger.warn("Error creating a point", (Throwable)e1);
        }
    }

    private void relativeToAbsolute(double[] xy, Rectangle r, double ratioLabel, double ratioViewPort) {
        int x;
        int y;
        if (ratioViewPort > ratioLabel) {
            y = (int)((double)r.height * xy[1]);
            x = (int)(0.5 * (double)r.width - (0.5 - xy[0]) * (ratioLabel * (double)r.height));
        } else {
            x = (int)((double)r.width * xy[0]);
            y = (int)(0.5 * (double)r.height - (0.5 - xy[1]) * ((double)r.width / ratioLabel));
        }
        xy[0] = x;
        xy[1] = y;
    }

    public void drawInsideRectangle(Graphics2D graphics, Rectangle bounds) throws SymbolDrawingException {
        if (this.labelStyle != null) {
            CartographicSupport.copyCartographicContext((CartographicSupport)this, (Object)this.labelStyle);
            this.labelStyle.drawInsideRectangle(graphics, bounds);
            Rectangle2D[] textBounds = this.labelStyle.getTextBounds();
            Dimension labelSz = this.getSize();
            double ratioLabel = labelSz.getWidth() / labelSz.getHeight();
            double ratioViewPort = bounds.getWidth() / bounds.getHeight();
            double[] xy = new double[2];
            if (textBounds.length > 0 && this.texts != null) {
                for (int i = 0; i < textBounds.length && i < this.texts.length; ++i) {
                    this.getTextSymbol().setText(this.texts[i]);
                    Rectangle2D textFieldArea = textBounds[i];
                    xy[0] = textFieldArea.getX();
                    xy[1] = textFieldArea.getY();
                    this.relativeToAbsolute(xy, bounds, ratioLabel, ratioViewPort);
                    int x = (int)Math.round(xy[0]);
                    int y = (int)Math.round(xy[1]);
                    xy[0] = textFieldArea.getMaxX();
                    xy[1] = textFieldArea.getMaxY();
                    this.relativeToAbsolute(xy, bounds, ratioLabel, ratioViewPort);
                    int width = (int)Math.round(xy[0]) - x;
                    int height = (int)Math.round(xy[1] - (double)y);
                    Rectangle textRect = new Rectangle(x, y, width, height);
                    Shape oldClip = graphics.getClip();
                    graphics.setClip(textRect);
                    this.getTextSymbol().drawInsideRectangle(graphics, null, textRect);
                    graphics.setClip(oldClip);
                }
            }
        } else {
            if (this.texts != null && this.texts.length > 0) {
                String fullText = "";
                for (String text : this.texts) {
                    fullText = fullText + text;
                }
                this.getTextSymbol().setText(fullText);
            }
            this.getTextSymbol().drawInsideRectangle(graphics, null, bounds);
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public Geometry getShape(ILabelLocationMetrics llm) throws CreateGeometryException {
        if (llm == null) {
            return null;
        }
        Point2D anchor = llm.getAnchor();
        double theta = llm.getRotation();
        Rectangle bounds = this.getBounds();
        AffineTransform at = AffineTransform.getTranslateInstance(anchor.getX(), anchor.getY());
        at.concatenate(AffineTransform.getRotateInstance(theta));
        Polygon returnedValue = geomManager.createPolygon(0);
        returnedValue.addVertex(bounds.getMinX(), bounds.getMinY());
        returnedValue.addVertex(bounds.getMinX(), bounds.getMaxY());
        returnedValue.addVertex(bounds.getMaxX(), bounds.getMaxY());
        returnedValue.addVertex(bounds.getMaxX(), bounds.getMinY());
        returnedValue.addVertex(bounds.getMinX(), bounds.getMinY());
        returnedValue.transform(at);
        return returnedValue;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public double getCartographicSize(ViewPort viewPort, double dpi, Geometry geom) {
        Dimension sz = this.getSize();
        double width = sz.getWidth();
        double height = sz.getHeight();
        return CartographicSupportToolkit.getCartographicLength((CartographicSupport)this, (double)Math.max(width, height), (ViewPort)viewPort, (double)dpi);
    }

    public void setReferenceSystem(int referenceSystem) {
        super.setReferenceSystem(referenceSystem);
        if (this.textSymbol != null && this.textSymbol instanceof CartographicSupport) {
            ((CartographicSupport)this.textSymbol).setReferenceSystem(referenceSystem);
        }
    }

    public void setUnit(int unitIndex) {
        super.setUnit(unitIndex);
        if (this.textSymbol != null && this.textSymbol instanceof CartographicSupport) {
            ((CartographicSupport)this.textSymbol).setUnit(unitIndex);
        }
    }

    public Rectangle getBounds() {
        Dimension cBounds = this.getSize();
        return new Rectangle(0, 0, Math.round(cBounds.width), Math.round(cBounds.height));
    }

    public String getSQLQuery() {
        if (this.sqlQuery == null) {
            this.sqlQuery = "";
        }
        return this.sqlQuery;
    }

    public void setSQLQuery(String sqlQuery) {
        this.sqlQuery = sqlQuery;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(FIELD_NAME, this.getName());
        state.set(FIELD_TEXT_SYMBOL, (Persistent)this.getTextSymbol());
        state.set(FIELD_LABEL_EXPRESSIONS, this.getLabelExpressions());
        state.set(FIELD_VISIBLE, this.isVisible());
        ILabelStyle sty = this.getLabelStyle();
        if (sty != null) {
            state.set(FIELD_LABEL_STYLE, (Persistent)this.getLabelStyle());
        }
        state.set(FIELD_TEXTS, this.getTexts());
        state.set(FIELD_PRIORITY, this.getPriority());
        state.set(FIELD_SCALE, 1.0);
        state.set(FIELD_SQL_QUERY, this.getSQLQuery());
        state.set(FIELD_IS_USESQL, this.isUseSqlQuery());
        state.set(FIELD_UNIT, this.getUnit());
        state.set(FIELD_REFERENCE_SYSTEM, this.getReferenceSystem());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.setName(state.getString(FIELD_NAME));
        this.setTextSymbol((ITextSymbol)state.get(FIELD_TEXT_SYMBOL));
        this.setLabelExpressions(state.getStringArray(FIELD_LABEL_EXPRESSIONS));
        this.setVisible(state.getBoolean(FIELD_VISIBLE));
        if (state.hasValue(FIELD_LABEL_STYLE)) {
            this.setLabelStyle((ILabelStyle)state.get(FIELD_LABEL_STYLE));
        }
        this.setTexts((String[])state.getArray(FIELD_TEXTS, String.class));
        this.setPriority(state.getInt(FIELD_PRIORITY));
        double scale = state.getDouble(FIELD_SCALE);
        this.setUseSqlQuery(state.getBoolean(FIELD_IS_USESQL));
        this.setSQLQuery(state.getString(FIELD_SQL_QUERY));
        this.setUnit(state.getInt(FIELD_UNIT));
        this.setReferenceSystem(state.getInt(FIELD_REFERENCE_SYSTEM));
    }

    public void setUseSqlQuery(boolean use_sql) {
        this.usesSQL = use_sql;
    }

    public boolean isUseSqlQuery() {
        return this.usesSQL;
    }

    public String getStringLabelExpression() {
        String expr = "";
        if (this.labelExpressions != null && this.labelExpressions.length > 0) {
            for (int i = 0; i < this.labelExpressions.length - 1; ++i) {
                expr = expr + this.labelExpressions[i] + ":";
            }
            expr = expr + this.labelExpressions[this.labelExpressions.length - 1];
        } else {
            expr = "";
        }
        return expr;
    }

    public Object clone() throws CloneNotSupportedException {
        Object resp;
        PersistentState state;
        PersistenceManager persman = ToolsLocator.getPersistenceManager();
        try {
            state = persman.getState((Object)this, true);
        }
        catch (PersistenceException e) {
            logger.warn("Can't clone, return me !!!!!!!!!!!!!!", (Throwable)e);
            return this;
        }
        PersistentContext context = state.getContext();
        if (context instanceof PersistentContextServices) {
            ((PersistentContextServices)context).clear();
        }
        try {
            resp = persman.create(state);
        }
        catch (Exception e) {
            logger.warn("Can't clone, return me !!!!!!!!!!!!!!", (Throwable)e);
            return this;
        }
        return resp;
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(LabelClass.LABEL_CLASS_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(LabelClass.class, LabelClass.LABEL_CLASS_PERSISTENCE_DEFINITION_NAME, "LabelClass Persistence definition", null, null);
                definition.addDynFieldString(LabelClass.FIELD_NAME).setMandatory(true);
                definition.addDynFieldObject(LabelClass.FIELD_TEXT_SYMBOL).setMandatory(true).setClassOfValue(ITextSymbol.class);
                definition.addDynFieldArray(LabelClass.FIELD_LABEL_EXPRESSIONS).setClassOfItems(String.class).setMandatory(true);
                definition.addDynFieldBoolean(LabelClass.FIELD_VISIBLE).setMandatory(true);
                definition.addDynFieldObject(LabelClass.FIELD_LABEL_STYLE).setMandatory(false).setClassOfValue(ILabelStyle.class);
                definition.addDynFieldList(LabelClass.FIELD_TEXTS).setMandatory(true).setClassOfItems(String.class);
                definition.addDynFieldInt(LabelClass.FIELD_PRIORITY).setMandatory(true);
                definition.addDynFieldDouble(LabelClass.FIELD_SCALE).setMandatory(true);
                definition.addDynFieldString(LabelClass.FIELD_SQL_QUERY).setMandatory(true);
                definition.addDynFieldBoolean(LabelClass.FIELD_IS_USESQL).setMandatory(true);
                definition.addDynFieldInt(LabelClass.FIELD_UNIT).setMandatory(true);
                definition.addDynFieldInt(LabelClass.FIELD_REFERENCE_SYSTEM).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

