/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.fmap.mapcontext.rendering.symbols.IWarningSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IMarkerFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.AbstractFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol_v2;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IMarkerFillPropertiesStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.SimpleMarkerFillPropertiesStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerFillSymbol
extends AbstractFillSymbol
implements IMarkerFillSymbol {
    private static final Logger logger = LoggerFactory.getLogger(MarkerFillSymbol.class);
    public static final String MARK_FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME = "MarkerFillSymbol";
    private static final String MARKER_SYMBOL = "markerSymbol";
    private static final String SELECTION_SYMBOL = "selectionSymbol";
    private static final String MARKER_FILL_PROPERTIES = "markerFillProperties";
    private static final String PREVIOUS_MARKERSIZE = "previousMarkerSize";
    public static final int RANDOM_FILL = 3;
    public static final int GRID_FILL = 1;
    public static final int SINGLE_CENTERED_SYMBOL = 2;
    public static int DefaultFillStyle = 1;
    private MarkerFillSymbol selectionSymbol;
    private IMarkerFillPropertiesStyle markerFillProperties = new SimpleMarkerFillPropertiesStyle();
    private IMarkerSymbol markerSymbol = (IMarkerSymbol)MapContextLocator.getSymbolManager().createSymbol("marker");

    public ISymbol getSymbolForSelection(Color selectionColor) {
        if (this.selectionSymbol == null) {
            this.selectionSymbol = (MarkerFillSymbol)this.cloneForSelection(selectionColor);
            this.selectionSymbol.setMarker((IMarkerSymbol)this.selectionSymbol.getMarker().getSymbolForSelection(selectionColor));
            this.selectionSymbol.setFillColor(selectionColor);
        } else {
            this.selectionSymbol.setColor(selectionColor);
        }
        if (this.selectionSymbol instanceof CartographicSupport) {
            this.selectionSymbol.setUnit(this.getUnit());
        }
        if (this.selectionSymbol.getMarker() instanceof CartographicSupport) {
            this.selectionSymbol.getMarker().setUnit(this.getUnit());
        }
        return this.selectionSymbol;
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle rect) {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        Point centroid = null;
        if (this.markerSymbol instanceof CartographicSupport) {
            this.markerSymbol.setCartographicContext(this.getCartographicContext());
        }
        if (rect != null) {
            geom = this.getSampleGeometry(rect);
        }
        switch (this.markerFillProperties.getFillStyle()) {
            case 2: {
                try {
                    centroid = geom.centroid();
                }
                catch (Exception e2) {
                    logger.warn("Can't get centroid", (Throwable)e2);
                }
                Point p = null;
                if (centroid != null && !Double.isNaN(centroid.getX()) && !Double.isNaN(centroid.getY())) {
                    double pX = centroid.getX() + this.markerFillProperties.getXOffset();
                    double pY = centroid.getY() + this.markerFillProperties.getYOffset();
                    try {
                        p = geometryManager.createPoint(pX, pY, 0);
                    }
                    catch (CreateGeometryException e) {
                        logger.error("Can't create the point (" + pX + "," + pY + ")", (Throwable)e);
                    }
                    if (p == null) break;
                    if (this.markerSymbol instanceof IMarkerSymbol_v2) {
                        ((IMarkerSymbol_v2)this.markerSymbol).draw(g, affineTransform, (Geometry)p, f, null, null);
                        break;
                    }
                    this.markerSymbol.draw(g, affineTransform, (Geometry)p, f, null);
                    break;
                }
                Envelope env = geom.getEnvelope();
                double pX = env.getCenter(0);
                double pY = env.getCenter(1);
                try {
                    p = geometryManager.createPoint(pX, pY, 0);
                }
                catch (CreateGeometryException e) {
                    logger.error("Can't create the point (" + pX + "," + pY + ")", (Throwable)e);
                }
                if (p == null) break;
                if (this.markerSymbol instanceof IMarkerSymbol_v2) {
                    ((IMarkerSymbol_v2)this.markerSymbol).draw(g, affineTransform, (Geometry)p, f, null, null);
                    break;
                }
                this.markerSymbol.draw(g, affineTransform, (Geometry)p, f, null);
                break;
            }
            case 1: {
                Rectangle rClip = null;
                if (g.getClipBounds() != null) {
                    rClip = (Rectangle)g.getClipBounds().clone();
                    g.setClip(rClip.x, rClip.y, rClip.width, rClip.height);
                }
                g.clip(geom.getShape(affineTransform));
                int size = (int)this.toCartographicUnits(this.markerSymbol.getSize());
                Dimension maxSize = ToolsSwingLocator.getToolsSwingManager().getMaxPhysicalSizeOfBufferedImage();
                if (size > 0 && size <= maxSize.width && size <= maxSize.height) {
                    Rectangle rProv = new Rectangle();
                    rProv.setFrame(0.0, 0.0, size, size);
                    TexturePaint resulPatternFill = null;
                    double xSeparation = this.toCartographicUnits(this.markerFillProperties.getXSeparation());
                    double ySeparation = this.toCartographicUnits(this.markerFillProperties.getYSeparation());
                    double xOffset = this.toCartographicUnits(this.markerFillProperties.getXOffset());
                    double yOffset = this.toCartographicUnits(this.markerFillProperties.getYOffset());
                    BufferedImage sample = null;
                    Graphics2D gAux = null;
                    if (size <= 0) break;
                    sample = new BufferedImage(size, size, 2);
                    gAux = sample.createGraphics();
                    try {
                        this.markerSymbol.drawInsideRectangle(gAux, gAux.getTransform(), rProv);
                    }
                    catch (SymbolDrawingException e) {
                        if (e.getType() == 0) {
                            try {
                                IWarningSymbol warning = MapContextLocator.getSymbolManager().getWarningSymbol(SymbolDrawingException.STR_UNSUPPORTED_SET_OF_SETTINGS, "", 0);
                                warning.drawInsideRectangle(gAux, gAux.getTransform(), rProv);
                            }
                            catch (SymbolDrawingException symbolDrawingException) {}
                        }
                        throw new Error(Messages.getText((String)"symbol_shapetype_mismatch"));
                    }
                    rProv.setRect(xOffset, yOffset, rProv.getWidth() + xSeparation, rProv.getHeight() + ySeparation);
                    BufferedImage bi = new BufferedImage(rProv.width, rProv.height, 2);
                    gAux = bi.createGraphics();
                    gAux.drawImage(sample, null, 0, 0);
                    resulPatternFill = new TexturePaint(bi, rProv);
                    sample = null;
                    if (gAux != null) {
                        gAux.dispose();
                    }
                    g.setColor(null);
                    g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g.setPaint(resulPatternFill);
                    g.fill(geom.getShape(affineTransform));
                    g.setClip(rClip);
                    bi = null;
                    break;
                }
            }
            case 3: {
                double s = this.markerSymbol.getSize();
                Shape shp = geom.getShape(affineTransform);
                Rectangle r = shp.getBounds();
                int drawCount = (int)(Math.min(r.getWidth(), r.getHeight()) / s);
                Random random = new Random();
                int minx = r.x;
                int miny = r.y;
                int width = r.width;
                int height = r.height;
                r = new Rectangle();
                g.setClip(shp);
                for (int i = 0; !(cancel != null && cancel.isCanceled() || i >= drawCount); ++i) {
                    int x = (int)Math.abs(random.nextDouble() * (double)width);
                    int y = (int)Math.abs(random.nextDouble() * (double)height);
                    x += minx;
                    y += miny;
                    Point p = null;
                    try {
                        p = geometryManager.createPoint((double)x, (double)y, 0);
                    }
                    catch (CreateGeometryException e) {
                        logger.error("Can't create the point (" + x + "," + y + ")", (Throwable)e);
                    }
                    if (p == null) continue;
                    if (this.markerSymbol instanceof IMarkerSymbol_v2) {
                        ((IMarkerSymbol_v2)this.markerSymbol).draw(g, new AffineTransform(), (Geometry)p, f, cancel, null);
                        continue;
                    }
                    this.markerSymbol.draw(g, new AffineTransform(), (Geometry)p, f, cancel);
                }
                g.setClip(null);
                break;
            }
        }
        if (this.getOutline() != null) {
            this.getOutline().setCartographicContext(this.getCartographicContext());
            if (this.getOutline() instanceof ISymbol_v2) {
                ((ISymbol_v2)this.getOutline()).draw(g, affineTransform, geom, f, cancel, null);
            } else {
                this.getOutline().draw(g, affineTransform, geom, f, cancel);
            }
        }
    }

    public int getSymbolType() {
        return 3;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void setMarker(IMarkerSymbol marker) {
        this.markerSymbol = marker;
    }

    public IMarkerSymbol getMarker() {
        return this.markerSymbol;
    }

    public void setMarkerFillProperties(IMarkerFillPropertiesStyle markerFillStyle) {
        this.markerFillProperties = markerFillStyle;
    }

    public IMarkerFillPropertiesStyle getMarkerFillProperties() {
        return this.markerFillProperties;
    }

    @Override
    public void setUnit(int unitIndex) {
        super.setUnit(unitIndex);
        if (this.getMarker() != null) {
            this.getMarker().setUnit(unitIndex);
        }
    }

    public void setReferenceSystem(int system) {
        super.setReferenceSystem(system);
        if (this.getMarker() != null) {
            this.getMarker().setReferenceSystem(system);
        }
    }

    public void setCartographicContext(CartographicSupport.CartographicContext ctx) {
        super.setCartographicContext(ctx);
        IMarkerSymbol marker = this.getMarker();
        if (marker != null) {
            marker.setCartographicContext(ctx);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MarkerFillSymbol copy = (MarkerFillSymbol)((Object)super.clone());
        if (this.markerSymbol != null) {
            copy.markerSymbol = (IMarkerSymbol)this.markerSymbol.clone();
        }
        if (this.selectionSymbol != null) {
            copy.selectionSymbol = (MarkerFillSymbol)((Object)this.selectionSymbol.clone());
        }
        if (this.markerFillProperties != null) {
            copy.markerFillProperties = (IMarkerFillPropertiesStyle)this.markerFillProperties.clone();
        }
        return copy;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.markerSymbol = (IMarkerSymbol)state.get(MARKER_SYMBOL);
        this.selectionSymbol = (MarkerFillSymbol)((Object)state.get(SELECTION_SYMBOL));
        this.markerFillProperties = (IMarkerFillPropertiesStyle)state.get(MARKER_FILL_PROPERTIES);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(MARKER_SYMBOL, (Persistent)this.markerSymbol);
        state.set(SELECTION_SYMBOL, (Persistent)this.selectionSymbol);
        state.set(MARKER_FILL_PROPERTIES, (Persistent)this.markerFillProperties);
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            int[] shapeTypes = new int[]{3, 11, 13, 9};
            manager.registerMultiLayerSymbol("fill", shapeTypes, MarkerFillSymbol.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(MarkerFillSymbol.MARK_FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(MarkerFillSymbol.class, MarkerFillSymbol.MARK_FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME, "MarkerFillSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("FillSymbol"));
                definition.addDynFieldObject(MarkerFillSymbol.MARKER_SYMBOL).setClassOfValue(IMarkerSymbol.class).setMandatory(true);
                definition.addDynFieldObject(MarkerFillSymbol.SELECTION_SYMBOL).setClassOfValue(IMarkerFillSymbol.class).setMandatory(false);
                definition.addDynFieldObject(MarkerFillSymbol.MARKER_FILL_PROPERTIES).setClassOfValue(IMarkerFillPropertiesStyle.class).setMandatory(true);
                definition.addDynFieldDouble(MarkerFillSymbol.PREVIOUS_MARKERSIZE);
            }
            return Boolean.TRUE;
        }
    }
}

