/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IMultiLayerFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.AbstractFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLayerFillSymbol
extends AbstractFillSymbol
implements IFillSymbol,
IMultiLayerSymbol,
IMultiLayerFillSymbol {
    private static final Logger LOG = LoggerFactory.getLogger(MultiLayerFillSymbol.class);
    public static final String MULTILAYER_FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME = "MultiLayerFillSymbol";
    private static final String FIELD_LAYERS = "layers";
    private static final double OPACITY_SELECTION_FACTOR = 0.8;
    private IFillSymbol[] layers = new IFillSymbol[0];
    private MultiLayerFillSymbol selectionSymbol;
    private double[] sizes;

    @Override
    public Color getFillColor() {
        return null;
    }

    @Override
    public ILineSymbol getOutline() {
        return null;
    }

    @Override
    public boolean isSuitableFor(Geometry geom) {
        GeometryType gt = geom.getGeometryType();
        return gt.isTypeOf(3);
    }

    @Override
    public void setFillColor(Color color) {
        for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
            this.layers[i].setFillColor(color);
        }
    }

    @Override
    public void setOutline(ILineSymbol outline) {
        if (this.layers != null && this.layers.length > 0) {
            for (int i = 0; i < this.layers.length - 1; ++i) {
                this.layers[i].setOutline(null);
            }
            this.layers[this.layers.length - 1].setOutline(outline);
        }
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        for (int i = 0; !(cancel != null && cancel.isCanceled() || this.layers == null || i >= this.layers.length); ++i) {
            IFillSymbol layer = this.layers[i];
            if (layer == null) continue;
            if (layer instanceof CartographicSupport) {
                ((CartographicSupport)layer).setCartographicContext(this.getCartographicContext());
            }
            if (layer instanceof ISymbol_v2) {
                ((ISymbol_v2)layer).draw(g, affineTransform, geom, f, cancel, r);
                continue;
            }
            layer.draw(g, affineTransform, geom, f, cancel);
        }
    }

    public ISymbol getSymbolForSelection() {
        if (this.selectionSymbol == null) {
            MultiLayerFillSymbol selectionSymbol = new MultiLayerFillSymbol();
            selectionSymbol.setDescription(this.getDescription());
            for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
                selectionSymbol.addLayer(this.layers[i].getSymbolForSelection());
            }
            this.setSymbolForSelection(selectionSymbol);
        } else {
            for (int i = 0; i < this.selectionSymbol.getLayerCount(); ++i) {
                this.selectionSymbol.setLayer(i, this.selectionSymbol.getLayer(i).getSymbolForSelection());
            }
        }
        if (this.selectionSymbol instanceof CartographicSupport) {
            this.selectionSymbol.setUnit(this.getUnit());
        }
        return this.selectionSymbol;
    }

    public int getSymbolType() {
        return 3;
    }

    public void setLayer(int index, ISymbol layer) throws IndexOutOfBoundsException {
        this.layers[index] = (IFillSymbol)layer;
    }

    public void swapLayers(int index1, int index2) {
        ISymbol aux1 = this.getLayer(index1);
        ISymbol aux2 = this.getLayer(index2);
        this.layers[index2] = (IFillSymbol)aux1;
        this.layers[index1] = (IFillSymbol)aux2;
    }

    public ISymbol getLayer(int layerIndex) {
        return this.layers[layerIndex];
    }

    public int getLayerCount() {
        return this.layers.length;
    }

    public void addLayer(ISymbol newLayer) {
        this.addLayer(newLayer, this.layers.length);
    }

    public void addLayer(ISymbol newLayer, int layerIndex) throws IndexOutOfBoundsException {
        if (newLayer == null) {
            return;
        }
        this.selectionSymbol = null;
        if (layerIndex < 0 || this.layers.length < layerIndex) {
            throw new IndexOutOfBoundsException(layerIndex + " < 0 or " + layerIndex + " > " + this.layers.length);
        }
        ArrayList<Object> newLayers = new ArrayList<Object>();
        newLayers.addAll(Arrays.asList(this.layers));
        try {
            newLayers.add(layerIndex, newLayer);
            this.layers = newLayers.toArray(new IFillSymbol[0]);
        }
        catch (ArrayStoreException asEx) {
            throw new ClassCastException(newLayer.getClass().getName() + " is not an IFillSymbol");
        }
    }

    public boolean removeLayer(ISymbol layer) {
        int capacity = this.layers.length;
        ArrayList<IFillSymbol> lst = new ArrayList<IFillSymbol>(capacity);
        for (int i = 0; this.layers != null && i < capacity; ++i) {
            lst.add(this.layers[i]);
        }
        boolean contains = lst.remove(layer);
        this.layers = lst.toArray(new IFillSymbol[0]);
        return contains;
    }

    @Override
    public void setUnit(int unitIndex) {
        super.setUnit(unitIndex);
        for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
            this.layers[i].setUnit(unitIndex);
        }
    }

    public void setReferenceSystem(int system) {
        super.setReferenceSystem(system);
        for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
            this.layers[i].setReferenceSystem(system);
        }
    }

    @Override
    public int getFillAlpha() {
        double myAlpha = 0.0;
        for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
            double layerAlpha = (double)this.layers[i].getFillAlpha() / 255.0;
            myAlpha += (1.0 - myAlpha) * layerAlpha;
        }
        int result = (int)Math.round(myAlpha * 255.0);
        return result > 255 ? 255 : result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MultiLayerFillSymbol copy = (MultiLayerFillSymbol)((Object)super.clone());
        if (this.layers != null) {
            IFillSymbol[] layersCopy = new IFillSymbol[this.layers.length];
            for (int i = 0; i < this.layers.length; ++i) {
                layersCopy[i] = (IFillSymbol)this.layers[i].clone();
            }
            copy.layers = layersCopy;
        }
        if (this.selectionSymbol != null) {
            copy.selectionSymbol = (MultiLayerFillSymbol)((Object)this.selectionSymbol.clone());
        }
        return copy;
    }

    private void setSymbolForSelection(MultiLayerFillSymbol symbolForSelection) {
        this.selectionSymbol = symbolForSelection;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        LOG.warn("FIXME, fix implement of loadFromState");
        List theLayers = state.getList(FIELD_LAYERS);
        if (theLayers != null) {
            for (int i = 0; i < theLayers.size(); ++i) {
                this.addLayer((ISymbol)theLayers.get(i));
            }
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        LOG.warn("FIXME, fix implement of saveToState");
        state.set(FIELD_LAYERS, (Object[])this.layers);
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            int[] shapeTypes = new int[]{3, 9};
            manager.registerMultiLayerSymbol("fill", shapeTypes, MultiLayerFillSymbol.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(MultiLayerFillSymbol.MULTILAYER_FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(MultiLayerFillSymbol.class, MultiLayerFillSymbol.MULTILAYER_FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME, "MultiLayerFillSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("FillSymbol"));
                definition.addDynFieldList(MultiLayerFillSymbol.FIELD_LAYERS).setClassOfItems(IFillSymbol.class);
            }
            return Boolean.TRUE;
        }
    }
}

