/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.IBackgroundFileStyle;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IPictureFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.AbstractFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.BackgroundFileStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IMarkerFillPropertiesStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.SimpleMarkerFillPropertiesStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PictureFillSymbol
extends AbstractFillSymbol
implements IPictureFillSymbol {
    private static final Logger logger = LoggerFactory.getLogger(PictureFillSymbol.class);
    public static final String PICTURE_FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME = "PictureFillSymbol";
    private static final String SELECTED = "selected";
    private static final String SELECTION_SYMBOL = "selectionSym";
    private static final String BACKGROUND_IMAGE = "bgImage";
    private static final String BACKGROUND_SELECTION_IMAGE = "bgSelImage";
    private static final String ANGLE = "angle";
    private static final String X_SCALE = "xScale";
    private static final String Y_SCALE = "yScale";
    private static final String MARKER_FILL_PROPERTIES = "markerFillProperties";
    private double angle = 0.0;
    private double xScale = 1.0;
    private double yScale = 1.0;
    private transient PictureFillSymbol selectionSym;
    private boolean selected;
    private IMarkerFillPropertiesStyle markerFillProperties = new SimpleMarkerFillPropertiesStyle();
    private BackgroundFileStyle bgImage;
    private BackgroundFileStyle bgSelImage;

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        BackgroundFileStyle bg;
        Color fillColor = this.getFillColor();
        if (r != null) {
            geom = this.getSampleGeometry(r);
        }
        Shape transf_geom = geom.getShape(affineTransform);
        if (fillColor != null) {
            g.setColor(fillColor);
            g.fill(transf_geom);
        }
        g.setClip(transf_geom);
        BackgroundFileStyle backgroundFileStyle = bg = !this.selected ? this.bgImage : this.bgSelImage;
        if (bg != null && bg.getBounds() != null) {
            int sizeW = (int)((double)((int)bg.getBounds().getWidth()) * this.xScale);
            int sizeH = (int)((double)((int)bg.getBounds().getHeight()) * this.yScale);
            Rectangle rProv = new Rectangle();
            rProv.setFrame(0.0, 0.0, sizeW, sizeH);
            BufferedImage sample = new BufferedImage(sizeW, sizeH, 2);
            Graphics2D gAux = sample.createGraphics();
            double xSeparation = this.markerFillProperties.getXSeparation();
            double ySeparation = this.markerFillProperties.getYSeparation();
            double xOffset = this.markerFillProperties.getXOffset();
            double yOffset = this.markerFillProperties.getYOffset();
            try {
                bg.drawInsideRectangle(gAux, rProv);
            }
            catch (SymbolDrawingException e) {
                logger.warn(Messages.getText((String)"label_style_could_not_be_painted"), (Throwable)e);
            }
            Dimension sz = rProv.getSize();
            sz = new Dimension((int)Math.round(sz.getWidth() + xSeparation), (int)Math.round(sz.getHeight() + ySeparation));
            rProv.setSize(sz);
            BufferedImage bi = new BufferedImage(rProv.width, rProv.height, 2);
            gAux = bi.createGraphics();
            gAux.drawImage(sample, null, (int)(xSeparation * 0.5), (int)(ySeparation * 0.5));
            rProv.x += (int)xOffset;
            rProv.y += (int)yOffset;
            TexturePaint resulPatternFill = new TexturePaint(bi, rProv);
            g.setColor(null);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setPaint(resulPatternFill);
        }
        if (this.angle == 0.0) {
            g.fill(transf_geom);
        } else {
            AffineTransform at = new AffineTransform();
            at.rotate(this.angle);
            Geometry pixels_geom = geom.cloneGeometry();
            pixels_geom.transform(affineTransform);
            pixels_geom.transform(at);
            g.rotate(-this.angle);
            g.fill(pixels_geom.getShape());
            g.rotate(this.angle);
        }
        g.setClip(null);
        if (this.getOutline() != null) {
            this.getOutline().setCartographicContext(this.getCartographicContext());
            if (this.getOutline() instanceof ISymbol_v2) {
                ((ISymbol_v2)this.getOutline()).draw(g, affineTransform, geom, null, cancel, null);
            } else {
                this.getOutline().draw(g, affineTransform, geom, null, cancel);
            }
        }
    }

    public PictureFillSymbol() {
    }

    public PictureFillSymbol(URL imageURL, URL selImageURL) throws IOException {
        this.setImage(imageURL);
        if (selImageURL != null) {
            this.setSelImage(selImageURL);
        } else {
            this.setSelImage(imageURL);
        }
    }

    public final void setSelImage(URL selImageUrl) throws IOException {
        this.bgSelImage = BackgroundFileStyle.createStyleByURL(selImageUrl);
    }

    public final void setImage(URL imageUrl) throws IOException {
        this.bgImage = BackgroundFileStyle.createStyleByURL(imageUrl);
    }

    public ISymbol getSymbolForSelection(Color selectionColor) {
        if (this.selectionSym == null) {
            this.selectionSym = (PictureFillSymbol)this.cloneForSelection(selectionColor);
            this.selectionSym.selected = true;
            this.selectionSym.selectionSym = this.selectionSym;
        } else {
            this.selectionSym.setFillColor(selectionColor);
        }
        if (this.selectionSym instanceof CartographicSupport) {
            this.selectionSym.setUnit(this.getUnit());
        }
        return this.selectionSym;
    }

    public int getSymbolType() {
        return 3;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public IMarkerFillPropertiesStyle getMarkerFillProperties() {
        return this.markerFillProperties;
    }

    public void setMarkerFillProperties(IMarkerFillPropertiesStyle prop) {
        this.markerFillProperties = prop;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getXScale() {
        return this.xScale;
    }

    public void setXScale(double xScale) {
        this.xScale = xScale;
    }

    public double getYScale() {
        return this.yScale;
    }

    public void setYScale(double yScale) {
        this.yScale = yScale;
    }

    public URL getSource() {
        if (this.bgImage != null) {
            return this.bgImage.getSource();
        }
        return null;
    }

    public URL getSelectedSource() {
        if (this.bgSelImage != null) {
            return this.bgSelImage.getSource();
        }
        return null;
    }

    @Override
    public double toCartographicSize(ViewPort viewPort, double dpi, Geometry geom) {
        return super.toCartographicSize(viewPort, dpi, geom);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PictureFillSymbol copy = (PictureFillSymbol)((Object)super.clone());
        if (this.selectionSym != null) {
            copy.selectionSym = this == this.selectionSym ? copy : (PictureFillSymbol)((Object)this.selectionSym.clone());
        }
        if (this.bgImage != null) {
            copy.bgImage = (BackgroundFileStyle)((Object)this.bgImage.clone());
        }
        if (this.bgSelImage != null) {
            copy.bgSelImage = (BackgroundFileStyle)((Object)this.bgSelImage.clone());
        }
        return copy;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.selected = (Boolean)state.get(SELECTED);
        this.selectionSym = (PictureFillSymbol)((Object)state.get(SELECTION_SYMBOL));
        this.bgImage = (BackgroundFileStyle)((Object)state.get(BACKGROUND_IMAGE));
        this.bgSelImage = (BackgroundFileStyle)((Object)state.get(BACKGROUND_SELECTION_IMAGE));
        this.angle = (Double)state.get(ANGLE);
        this.xScale = (Double)state.get(X_SCALE);
        this.yScale = (Double)state.get(Y_SCALE);
        this.markerFillProperties = (IMarkerFillPropertiesStyle)state.get(MARKER_FILL_PROPERTIES);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(SELECTED, this.selected);
        state.set(SELECTION_SYMBOL, (Persistent)this.getSymbolForSelection());
        state.set(BACKGROUND_IMAGE, (Persistent)this.bgImage);
        state.set(BACKGROUND_SELECTION_IMAGE, (Persistent)this.bgSelImage);
        state.set(ANGLE, this.angle);
        state.set(X_SCALE, this.xScale);
        state.set(Y_SCALE, this.yScale);
        state.set(MARKER_FILL_PROPERTIES, (Persistent)this.markerFillProperties);
    }

    public IBackgroundFileStyle getBackgroundFileStyle() {
        return this.bgImage;
    }

    public IBackgroundFileStyle getSelectedBackgroundFileStyle() {
        return this.bgSelImage;
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            manager.registerSymbol(PictureFillSymbol.PICTURE_FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME, PictureFillSymbol.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(PictureFillSymbol.PICTURE_FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(PictureFillSymbol.class, PictureFillSymbol.PICTURE_FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME, "PictureFillSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("FillSymbol"));
                definition.addDynFieldBoolean(PictureFillSymbol.SELECTED).setMandatory(false);
                definition.addDynFieldObject(PictureFillSymbol.SELECTION_SYMBOL).setClassOfValue(PictureFillSymbol.class).setMandatory(false);
                definition.addDynFieldObject(PictureFillSymbol.BACKGROUND_IMAGE).setClassOfValue(BackgroundFileStyle.class).setMandatory(false);
                definition.addDynFieldObject(PictureFillSymbol.BACKGROUND_SELECTION_IMAGE).setClassOfValue(BackgroundFileStyle.class).setMandatory(false);
                definition.addDynFieldDouble(PictureFillSymbol.ANGLE).setMandatory(true);
                definition.addDynFieldDouble(PictureFillSymbol.X_SCALE).setMandatory(true);
                definition.addDynFieldDouble(PictureFillSymbol.Y_SCALE).setMandatory(true);
                definition.addDynFieldObject(PictureFillSymbol.MARKER_FILL_PROPERTIES).setClassOfValue(IMarkerFillPropertiesStyle.class).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

