/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.ISimpleFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.impl.AbstractFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.TransparencySupport;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFillSymbol
extends AbstractFillSymbol
implements ISimpleFillSymbol,
TransparencySupport {
    private static final String SIMPLE_FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME = "SimpleFillSymbol";
    private static final Logger LOG = LoggerFactory.getLogger(SimpleFillSymbol.class);
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final String FIELD_SYMBOL_FOR_SELECTION = "symbolForSelection";
    private SimpleFillSymbol symbolForSelection;

    public ISymbol getSymbolForSelection(Color selectionColor) {
        if (this.symbolForSelection == null) {
            SimpleFillSymbol selectionSymbol = (SimpleFillSymbol)this.cloneForSelection(selectionColor);
            if (selectionSymbol != null) {
                selectionSymbol.setHasFill(true);
                this.setSymbolForSelection(selectionSymbol);
            }
        } else {
            this.symbolForSelection.setColor(selectionColor);
        }
        if (this.symbolForSelection instanceof TransparencySupport) {
            this.symbolForSelection.setTransparency(this.getTransparency());
        }
        return this.symbolForSelection;
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        if (r != null) {
            geom = this.getSampleGeometry(r);
        }
        Color c = this.getFillColor();
        try {
            Geometry env = geom.getEnvelope().getGeometry();
            env.transform(affineTransform);
            Envelope env2 = env.getEnvelope();
            if (env2.getLength(0) < 1.5 && env2.getLength(1) < 1.5) {
                Point upperCorner = env2.getUpperCorner();
                int y = (int)upperCorner.getY();
                int x = (int)upperCorner.getX();
                if (c != null && this.hasFill()) {
                    g.setColor(c);
                    g.drawLine(x, y, x, y);
                }
                if (this.getOutline() != null && this.hasOutline()) {
                    g.setColor(this.getOutline().getColor());
                    g.drawLine(x, y, x, y);
                }
                return;
            }
        }
        catch (Exception ex) {
            LOG.warn("Error optimizing the drawing of the geometry. Continues with normal drawing.", (Throwable)ex);
        }
        if (c != null && this.hasFill()) {
            g.setColor(c);
            g.fill(geom.getShape(affineTransform));
        }
        if (this.getOutline() != null && this.hasOutline()) {
            if (this.getOutline() instanceof ISymbol_v2) {
                this.getOutline().setCartographicContext(this.getCartographicContext());
                ((ISymbol_v2)this.getOutline()).draw(g, affineTransform, geom, f, cancel, null);
            } else {
                this.getOutline().draw(g, affineTransform, geom, f, cancel);
            }
        }
    }

    public int getSymbolType() {
        return 3;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SimpleFillSymbol copy = (SimpleFillSymbol)((Object)super.clone());
        if (this.symbolForSelection != null) {
            copy.symbolForSelection = (SimpleFillSymbol)((Object)this.symbolForSelection.clone());
        }
        return copy;
    }

    private void setSymbolForSelection(SimpleFillSymbol symbolForSelection) {
        this.symbolForSelection = symbolForSelection;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setSymbolForSelection((SimpleFillSymbol)((Object)state.get(FIELD_SYMBOL_FOR_SELECTION)));
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_SYMBOL_FOR_SELECTION, (Persistent)this.symbolForSelection);
    }

    public void setTransparency(double transparency) {
        SimpleFillSymbol selectionSymbol;
        Color c = this.getFillColor();
        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(transparency * 255.0));
        this.setFillColor(c);
        ILineSymbol theOutline = this.getOutline();
        if (theOutline != null && theOutline instanceof TransparencySupport) {
            ((TransparencySupport)theOutline).setTransparency(transparency);
        }
        if ((selectionSymbol = this.symbolForSelection) != null && selectionSymbol instanceof TransparencySupport) {
            ((TransparencySupport)selectionSymbol).setTransparency(transparency);
        }
    }

    @Override
    public void setOutline(ILineSymbol outline) {
        super.setOutline(outline);
    }

    public double getTransparency() {
        return (double)this.getFillAlpha() / 255.0;
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            int[] shapeTypes = new int[]{3, 11, 13, 9, 15, 25, 22, 19};
            manager.registerSymbol("fill", shapeTypes, SimpleFillSymbol.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(SimpleFillSymbol.SIMPLE_FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(SimpleFillSymbol.class, SimpleFillSymbol.SIMPLE_FILL_SYMBOL_PERSISTENCE_DEFINITION_NAME, "SimpleFillSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("FillSymbol"));
                definition.addDynFieldObject(SimpleFillSymbol.FIELD_SYMBOL_FOR_SELECTION).setClassOfValue(SimpleFillSymbol.class).setMandatory(false);
            }
            return Boolean.TRUE;
        }
    }
}

