/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.impl;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IPictureMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ILineStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.SimpleLineStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public abstract class AbstractLineSymbol
extends AbstractSymbol
implements ILineSymbol {
    private static final String FIELD_LINESTYLE = "lineStyle";
    private static final String FIELD_COLOR = "color";
    public static final String LINE_SYMBOL_PERSISTENCE_DEFINITION_NAME = "LineSymbol";
    private Color color;
    private ILineStyle lineStyle = new SimpleLineStyle();

    public AbstractLineSymbol() {
        this.color = MapContextLocator.getSymbolManager().getSymbolPreferences().getDefaultSymbolFillColor();
    }

    public Color getColor() {
        return this.color;
    }

    public void setLineColor(Color color) {
        this.color = color;
    }

    public void setColor(Color color) {
        this.setLineColor(color);
    }

    public final int getSymbolType() {
        return 2;
    }

    public boolean isSuitableFor(Geometry geom) {
        return geom.getGeometryType().isTypeOf(2);
    }

    public ILineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(ILineStyle lineStyle) {
        this.lineStyle = lineStyle;
        if (this.lineStyle instanceof CartographicSupport) {
            ((CartographicSupport)lineStyle).setUnit(this.getUnit());
            ((CartographicSupport)lineStyle).setReferenceSystem(this.getReferenceSystem());
        }
    }

    public void setUnit(int unitIndex) {
        super.setUnit(unitIndex);
        if (this.lineStyle instanceof CartographicSupport) {
            ((CartographicSupport)this.lineStyle).setUnit(unitIndex);
        }
    }

    public void setReferenceSystem(int system) {
        super.setReferenceSystem(system);
        if (this.lineStyle instanceof CartographicSupport) {
            ((CartographicSupport)this.lineStyle).setReferenceSystem(system);
        }
    }

    public int getAlpha() {
        return this.color.getAlpha();
    }

    public void setAlpha(int outlineAlpha) {
        this.color = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), outlineAlpha);
    }

    protected Geometry getSampleGeometry(Rectangle r) {
        int hGap = (int)(r.getWidth() * 0.1);
        boolean vPos = true;
        int splitCount = 3;
        int splitHSize = (r.width - hGap - hGap) / 3;
        int hPos = hGap;
        boolean swap = false;
        GeneralPathX gpx = new GeneralPathX();
        gpx.moveTo((double)(r.x + hPos), (double)(r.y + r.height - 1));
        boolean hasDecorator = this.getLineStyle().getArrowDecorator() != null;
        boolean hasPictureDeco = hasDecorator && this.getLineStyle().getArrowDecorator().getMarker() instanceof IPictureMarkerSymbol;
        for (int i = 0; i < 3; ++i) {
            boolean bl = swap = !swap;
            if (i == 2 && hasPictureDeco) {
                gpx.lineTo((double)(r.x + hPos + splitHSize / 2), (double)(r.y + r.height / 2));
            } else {
                gpx.lineTo((double)(r.x + hPos + splitHSize), (double)((swap ? 1 : r.height - 1) + r.y));
            }
            hPos += splitHSize;
        }
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createCurve(gpx, 0);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create sample geometry.", e);
        }
    }

    public static Geometry offsetFShape(Geometry shp, double offset) {
        Geometry offsetFShape = null;
        if (shp != null) {
            if (offset == 0.0) {
                return shp;
            }
            ArrayList<Point2D[]> segments = new ArrayList<Point2D[]>();
            GeneralPathX gpx = new GeneralPathX(shp.getPathIterator(null));
            PathIterator it = gpx.getPathIterator(null);
            double[] data = new double[6];
            Point2D.Double segmentIni = null;
            Point2D.Double segmentEnd = null;
            while (!it.isDone()) {
                switch (it.currentSegment(data)) {
                    case 0: {
                        segmentEnd = new Point2D.Double(data[0], data[1]);
                        break;
                    }
                    case 1: {
                        segmentEnd = segmentIni;
                        segmentIni = new Point2D.Double(data[0], data[1]);
                        segments.add(AbstractLineSymbol.getParallel(segmentIni, segmentEnd, offset));
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
            }
        }
        return offsetFShape;
    }

    private static Point2D[] getParallel(Point2D p1, Point2D p2, double distance) {
        Point2D[] pParallel = new Point2D[]{AbstractLineSymbol.getPerpendicularPoint(p1, p2, p1, distance), AbstractLineSymbol.getPerpendicularPoint(p1, p2, p2, distance)};
        return pParallel;
    }

    private static Point2D getPerpendicularPoint(Point2D p1, Point2D p2, Point2D perpPoint, double dist) {
        Point2D[] p = AbstractLineSymbol.getPerpendicular(p1, p2, perpPoint);
        Point2D unit = AbstractLineSymbol.getUnitVector(p[0], p[1]);
        return new Point2D.Double(perpPoint.getX() + unit.getX() * dist, perpPoint.getY() + unit.getY() * dist);
    }

    private static Point2D[] getPerpendicular(Point2D p1, Point2D p2, Point2D perp) {
        if (p2.getY() - p1.getY() == 0.0) {
            return new Point2D[]{new Point2D.Double(perp.getX(), 0.0), new Point2D.Double(perp.getX(), 1.0)};
        }
        double m = (p1.getX() - p2.getX()) / (p2.getY() - p1.getY());
        double b = perp.getY() - m * perp.getX();
        Point2D[] res = new Point2D[]{new Point2D.Double(0.0, m * 0.0 + b), new Point2D.Double(1000.0, m * 1000.0 + b)};
        return res;
    }

    private static Point2D getUnitVector(Point2D p1, Point2D p2) {
        Point2D.Double paux = new Point2D.Double(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        double v = Math.sqrt(Math.pow(((Point2D)paux).getX(), 2.0) + Math.pow(((Point2D)paux).getY(), 2.0));
        paux = new Point2D.Double(((Point2D)paux).getX() / v, ((Point2D)paux).getY() / v);
        return paux;
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractLineSymbol copy = (AbstractLineSymbol)((Object)super.clone());
        if (this.lineStyle != null) {
            copy.lineStyle = (ILineStyle)this.lineStyle.clone();
        }
        return copy;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setColor((Color)state.get(FIELD_COLOR));
        this.setLineStyle((ILineStyle)state.get(FIELD_LINESTYLE));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_COLOR, (Object)this.getColor());
        state.set(FIELD_LINESTYLE, (Persistent)this.getLineStyle());
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(AbstractLineSymbol.LINE_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(AbstractLineSymbol.class, AbstractLineSymbol.LINE_SYMBOL_PERSISTENCE_DEFINITION_NAME, "LineSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("Symbol"));
                definition.addDynFieldObject(AbstractLineSymbol.FIELD_COLOR).setMandatory(false).setClassOfValue(Color.class);
                definition.addDynFieldObject(AbstractLineSymbol.FIELD_LINESTYLE).setMandatory(false).setClassOfValue(ILineStyle.class);
            }
            return Boolean.TRUE;
        }
    }
}

