/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ISimpleLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.impl.AbstractLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ArrowDecoratorStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IArrowDecoratorStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ILineStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.TransparencySupport;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLineSymbol
extends AbstractLineSymbol
implements ISimpleLineSymbol,
TransparencySupport {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleLineSymbol.class);
    public static final String SIMPLE_LINE_SYMBOL_PERSISTENCE_DEFINITION_NAME = "SimpleLineSymbol";
    private static final String SELECTION_SYMBOL = "symbolForSelection";
    SimpleLineSymbol symbolForSelection;
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();

    public SimpleLineSymbol() {
        this.setLineWidth(1.0);
    }

    public ISymbol getSymbolForSelection(Color selectionColor) {
        if (this.symbolForSelection == null) {
            this.symbolForSelection = (SimpleLineSymbol)this.cloneForSelection(selectionColor);
        } else {
            this.symbolForSelection.setColor(selectionColor);
        }
        if (this.symbolForSelection instanceof TransparencySupport) {
            this.symbolForSelection.setTransparency(this.getTransparency());
        }
        return this.symbolForSelection;
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        if (r != null) {
            geom = this.getSampleGeometry(r);
        }
        Color c = this.getColor();
        try {
            Geometry env = geom.getEnvelope().getGeometry();
            env.transform(affineTransform);
            Envelope env2 = env.getEnvelope();
            if (env2.getLength(0) < 1.5 && env2.getLength(1) < 1.5) {
                g.setColor(c);
                Point upperCorner = env2.getUpperCorner();
                int x = (int)upperCorner.getX();
                int y = (int)upperCorner.getY();
                g.drawLine(x, y, x, y);
                return;
            }
        }
        catch (Exception ex) {
            LOG.warn("Error optimizing the drawing of the geometry. Continues with normal drawing.", (Throwable)ex);
        }
        Geometry geomToDraw = geom.cloneGeometry();
        ILineStyle lineStyle = this.getLineStyle();
        if (lineStyle != null) {
            if (lineStyle instanceof CartographicSupport && r == null) {
                ((CartographicSupport)lineStyle).setCartographicContext(this.getCartographicContext());
                g.setStroke(lineStyle.getCartographicStroke());
            } else {
                g.setStroke(lineStyle.getStroke());
            }
        }
        if (geomToDraw != null) {
            g.setColor(c);
            Shape shape = null;
            geomToDraw.transform(affineTransform);
            double offset = lineStyle.getOffset();
            if (offset != 0.0) {
                geomToDraw = this.applyOffset(this.toCartographicUnits(offset), r, geomToDraw);
            }
            if (geomToDraw != null && (shape = geomToDraw.getShape()) != null) {
                ArrowDecoratorStyle arrowDecorator;
                g.draw(shape);
                if (lineStyle != null && (arrowDecorator = (ArrowDecoratorStyle)lineStyle.getArrowDecorator()) != null) {
                    try {
                        if (arrowDecorator instanceof CartographicSupport) {
                            if (r == null) {
                                arrowDecorator.setCartographicContext(this.getCartographicContext());
                            } else {
                                arrowDecorator.setCartographicContext(null);
                            }
                        }
                        arrowDecorator.draw(g, null, geomToDraw, f);
                    }
                    catch (CreateGeometryException e) {
                        LOG.warn("Error drawing geometry.", (Throwable)e);
                    }
                }
            }
        }
    }

    private Geometry applyOffset(double offset, Rectangle r, Geometry geomToDraw) {
        if (offset != 0.0) {
            try {
                geomToDraw = geomToDraw.offset(offset);
            }
            catch (Exception e) {
                LOG.warn("Error creating a polygon with an offset", (Throwable)e);
            }
        }
        return geomToDraw;
    }

    public void setLineWidth(double width) {
        this.getLineStyle().setLineWidth((float)width);
    }

    public double getLineWidth() {
        return this.getLineStyle().getLineWidth();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SimpleLineSymbol copy = (SimpleLineSymbol)((Object)super.clone());
        if (this.symbolForSelection != null) {
            copy.symbolForSelection = (SimpleLineSymbol)((Object)this.symbolForSelection.clone());
        }
        return copy;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.symbolForSelection = (SimpleLineSymbol)((Object)state.get(SELECTION_SYMBOL));
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        if (this.symbolForSelection != null) {
            state.set(SELECTION_SYMBOL, (Persistent)this.getSymbolForSelection());
        }
    }

    public void setTransparency(double transparency) {
        Color c = this.getColor();
        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(transparency * 255.0));
        this.setColor(c);
        SimpleLineSymbol selectionSymbol = this.symbolForSelection;
        if (selectionSymbol != null && selectionSymbol instanceof TransparencySupport) {
            ((TransparencySupport)selectionSymbol).setTransparency(transparency);
        }
    }

    public double getTransparency() {
        return (double)this.getAlpha() / 255.0;
    }

    public void setCartographicContext(CartographicSupport.CartographicContext ctx) {
        IArrowDecoratorStyle arrowDecorator;
        super.setCartographicContext(ctx);
        if (this.getLineStyle() != null && this.getLineStyle().getArrowDecorator() != null && (arrowDecorator = this.getLineStyle().getArrowDecorator()) != null) {
            IMarkerSymbol marker;
            if (arrowDecorator instanceof CartographicSupport) {
                ((CartographicSupport)arrowDecorator).setCartographicContext(ctx);
            }
            if (arrowDecorator.getMarker() != null && (marker = arrowDecorator.getMarker()) instanceof CartographicSupport) {
                marker.setCartographicContext(ctx);
            }
        }
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            int[] shapeTypes = new int[]{2, 12, 8, 23, 24, 14, 18, 21};
            manager.registerSymbol("line", shapeTypes, SimpleLineSymbol.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(SimpleLineSymbol.SIMPLE_LINE_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(SimpleLineSymbol.class, SimpleLineSymbol.SIMPLE_LINE_SYMBOL_PERSISTENCE_DEFINITION_NAME, "SimpleLineSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("LineSymbol"));
                definition.addDynFieldObject(SimpleLineSymbol.SELECTION_SYMBOL).setClassOfValue(SimpleLineSymbol.class);
            }
            return Boolean.TRUE;
        }
    }
}

