/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.IBackgroundFileStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.AbstractStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.ImageStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.RemoteFileStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.SVGStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public abstract class BackgroundFileStyle
extends AbstractStyle
implements IBackgroundFileStyle {
    public static final String BACKGROUND_FILE_STYLE_PERSISTENCE_DEFINITION_NAME = "BackgroundFileStyle";
    protected static final String SOURCE_SYMBOL_IN_LIBRARY = "sourceSymbolInLibrary";
    protected URL source;
    protected SymbolTable symbolTable;

    public static BackgroundFileStyle createStyleByURL(URL url) throws IOException {
        String l = url.toString().toLowerCase();
        BackgroundFileStyle bgImage = l.startsWith("http://") || l.startsWith("https://") ? new RemoteFileStyle() : (l.toLowerCase().endsWith(".svg") ? new SVGStyle() : new ImageStyle());
        ((BackgroundFileStyle)bgImage).setSource(url);
        return bgImage;
    }

    public abstract void setSource(URL var1) throws IOException;

    public abstract Rectangle getBounds();

    public final URL getSource() {
        return this.source;
    }

    public final void drawInsideRectangle(Graphics2D g, Rectangle r) throws SymbolDrawingException {
        this.drawInsideRectangle(g, r, true);
    }

    public abstract void drawInsideRectangle(Graphics2D var1, Rectangle var2, boolean var3) throws SymbolDrawingException;

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected boolean isLibrarySymbol() {
        return this.source.toString().startsWith(this.getSymbolLibraryURL().toString());
    }

    protected URL getSymbolLibraryURL() {
        String symbolLibraryPath = MapContextLocator.getSymbolManager().getSymbolPreferences().getSymbolLibraryPath();
        URL symbolLibraryURL = null;
        try {
            symbolLibraryURL = new File(symbolLibraryPath).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return symbolLibraryURL;
    }

    protected String getSourceSymbolInLibrary() {
        return this.source.toString().substring(this.getSymbolLibraryURL().toString().length());
    }

    public void setSymbolTable(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    public class PersistenceCantSetSourceException
    extends PersistenceException {
        private static final long serialVersionUID = -3783412193739147977L;
        private static final String MESSAGE_FORMAT = "Can't set source file.";
        private static final String MESSAGE_KEY = "_PersistenceCantSetSourceException";

        public PersistenceCantSetSourceException() {
            super(MESSAGE_FORMAT, MESSAGE_KEY, -3783412193739147977L);
        }

        public PersistenceCantSetSourceException(Throwable cause) {
            super(MESSAGE_FORMAT, cause, MESSAGE_KEY, -3783412193739147977L);
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(BackgroundFileStyle.BACKGROUND_FILE_STYLE_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(BackgroundFileStyle.class, BackgroundFileStyle.BACKGROUND_FILE_STYLE_PERSISTENCE_DEFINITION_NAME, "BackgroundFileStyle Persistence definition", null, null);
                definition.extend(manager.getDefinition("Style"));
            }
            return Boolean.TRUE;
        }
    }
}

