/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.BackgroundFileStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public class RemoteFileStyle
extends BackgroundFileStyle {
    public static final String REMOTE_FILE_STYLE_PERSISTENCE_DEFINITION_NAME = "RemoteFileStyle";
    private static final String SOURCE = "source";
    private BackgroundFileStyle bgStyle;

    @Override
    public Rectangle getBounds() {
        return this.bgStyle.getBounds();
    }

    @Override
    public void setSource(URL url) throws IOException {
        File f = Utilities.downloadFile((URL)url, (String)"remote_picture_symbol_style", null);
        this.source = url;
        this.bgStyle = BackgroundFileStyle.createStyleByURL(f.toURI().toURL());
    }

    @Override
    public void drawInsideRectangle(Graphics2D g, Rectangle r, boolean keepAspectRatio) throws SymbolDrawingException {
        this.bgStyle.drawInsideRectangle(g, r, keepAspectRatio);
    }

    public void drawOutline(Graphics2D g, Rectangle r) throws SymbolDrawingException {
        this.bgStyle.drawOutline(g, r);
    }

    public boolean isSuitableFor(ISymbol symbol) {
        return this.bgStyle.isSuitableFor(symbol);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        try {
            this.setSource(state.getURL(SOURCE));
        }
        catch (Exception e) {
            throw new BackgroundFileStyle.PersistenceCantSetSourceException(e);
        }
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(SOURCE, this.source);
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(RemoteFileStyle.REMOTE_FILE_STYLE_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(RemoteFileStyle.class, RemoteFileStyle.REMOTE_FILE_STYLE_PERSISTENCE_DEFINITION_NAME, "RemoteFileStyle Persistence definition", null, null);
                definition.extend(manager.getDefinition("BackgroundFileStyle"));
                definition.addDynFieldURL(RemoteFileStyle.SOURCE);
            }
            return Boolean.TRUE;
        }
    }
}

