/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ITextSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolPreferences;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.CartographicSupportToolkit;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTextSymbol
extends AbstractSymbol
implements ITextSymbol,
ISimpleTextSymbol {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTextSymbol.class);
    public static final String SIMPLE_TEXT_SYMBOL_PERSISTENCE_DEFINITION_NAME = "SimpleTextSymbol";
    private static final String FIELD_TEXT = "text";
    private static final String FIELD_FONT = "font";
    private static final String FIELD_TEXT_COLOR = "textColor";
    private static final String FIELD_ROTATION = "rotation";
    private static final String FIELD_AUTO_RESIZE = "autoResize";
    private static final String FIELD_HAS_HALO = "hasHalo";
    private static final String FIELD_HALO_COLOR = "haloColor";
    private static final String FIELD_HALO_WIDTH = "haloWidth";
    private String text = "";
    private Font font;
    private Color haloColor = Color.WHITE;
    private float haloWidth = 3.0f;
    private boolean drawWithHalo = false;
    private BasicStroke haloStroke = new BasicStroke(6.0f, 1, 1);
    private Color textColor;
    private double rotation;
    private final FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, true);
    private boolean autoresize;

    public SimpleTextSymbol() {
        SymbolPreferences preferences = MapContextLocator.getSymbolManager().getSymbolPreferences();
        this.font = preferences.getDefaultSymbolFont();
        this.textColor = preferences.getDefaultSymbolColor();
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        Point point;
        if (!this.isShapeVisible()) {
            return;
        }
        if (r != null) {
            point = this.getSamplePoint(r);
        } else {
            try {
                point = geom.centroid();
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't get centroid of geometry.", ex);
            }
        }
        Font theFont = this.getFont();
        if (this.autoresize && r != null) {
            int sz = theFont.getSize();
            if (sz == 0) {
                sz = 1;
                theFont = new Font(theFont.getName(), theFont.getStyle(), sz);
            }
            g.setFont(theFont);
            FontMetrics fm = g.getFontMetrics();
            Rectangle2D rect = fm.getStringBounds(this.getText(), g);
            double width = rect.getWidth();
            double height = rect.getHeight();
            double rWidth = r.getWidth();
            double rHeight = r.getHeight();
            double ratioText = width / height;
            double ratioRect = rWidth / rHeight;
            sz = ratioText > ratioRect ? (int)((double)sz * (rWidth / width)) : (int)((double)sz * (rHeight / height));
            theFont = new Font(theFont.getName(), theFont.getStyle(), sz);
        } else if (!this.isInPixels()) {
            theFont = new Font(theFont.getName(), theFont.getStyle(), (int)this.toCartographicUnits(theFont.getSize()));
        }
        point.transform(affineTransform);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(point.getX(), point.getY());
        g.rotate(this.rotation);
        if (this.isDrawWithHalo()) {
            char[] charText = new char[this.getText().length()];
            this.getText().getChars(0, charText.length, charText, 0);
            GlyphVector glyph = theFont.layoutGlyphVector(this.frc, charText, 0, charText.length, 4);
            g.setColor(this.getHaloColor());
            g.setStroke(this.haloStroke);
            g.draw(glyph.getOutline());
        }
        g.setColor(this.textColor);
        g.setFont(theFont);
        g.drawString(this.getText(), 0, 0);
        g.rotate(-this.rotation);
        g.translate(-point.getX(), -point.getY());
    }

    public ISymbol getSymbolForSelection() {
        return this;
    }

    public int getSymbolType() {
        return 0;
    }

    public boolean isSuitableFor(Geometry geom) {
        return true;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getText() {
        if (this.text == null) {
            return "";
        }
        return this.text;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setFont(Font font) {
        if (font == null) {
            LOG.warn("font <-- null");
            return;
        }
        this.font = font;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Color getColor() {
        return this.getTextColor();
    }

    public void setColor(Color color) {
        this.setTextColor(color);
    }

    public void setFontSize(double size) {
        Font newFont;
        this.font = newFont = new Font(this.font.getName(), this.font.getStyle(), (int)size);
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    public Geometry getTextWrappingShape(Point p) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Font theFont = this.getFont();
        GlyphVector gv = theFont.createGlyphVector(this.frc, this.getText());
        Shape shape = gv.getOutline((float)p.getX(), (float)p.getY());
        try {
            Surface myFShape = geomManager.createSurface(new GeneralPathX(shape.getBounds2D().getPathIterator(null)), 0);
            myFShape.transform(AffineTransform.getTranslateInstance(p.getX(), p.getY()));
            if (this.rotation != 0.0) {
                myFShape.transform(AffineTransform.getRotateInstance(this.rotation));
            }
            return myFShape;
        }
        catch (CreateGeometryException e) {
            LOG.error("Error creating a surface", (Throwable)e);
            return null;
        }
    }

    public Rectangle getBounds() {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Rectangle bounds = null;
        try {
            bounds = this.getTextWrappingShape(geomManager.createPoint(0.0, 0.0, 0)).getShape().getBounds();
        }
        catch (CreateGeometryException e) {
            LOG.error("Error creating a point", (Throwable)e);
        }
        return bounds;
    }

    public void setCartographicSize(double cartographicSize, Geometry geom) {
        this.setFontSize(cartographicSize);
    }

    public double toCartographicSize(ViewPort viewPort, double dpi, Geometry geom) {
        double oldSize = this.getFont().getSize();
        this.setCartographicSize(this.getCartographicSize(viewPort, dpi, geom), geom);
        return oldSize;
    }

    public double getCartographicSize(ViewPort viewPort, double dpi, Geometry geom) {
        return CartographicSupportToolkit.getCartographicLength((CartographicSupport)this, (double)this.getFont().getSize(), (ViewPort)viewPort, (double)dpi);
    }

    public boolean isAutoresizeEnabled() {
        return this.autoresize;
    }

    public void setAutoresizeEnabled(boolean autoresizeFlag) {
        this.autoresize = autoresizeFlag;
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleTextSymbol copy = (SimpleTextSymbol)((Object)super.clone());
        return copy;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setAutoresizeEnabled(state.getBoolean(FIELD_AUTO_RESIZE));
        this.setFont((Font)state.get(FIELD_FONT));
        this.setRotation(state.getDouble(FIELD_ROTATION));
        this.setText(state.getString(FIELD_TEXT));
        this.setTextColor((Color)state.get(FIELD_TEXT_COLOR));
        this.setDrawWithHalo(state.getBoolean(FIELD_HAS_HALO));
        this.setHaloColor((Color)state.get(FIELD_HALO_COLOR));
        this.setHaloWidth(state.getFloat(FIELD_HALO_WIDTH));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_AUTO_RESIZE, this.isAutoresizeEnabled());
        state.set(FIELD_FONT, (Object)this.getFont());
        state.set(FIELD_ROTATION, this.getRotation());
        state.set(FIELD_TEXT, this.getText());
        state.set(FIELD_TEXT_COLOR, (Object)this.getTextColor());
        state.set(FIELD_HAS_HALO, this.isDrawWithHalo());
        state.set(FIELD_HALO_COLOR, (Object)this.getHaloColor());
        state.set(FIELD_HALO_WIDTH, this.getHaloWidth());
    }

    public Color getHaloColor() {
        return this.haloColor;
    }

    public void setHaloColor(Color co) {
        if (co != null) {
            this.haloColor = co;
        }
    }

    public float getHaloWidth() {
        return this.haloWidth;
    }

    public void setHaloWidth(float haloWidth) {
        this.haloWidth = haloWidth;
        this.haloStroke = new BasicStroke(2.0f * haloWidth, 1, 1);
    }

    public boolean isDrawWithHalo() {
        return this.drawWithHalo;
    }

    public void setDrawWithHalo(boolean drawWithHalo) {
        this.drawWithHalo = drawWithHalo;
    }

    protected Point getSamplePoint(Rectangle r) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createPoint(r.getMinX(), r.getMinY() + 0.725 * r.getHeight(), 0);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create sample point.", e);
        }
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            int[] shapeTypes = new int[]{0};
            manager.registerSymbol(SimpleTextSymbol.FIELD_TEXT, shapeTypes, SimpleTextSymbol.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(SimpleTextSymbol.SIMPLE_TEXT_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(SimpleTextSymbol.class, SimpleTextSymbol.SIMPLE_TEXT_SYMBOL_PERSISTENCE_DEFINITION_NAME, "SimpleTextSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("Symbol"));
                definition.addDynFieldBoolean(SimpleTextSymbol.FIELD_AUTO_RESIZE).setMandatory(true);
                definition.addDynFieldObject(SimpleTextSymbol.FIELD_FONT).setClassOfValue(Font.class).setMandatory(true);
                definition.addDynFieldDouble(SimpleTextSymbol.FIELD_ROTATION).setMandatory(true);
                definition.addDynFieldString(SimpleTextSymbol.FIELD_TEXT);
                definition.addDynFieldObject(SimpleTextSymbol.FIELD_TEXT_COLOR).setClassOfValue(Color.class).setMandatory(true);
                definition.addDynFieldBoolean(SimpleTextSymbol.FIELD_HAS_HALO).setMandatory(true);
                definition.addDynFieldObject(SimpleTextSymbol.FIELD_HALO_COLOR).setClassOfValue(Color.class).setMandatory(true);
                definition.addDynFieldFloat(SimpleTextSymbol.FIELD_HALO_WIDTH).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

