/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.warning.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import org.gvsig.compat.CompatLocator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.IWarningSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.MultiShapeSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.impl.SimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;

public class WarningSymbol
extends MultiShapeSymbol
implements IWarningSymbol {
    public static final String WARNING_SYMBOL_PERSISTENCE_DEFINITION_NAME = "WarningSymbol";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_MESSAGE = "message";
    private static final String FIELD_EXCEPTION_TYPE = "exceptionType";
    private String message;
    private int exceptionType;
    private SimpleTextSymbol text;

    public WarningSymbol() {
    }

    public WarningSymbol(String message, String symbolDesc, int symbolDrawExceptionType) {
        this.message = message;
        this.exceptionType = symbolDrawExceptionType;
        this.setDescription(symbolDesc);
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Cancellable cancel) {
        try {
            this.drawInsideRectangle(g, g.getTransform(), geom.getShape().getBounds());
        }
        catch (SymbolDrawingException symbolDrawingException) {
            // empty catch block
        }
    }

    public void setDrawExceptionType(int symbolDrawExceptionType) {
        this.exceptionType = symbolDrawExceptionType;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private String getMessage() {
        return this.message;
    }

    public void drawInsideRectangle(Graphics2D g, AffineTransform scaleInstance, Rectangle r) throws SymbolDrawingException {
        g.setClip(r);
        if (this.message == null) {
            this.message = "Symbol undrawable.\nPlease, check errors.";
        }
        String[] messageLines = CompatLocator.getStringUtils().split(this.message, "\n");
        int strokeWidth = (int)((double)Math.min(r.width, r.height) * 0.1);
        if (strokeWidth == 0) {
            strokeWidth = 1;
        }
        g.setColor(Color.red);
        g.setStroke(new BasicStroke(strokeWidth, 0, 1));
        int width = r.width - (strokeWidth + strokeWidth);
        int height = r.height - (strokeWidth + strokeWidth);
        double radius = (double)Math.min(width, height) * 0.5;
        double centerX = r.getCenterX();
        double centerY = r.getCenterY();
        Ellipse2D.Double circle = new Ellipse2D.Double(centerX - radius, centerY - radius, 2.0 * radius, 2.0 * radius);
        g.draw(circle);
        g.setClip(circle);
        double aux = Math.cos(0.7853981633974483) * radius;
        g.drawLine((int)(centerX - aux), (int)(centerY - aux), (int)(centerX + aux), (int)(centerY + aux));
        int fontSize = 20;
        g.setFont(new Font("Arial", fontSize, 0));
        g.setColor(Color.black);
        g.setClip(null);
        if (this.text == null) {
            this.text = new SimpleTextSymbol();
            this.text.setAutoresizeEnabled(true);
        }
        double lineHeight = (r.getHeight() - 6.0) / (double)messageLines.length;
        Rectangle textRect = new Rectangle((int)r.getMinX(), (int)r.getMinY() + 6, (int)r.getWidth(), (int)lineHeight);
        for (String messageLine : messageLines) {
            this.text.setText(messageLine);
            this.text.drawInsideRectangle(g, null, textRect);
            textRect.setLocation((int)r.getX(), (int)(r.getY() + r.getHeight()));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        WarningSymbol copy = (WarningSymbol)((Object)super.clone());
        if (this.text != null) {
            copy.text = (SimpleTextSymbol)((Object)this.text.clone());
        }
        return copy;
    }

    private int getExceptionType() {
        return this.exceptionType;
    }

    private void setExceptionType(int exceptionType) {
        this.exceptionType = exceptionType;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        this.setDescription(state.getString(FIELD_DESCRIPTION));
        this.setExceptionType(state.getInt(FIELD_EXCEPTION_TYPE));
        this.setMessage(state.getString(FIELD_MESSAGE));
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(FIELD_DESCRIPTION, this.getDescription());
        state.set(FIELD_EXCEPTION_TYPE, this.getExceptionType());
        state.set(FIELD_MESSAGE, this.getMessage());
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            manager.registerSymbol("warning", WarningSymbol.class);
            return Boolean.TRUE;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(WarningSymbol.WARNING_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(WarningSymbol.class, WarningSymbol.WARNING_SYMBOL_PERSISTENCE_DEFINITION_NAME, "WarningSymbol Persistence definition", null, null);
                definition.addDynFieldString(WarningSymbol.FIELD_DESCRIPTION).setMandatory(true);
                definition.addDynFieldInt(WarningSymbol.FIELD_EXCEPTION_TYPE).setMandatory(true);
                definition.addDynFieldString(WarningSymbol.FIELD_MESSAGE).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

