/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.io;

import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import org.apache.commons.io.FilenameUtils;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.DatasetBand;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.BandNotFoundInListException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InfoByPointException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RemoteServiceException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.datastruct.BandListImpl;
import org.gvsig.raster.impl.datastruct.DatasetBandImpl;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.RemoteRasterProvider;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.DefaultStoreFactory;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;
import org.gvsig.raster.impl.store.properties.RemoteStoreHistogram;
import org.gvsig.raster.util.DefaultProviderServices;
import org.gvsig.raster.wms.io.RemoteWMSStyle;
import org.gvsig.raster.wms.io.WMSConnector;
import org.gvsig.raster.wms.io.WMSDataParameters;
import org.gvsig.raster.wms.io.WMSDataParametersImpl;
import org.gvsig.raster.wms.io.WMSServerExplorer;
import org.gvsig.raster.wms.io.WMSServerExplorerParameters;
import org.gvsig.raster.wms.io.downloader.WMSTileServer;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.remoteclient.wms.WMSStatus;
import org.gvsig.tools.ToolsLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMSProvider
extends AbstractRasterProvider
implements RemoteRasterProvider {
    public static String NAME = "Wms Store";
    public static String DESCRIPTION = "Wms Raster file";
    public static final String METADATA_DEFINITION_NAME = "WmsStore";
    private static final Logger logger = LoggerFactory.getLogger(WMSProvider.class);
    private static final int FIXED_SIZE = 800;
    private Extent viewRequest = null;
    private static Hashtable<String, WMSConnector> drivers = new Hashtable();
    private boolean open = false;
    private DataStoreTransparency fileTransparency = null;
    private final int minTilePrintWidth = 12;
    private final int minTilePrintHeight = 12;
    private int lastWidthRequest = 0;
    private int lastHeightRequest = 0;
    private File fileLayerPixelSize = null;
    private File lastRequest = null;
    private AbstractRasterProvider lastRequestProvider = null;

    public static void register() {
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        if (dataman != null && !dataman.getStoreProviders().contains(NAME)) {
            dataman.registerStoreProvider(NAME, WMSProvider.class, WMSDataParametersImpl.class);
        }
        if (!dataman.getExplorerProviders().contains(WMSServerExplorer.NAME)) {
            dataman.registerExplorerProvider(WMSServerExplorer.NAME, WMSServerExplorer.class, WMSServerExplorerParameters.class);
        }
        dataman.registerStoreFactory(NAME, DefaultStoreFactory.class);
    }

    public WMSProvider() throws NotSupportedExtensionException {
    }

    public void registerTileProviderFormats(Class<RasterProvider> c) {
    }

    public WMSProvider(String params) throws InitializeException, OpenException {
        super(params);
        logger.info("Deprecated use of WMSProvider constructor");
        if (params instanceof String) {
            WMSDataParametersImpl p = new WMSDataParametersImpl();
            try {
                p.setURI(new URI(params));
            }
            catch (URISyntaxException e) {
                throw new OpenException("Can't create URI from" + params, (Throwable)e);
            }
            super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
            this.init((DataStoreParameters)p, null);
        }
    }

    public WMSProvider(URI uri) throws InitializeException {
        super(uri);
        WMSDataParametersImpl p = new WMSDataParametersImpl();
        p.setURI(uri);
        super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init((DataStoreParameters)p, null);
    }

    public WMSProvider(WMSDataParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        super((DataStoreParameters)params, storeServices, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init((DataStoreParameters)params, storeServices);
    }

    public WMSConnector getConnector() throws RemoteServiceException {
        WMSDataParameters p = (WMSDataParameters)this.parameters;
        URL url = null;
        try {
            url = p.getURI().toURL();
        }
        catch (Exception e) {
            throw new RemoteServiceException("Malformed URL", (Throwable)e);
        }
        try {
            return WMSProvider.getConnectorFromURL(url, false);
        }
        catch (IOException e) {
            throw new RemoteServiceException("Error getting the connector", (Throwable)e);
        }
    }

    public void init(DataStoreParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        this.setParam(storeServices, params);
        this.setDataType(new int[]{0, 0, 0});
        this.bandCount = 3;
        this.open = true;
        try {
            this.loadInitialInfo();
        }
        catch (RasterDriverException e) {
            throw new InitializeException(e.getMessage(), (Throwable)e);
        }
    }

    private void loadInitialInfo() throws RasterDriverException {
        WMSDataParametersImpl p = (WMSDataParametersImpl)this.parameters;
        Extent ext = this.getExtent();
        Rectangle2D bBox = ext.toRectangle2D();
        int w = 0;
        int h = 0;
        if (ext.width() > ext.height()) {
            w = 200;
            h = (int)(ext.height() * (double)w / ext.width());
        } else {
            h = 200;
            w = (int)(ext.width() * (double)h / ext.height());
        }
        p.setWidth(w);
        p.setHeight(h);
        p.setExtent(bBox);
        if (p.getSRSCode() != null) {
            try {
                IProjection proj = CRSFactory.getCRS((String)p.getSRSCode());
                this.setProjection(proj, false);
            }
            catch (Exception proj) {
                // empty catch block
            }
        }
        WMSStatus wmsStatus = this.loadWMSStatus(bBox);
        this.lastRequest = this.downloadFile(wmsStatus, ext.getULX(), ext.getULY(), ext.getLRX(), ext.getLRY(), w, h);
        try {
            AbstractRasterProvider driver = DefaultProviderServices.loadProvider((File)this.lastRequest);
            this.setDataType(driver.getDataType());
            this.bandCount = driver.getBandCount();
            if (this.bandCount > 3) {
                this.getColorInterpretation().setColorInterpValue(3, "Alpha");
                this.getTransparency().setTransparencyBand(3);
            }
            this.setColorTable(driver.getColorTable());
            driver.close();
        }
        catch (ProviderNotRegisteredException e) {
            throw new RasterDriverException("", (Exception)((Object)e));
        }
        catch (InitializeException e) {
            throw new RasterDriverException("", (Exception)((Object)e));
        }
    }

    public static final WMSConnector getConnectorFromURL(URL url, boolean updating) throws IOException {
        WMSConnector drv = null;
        if (!updating) {
            drv = drivers.get(url.toString());
        } else if (drivers.get(url.toString()) != null) {
            drivers.remove(url.toString());
        }
        if (drv == null) {
            drv = new WMSConnector(url);
            drivers.put(url.toString(), drv);
        }
        return drv;
    }

    public ColorInterpretation getColorInterpretation() {
        if (super.getColorInterpretation() == null) {
            DataStoreColorInterpretation colorInterpretation = new DataStoreColorInterpretation(this.getBandCount());
            if (this.getBandCount() == 1 || this.getBandCount() == 2) {
                colorInterpretation = DataStoreColorInterpretation.createGrayInterpretation();
            }
            if (this.getBandCount() == 3) {
                colorInterpretation = DataStoreColorInterpretation.createRGBInterpretation();
            }
            if (this.getBandCount() == 4) {
                colorInterpretation = DataStoreColorInterpretation.createRGBAInterpretation();
            }
            this.setColorInterpretation((ColorInterpretation)colorInterpretation);
        }
        return super.getColorInterpretation();
    }

    public AffineTransform getAffineTransform() {
        WMSDataParameters p = (WMSDataParameters)this.parameters;
        if (p.isSizeFixed()) {
            Extent e = this.getExtent();
            double psX = e.width() / (double)(p.getWidth() - 1);
            double psY = -(e.height() / (double)(p.getHeight() - 1));
            this.ownTransformation = new AffineTransform(psX, 0.0, 0.0, psY, e.getULX() - psX / 2.0, e.getULY() - psY / 2.0);
        } else {
            Rectangle2D bbox = p.getExtent();
            double psX = bbox.getWidth() / (double)p.getWidth();
            double psY = -(bbox.getHeight() / (double)p.getHeight());
            this.ownTransformation = new AffineTransform(psX, 0.0, 0.0, psY, bbox.getX(), bbox.getY() + bbox.getHeight());
        }
        this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
        return this.ownTransformation;
    }

    public Extent getExtent() {
        WMSDataParameters p = (WMSDataParameters)this.parameters;
        Vector layerNames = Utilities.createVector((String)p.getLayerQuery(), (String)",");
        String[] ln = new String[layerNames.size()];
        for (int i = 0; i < ln.length; ++i) {
            ln[i] = (String)layerNames.get(i);
        }
        Rectangle2D r = null;
        try {
            r = this.getConnector().getLayersExtent(ln, p.getSRSCode());
            if (r == null) {
                String latLonID = "EPSG:4326";
                r = this.getConnector().getLayersExtent(ln, latLonID);
                if (r == null) {
                    r = this.getConnector().getLayersExtent(ln, "CRS:84");
                }
                IProjection reqProj = CRSFactory.getCRS((String)p.getSRSCode());
                IProjection latLonProj = CRSFactory.getCRS((String)latLonID);
                if (reqProj != null && latLonProj != null) {
                    Rectangle2D reprojectedRect;
                    ICoordTrans ct = latLonProj.getCT(reqProj);
                    r = reprojectedRect = ct.convert(r);
                }
            }
        }
        catch (RemoteServiceException remoteServiceException) {
            // empty catch block
        }
        if (r == null) {
            return null;
        }
        return new ExtentImpl(r.getMinX(), r.getMaxY(), r.getMaxX(), r.getMinY());
    }

    public Rectangle2D getLayerExtent(String layerName, String srs) throws RemoteServiceException {
        return this.getConnector().getLayersExtent(new String[]{layerName}, srs);
    }

    public RasterProvider load() {
        return this;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        this.open = false;
    }

    public Transparency getTransparency() {
        if (this.fileTransparency == null) {
            this.fileTransparency = new DataStoreTransparency(this.getColorInterpretation());
        }
        return this.fileTransparency;
    }

    public URI translateURI(URI uri) {
        return uri;
    }

    public void setView(Extent e) {
        this.viewRequest = e;
    }

    public Extent getView() {
        return this.viewRequest;
    }

    public double getWidth() {
        WMSDataParameters p = (WMSDataParameters)this.parameters;
        return p.getWidth();
    }

    public double getHeight() {
        WMSDataParameters p = (WMSDataParameters)this.parameters;
        return p.getHeight();
    }

    public WMSDataParameters getParameters() {
        return (WMSDataParameters)this.parameters;
    }

    public Object readCompleteLine(int line, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        return null;
    }

    public File getFileLayer() throws RasterDriverException {
        if (this.fileLayerPixelSize != null) {
            return this.fileLayerPixelSize;
        }
        WMSDataParameters p = (WMSDataParameters)this.parameters;
        Extent e = this.getExtent();
        Rectangle2D.Double bBox = new Rectangle2D.Double(e.getULX(), e.getLRY(), e.width(), e.height());
        WMSStatus wmsStatus = this.loadWMSStatus(bBox);
        if (!p.isSizeFixed()) {
            int w = 0;
            int h = 0;
            if (e.width() > e.height()) {
                w = 800;
                h = (int)(e.height() * 800.0 / e.width());
            } else {
                h = 800;
                w = (int)(e.width() * 800.0 / e.height());
            }
            wmsStatus.setWidth(w);
            wmsStatus.setHeight(h);
            this.fileLayerPixelSize = this.downloadFile(wmsStatus, e.getULX(), e.getULY(), e.getLRX(), e.getLRY(), w, h);
        } else {
            this.fileLayerPixelSize = this.downloadFile(wmsStatus, e.getULX(), e.getULY(), e.getLRX(), e.getLRY(), p.getFixedSize().width, p.getFixedSize().height);
        }
        return this.fileLayerPixelSize;
    }

    public Object readBlock(int pos, int blockHeight, double scale) throws InvalidSetViewException, FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        File lastFile = this.getFileLayer();
        BandListImpl bandList = new BandListImpl();
        for (int i = 0; i < 3; ++i) {
            try {
                bandList.addBand((DatasetBand)new DatasetBandImpl(lastFile.getPath(), pos, 0, 3));
                continue;
            }
            catch (BandNotFoundInListException bandNotFoundInListException) {
                // empty catch block
            }
        }
        bandList.setDrawableBands(new int[]{0, 1, 2});
        try {
            this.lastRequestProvider = this.openLastRequest();
            return this.lastRequestProvider.readBlock(pos, blockHeight, scale);
        }
        catch (ProviderNotRegisteredException exc) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)exc));
        }
        catch (InitializeException exc) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)exc));
        }
    }

    public double getLastRequestHeight() throws RasterDriverException {
        if (this.lastRequestProvider == null) {
            try {
                this.lastRequestProvider = this.openLastRequest();
            }
            catch (ProviderNotRegisteredException e) {
                throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
            }
            catch (InitializeException e) {
                throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
            }
        }
        return this.lastRequestProvider.getHeight();
    }

    public double getLastRequestWidth() throws RasterDriverException {
        if (this.lastRequestProvider == null) {
            try {
                this.lastRequestProvider = this.openLastRequest();
            }
            catch (ProviderNotRegisteredException e) {
                throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
            }
            catch (InitializeException e) {
                throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
            }
        }
        return this.lastRequestProvider.getWidth();
    }

    public File getLastRequest() {
        return this.lastRequest;
    }

    public Buffer getBufferLastRequest() throws ProcessInterruptedException, RasterDriverException {
        try {
            this.lastRequestProvider = this.openLastRequest();
            return this.getDownloadedRaster(this.lastRequestProvider);
        }
        catch (ProviderNotRegisteredException e) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
        }
        catch (InitializeException e) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
        }
        catch (QueryException e) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
        }
    }

    private AbstractRasterProvider openLastRequest() throws ProviderNotRegisteredException, InitializeException, RasterDriverException {
        if (this.lastRequestProvider != null) {
            this.lastRequestProvider.close();
        }
        File lastFile = this.getFileLayer();
        this.lastRequestProvider = DefaultProviderServices.loadProvider((File)new File(lastFile.getPath()));
        this.setColorTable(this.lastRequestProvider.getColorTable());
        return this.lastRequestProvider;
    }

    public Object getData(int x, int y, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        return null;
    }

    private String getWorldFile(String file) {
        String worldFile = file;
        int index = file.lastIndexOf(".");
        if (index > 0) {
            worldFile = file.substring(0, index) + this.getExtensionWorldFile();
        }
        return worldFile;
    }

    private String getExtensionWorldFile() {
        WMSDataParameters p = (WMSDataParameters)this.parameters;
        String extWorldFile = ".wld";
        if (p.getFormat().equals("image/tif") || p.getFormat().equals("image/tiff")) {
            extWorldFile = ".tfw";
        }
        return extWorldFile;
    }

    public WMSStatus loadWMSStatus(Rectangle2D bBox) {
        WMSDataParameters p = (WMSDataParameters)this.parameters;
        WMSStatus wmsStatus = new WMSStatus();
        wmsStatus.setLayerNames(Utilities.createVector((String)p.getLayerQuery(), (String)","));
        wmsStatus.setSrs(p.getSRSCode());
        wmsStatus.setFormat(p.getFormat());
        wmsStatus.setInfoFormat(p.getInfoFormat());
        List<RemoteWMSStyle> listStyles = p.getStyles();
        Vector<RemoteWMSStyle> v = listStyles != null ? new Vector<RemoteWMSStyle>(listStyles) : null;
        wmsStatus.setStyles(v);
        wmsStatus.setDimensions(p.getDimensions());
        wmsStatus.setTransparency(p.isWmsTransparent());
        wmsStatus.setOnlineResource(p.getOnlineResource().get("GetMap"));
        if (p.isSizeFixed()) {
            wmsStatus.setExtent(this.getExtent().toRectangle2D());
        } else {
            wmsStatus.setExtent(bBox);
        }
        wmsStatus.setHeight(p.getHeight());
        wmsStatus.setWidth(p.getWidth());
        wmsStatus.setXyAxisOrder(p.isXyAxisOrder());
        IProjection proj = this.getProjection();
        if (proj != null) {
            wmsStatus.setProjected(proj.isProjected());
        }
        return wmsStatus;
    }

    private File downloadFile(WMSStatus wmsStatus, double ulx, double uly, double lrx, double lry, int w, int h) throws RasterDriverException {
        WMSDataParameters p = (WMSDataParameters)this.parameters;
        try {
            this.lastRequest = this.getConnector().getMap(wmsStatus, ((WMSDataParameters)this.parameters).getCancellable());
        }
        catch (RemoteServiceException e) {
            throw new RasterDriverException(e.getMessage(), (Exception)((Object)e));
        }
        if (this.lastRequest == null) {
            return null;
        }
        String nameWorldFile = this.getWorldFile(this.lastRequest.getPath());
        try {
            if (p.isSizeFixed()) {
                Extent e = this.getExtent();
                this.fileUtil.createWorldFile(nameWorldFile, e, p.getWidth(), p.getHeight());
            } else {
                this.fileUtil.createWorldFile(nameWorldFile, (Extent)new ExtentImpl(ulx, uly, lrx, lry), w, h);
            }
        }
        catch (IOException e) {
            throw new RasterDriverException("Error creating world file", (Exception)e);
        }
        return this.lastRequest;
    }

    public void loadBuffer(SpiRasterQuery q) throws ProcessInterruptedException, RasterDriverException {
        Extent bbox = q.getRequestBoundingBox();
        this.lastWidthRequest = q.getBufWidth();
        this.lastHeightRequest = q.getBufHeight();
        WMSStatus wmsStatus = this.loadWMSStatus(bbox.toRectangle2D());
        this.lastRequest = this.downloadFile(wmsStatus, bbox.getULX(), bbox.getULY(), bbox.getLRX(), bbox.getLRY(), q.getBufWidth(), q.getBufHeight());
        if (this.lastRequest == null) {
            return;
        }
        Buffer b = null;
        try {
            b = this.getDownloadedRaster(this.lastRequest);
        }
        catch (QueryException e) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
        }
        catch (ProviderNotRegisteredException e) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
        }
        catch (InitializeException e) {
            throw new RasterDriverException("Error building GdalDriver", (Exception)((Object)e));
        }
        q.setBufferResult(b);
    }

    private Buffer getDownloadedRaster(File f) throws ProcessInterruptedException, QueryException, ProviderNotRegisteredException, InitializeException {
        AbstractRasterProvider provider = DefaultProviderServices.loadProvider((File)new File(f.getPath()));
        this.setColorTable(provider.getColorTable());
        return this.getDownloadedRaster(provider);
    }

    private Buffer getDownloadedRaster(AbstractRasterProvider provider) throws ProcessInterruptedException, QueryException, ProviderNotRegisteredException, InitializeException {
        DefaultRasterStore store = new DefaultRasterStore();
        store.setProvider((RasterProvider)provider);
        RasterQuery q = RasterLocator.getManager().createQuery();
        q.setAreaOfInterest();
        if (this.getColorInterpretation() != null) {
            q.setDrawableBands(this.getColorInterpretation().buildRenderBands());
        }
        if (store.getBandCount() > 3) {
            q.forceARGBRequest();
        } else {
            q.forceRGBRequest();
        }
        Buffer buf = store.query(q);
        store.close();
        return buf;
    }

    public Image getImageLegend() {
        try {
            WMSStatus wmsStatus = this.loadWMSStatus(this.getExtent().toRectangle2D());
            wmsStatus.setOnlineResource(this.getParameters().getOnlineResource().get("GetCapabilities"));
            File file = this.getConnector().getLegendGraphic(wmsStatus, this.getParameters().getLayerQuery(), null);
            Image img = null;
            if (file != null && file.length() > 0L) {
                img = new ImageIcon(file.getAbsolutePath()).getImage();
            }
            return img;
        }
        catch (Exception e) {
            logger.info("Problems in GetLegendGraphic", (Throwable)e);
            return null;
        }
    }

    public int getBlockSize() {
        return 0;
    }

    public void setAffineTransform(AffineTransform t) {
    }

    public int getOverviewCount(int band) throws BandAccessException, RasterDriverException {
        return 0;
    }

    public int getOverviewWidth(int band, int overview) throws BandAccessException, RasterDriverException {
        return 0;
    }

    public int getOverviewHeight(int band, int overview) throws BandAccessException, RasterDriverException {
        return 0;
    }

    public boolean isOverviewsSupported() {
        return false;
    }

    public boolean isReproyectable() {
        return false;
    }

    public String getProviderName() {
        return NAME;
    }

    public String getName() {
        return this.getParameters().getName();
    }

    public String getFullName() {
        return this.getURI().getPath();
    }

    public Point2D rasterToWorld(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        this.getAffineTransform().transform(pt, p);
        return p;
    }

    public Point2D worldToRaster(Point2D pt) {
        Point2D.Double p = new Point2D.Double();
        try {
            this.getAffineTransform().inverseTransform(pt, p);
        }
        catch (NoninvertibleTransformException e) {
            return pt;
        }
        return p;
    }

    public void setStatus(RasterProvider provider) {
        if (provider instanceof WMSProvider) {
            // empty if block
        }
    }

    public void setParam(DataStoreProviderServices storeServices, DataStoreParameters param) {
        if (param instanceof WMSDataParameters) {
            this.uri = ((WMSDataParameters)param).getURI();
        }
        this.param = param;
    }

    public String getInfoByPoint(int x, int y, Extent bbox, int w, int h, ICancellable cancellable) throws InfoByPointException {
        WMSDataParameters p = (WMSDataParameters)this.parameters;
        WMSStatus wmsStatus = new WMSStatus();
        wmsStatus.setLayerNames(Utilities.createVector((String)p.getLayerQuery(), (String)","));
        wmsStatus.setSrs(p.getSRSCode());
        wmsStatus.setFormat(p.getFormat());
        wmsStatus.setInfoFormat(p.getInfoFormat());
        List<RemoteWMSStyle> listStyles = p.getStyles();
        Vector<RemoteWMSStyle> v = listStyles != null ? new Vector<RemoteWMSStyle>(listStyles) : null;
        wmsStatus.setStyles(v);
        wmsStatus.setDimensions(p.getDimensions());
        wmsStatus.setTransparency(p.isWmsTransparent());
        wmsStatus.setOnlineResource(p.getOnlineResource().get("GetMap"));
        wmsStatus.setExtent(bbox.toRectangle2D());
        wmsStatus.setHeight(h);
        wmsStatus.setWidth(w);
        wmsStatus.setXyAxisOrder(p.isXyAxisOrder());
        try {
            return this.getConnector().getFeatureInfo(wmsStatus, x, y, Integer.MAX_VALUE, cancellable);
        }
        catch (RemoteServiceException e) {
            throw new InfoByPointException("Error in getFeatureInfo", (Throwable)e);
        }
    }

    public String getFileSuffix() {
        WMSDataParameters p = (WMSDataParameters)this.parameters;
        String format = p.getFormat();
        if (format == null) {
            return "xml";
        }
        if (format.indexOf("png") >= 0) {
            return "png";
        }
        if (format.indexOf("xml") >= 0) {
            return "xml";
        }
        if (format.indexOf("gif") >= 0) {
            return "gif";
        }
        if (format.indexOf("tif") >= 0) {
            return "tif";
        }
        if (format.indexOf("bmp") >= 0) {
            return "bmp";
        }
        if (format.indexOf("jpg") >= 0 || format.indexOf("jpeg") >= 0) {
            return "jpg";
        }
        return "xml";
    }

    public TileServer getTileServer() {
        if (this.tileServer == null) {
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((RasterProvider)this);
            this.tileServer = new WMSTileServer((RasterDataStore)store);
        }
        return this.tileServer;
    }

    public boolean isRasterEnclosed() {
        WMSDataParameters p = (WMSDataParameters)this.parameters;
        return !p.isSizeFixed();
    }

    public File getRMFFile() {
        if (this.lastRequest != null) {
            return new File(FilenameUtils.removeExtension((String)this.lastRequest.getAbsolutePath()) + ".rmf");
        }
        return null;
    }

    public HistogramComputer getHistogramComputer() {
        if (this.histogram == null) {
            this.histogram = new RemoteStoreHistogram((RemoteRasterProvider)this);
        }
        return this.histogram;
    }

    public void addFile(File file) throws InvalidSourceException {
    }

    public void removeFile(File file) {
    }
}

