/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.io;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.coverage.exception.ConnectException;
import org.gvsig.fmap.dal.coverage.store.RasterDataServerExplorer;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.spi.AbstractDataServerExplorer;
import org.gvsig.fmap.dal.spi.DataServerExplorerProvider;
import org.gvsig.fmap.dal.spi.DataServerExplorerProviderServices;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.wms.io.WMSConnector;
import org.gvsig.raster.wms.io.WMSDataParameters;
import org.gvsig.raster.wms.io.WMSLayerNode;
import org.gvsig.raster.wms.io.WMSProvider;
import org.gvsig.raster.wms.io.WMSServerExplorerParameters;
import org.gvsig.remoteclient.utils.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMSServerExplorer
extends AbstractDataServerExplorer
implements RasterDataServerExplorer,
DataServerExplorerProvider {
    public static final String NAME = WMSProvider.NAME;
    private WMSConnector connector = null;
    private Logger log = LoggerFactory.getLogger(WMSServerExplorer.class);

    public WMSServerExplorer(WMSServerExplorerParameters parameters, DataServerExplorerProviderServices services) throws InitializeException {
        super((DataServerExplorerParameters)parameters, services);
    }

    public String getDataStoreProviderName() {
        return WMSProvider.NAME;
    }

    public String getDescription() {
        return WMSProvider.DESCRIPTION;
    }

    public boolean add(String provider, NewDataStoreParameters parameters, boolean overwrite) throws DataException {
        return false;
    }

    public boolean canAdd() {
        return false;
    }

    public boolean canAdd(String storeName) throws DataException {
        return false;
    }

    public NewDataStoreParameters getAddParameters(String storeName) throws DataException {
        return null;
    }

    public List<String> getDataStoreProviderNames() {
        return null;
    }

    public WMSServerExplorerParameters getParameters() {
        return (WMSServerExplorerParameters)super.getParameters();
    }

    public List<DataStoreParameters> list() throws DataException {
        return null;
    }

    public List<DataStoreParameters> list(int mode) throws DataException {
        return null;
    }

    public void remove(DataStoreParameters parameters) throws DataException {
    }

    public String getProviderName() {
        return null;
    }

    public DataStoreParameters get(String layerName) {
        WMSDataParameters params = (WMSDataParameters)this.getStoredParameters();
        params.setLayerQuery(layerName);
        return params;
    }

    public DataStoreParameters getStoredParameters() {
        DataManager manager = DALLocator.getDataManager();
        WMSDataParameters params = null;
        try {
            params = (WMSDataParameters)manager.createStoreParameters(this.getDataStoreProviderName());
            params.setURI(new URI(this.getParameters().getHost()));
        }
        catch (InitializeException e) {
            this.log.debug("Error initializating parameters", (Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            this.log.debug("Error getting parameters", (Throwable)e);
        }
        catch (URISyntaxException e) {
            this.log.debug("Can't create URI from " + this.getParameters().getHost(), (Throwable)e);
        }
        return params;
    }

    public void open() throws OpenException {
        try {
            this.connect(null);
        }
        catch (ConnectException ex) {
            throw new OpenException(this.getHost(), (Throwable)ex);
        }
    }

    public void connect(ICancellable cancellable) throws ConnectException {
        this.connect(cancellable, false);
    }

    public void connect(ICancellable cancellable, boolean updateCache) throws ConnectException {
        URL url = null;
        try {
            url = new URL(this.getParameters().getHost());
        }
        catch (Exception e) {
            throw new ConnectException(Messages.getText((String)"malformed_url"), (Throwable)e);
        }
        try {
            this.connector = WMSProvider.getConnectorFromURL(url, updateCache);
            if (!this.connector.connect(this.getParameters(), updateCache, cancellable)) {
                throw new ConnectException(Messages.getText((String)"error_connecting"));
            }
        }
        catch (IOException e) {
            throw new ConnectException(Messages.getText((String)"error_connecting"), (Throwable)e);
        }
    }

    public boolean isHostReachable(int timeout) {
        URL url = null;
        try {
            url = new URL(this.getParameters().getHost());
            File file = Utilities.downloadFile((URL)url, (String)"checkhost.dat", null);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean isHostReachable() {
        int timeout = 10000;
        return this.isHostReachable(timeout);
    }

    public boolean isConnected() {
        return this.connector != null;
    }

    public String getAbstract() {
        if (this.connector != null) {
            return this.connector.getAbstract();
        }
        return null;
    }

    public String[] getFormats() {
        if (this.connector != null) {
            Vector f = this.connector.getFormats();
            ArrayList formatos = new ArrayList();
            for (int i = 0; i < f.size(); ++i) {
                formatos.add(f.elementAt(i));
            }
            return formatos.toArray(new String[0]);
        }
        return null;
    }

    public String[] getInfoFormats() {
        if (this.connector != null) {
            Vector f = this.connector.getInfoFormats();
            ArrayList formatos = new ArrayList();
            for (int i = 0; i < f.size(); ++i) {
                formatos.add(f.elementAt(i));
            }
            return formatos.toArray(new String[0]);
        }
        return null;
    }

    public WMSLayerNode getLayerTree() {
        if (this.connector != null) {
            return this.connector.getLayersTree();
        }
        return null;
    }

    public String getServerType() {
        if (this.getVersion() == null) {
            return "WMS";
        }
        return "WMS " + this.getVersion();
    }

    public Hashtable getOnlineResources() {
        if (this.connector != null) {
            return this.connector.getOnlineResources();
        }
        return null;
    }

    public String getVersion() {
        if (this.connector != null) {
            return this.connector.getVersion() == null ? "" : this.connector.getVersion();
        }
        return null;
    }

    public Rectangle2D getLayersExtent(String[] layerName, String srs) {
        return this.connector.getLayersExtent(layerName, srs);
    }

    public WMSLayerNode getLayer(String layerName) {
        return this.connector.getLayer(layerName);
    }

    public String getHost() {
        return this.getParameters().getHost();
    }

    public Rectangle2D getBoundingBox(String[] layerNames, String srs) {
        return this.connector.getLayersExtent(layerNames, srs);
    }

    public boolean isQueryable() {
        return this.connector.isQueryable();
    }

    public String getTitle() {
        return null;
    }

    public String getServiceTitle() {
        return this.connector.getServiceTitle();
    }

    public DataServerExplorerProviderServices getServerExplorerProviderServices() {
        return null;
    }

    public DataStore open(DataStoreParameters par) throws DataException {
        String layerName = "unknown";
        try {
            layerName = (String)par.getDynValue("layer_query");
            DataManager datamanager = DALLocator.getDataManager();
            RasterDataStore store = (RasterDataStore)datamanager.openStore(NAME, par);
            store.setExplorer((RasterDataServerExplorer)this);
            return store;
        }
        catch (Exception ex) {
            throw new OpenException(layerName, (Throwable)ex);
        }
    }

    public Object getProperty(String name) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"OnlineResources", (CharSequence)name)) {
            return this.getOnlineResources();
        }
        return super.getProperty(name);
    }
}

