/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.io;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.spi.AbstractDataServerExplorerParameters;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.wms.io.WMSProvider;
import org.gvsig.raster.wms.io.WMSServerExplorer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMSServerExplorerParameters
extends AbstractDataServerExplorerParameters
implements DataServerExplorerParameters {
    protected static final String FIELD_HOST = "host";
    protected static DynClass DYNCLASS = null;
    private DelegatedDynObject delegatedDynObject = null;
    private static final String FIELD_XYAXISORDER = "xyaxisorder";
    private static final String OLD_FIELD_AXISORDER = "axisorder";
    private static final Logger logger = LoggerFactory.getLogger(WMSServerExplorerParameters.class);

    public WMSServerExplorerParameters() {
        this.initialize();
    }

    protected void initialize() {
        this.delegatedDynObject = (DelegatedDynObject)ToolsLocator.getDynObjectManager().createDynObject(WMSServerExplorerParameters.registerDynClass());
    }

    public static DynStruct registerDynClass() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("WMSServerExplorerParameters_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(WMSServerExplorerParameters.class, "WMSServerExplorerParameters_Persistent", "WMS Explorer DataParameters Persistency", null, null);
        }
        AbstractRasterDataParameters.registerDynClass((DynStruct)definition);
        definition.addDynFieldBoolean(FIELD_XYAXISORDER).setDescription("Longitude first in axis order").setMandatory(false).setDefaultFieldValue((Object)new Boolean(false));
        definition.addDynFieldString(FIELD_HOST).setDescription("Uniform Resource Identifier (File name or URL)").setMandatory(false);
        return definition;
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.delegatedDynObject;
    }

    public String getHost() {
        return (String)this.getDynValue(FIELD_HOST);
    }

    public void setHost(String host) {
        this.setDynValue(FIELD_HOST, host);
    }

    public String getDataStoreName() {
        return WMSProvider.NAME;
    }

    public String getDescription() {
        return WMSProvider.DESCRIPTION;
    }

    public String getExplorerName() {
        return WMSServerExplorer.NAME;
    }

    public boolean isXyAxisOrder() {
        if (this.hasDynValue(FIELD_XYAXISORDER)) {
            Object b;
            Object obj = this.getDynValue(FIELD_XYAXISORDER);
            if (obj instanceof Boolean && (b = (Boolean)this.getDynValue(FIELD_XYAXISORDER)) != null) {
                return (Boolean)b;
            }
            if (obj instanceof String && (b = (String)this.getDynValue(FIELD_XYAXISORDER)) != null) {
                return new Boolean((String)b);
            }
        }
        return false;
    }

    public void setXyAxisOrder(boolean assumeXY) {
        this.setDynValue(FIELD_XYAXISORDER, new Boolean(assumeXY));
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        try {
            this.setDynValue(FIELD_XYAXISORDER, state.get(OLD_FIELD_AXISORDER));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setDynValue(String name, Object value) {
        if (OLD_FIELD_AXISORDER.equalsIgnoreCase(name)) {
            super.setDynValue(FIELD_XYAXISORDER, value);
        } else {
            super.setDynValue(name, value);
        }
    }

    public boolean isTheSameServerExplorer(DataServerExplorerParameters params) {
        if (!(params instanceof WMSServerExplorerParameters)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getHost(), (CharSequence)((WMSServerExplorerParameters)params).getHost());
    }
}

