/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.io.time;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.gvsig.raster.wms.io.time.RemoteTimeDimension;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class TimeDimension
implements RemoteTimeDimension {
    private static final byte YEAR_FORMAT = 1;
    private static final byte YEAR_TO_MONTH_FORMAT = 2;
    private static final byte YEAR_TO_DAY_FORMAT = 3;
    private static final byte FULL_FORMAT = 4;
    private static final long millisXsec = 1000L;
    private static final long millisXminute = 60000L;
    private static final long millisXhour = 3600000L;
    private static final long millisXday = 86400000L;
    private static final long millisXmonth = 2592000000L;
    private static final long millisXyear = 31558149700L;
    private static final String digit = "[0-9]";
    private static final String nonZeroDigit = "[1-9]";
    private static final String seconds = "([0-5][0-9]((\\.|,)[0-9][0-9]?[0-9]?)?)";
    private static final String minutes = "([0-5][0-9])";
    private static final String hours = "(0[0-9]|1[0-9]|2[0-3])";
    private static final String time = "(0[0-9]|1[0-9]|2[0-3]):([0-5][0-9])(:([0-5][0-9]((\\.|,)[0-9][0-9]?[0-9]?)?))?";
    private static final String days = "(0?[1-9]|1[0-9]|2[0-9]|30|31)";
    private static final String months = "(0?[1-9]|10|11|12)";
    private static final String year = "([0-9][0-9])";
    private static final String century = "([0-9][0-9])";
    private static final String floatingPointNumber = "([0-9]+(\\.[0-9]+)?)";
    private String unit;
    private String unitSymbol;
    private List<GregorianCalendar> valueList;
    private boolean compiled;
    private boolean isGeologic;
    private String expression;
    private int type;
    private byte format = 0;
    private static final String regexDateExtendedForBCE1 = "B?([0-9][0-9])([0-9][0-9])";
    private static final String regexDateExtendedForBCE2 = "B?([0-9][0-9])([0-9][0-9])-(0?[1-9]|10|11|12)";
    private static final String regexDateExtendedForBCE3 = "B?([0-9][0-9])([0-9][0-9])-(0?[1-9]|10|11|12)-(0?[1-9]|1[0-9]|2[0-9]|30|31)";
    private static final String regexDateExtendedForBCE4 = "B?([0-9][0-9])([0-9][0-9])-(0?[1-9]|10|11|12)-(0?[1-9]|1[0-9]|2[0-9]|30|31)(T| )(0[0-9]|1[0-9]|2[0-3]):([0-5][0-9])(:([0-5][0-9]((\\.|,)[0-9][0-9]?[0-9]?)?))?Z";
    private static final String regexDateExtendedForBCE = "(B?([0-9][0-9])([0-9][0-9])|B?([0-9][0-9])([0-9][0-9])-(0?[1-9]|10|11|12)|B?([0-9][0-9])([0-9][0-9])-(0?[1-9]|10|11|12)-(0?[1-9]|1[0-9]|2[0-9]|30|31)|B?([0-9][0-9])([0-9][0-9])-(0?[1-9]|10|11|12)-(0?[1-9]|1[0-9]|2[0-9]|30|31)(T| )(0[0-9]|1[0-9]|2[0-3]):([0-5][0-9])(:([0-5][0-9]((\\.|,)[0-9][0-9]?[0-9]?)?))?Z)";
    private static final String periodMagnitude = "(Y|M|D)";
    private static final String p1 = "(([0-9])+(Y|M|D))";
    private static final String timeMagnitude = "(H|M|S)";
    private static final String p2 = "(([0-9]+(\\.[0-9]+)?)(H|M|S))";
    private static final String regexPeriod = "P(((([0-9])+(Y|M|D))+(T(([0-9]+(\\.[0-9]+)?)(H|M|S)))*)|((([0-9])+(Y|M|D))*(T(([0-9]+(\\.[0-9]+)?)(H|M|S)))+))";
    private static final String regexIntervalTimeDimension = "((B?([0-9][0-9])([0-9][0-9])|B?([0-9][0-9])([0-9][0-9])-(0?[1-9]|10|11|12)|B?([0-9][0-9])([0-9][0-9])-(0?[1-9]|10|11|12)-(0?[1-9]|1[0-9]|2[0-9]|30|31)|B?([0-9][0-9])([0-9][0-9])-(0?[1-9]|10|11|12)-(0?[1-9]|1[0-9]|2[0-9]|30|31)(T| )(0[0-9]|1[0-9]|2[0-3]):([0-5][0-9])(:([0-5][0-9]((\\.|,)[0-9][0-9]?[0-9]?)?))?Z))/((B?([0-9][0-9])([0-9][0-9])|B?([0-9][0-9])([0-9][0-9])-(0?[1-9]|10|11|12)|B?([0-9][0-9])([0-9][0-9])-(0?[1-9]|10|11|12)-(0?[1-9]|1[0-9]|2[0-9]|30|31)|B?([0-9][0-9])([0-9][0-9])-(0?[1-9]|10|11|12)-(0?[1-9]|1[0-9]|2[0-9]|30|31)(T| )(0[0-9]|1[0-9]|2[0-3]):([0-5][0-9])(:([0-5][0-9]((\\.|,)[0-9][0-9]?[0-9]?)?))?Z))/(P(((([0-9])+(Y|M|D))+(T(([0-9]+(\\.[0-9]+)?)(H|M|S)))*)|((([0-9])+(Y|M|D))*(T(([0-9]+(\\.[0-9]+)?)(H|M|S)))+)))";
    private static final String geologicDatasets = "(K|M|G)";
    private static final String regexDateForGeologicDatasets = "(K|M|G)([0-9]+(\\.[0-9]+)?)";

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.unit = state.getString("unit");
        this.unitSymbol = state.getString("unitSymbol");
        List list = state.getList("valueList");
        this.valueList = this.convertStringListToGregorianCalendarList(list);
        this.compiled = state.getBoolean("compiled");
        this.isGeologic = state.getBoolean("isGeologic");
        this.expression = state.getString("expression");
        this.type = state.getInt("type");
        this.format = (byte)state.getInt("format");
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("unit", this.unit);
        state.set("unitSymbol", this.unitSymbol);
        state.set("valueList", this.convertGregorianCalendarListToStringList(this.valueList));
        state.set("compiled", this.compiled);
        state.set("isGeologic", this.isGeologic);
        state.set("expression", this.expression);
        state.set("type", this.type);
        state.set("format", (int)this.format);
    }

    private List<String> convertGregorianCalendarListToStringList(List<GregorianCalendar> gList) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < gList.size(); ++i) {
            l.add(this.toString(gList.get(i)));
        }
        return l;
    }

    private List<GregorianCalendar> convertStringListToGregorianCalendarList(List<String> sList) {
        ArrayList<GregorianCalendar> l = new ArrayList<GregorianCalendar>();
        for (int i = 0; i < sList.size(); ++i) {
            l.add(this.valueOf(sList.get(i)));
        }
        return l;
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("TimeDimension_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(TimeDimension.class, "TimeDimension_Persistent", "TimeDimension Persistence", null, null);
        }
        definition.addDynFieldString("unit").setMandatory(false);
        definition.addDynFieldString("unitSymbol").setMandatory(false);
        definition.addDynFieldList("valueList").setClassOfItems(String.class).setMandatory(false);
        definition.addDynFieldBoolean("compiled").setMandatory(false);
        definition.addDynFieldBoolean("isGeologic").setMandatory(false);
        definition.addDynFieldString("expression").setMandatory(false);
        definition.addDynFieldInt("type").setMandatory(false);
        definition.addDynFieldInt("format").setMandatory(false);
    }

    public TimeDimension() {
    }

    public TimeDimension(String _units, String _unitSymbol, String _dimensionExpression) {
        this.unit = _units;
        this.unitSymbol = _unitSymbol;
        this.setExpression(_dimensionExpression);
    }

    @Override
    public String getName() {
        return "TIME";
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public String getUnitSymbol() {
        return this.unitSymbol;
    }

    @Override
    public String getLowLimit() {
        return this.valueAt(0);
    }

    @Override
    public String getHighLimit() {
        return this.valueAt(this.valueList.size() - 1);
    }

    @Override
    public String getResolution() {
        return null;
    }

    @Override
    public boolean isValidValue(String value) {
        return value.matches(regexDateForGeologicDatasets) || value.matches(regexDateExtendedForBCE);
    }

    @Override
    public GregorianCalendar valueOf(String value) throws IllegalArgumentException {
        if (this.compiled) {
            String myValue = value.toUpperCase();
            if (this.isValidValue(myValue)) {
                GregorianCalendar val = null;
                if (!this.isGeologic) {
                    GregorianCalendar cal;
                    float mySecond;
                    int myMinute;
                    int myHour;
                    int myDay;
                    int myMonth;
                    String[] s = myValue.split("-");
                    int myYear = s[0].charAt(0) == 'B' ? -Integer.parseInt(s[0].substring(1, 5)) : Integer.parseInt(s[0].substring(0, 4));
                    int n = myMonth = s.length > 1 ? Integer.parseInt(s[1]) - 1 : 0;
                    if (myValue.matches(regexDateExtendedForBCE4)) {
                        if (s[2].endsWith("Z")) {
                            s[2] = s[2].substring(0, s[2].length() - 1);
                        }
                        s = s[2].indexOf(84) != -1 ? s[2].split("T") : s[2].split(" ");
                        myDay = Integer.parseInt(s[0]);
                        s = s[1].split(":");
                        myHour = Integer.parseInt(s[0]);
                        myMinute = s.length > 1 ? Integer.parseInt(s[1]) : 0;
                        mySecond = s.length > 2 ? Float.parseFloat(s[2]) : 0.0f;
                    } else {
                        myDay = s.length > 2 ? Integer.parseInt(s[2]) : 1;
                        myHour = 0;
                        myMinute = 0;
                        mySecond = 0.0f;
                    }
                    val = cal = new GregorianCalendar(myYear, myMonth, myDay, myHour, myMinute, (int)mySecond);
                }
                return val;
            }
            throw new IllegalArgumentException(myValue);
        }
        return null;
    }

    @Override
    public String valueAt(int pos) throws ArrayIndexOutOfBoundsException {
        return this.toString(this.valueList.get(pos));
    }

    @Override
    public int valueCount() {
        return this.valueList.size();
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public void setExpression(String expr) {
        this.expression = expr;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void compile() throws IllegalArgumentException {
        this.compiled = true;
        this.valueList = new ArrayList<GregorianCalendar>();
        String[] items = this.expression.split(",");
        for (int i = 0; i < items.length; ++i) {
            items[i] = items[i].trim();
            if (items[i].matches(regexDateExtendedForBCE1)) {
                this.upgradeFormat((byte)1);
                this.valueList.add(this.valueOf(items[i]));
                continue;
            }
            if (items[i].matches(regexDateExtendedForBCE2)) {
                this.upgradeFormat((byte)2);
                this.valueList.add(this.valueOf(items[i]));
                continue;
            }
            if (items[i].matches(regexDateExtendedForBCE3)) {
                this.upgradeFormat((byte)3);
                this.valueList.add(this.valueOf(items[i]));
                continue;
            }
            if (items[i].matches(regexDateExtendedForBCE4)) {
                this.upgradeFormat((byte)4);
                this.valueList.add(this.valueOf(items[i]));
                continue;
            }
            if (items[i].matches(regexIntervalTimeDimension)) {
                String[] s = items[i].split("/");
                if (s[0].matches(regexDateExtendedForBCE1)) {
                    this.upgradeFormat((byte)1);
                } else if (s[0].matches(regexDateExtendedForBCE2)) {
                    this.upgradeFormat((byte)2);
                } else if (s[0].matches(regexDateExtendedForBCE3)) {
                    this.upgradeFormat((byte)3);
                } else if (s[0].matches(regexDateExtendedForBCE4)) {
                    this.upgradeFormat((byte)4);
                }
                GregorianCalendar minValue = this.valueOf(s[0]);
                if (s[0].matches(regexDateExtendedForBCE1)) {
                    this.upgradeFormat((byte)1);
                } else if (s[1].matches(regexDateExtendedForBCE2)) {
                    this.upgradeFormat((byte)2);
                } else if (s[1].matches(regexDateExtendedForBCE3)) {
                    this.upgradeFormat((byte)3);
                } else if (s[1].matches(regexDateExtendedForBCE4)) {
                    this.upgradeFormat((byte)4);
                }
                GregorianCalendar maxValue = this.valueOf(s[1]);
                String period = s[2];
                if (period == null) {
                    this.valueList.add(minValue);
                    this.valueList.add(maxValue);
                    continue;
                }
                long x1 = maxValue.getTimeInMillis();
                long x0 = minValue.getTimeInMillis();
                long distance = x1 - x0;
                long step = 0L;
                boolean isTimeField = false;
                String val = "";
                block8: for (int j = 0; j < period.length(); ++j) {
                    if (period.charAt(j) == 'P') continue;
                    if (period.charAt(j) == 'T') {
                        isTimeField = true;
                        continue;
                    }
                    switch (period.charAt(j)) {
                        case 'Y': {
                            step += (long)Integer.parseInt(val) * 31558149700L;
                            val = "";
                            continue block8;
                        }
                        case 'M': {
                            step = isTimeField ? (step += (long)Integer.parseInt(val) * 60000L) : (step += (long)Integer.parseInt(val) * 2592000000L);
                            val = "";
                            continue block8;
                        }
                        case 'D': {
                            step += (long)Integer.parseInt(val) * 86400000L;
                            val = "";
                            continue block8;
                        }
                        case 'H': {
                            step += (long)Integer.parseInt(val) * 3600000L;
                            val = "";
                            continue block8;
                        }
                        case 'S': {
                            step += (long)(Integer.parseInt(val) * 1000);
                            val = "";
                            continue block8;
                        }
                        default: {
                            val = val + period.charAt(j);
                        }
                    }
                }
                int valueCount = (int)(distance / step) + 1;
                this.valueList.add(minValue);
                for (int pos = 1; pos < valueCount; ++pos) {
                    long newTime = minValue.getTimeInMillis();
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTimeInMillis(newTime += step * (long)pos);
                    if (cal.after(maxValue) || cal.before(minValue)) continue;
                    this.valueList.add(cal);
                }
                this.valueList.add(maxValue);
                continue;
            }
            this.compiled = false;
            throw new IllegalArgumentException();
        }
    }

    private String toString(GregorianCalendar cal) {
        int iYear = cal.get(1);
        int iMonth = cal.get(2) + 1;
        int iDay = cal.get(5);
        int iHour = cal.get(11);
        int iMinute = cal.get(12);
        int iSecond = cal.get(13);
        String myYear = iYear < 10 ? "200" + iYear : (iYear < 100 ? "20" + iYear : (iYear < 1000 ? "2" + iYear : "" + iYear));
        String myMonth = iMonth < 10 ? "0" + iMonth : "" + iMonth;
        String myDay = iDay < 10 ? "0" + iDay : "" + iDay;
        String myHour = iHour < 10 ? "0" + iHour : "" + iHour;
        String myMinute = iMinute < 10 ? "0" + iMinute : "" + iMinute;
        String mySecond = iSecond < 10 ? "0" + iSecond : "" + iSecond;
        int myMilliSecond = cal.get(14);
        String s = null;
        if (this.format == 1) {
            s = myYear + "";
        } else if (this.format == 2) {
            s = myYear + "-" + myMonth;
        } else if (this.format == 3) {
            s = myYear + "-" + myMonth + "-" + myDay;
        } else if (this.format == 4) {
            s = myYear + "-" + myMonth + "-" + myDay + "T" + myHour + ":" + myMinute + ":" + mySecond + "." + myMilliSecond / 10 + "Z";
        }
        if (iYear < 0) {
            s = "B" + s;
        }
        return s;
    }

    private void upgradeFormat(byte sFormat) {
        switch (sFormat) {
            case 1: {
                if (this.format >= 1) break;
                this.format = 1;
                break;
            }
            case 2: {
                if (this.format >= 2) break;
                this.format = (byte)2;
                break;
            }
            case 3: {
                if (this.format >= 3) break;
                this.format = (byte)3;
                break;
            }
            case 4: {
                if (this.format >= 4) break;
                this.format = (byte)4;
            }
        }
    }
}

