/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.jdbc.service;

import java.text.MessageFormat;
import java.util.Objects;
import org.cresques.cts.ICoordTrans;
import org.gvsig.export.ExportAttributes;
import org.gvsig.export.ExportException;
import org.gvsig.export.ExportLocator;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.ExportParametersGeometry;
import org.gvsig.export.jdbc.service.ExportJDBCParameters;
import org.gvsig.export.spi.AbstractExportService;
import org.gvsig.export.spi.ExportService;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.export.spi.ExportServiceManager;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorer;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryCoercionContext;
import org.gvsig.tools.dispose.DisposableIterator;

public class ExportJDBCService
extends AbstractExportService
implements ExportService {
    private FeatureType targetFeatureType;

    protected ExportJDBCService(ExportServiceFactory factory, ExportJDBCParameters parameters) {
        super(factory, (ExportParameters)parameters);
    }

    public ExportJDBCParameters getParameters() {
        return (ExportJDBCParameters)super.getParameters();
    }

    protected JDBCServerExplorer createServerExplorer() throws ExportException {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorer explorer = (JDBCServerExplorer)dataManager.openServerExplorer(this.getParameters().getExplorerParameters().getExplorerName(), (DataServerExplorerParameters)this.getParameters().getExplorerParameters());
            return explorer;
        }
        catch (Exception e) {
            throw new ExportException((Throwable)e);
        }
    }

    protected NewDataStoreParameters createTargetNewStoreParameters() throws ExportException {
        try {
            EditableFeatureAttributeDescriptor attrdescriptor;
            JDBCServerExplorer explorer = this.createServerExplorer();
            DataManager manager = DALLocator.getDataManager();
            FeatureStoreProviderFactory factory = (FeatureStoreProviderFactory)manager.getStoreProviderFactory(explorer.getStoreName());
            boolean preferNotToUseNonNullRestrictions = factory.preferNotToUseNonNullRestrictions();
            ExportAttributes exportAttributes = this.getParameters().getExportAttributes();
            FeatureType targetTempFeatureType = exportAttributes.getTargetFeatureType().getCopy();
            EditableFeatureType targetEditableFeatureType = targetTempFeatureType.getEditable();
            targetEditableFeatureType.setHasOID(false);
            for (int i = 0; i < targetEditableFeatureType.size(); ++i) {
                EditableFeatureAttributeDescriptor eAttr = (EditableFeatureAttributeDescriptor)targetEditableFeatureType.get(i);
                if (eAttr.isPrimaryKey() && factory.allowEditableFeatureType() != 2) {
                    eAttr.setIsPrimaryKey(false);
                    eAttr.setAllowNull(false);
                    continue;
                }
                if (!preferNotToUseNonNullRestrictions) continue;
                eAttr.setAllowNull(true);
            }
            String pkname = this.getParameters().getPrimaryKey();
            if (pkname != null) {
                pkname = this.getParameters().getExportAttributes().getTargetName(pkname);
                EditableFeatureAttributeDescriptor pk = (EditableFeatureAttributeDescriptor)targetEditableFeatureType.get(pkname);
                if (pk == null) {
                    pkname = this.getParameters().getExportAttributes().getNamesTranslator().getSuggestion(pkname);
                    pk = targetEditableFeatureType.add(pkname, 5);
                    pk.setIsPrimaryKey(true);
                    pk.setIsAutomatic(true);
                    pk.setIsReadOnly(true);
                } else {
                    pk.setIsPrimaryKey(true);
                }
            }
            if ((attrdescriptor = (EditableFeatureAttributeDescriptor)targetEditableFeatureType.getDefaultGeometryAttribute()) != null && this.getParameters().getCreateIndexInGeometryRow()) {
                attrdescriptor.setIsIndexed(true);
            }
            if (attrdescriptor != null) {
                attrdescriptor.setSRS(this.getParameters().getTargetProjection());
                attrdescriptor.setGeometryType(this.getParameters().getTargetGeometryType());
            }
            this.targetFeatureType = targetEditableFeatureType.getNotEditableCopy();
            if (factory.allowEditableFeatureType() != 2) {
                for (int i = 0; i < targetEditableFeatureType.size(); ++i) {
                    EditableFeatureAttributeDescriptor x = (EditableFeatureAttributeDescriptor)targetEditableFeatureType.get(i);
                    x.setIsIndexed(false);
                }
            }
            JDBCNewStoreParameters createTableParams = explorer.getAddParameters();
            createTableParams.setSelectRole(this.getParameters().getSelectRole());
            createTableParams.setInsertRole(this.getParameters().getInsertRole());
            createTableParams.setUpdateRole(this.getParameters().getUpdateRole());
            createTableParams.setDeleteRole(this.getParameters().getDeleteRole());
            createTableParams.setTruncateRole(this.getParameters().getTruncateRole());
            createTableParams.setReferenceRole(this.getParameters().getReferenceRole());
            createTableParams.setTriggerRole(this.getParameters().getTriggerRole());
            createTableParams.setAllRole(this.getParameters().getAllRole());
            createTableParams.setSchema(this.getParameters().getSchema());
            createTableParams.setPostCreatingStatement(this.getParameters().getPostCreatingStatement());
            createTableParams.setDefaultFeatureType((FeatureType)targetEditableFeatureType);
            createTableParams.setTable(this.getParameters().getTableName());
            return createTableParams;
        }
        catch (Exception ex) {
            throw new ExportException((Throwable)ex);
        }
    }

    public OpenDataStoreParameters createTargetOpenStoreParameters() throws ExportException {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            JDBCServerExplorer explorer = this.createServerExplorer();
            JDBCStoreParameters openStoreParameters = (JDBCStoreParameters)explorer.getOpenParameters();
            openStoreParameters.setSchema(this.getParameters().getSchema());
            openStoreParameters.setTable(this.getParameters().getTableName());
            openStoreParameters.setCRS(this.getParameters().getTargetProjection());
            openStoreParameters.setDefaultGeometryField(this.getParameters().getTargetFeatureType().getDefaultGeometryAttributeName());
            return openStoreParameters;
        }
        catch (DataException ex) {
            throw new ExportException((Throwable)ex);
        }
    }

    private int getGeometryColumnCount(FeatureType featureType) {
        int count = 0;
        for (int i = 0; i < featureType.size(); ++i) {
            if (featureType.getAttributeDescriptor(i).getType() != 66) continue;
            ++count;
        }
        return count;
    }

    public void export(FeatureSet featureSet) throws ExportException {
        DisposableIterator it = null;
        EditableFeature targetFeature = null;
        FeatureStore target = null;
        Feature feature = null;
        DataManager dataManager = DALLocator.getDataManager();
        DataTransaction trans = dataManager.createTransaction();
        try {
            GeometryCoercionContext coercionContext;
            ExportServiceManager serviceManager = ExportLocator.getServiceManager();
            ICoordTrans coord_trans = this.getParameters().getTransformationToUse();
            JDBCServerExplorer explorer = this.createServerExplorer();
            trans.add((DataServerExplorer)explorer);
            if (this.getParameters().canCreatetable()) {
                LOG.debug("Creating table");
                this.getTaskStatus().message("Creating table");
                NewDataStoreParameters targetNewStoreParameters = this.createTargetNewStoreParameters();
                explorer.add(targetNewStoreParameters.getDataStoreName(), targetNewStoreParameters, true);
                this.getParameters().setTableName(((JDBCNewStoreParameters)targetNewStoreParameters).getTable());
            }
            JDBCStoreParameters openParams = (JDBCStoreParameters)this.createTargetOpenStoreParameters();
            try {
                LOG.info("Start export " + Objects.toString(openParams));
            }
            catch (Throwable t) {
                LOG.info("Start export");
            }
            target = (FeatureStore)explorer.open((DataStoreParameters)openParams);
            FeatureType theTargetFeatureType = target.getDefaultFeatureType();
            FeatureType theSourceFeatureType = featureSet.getDefaultFeatureType();
            if (!this.getParameters().canCreatetable() && this.getParameters().isDeleteRows()) {
                Expression filter = this.getParameters().getDeleteRowsFilter();
                if (ExpressionUtils.isPhraseEmpty((Expression)filter)) {
                    filter = ExpressionUtils.createExpression((String)"1=1");
                }
                target.edit(3);
                target.delete(filter);
                target.finishEditing();
            }
            target.edit(2);
            long featureCount = 1L;
            this.getTaskStatus().setRangeOfValues(1L, featureSet.getSize());
            int targetGeometryIndex = -1;
            int sourceGeometryIndex = -1;
            if (this.getGeometryColumnCount(theSourceFeatureType) == 1 && this.getGeometryColumnCount(theTargetFeatureType) == 1) {
                targetGeometryIndex = theTargetFeatureType.getDefaultGeometryAttributeIndex();
                sourceGeometryIndex = theSourceFeatureType.getDefaultGeometryAttributeIndex();
            } else {
                FeatureAttributeDescriptor attr = theSourceFeatureType.getDefaultGeometryAttribute();
                if (attr != null && theTargetFeatureType.getAttributeDescriptor(attr.getName()) != null) {
                    sourceGeometryIndex = attr.getIndex();
                    targetGeometryIndex = theTargetFeatureType.getAttributeDescriptor(attr.getName()).getIndex();
                }
            }
            if (targetGeometryIndex != -1 && (coercionContext = (GeometryCoercionContext)theTargetFeatureType.getAttributeDescriptor(targetGeometryIndex).getCoercionContext()) != null) {
                coercionContext.setMode(1);
            }
            LOG.debug("Inserting rows");
            this.getTaskStatus().message("Inserting rows");
            it = featureSet.fastIterator();
            block19: while (it.hasNext()) {
                feature = (Feature)it.next();
                targetFeature = target.createNewFeature(theTargetFeatureType, true);
                targetFeature.copyFrom(feature);
                for (int i = 0; i < theSourceFeatureType.size(); ++i) {
                    String targetField;
                    int targetAttributeIndex;
                    if (i == sourceGeometryIndex) {
                        targetFeature.set(targetGeometryIndex, feature.get(sourceGeometryIndex));
                        continue;
                    }
                    FeatureAttributeDescriptor sourceField = theSourceFeatureType.getAttributeDescriptor(i);
                    if (!this.getParameters().getExportAttributes().getExportAttribute(sourceField.getName()).isExported() || (targetAttributeIndex = theTargetFeatureType.getIndex(targetField = this.getParameters().getExportAttributes().getTargetName(sourceField.getName()))) < 0 || theTargetFeatureType.getAttributeDescriptor(targetField).isReadOnly()) continue;
                    targetFeature.set(targetAttributeIndex, feature.get(sourceField.getName()));
                }
                if (targetGeometryIndex != -1) {
                    Geometry geometry = targetFeature.getGeometry(targetGeometryIndex);
                    ExportServiceManager.FixGeometryStatus check = serviceManager.fixGeometry((ExportParametersGeometry)this.getParameters(), coord_trans, geometry);
                    switch (check.getState()) {
                        case 0: {
                            targetFeature.setDefaultGeometry(check.getGeometry());
                            break;
                        }
                        case 1: {
                            continue block19;
                        }
                        case 2: {
                            throw new AbstractExportService.InvalidGeometryException((Feature)targetFeature, check.getMessage());
                        }
                    }
                }
                target.insert(targetFeature);
                this.getTaskStatus().incrementCurrentValue();
                if (this.getTaskStatus().isCancellationRequested()) {
                    return;
                }
                ++featureCount;
            }
            String msgRowCount = MessageFormat.format(" ({0,number, #,###} rows)", featureCount);
            targetFeature = null;
            this.getTaskStatus().setIndeterminate();
            LOG.debug("Finish editing" + msgRowCount);
            if (featureCount > 50000L) {
                this.getTaskStatus().message("Finishing insertion of records, may take a while" + msgRowCount);
            } else {
                this.getTaskStatus().message("Finishing insertion of records" + msgRowCount);
            }
            target.finishEditing();
            if (this.getParameters().canCreatetable() && ((FeatureStoreProviderFactory)target.getProviderFactory()).allowEditableFeatureType() != 2) {
                this.getTaskStatus().message("Preparing the update of the indices" + msgRowCount);
                target.edit();
                EditableFeatureType ft = target.getDefaultFeatureType().getEditable();
                for (FeatureAttributeDescriptor attr : this.targetFeatureType) {
                    EditableFeatureAttributeDescriptor attr2 = (EditableFeatureAttributeDescriptor)ft.getAttributeDescriptor(attr.getName());
                    if (attr2 == null) continue;
                    if (attr2.isPrimaryKey()) {
                        attr2.setAllowNull(false);
                    }
                    attr2.setIsIndexed(attr.isIndexed());
                    attr2.setIsAutomatic(attr.isAutomatic());
                    attr2.setIsReadOnly(attr.isReadOnly());
                }
                target.update(ft);
                this.getTaskStatus().message("Updating the indices" + msgRowCount);
                target.finishEditing();
            }
            if (this.getParameters().getUpdateTableStatistics()) {
                LOG.debug("Updating statistics");
                this.getTaskStatus().message("Updating statistics" + msgRowCount);
                explorer.updateTableStatistics(openParams.getDBName(), openParams.getSchema(), openParams.getTable());
            }
            LOG.info("Finish export");
            trans.commit();
            this.getTaskStatus().message("Exportation finished");
            this.getTaskStatus().terminate();
        }
        catch (Exception e) {
            LOG.warn("Can't export data.", (Throwable)e);
            trans.rollbackQuietly();
            this.getTaskStatus().message("Problems exporting data");
            throw new ExportException((Throwable)e, targetFeature);
        }
        finally {
            if (it != null) {
                it.dispose();
            }
            featureSet.dispose();
            if (target != null) {
                if (target.isAppending()) {
                    try {
                        target.cancelEditing();
                    }
                    catch (Exception ex) {
                        LOG.warn("Can't cancel editing.", (Throwable)ex);
                    }
                }
                target.dispose();
            }
            DataTransaction.close((DataTransaction)trans);
            this.getTaskStatus().terminate();
            this.getTaskStatus().remove();
        }
    }
}

