/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.jdbc.swing.panels;

import javax.swing.JComponent;
import org.gvsig.export.jdbc.service.ExportJDBCParameters;
import org.gvsig.export.jdbc.swing.panels.GeometryIndexPanelLayout;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.feature.FeatureStoreProviderFactory;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeometryIndexPanel
extends GeometryIndexPanelLayout
implements ExportPanel {
    private static final long serialVersionUID = -3995015914295698209L;
    private static final Logger logger = LoggerFactory.getLogger(GeometryIndexPanel.class);
    private final ExportJDBCParameters parameters;
    private final JExportProcessPanel processPanel;

    public GeometryIndexPanel(JExportProcessPanel processPanel, ExportJDBCParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = parameters;
        this.initComponents();
    }

    private void initComponents() {
        this.translate();
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblHeader.setText("<html>" + i18nManager.getTranslation("_Create_spatial_index_header") + "</html>");
        this.chkCreateGeometryIndex.setText(i18nManager.getTranslation("_Crear_indice_espacial_sobre_las_columnas_de_tipo_geometria"));
    }

    public String getIdPanel() {
        return this.getClass().getCanonicalName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Create_spatial_index");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return true;
    }

    public void enterPanel() {
        String providerName = this.parameters.getExplorerParameters().getProviderName();
        DataManager dataManager = DALLocator.getDataManager();
        DataStoreProviderFactory storeProviderFactory = dataManager.getStoreProviderFactory(providerName);
        FeatureStoreProviderFactory providerFactory = (FeatureStoreProviderFactory)storeProviderFactory;
        if (providerFactory.allowSpatialIndexSupport()) {
            if (this.parameters.canCreatetable()) {
                int index = -1;
                index = this.parameters.getSourceFeatureType().getDefaultGeometryAttributeIndex();
                if (index < 0) {
                    this.chkCreateGeometryIndex.setEnabled(false);
                    this.chkCreateGeometryIndex.setSelected(false);
                } else {
                    this.chkCreateGeometryIndex.setEnabled(true);
                    this.chkCreateGeometryIndex.setSelected(true);
                }
            } else {
                this.chkCreateGeometryIndex.setEnabled(false);
                this.chkCreateGeometryIndex.setSelected(false);
            }
            this.chkCreateGeometryIndex.setSelected(this.parameters.getCreateIndexInGeometryRow());
        } else {
            this.chkCreateGeometryIndex.setEnabled(false);
            this.chkCreateGeometryIndex.setSelected(false);
        }
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        this.parameters.setCreateIndexInGeometryRow(this.chkCreateGeometryIndex.isSelected());
    }

    public JComponent asJComponent() {
        return this;
    }

    public boolean getCreateIndexInGeometryRow() {
        return this.chkCreateGeometryIndex.isSelected();
    }
}

