/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.feature.spi.simpleprovider;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.BaseStoresRepository;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.DataRuntimeException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.exception.PerformEditingException;
import org.gvsig.fmap.dal.feature.spi.DefaultFeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.feature.spi.memory.AbstractMemoryStoreProvider;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.AutomaticDetectionOfTypes;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReader;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReaderFactory;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReaderStoreParameters;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.spi.DALSPILocator;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dispose.impl.AbstractDisposable;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.gvsig.tools.util.UnmodifiableBasicMap;
import org.gvsig.tools.util.UnmodifiableBasicMapToMapAdapter;
import org.gvsig.tools.util.UnmodifiableBasicSet;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSequentialReaderStoreProvider
extends AbstractMemoryStoreProvider
implements ResourceConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSequentialReaderStoreProvider.class);
    private final ResourceProvider resource;
    private Envelope envelope;
    private boolean need_calculate_envelope = false;
    private String name = "";
    private final SimpleSequentialReaderFactory readerFactory;
    private List<ReaderData> childrenData;
    private ReaderData readerData;
    private final boolean isAChild;

    public SimpleSequentialReaderStoreProvider(SimpleSequentialReaderFactory readerFactory, SimpleSequentialReaderStoreParameters parameters, DataStoreProviderServices storeServices) throws InitializeException {
        this(readerFactory, parameters, storeServices, new ArrayList<ReaderData>(), null);
    }

    private SimpleSequentialReaderStoreProvider(SimpleSequentialReaderFactory readerFactory, SimpleSequentialReaderStoreParameters parameters, DataStoreProviderServices storeServices, List<ReaderData> childrenData, ReaderData readerData) throws InitializeException {
        super((DataStoreParameters)parameters, storeServices, FileHelper.newMetadataContainer(readerFactory.getName()));
        this.childrenData = childrenData;
        for (ReaderData readerDataChild : childrenData) {
            DisposeUtils.bind((Disposable)readerDataChild);
        }
        this.readerData = readerData;
        if (this.readerData != null) {
            DisposeUtils.bind((Disposable)this.readerData);
        }
        this.readerFactory = readerFactory;
        this.isAChild = this.readerData != null;
        File file = this.getParameters().getFile();
        this.resource = this.createResource("file", new Object[]{file.getAbsolutePath()});
        this.resource.addConsumer((ResourceConsumer)this);
        if (this.readerData != null) {
            this.name = this.readerData.getName();
        }
        if (storeServices != null) {
            this.initializeFeatureTypes();
        }
    }

    public String toString() {
        try {
            if (this.readerData == null) {
                return this.getFullName() + " " + this.childrenData.size();
            }
            return this.readerData.getName() + " " + this.getFullName() + " " + this.childrenData.size();
        }
        catch (Exception ex) {
            return super.toString();
        }
    }

    private boolean isChild() {
        return this.isAChild;
    }

    protected void setStoreServices(FeatureStoreProviderServices storeServices) {
        super.setStoreServices(storeServices);
        try {
            this.initializeFeatureTypes();
        }
        catch (InitializeException ex) {
            throw new DataRuntimeException("Can't initialize feature type", (Throwable)ex);
        }
    }

    public FeatureStoreProviderServices getStoreServices() {
        if (this.store == null) {
            LOGGER.warn("Algo no anda bien, el store es null");
            DataStore theStore = this.readerData.createStore();
            if (theStore == null) {
                return null;
            }
            this.store = (FeatureStoreProviderServices)theStore;
        }
        return this.store;
    }

    public SimpleSequentialReaderStoreParameters getParameters() {
        return (SimpleSequentialReaderStoreParameters)super.getParameters();
    }

    public String getProviderName() {
        if (this.readerFactory == null) {
            return "unknown";
        }
        return this.readerFactory.getName();
    }

    public boolean allowWrite() {
        return false;
    }

    private String getFullFileName() {
        String s;
        try {
            s = this.getParameters().getFile().getAbsolutePath();
        }
        catch (Exception e2) {
            s = "(unknow)";
        }
        return s;
    }

    public void open() throws OpenException {
        if (this.data != null) {
            return;
        }
        this.data = new ArrayList();
        this.resource.setData(new HashMap());
        try {
            this.loadFeatures();
        }
        catch (RuntimeException e) {
            LOGGER.warn("Can't load features from '" + this.getProviderName() + "' file '" + this.getFullFileName() + "'.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("Can't load features from '" + this.getProviderName() + "' file '" + this.getFullFileName() + "'.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public DataServerExplorer getExplorer() throws ReadException {
        DataManager manager = DALLocator.getDataManager();
        try {
            FilesystemServerExplorerParameters params = (FilesystemServerExplorerParameters)manager.createServerExplorerParameters("FilesystemExplorer");
            params.setRoot(this.getParameters().getFile().getParent());
            return manager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)params);
        }
        catch (DataException | ValidateDataParametersException e) {
            throw new ReadException(this.getProviderName(), e);
        }
    }

    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator originalFeatureTypesUpdated) throws PerformEditingException {
        throw new UnsupportedOperationException();
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return true;
    }

    public int getOIDType() {
        return 5;
    }

    public boolean supportsAppendMode() {
        return false;
    }

    public void append(FeatureProvider featureProvider) {
        throw new UnsupportedOperationException();
    }

    public void beginAppend() {
        throw new UnsupportedOperationException();
    }

    public void endAppend() {
        throw new UnsupportedOperationException();
    }

    public Object createNewOID() {
        throw new UnsupportedOperationException();
    }

    public FeatureProvider createFeatureProvider(FeatureType featureType) throws DataException {
        return new SimpleSequentialReaderFeatureProvider(featureType);
    }

    protected void doDispose() throws BaseException {
        for (ReaderData theReaderData : this.childrenData) {
            DisposeUtils.disposeQuietly((Disposable)theReaderData);
        }
        this.childrenData = null;
        DisposeUtils.disposeQuietly((Disposable)this.readerData);
        this.readerData = null;
        this.envelope = null;
        super.doDispose();
    }

    private void initializeFeatureTypes() throws InitializeException {
        try {
            this.open();
        }
        catch (OpenException e) {
            throw new InitializeException(this.getProviderName(), (Throwable)e);
        }
    }

    public Envelope getEnvelope() throws DataException {
        this.open();
        if (this.envelope != null) {
            return this.envelope;
        }
        if (!this.need_calculate_envelope) {
            return null;
        }
        FeatureStore fs = this.getFeatureStore();
        FeatureType ft = fs.getDefaultFeatureType();
        FeatureAttributeDescriptor fad = ft.getAttributeDescriptor(ft.getDefaultGeometryAttributeIndex());
        try {
            this.envelope = GeometryLocator.getGeometryManager().createEnvelope(fad.getGeomType().getSubType());
            fs.accept(new Visitor(){

                public void visit(Object obj) throws VisitCanceledException, BaseException {
                    Feature f = (Feature)obj;
                    Geometry geom = f.getDefaultGeometry();
                    if (geom != null) {
                        SimpleSequentialReaderStoreProvider.this.envelope.add(geom.getEnvelope());
                    }
                }
            });
        }
        catch (BaseException e) {
            LOGGER.warn("Can't calculate the envelope of '" + this.getProviderName() + "' file '" + this.getFullName() + "'.", (Throwable)e);
            this.envelope = null;
        }
        this.need_calculate_envelope = false;
        return this.envelope;
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        if ("Envelope".equalsIgnoreCase(name)) {
            try {
                return this.getEnvelope();
            }
            catch (DataException e) {
                return null;
            }
        }
        if ("CRS".equalsIgnoreCase(name)) {
            IProjection pro = this.getParameters().getCRS();
            if (pro != null) {
                return pro;
            }
            try {
                FeatureType type = this.getStoreServices().getDefaultFeatureType();
                pro = type.getDefaultSRS();
                if (pro != null) {
                    return pro;
                }
            }
            catch (DataException dataException) {
                // empty catch block
            }
        }
        return super.getDynValue(name);
    }

    public void resourceChanged(ResourceProvider resource) {
        this.getStoreServices().notifyChange("resourceChange_DataStore", (Resource)resource);
    }

    public Object getSourceId() {
        return this.getParameters().getFile();
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.getParameters().getFile().getAbsolutePath();
    }

    public ResourceProvider getResource() {
        return this.resource;
    }

    private String[] split(String value, String separators) {
        int firstSeparatorPosition = 1000000;
        Character sep = null;
        for (char ch : separators.toCharArray()) {
            int pos = value.indexOf(ch);
            if (pos <= 0 || pos >= firstSeparatorPosition) continue;
            sep = Character.valueOf(ch);
            firstSeparatorPosition = pos;
        }
        if (sep == null) {
            return new String[]{value};
        }
        return value.split("[" + sep + "]");
    }

    private EditableFeatureType getFeatureType(List<String> headers, int[] automaticTypes) {
        EditableFeatureAttributeDescriptor fad;
        int[] param_sizes;
        int i;
        EditableFeatureType fType = this.getStoreServices().createFeatureType(this.getName());
        fType.setHasOID(true);
        FieldTypeParser[] fieldTypes = new FieldTypeParser[headers.size()];
        for (i = 0; i < fieldTypes.length; ++i) {
            fieldTypes[i] = new FieldTypeParser();
        }
        if (automaticTypes != null) {
            for (i = 0; i < fieldTypes.length && i < automaticTypes.length; ++i) {
                fieldTypes[i].type = automaticTypes[i];
            }
        }
        for (i = 0; i < fieldTypes.length; ++i) {
            fieldTypes[i].parse(headers.get(i));
        }
        int[] param_types = this.getParameters().getFieldTypes();
        if (param_types != null) {
            for (int i2 = 0; i2 < fieldTypes.length && i2 < param_types.length; ++i2) {
                fieldTypes[i2].type = param_types[i2];
            }
        }
        if ((param_sizes = this.getParameters().getFieldSizes()) != null) {
            for (int i3 = 0; i3 < param_sizes.length; ++i3) {
                if (param_sizes[i3] <= 0) continue;
                fieldTypes[i3].size = param_sizes[i3];
            }
        }
        DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
        for (FieldTypeParser fieldType : fieldTypes) {
            fad = fType.add(fieldType.name, fieldType.type);
            fad.setSize(fieldType.size);
            if (fieldType.type == 66) {
                fad.setGeometryType(fieldType.geomType, fieldType.geomSubtype);
                if (fType.getDefaultGeometryAttributeName() == null) {
                    fType.setDefaultGeometryAttributeName(fieldType.name);
                }
            }
            for (Map.Entry<String, String> entry : fieldType.assignments.entrySet()) {
                try {
                    switch (entry.getKey().toLowerCase()) {
                        case "expression": {
                            break;
                        }
                        default: {
                            fad.set(entry.getKey(), (Object)entry.getValue());
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't set property '" + entry.getKey() + "' of '" + fad.getName() + "'.", (Throwable)ex);
                }
            }
            Tags tags = fad.getTags();
            for (Object entry3 : fieldType.tags.entrySet()) {
                tags.set((String)entry3.getKey(), entry3.getValue());
            }
        }
        for (FieldTypeParser fieldType : fieldTypes) {
            fad = fType.getEditableAttributeDescriptor(fieldType.name);
            for (Map.Entry<String, String> entry : fieldType.assignments.entrySet()) {
                try {
                    switch (entry.getKey().toLowerCase()) {
                        case "expression": {
                            fad.set(entry.getKey(), (Object)entry.getValue());
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Can't set property '" + entry.getKey() + "' in '" + fad.getName() + "' of '" + this.getFullFileName() + "'.", (Throwable)ex);
                }
            }
        }
        String[] pointDimensionNames = this.getParameters().getPointDimensionNames();
        if (pointDimensionNames != null) {
            PointAttributeEmulator emulator = new PointAttributeEmulator(pointDimensionNames);
            EditableFeatureAttributeDescriptor attr = fType.add("the_geom", 66, (FeatureAttributeEmulator)emulator);
            GeometryManager geommgr = GeometryLocator.getGeometryManager();
            try {
                GeometryType gt = emulator.fieldNames != null && emulator.fieldNames.length <= 2 ? geommgr.getGeometryType(0, 0) : geommgr.getGeometryType(0, 1);
                attr.setGeometryType(gt);
            }
            catch (Exception e) {
                LOGGER.warn("Can't set geometry type for the calculated field in '" + this.getProviderName() + "' file '" + this.getFullFileName() + "'.", (Throwable)e);
            }
        }
        return fType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFeatures() throws IOException, DataException, CoercionException, CloneNotSupportedException {
        ReaderData theReaderData = this.readerData;
        if (theReaderData == null) {
            theReaderData = new ReaderData();
            try (SimpleSequentialReader reader = this.readerFactory.createReader(this.getParameters());){
                this.loadFeatures(reader, theReaderData);
                StoresRepositoryWithChildren repoWithChildren = new StoresRepositoryWithChildren();
                StoresRepository repo = reader.getStoresRepository();
                if (repo != null) {
                    repoWithChildren.addRepository(repo);
                }
                this.childrenData = new ArrayList<ReaderData>();
                List<SimpleSequentialReader> children = reader.getChildren();
                for (SimpleSequentialReader childReader : children) {
                    ReaderData childData = new ReaderData();
                    try {
                        this.loadFeatures(childReader, childData);
                        this.childrenData.add(childData);
                        repoWithChildren.add(childReader.getName(), (DataStoreParameters)childData.getParameters());
                        if (!StringUtils.isBlank((CharSequence)childReader.getAlias())) {
                            repoWithChildren.add(childReader.getAlias(), (DataStoreParameters)childData.getParameters());
                        }
                        childData.setStoresRepository((StoresRepository)repoWithChildren);
                    }
                    finally {
                        childReader.close();
                    }
                }
                repoWithChildren.add(reader.getName(), (DataStoreParameters)theReaderData.getParameters());
                if (!StringUtils.isBlank((CharSequence)reader.getAlias())) {
                    repoWithChildren.add(reader.getAlias(), (DataStoreParameters)theReaderData.getParameters());
                }
                theReaderData.setStoresRepository((StoresRepository)repoWithChildren);
                this.readerData = theReaderData;
            }
        }
        this.name = theReaderData.getName();
        FeatureStoreProviderServices theStore = this.getStoreServices();
        theStore.setFeatureTypes(theReaderData.getFeatureTypes(), theReaderData.getDefaultFeatureType());
        this.need_calculate_envelope = theReaderData.getNeedCalculateEnvelope();
        this.data = theReaderData.getFeatures();
    }

    private void loadFeatures(SimpleSequentialReader reader, ReaderData readerData) throws IOException, DataException, CoercionException, CloneNotSupportedException {
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        SimpleTaskStatus taskStatus = manager.createDefaultSimpleTaskStatus(reader.getName());
        taskStatus.setAutoremove(true);
        taskStatus.setIndeterminate();
        taskStatus.add();
        try {
            taskStatus.message("_preparing");
            readerData.setName(reader.getName());
            readerData.setStoresRepository(reader.getStoresRepository());
            readerData.setResourcesStorage(reader.getResourcesStorage());
            readerData.setParameters(reader.getParameters());
            readerData.setAlias(reader.getAlias());
            boolean ignore_errors = this.getParameters().getIgnoreErrors();
            List<String> headers = this.getParameters().getFieldNames();
            if (headers == null) {
                headers = new ArrayList<String>();
                for (String fielddesc : reader.getFieldNames()) {
                    headers.add(fielddesc.toString());
                }
            }
            EditableFeatureType edftype = this.getFeatureType(headers, this.automaticDetectionOfTypes(reader));
            edftype.setLabel(reader.getLabel());
            edftype.setDescription(reader.getDescription());
            Map<String, String> tagsReader = reader.getTags();
            if (tagsReader != null) {
                Tags tagsType = edftype.getTags();
                for (Map.Entry<String, String> tag : tagsReader.entrySet()) {
                    tagsType.set(tag.getKey(), (Object)tag.getValue());
                }
            }
            FeatureType ftype = edftype.getNotEditableCopy();
            ArrayList<Object> ftypes = new ArrayList<FeatureType>();
            ftypes.add(ftype);
            readerData.setFeatureTypes(ftypes, ftype);
            Coercion[] coercion = new Coercion[ftype.size()];
            CoercionContext[] coercionContext = new CoercionContext[ftype.size()];
            int[] sizes = new int[ftype.size()];
            for (int i = 0; i < ftype.size(); ++i) {
                sizes[i] = -1;
                FeatureAttributeDescriptor ad = ftype.getAttributeDescriptor(i);
                coercion[i] = ad.getCoercion();
                coercionContext[i] = ad.getCoercionContext();
                if (ad.getDataType().getType() != 8 || ad.getSize() != 0) continue;
                sizes[i] = 0;
            }
            if (ftype.getDefaultGeometryAttributeName() != null) {
                readerData.setNeedCalculateEnvelope(true);
            }
            Locale locale = this.getParameters().getLocale();
            taskStatus.message("_loading");
            long rowCount = reader.getRowCount();
            if (rowCount > 0L) {
                taskStatus.setRangeOfValues(0L, rowCount);
            }
            int count = 0;
            int count_errors = 0;
            reader.rewind();
            List<Object> row = reader.read();
            while (row != null) {
                taskStatus.setCurValue((long)(++count));
                FeatureProvider feature = this.createFeatureProvider(ftype);
                for (int i = 0; i < row.size(); ++i) {
                    try {
                        int x;
                        if (ftype.get(i).isComputed()) continue;
                        Object rawvalue = row.get(i);
                        if (rawvalue instanceof String && StringUtils.isBlank((CharSequence)((String)rawvalue))) {
                            rawvalue = null;
                        }
                        Object value = coercion[i].coerce(rawvalue, coercionContext[i]);
                        feature.set(i, value);
                        if (sizes[i] < 0 || value == null || sizes[i] >= (x = ((String)value).length())) continue;
                        sizes[i] = x;
                        continue;
                    }
                    catch (Exception ex) {
                        if (!ignore_errors) {
                            throw ex;
                        }
                        if (count_errors++ < 10) {
                            LOGGER.warn("Can't load value of attribute " + i + " (" + ftype.getAttributeName(i) + ") in row " + count + " in '" + readerData.getName() + "'(row size " + row.size() + ", type size " + ftype.size() + ").", (Throwable)ex);
                        }
                        if (count_errors != 10) continue;
                        LOGGER.info("Too many errors, suppress messages.");
                    }
                }
                readerData.addFeatureProvider(feature);
                row = reader.read();
            }
            for (int i = 0; i < ftype.size(); ++i) {
                EditableFeatureAttributeDescriptor efad;
                if (sizes[i] <= 0 || (efad = (EditableFeatureAttributeDescriptor)edftype.getAttributeDescriptor(i)).getSize() >= sizes[i]) continue;
                efad.setSize(sizes[i]);
            }
            ftype = edftype.getNotEditableCopy();
            ftypes = new ArrayList();
            ftypes.add(ftype);
            readerData.setFeatureTypes(ftypes, ftype);
            taskStatus.terminate();
        }
        catch (IOException ex) {
            taskStatus.abort();
            LOGGER.warn("Can't load features from '" + this.getProviderName() + "' file '" + this.getFullFileName() + "'.", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            taskStatus.abort();
            LOGGER.warn("Can't load features from '" + this.getProviderName() + "' file '" + this.getFullFileName() + "'.", (Throwable)ex);
        }
    }

    private int[] automaticDetectionOfTypes(SimpleSequentialReader reader) throws IOException {
        boolean automatic_types_detection = this.getParameters().getAutomaticTypesDetection();
        if (!automatic_types_detection) {
            return null;
        }
        int[] types = null;
        try {
            reader.rewind();
            List<String> fieldNames = reader.getFieldNames();
            if (fieldNames == null) {
                fieldNames = this.getParameters().getFieldNames();
            }
            AutomaticDetectionOfTypes x = new AutomaticDetectionOfTypes(this.getFullFileName());
            types = x.detect(fieldNames.size(), reader, false, this.getParameters().getLocale());
        }
        catch (Exception ex) {
            throw new RuntimeException("Problems reading '" + this.getProviderName() + "' file '" + this.getFullFileName() + "'.", ex);
        }
        return types;
    }

    public boolean hasDynValue(String name) {
        if ("Envelope".equalsIgnoreCase(name)) {
            return true;
        }
        if ("CRS".equalsIgnoreCase(name)) {
            return true;
        }
        return super.hasDynValue(name);
    }

    public UnmodifiableBasicMap<String, DataStore> getChildren() {
        if (this.isChild()) {
            return null;
        }
        return new Children();
    }

    public StoresRepository getStoresRepository() {
        StoresRepository repo = this.readerData.getStoresRepository();
        return repo;
    }

    public ResourcesStorage getResourcesStorage() {
        ResourcesStorage storage = this.readerData.getResourcesStorage();
        return storage;
    }

    class PointAttributeEmulator
    implements FeatureAttributeEmulator {
        private static final int XNAME = 0;
        private static final int YNAME = 1;
        private static final int ZNAME = 2;
        private GeometryManager geommgr;
        private String[] fieldNames;
        private Coercion toDouble;
        private int errorcount = 0;

        public PointAttributeEmulator() {
        }

        public PointAttributeEmulator(String[] pointDimensionNames) {
            if (pointDimensionNames.length > 2) {
                this.fieldNames = new String[3];
                this.fieldNames[2] = pointDimensionNames[2];
            } else {
                this.fieldNames = new String[2];
            }
            this.fieldNames[0] = pointDimensionNames[0];
            this.fieldNames[1] = pointDimensionNames[1];
            this.geommgr = GeometryLocator.getGeometryManager();
            DataTypesManager datatypeManager = ToolsLocator.getDataTypesManager();
            this.toDouble = datatypeManager.getCoercion(7);
        }

        public Object get(Feature feature) {
            try {
                Point point;
                Object valueX = feature.get(this.fieldNames[0]);
                valueX = this.toDouble.coerce(valueX);
                if (valueX == null) {
                    return null;
                }
                Object valueY = feature.get(this.fieldNames[1]);
                if ((valueY = this.toDouble.coerce(valueY)) == null) {
                    return null;
                }
                Object valueZ = null;
                if (this.fieldNames.length > 2 && (valueZ = this.toDouble.coerce(feature.get(this.fieldNames[2]))) == null) {
                    return null;
                }
                double x = (Double)valueX;
                double y = (Double)valueY;
                if (this.fieldNames.length > 2) {
                    point = this.geommgr.createPoint(x, y, 1);
                    double z = (Double)valueZ;
                    point.setCoordinateAt(2, z);
                } else {
                    point = this.geommgr.createPoint(x, y, 0);
                }
                return point;
            }
            catch (Exception ex) {
                if (++this.errorcount < 5) {
                    LOGGER.warn("[" + this.errorcount + "] Can't create point from '" + SimpleSequentialReaderStoreProvider.this.getProviderName() + "' file." + "XNAME='" + this.fieldNames[0] + "', YNAME='" + this.fieldNames[1] + "', ZNAME='" + (this.fieldNames.length > 2 ? this.fieldNames[2] : "(2D)") + "' feature=" + feature.toString(), (Throwable)ex);
                }
                return null;
            }
        }

        public void set(EditableFeature feature, Object value) {
            if (value == null) {
                return;
            }
            Point point = value instanceof MultiPoint ? (Point)((MultiPoint)value).getPrimitiveAt(0) : (Point)value;
            feature.set(this.fieldNames[0], (Object)point.getX());
            feature.set(this.fieldNames[1], (Object)point.getY());
            if (this.fieldNames.length > 2) {
                feature.set(this.fieldNames[2], (Object)point.getCoordinateAt(2));
            }
        }

        public boolean allowSetting() {
            return true;
        }

        public String[] getRequiredFieldNames() {
            return this.fieldNames;
        }

        public JsonObject toJson() {
            return this.toJsonBuilder().build();
        }

        public JsonObjectBuilder toJsonBuilder() {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("fieldNames", (Object[])this.fieldNames);
            builder.add_class((Object)this);
            return builder;
        }

        public void fromJson(JsonObject json) {
            JsonArray jsonFieldNames = json.getJsonArray("fieldNames");
            this.fieldNames = new String[jsonFieldNames.size()];
            for (int i = 0; i < jsonFieldNames.size(); ++i) {
                this.fieldNames[0] = jsonFieldNames.getString(i);
            }
            this.geommgr = GeometryLocator.getGeometryManager();
            DataTypesManager datatypeManager = ToolsLocator.getDataTypesManager();
            this.toDouble = datatypeManager.getCoercion(7);
            this.errorcount = 0;
        }
    }

    private class FieldTypeParser {
        public String name = null;
        public int type = 8;
        public int size = 0;
        public int geomType = 0;
        public int geomSubtype = 0;
        public Map<String, String> tags = new HashMap<String, String>();
        public Map<String, String> assignments = new HashMap<String, String>();
        private String typename = "string";

        FieldTypeParser() {
        }

        private int getType(String value) {
            DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
            return dataTypesManager.getType(this.typename);
        }

        public boolean parse(String value) {
            String[] args;
            if (value.contains("__")) {
                args = value.split("__");
            } else {
                args = SimpleSequentialReaderStoreProvider.this.split(value, ":/#@!;-");
                if (args.length == 1) {
                    this.name = value;
                    return true;
                }
            }
            int n = 0;
            this.name = args[n++];
            if (n >= args.length) {
                return true;
            }
            this.typename = args[n++];
            this.type = this.getType(this.typename);
            if (this.type == 0) {
                this.geomType = GeometryUtils.getGeometryType((String)this.typename);
                if (this.geomType == -1) {
                    this.type = 8;
                    LOGGER.info("Type '" + this.typename + "' not valid for attribute '" + value + "' in '" + SimpleSequentialReaderStoreProvider.this.getProviderName() + "' file '" + SimpleSequentialReaderStoreProvider.this.getFullFileName() + "'.");
                } else {
                    this.typename = "GEOMETRY";
                    this.type = 66;
                }
            }
            switch (this.type) {
                case 8: {
                    this.size = 50;
                    break;
                }
                case 4: {
                    this.size = 10;
                    break;
                }
                case 5: {
                    this.size = 20;
                    break;
                }
                case 6: {
                    this.size = 10;
                    break;
                }
                case 7: {
                    this.size = 20;
                    break;
                }
                default: {
                    this.size = 0;
                }
            }
            block19: while (n < args.length) {
                String option;
                switch (option = args[n++].toLowerCase()) {
                    case "size": {
                        try {
                            this.size = Integer.parseInt(args[n++]);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Ignore incorrect field size for field " + value + " in '" + SimpleSequentialReaderStoreProvider.this.getProviderName() + "' file '" + SimpleSequentialReaderStoreProvider.this.getFullFileName() + "'.", (Throwable)ex);
                        }
                        continue block19;
                    }
                    case "tag": {
                        String x = args[n++];
                        int pos = x.indexOf("=");
                        if (pos < 0) {
                            this.tags.put(x, null);
                            continue block19;
                        }
                        this.tags.put(StringUtils.substring((String)x, (int)0, (int)pos), StringUtils.substring((String)x, (int)(pos + 1)));
                        continue block19;
                    }
                    case "set": {
                        String x = args[n++];
                        int pos = x.indexOf("=");
                        if (pos < 0) {
                            this.assignments.put(x, null);
                            continue block19;
                        }
                        this.assignments.put(StringUtils.substring((String)x, (int)0, (int)pos), StringUtils.substring((String)x, (int)(pos + 1)));
                        continue block19;
                    }
                }
                LOGGER.warn("Illegal argumente '" + option + "' for field '" + this.name + "' in '" + SimpleSequentialReaderStoreProvider.this.getProviderName() + "' file '" + SimpleSequentialReaderStoreProvider.this.getFullFileName() + "' (" + value + ").");
            }
            return true;
        }
    }

    class Children
    implements UnmodifiableBasicMap<String, DataStore> {
        Children() {
        }

        public DataStore get(String key) {
            for (ReaderData child : SimpleSequentialReaderStoreProvider.this.childrenData) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)child.getName(), (CharSequence)key)) continue;
                return child.createStore();
            }
            return null;
        }

        public boolean isEmpty() {
            return SimpleSequentialReaderStoreProvider.this.childrenData.isEmpty();
        }

        public boolean containsKey(String key) {
            for (ReaderData child : SimpleSequentialReaderStoreProvider.this.childrenData) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)child.getName(), (CharSequence)key)) continue;
                return true;
            }
            return false;
        }

        public Map<String, DataStore> toMap() {
            return new UnmodifiableBasicMapToMapAdapter((UnmodifiableBasicMap)this);
        }

        public int size() {
            return SimpleSequentialReaderStoreProvider.this.childrenData.size();
        }

        public UnmodifiableBasicSet<String> keySet() {
            return new UnmodifiableBasicSet<String>(){

                public boolean isEmpty() {
                    return SimpleSequentialReaderStoreProvider.this.childrenData.isEmpty();
                }

                public int size() {
                    return SimpleSequentialReaderStoreProvider.this.childrenData.size();
                }

                public Iterator<String> iterator() {
                    final Iterator it = SimpleSequentialReaderStoreProvider.this.childrenData.iterator();
                    return new Iterator<String>(){

                        @Override
                        public boolean hasNext() {
                            return it.hasNext();
                        }

                        @Override
                        public String next() {
                            ReaderData theReaderData = (ReaderData)((Object)it.next());
                            return theReaderData.getName();
                        }
                    };
                }
            };
        }

        public Iterator<DataStore> iterator() {
            final Iterator it = this.keySet().iterator();
            return new Iterator<DataStore>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public DataStore next() {
                    String name = (String)it.next();
                    return Children.this.get(name);
                }
            };
        }
    }

    private class ReaderData
    extends AbstractDisposable {
        private FeatureType defaultFeatureType;
        private List<FeatureType> featureTypes;
        private List<FeatureProvider> features = new ArrayList<FeatureProvider>();
        private boolean needCalculateEnvelope = false;
        private String name;
        private String alias;
        private long OIDcounter = 0L;
        private StoresRepository storesRepository;
        private OpenFeatureStoreParameters parameters;
        private ResourcesStorage resourcesStorage;

        public String toString() {
            return Objects.toString(this.name);
        }

        public void doDispose() {
            this.features = null;
            this.OIDcounter = 0L;
            this.defaultFeatureType = null;
            this.featureTypes = null;
            this.parameters = null;
            this.storesRepository = null;
        }

        public void addFeatureProvider(FeatureProvider feature) {
            feature.setOID((Object)this.OIDcounter++);
            this.features.add(feature);
        }

        public void setFeatureTypes(List<FeatureType> featureTypes, FeatureType defaultFeatureType) {
            this.featureTypes = featureTypes;
            this.defaultFeatureType = defaultFeatureType;
        }

        public void setNeedCalculateEnvelope(boolean needCalculateEnvelope) {
            this.needCalculateEnvelope = needCalculateEnvelope;
        }

        public boolean getNeedCalculateEnvelope() {
            return this.needCalculateEnvelope;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<FeatureType> getFeatureTypes() {
            return this.featureTypes;
        }

        public FeatureType getDefaultFeatureType() {
            return this.defaultFeatureType;
        }

        public List<FeatureProvider> getFeatures() {
            return this.features;
        }

        public DataStore createStore() {
            DataStore store;
            try {
                SimpleSequentialReaderStoreProvider provider = new SimpleSequentialReaderStoreProvider(SimpleSequentialReaderStoreProvider.this.readerFactory, (SimpleSequentialReaderStoreParameters)this.getParameters(), null, SimpleSequentialReaderStoreProvider.this.childrenData, this);
                DataManagerProviderServices manager = DALSPILocator.getDataManagerProviderServices();
                store = manager.openStore((DataStoreParameters)this.getParameters(), (DataStoreProvider)provider);
                provider.setStoreServices((FeatureStoreProviderServices)store);
                provider.name = this.name;
            }
            catch (Exception ex) {
                LOGGER.warn("Can't build store form child '" + this.name + "'.", (Throwable)ex);
                return null;
            }
            return store;
        }

        public void setStoresRepository(StoresRepository storesRepository) {
            this.storesRepository = storesRepository;
        }

        public StoresRepository getStoresRepository() {
            return this.storesRepository;
        }

        public ResourcesStorage getResourcesStorage() {
            return this.resourcesStorage;
        }

        public void setResourcesStorage(ResourcesStorage resourcesStorage) {
            this.resourcesStorage = resourcesStorage;
        }

        public void setParameters(OpenFeatureStoreParameters parameters) {
            if (parameters == null) {
                LOGGER.warn("Can't set parameters to null");
                return;
            }
            this.parameters = parameters;
        }

        public OpenFeatureStoreParameters getParameters() {
            return this.parameters;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }
    }

    private class StoresRepositoryWithChildren
    extends BaseStoresRepository {
        public StoresRepositoryWithChildren() {
            super(SimpleSequentialReaderStoreProvider.this.getName());
        }

        public DataStore getStore(String name) {
            if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)SimpleSequentialReaderStoreProvider.this.readerData.getName()) || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)SimpleSequentialReaderStoreProvider.this.readerData.getAlias())) {
                return SimpleSequentialReaderStoreProvider.this.readerData.createStore();
            }
            for (ReaderData child : SimpleSequentialReaderStoreProvider.this.childrenData) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)child.getName()) && !StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)child.getAlias())) continue;
                return child.createStore();
            }
            return super.getStore(name);
        }
    }

    private static class SimpleSequentialReaderFeatureProvider
    extends DefaultFeatureProvider {
        public SimpleSequentialReaderFeatureProvider(FeatureType type) {
            super(type);
        }

        public SimpleSequentialReaderFeatureProvider(FeatureType featureType, Object createNewOID) {
            super(featureType, createNewOID);
        }

        public FeatureType getType() {
            return super.getType();
        }
    }
}

