/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.resource.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.ResourceParameters;
import org.gvsig.fmap.dal.resource.exception.AccessResourceException;
import org.gvsig.fmap.dal.resource.exception.PrepareResourceException;
import org.gvsig.fmap.dal.resource.exception.ResourceException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyOpenException;
import org.gvsig.fmap.dal.resource.file.FileResourceParameters;
import org.gvsig.fmap.dal.resource.spi.AbstractResource;

public class FileResource
extends AbstractResource {
    public static final String NAME = "file";
    public static final String DESCRIPTION = "File of filesystem";
    private File file = null;

    public FileResource(FileResourceParameters params) throws InitializeException {
        super((ResourceParameters)params);
    }

    public Object get() throws AccessResourceException {
        return this.getFile();
    }

    public String getFileName() throws AccessResourceException {
        return this.getFile().getPath();
    }

    public File getFile() throws AccessResourceException {
        try {
            this.prepare();
        }
        catch (PrepareResourceException e) {
            throw new AccessResourceException((Resource)this, (Throwable)e);
        }
        return ((FileResourceParameters)this.getParameters()).getFile();
    }

    public FileInputStream getFileInputStream() throws AccessResourceException, FileNotFoundException {
        FileInputStream fis = new FileInputStream(this.getFile());
        try {
            this.notifyOpen();
        }
        catch (ResourceNotifyOpenException e) {
            throw new AccessResourceException((Resource)this, (Throwable)e);
        }
        return fis;
    }

    public String getName() throws AccessResourceException {
        return MessageFormat.format("FileResource({0})", this.getFileName());
    }

    public boolean isThis(ResourceParameters parameters) throws ResourceException {
        if (!(parameters instanceof FileResourceParameters)) {
            return false;
        }
        FileResourceParameters params = (FileResourceParameters)parameters.getCopy();
        this.prepare((ResourceParameters)params);
        return params.getFileName().equals(this.getFileName());
    }
}

