/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.geom.GeometryCoercionContext;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionContextLocale;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.task.SimpleTaskStatus;

public class AutomaticDetectionOfTypes {
    private final String filename;
    private Character decimalSeparator;
    private static char[] START_DECIMAL = new char[]{'-', '+', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public AutomaticDetectionOfTypes() {
        this("(unknown)");
    }

    public AutomaticDetectionOfTypes(String filename) {
        this.filename = filename;
    }

    private String getFullFileName() {
        return this.filename;
    }

    public DetectedValue[] detect(int columns, Rows rows, boolean isFirstLineHeader, Locale locale, SimpleTaskStatus status) throws IOException {
        ArrayList<DetectedValueImpl> detectedValues = new ArrayList<DetectedValueImpl>(columns);
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.decimalSeparator = null;
        if (status != null) {
            status.message(i18n.getTranslation("_Types_detection"));
        }
        int lineno = 0;
        try {
            if (isFirstLineHeader) {
                rows.nextRowValues();
                ++lineno;
            }
            ArrayList<PossibleDataType> possibleDataTypes = new ArrayList<PossibleDataType>(columns);
            for (int i = 0; i < columns; ++i) {
                possibleDataTypes.add(new PossibleDataType());
                detectedValues.add(new DetectedValueImpl());
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            DataTypesManager typeManager = ToolsLocator.getDataTypesManager();
            Coercion toDecimal = typeManager.getCoercion(19);
            Coercion toDouble = typeManager.getCoercion(7);
            Coercion toFloat = typeManager.getCoercion(6);
            Coercion toDate = typeManager.getCoercion(9);
            Coercion toTime = typeManager.getCoercion(10);
            Coercion toTimestamp = typeManager.getCoercion(11);
            Coercion toInt = typeManager.getCoercion(4);
            Coercion toLong = typeManager.getCoercion(5);
            Coercion toGeom = typeManager.getCoercion(66);
            GeometryCoercionContext geometryCoercionContext = GeometryLocator.getGeometryManager().createGeometryCoercionContext();
            geometryCoercionContext.setMode(4);
            CoercionContextLocale coercionContext = DataTypeUtils.coerceContextLocale((Locale)locale);
            List<String> row = rows.nextRowValues();
            ++lineno;
            int detectedValuesSize = detectedValues.size();
            while (row != null) {
                int i;
                int rowsize;
                if (status != null) {
                    status.incrementCurrentValue();
                    if (status.isCancellationRequested()) {
                        status.cancel();
                        break;
                    }
                }
                if ((rowsize = row.size()) > detectedValuesSize) {
                    for (i = detectedValuesSize; i < rowsize; ++i) {
                        possibleDataTypes.add(new PossibleDataType());
                        detectedValues.add(new DetectedValueImpl());
                    }
                    detectedValuesSize = detectedValues.size();
                }
                for (i = 0; i < rowsize; ++i) {
                    int displaySize;
                    while (possibleDataTypes.size() < row.size()) {
                        possibleDataTypes.add(new PossibleDataType());
                    }
                    PossibleDataType possibleDataType = (PossibleDataType)possibleDataTypes.get(i);
                    DetectedValueImpl detectedValue = (DetectedValueImpl)detectedValues.get(i);
                    String rawvalue = row.get(i);
                    if (StringUtils.isBlank((CharSequence)rawvalue)) continue;
                    possibleDataType.hasData = true;
                    if (detectedValue.blank) {
                        detectedValue.blank = StringUtils.isBlank((CharSequence)rawvalue);
                    }
                    if ((displaySize = rawvalue.length()) > detectedValue.displaySize) {
                        detectedValue.displaySize = displaySize;
                    }
                    if (possibleDataType.possibleDecimal) {
                        try {
                            if (this.canBeDecimal(rawvalue, locale)) {
                                int integerDigits;
                                BigDecimal decimal = (BigDecimal)toDecimal.coerce((Object)rawvalue, (CoercionContext)coercionContext);
                                possibleDataType.possibleDecimal = true;
                                if (decimal.scale() > detectedValue.decimalDigits) {
                                    detectedValue.decimalDigits = decimal.scale();
                                }
                                if ((integerDigits = decimal.precision() - decimal.scale()) > detectedValue.integerDigits) {
                                    detectedValue.integerDigits = integerDigits;
                                }
                            } else {
                                possibleDataType.possibleDecimal = false;
                            }
                        }
                        catch (Exception ex) {
                            possibleDataType.possibleDecimal = false;
                        }
                    }
                    if (possibleDataType.possibleDouble) {
                        try {
                            if (this.canBeDecimal(rawvalue, locale)) {
                                toDouble.coerce((Object)rawvalue, (CoercionContext)coercionContext);
                                possibleDataType.possibleDouble = true;
                            } else {
                                possibleDataType.possibleDouble = false;
                            }
                        }
                        catch (Exception ex) {
                            possibleDataType.possibleDouble = false;
                        }
                    }
                    if (possibleDataType.possibleFloat) {
                        try {
                            if (this.canBeDecimal(rawvalue, locale)) {
                                toFloat.coerce((Object)rawvalue, (CoercionContext)coercionContext);
                                possibleDataType.possibleFloat = true;
                            } else {
                                possibleDataType.possibleFloat = false;
                            }
                        }
                        catch (Exception ex) {
                            possibleDataType.possibleFloat = false;
                        }
                    }
                    if (possibleDataType.possibleLong) {
                        possibleDataType.possibleLong = this.isValidLong(rawvalue);
                    }
                    if (possibleDataType.possibleInt) {
                        possibleDataType.possibleInt = this.isValidInteger(rawvalue);
                    }
                    if (possibleDataType.possibleDate) {
                        try {
                            toDate.coerce((Object)rawvalue, (CoercionContext)coercionContext);
                            possibleDataType.possibleDate = true;
                        }
                        catch (Exception ex) {
                            possibleDataType.possibleDate = false;
                        }
                    }
                    if (possibleDataType.possibleTime) {
                        try {
                            toTime.coerce((Object)rawvalue, (CoercionContext)coercionContext);
                            possibleDataType.possibleTime = true;
                        }
                        catch (Exception ex) {
                            possibleDataType.possibleTime = false;
                        }
                    }
                    if (possibleDataType.possibleTimestamp) {
                        try {
                            toTimestamp.coerce((Object)rawvalue, (CoercionContext)coercionContext);
                            possibleDataType.possibleTimestamp = true;
                        }
                        catch (Exception ex) {
                            possibleDataType.possibleTimestamp = false;
                        }
                    }
                    if (possibleDataType.possibleURL) {
                        try {
                            new URL(rawvalue);
                            possibleDataType.possibleURL = true;
                        }
                        catch (Exception ex) {
                            possibleDataType.possibleURL = false;
                        }
                    }
                    if (!possibleDataType.possibleGeometry) continue;
                    try {
                        toGeom.coerce((Object)rawvalue, (CoercionContext)geometryCoercionContext);
                        possibleDataType.possibleGeometry = true;
                        continue;
                    }
                    catch (Exception ex) {
                        possibleDataType.possibleGeometry = false;
                    }
                }
                row = rows.nextRowValues();
                ++lineno;
            }
            if (status != null) {
                status.setRangeOfValues(0L, (long)lineno);
                status.setCurValue(0L);
            }
            int n = 0;
            for (PossibleDataType possibleDataType : possibleDataTypes) {
                if (!possibleDataType.hasData) {
                    ((DetectedValueImpl)detectedValues.get(n++)).blank = true;
                    continue;
                }
                if (possibleDataType.possibleInt) {
                    ((DetectedValueImpl)detectedValues.get(n++)).type = 4;
                    continue;
                }
                if (possibleDataType.possibleLong) {
                    ((DetectedValueImpl)detectedValues.get(n++)).type = 5;
                    continue;
                }
                if (possibleDataType.possibleDecimal) {
                    ((DetectedValueImpl)detectedValues.get(n++)).type = 19;
                    continue;
                }
                if (possibleDataType.possibleFloat) {
                    ((DetectedValueImpl)detectedValues.get(n++)).type = 7;
                    continue;
                }
                if (possibleDataType.possibleDouble) {
                    ((DetectedValueImpl)detectedValues.get(n++)).type = 7;
                    continue;
                }
                if (possibleDataType.possibleURL) {
                    ((DetectedValueImpl)detectedValues.get(n++)).type = 16;
                    continue;
                }
                if (possibleDataType.possibleDate) {
                    ((DetectedValueImpl)detectedValues.get(n++)).type = 9;
                    continue;
                }
                if (possibleDataType.possibleTime) {
                    ((DetectedValueImpl)detectedValues.get(n++)).type = 10;
                    continue;
                }
                if (possibleDataType.possibleTimestamp) {
                    ((DetectedValueImpl)detectedValues.get(n++)).type = 11;
                    continue;
                }
                if (possibleDataType.possibleGeometry) {
                    ((DetectedValueImpl)detectedValues.get(n++)).type = 66;
                    continue;
                }
                ((DetectedValueImpl)detectedValues.get(n++)).type = 8;
            }
        }
        catch (Throwable ex) {
            status.abort();
            throw new RuntimeException("Problems reading file '" + this.getFullFileName() + "' near line " + lineno + ".", ex);
        }
        DetectedValue[] r = detectedValues.toArray(new DetectedValue[detectedValues.size()]);
        return r;
    }

    private boolean isValidLong(String s) {
        if (s == null) {
            return true;
        }
        if ((s = s.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        try {
            if (s.startsWith("0x")) {
                Long.valueOf(s.substring(2), 16);
            } else {
                Long.valueOf(s);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isValidInteger(String s) {
        if (s == null) {
            return true;
        }
        if ((s = s.trim().toLowerCase()).isEmpty()) {
            return true;
        }
        try {
            if (s.startsWith("0x")) {
                Integer.valueOf(s.substring(2), 16);
            } else {
                Integer.valueOf(s);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean canBeDecimal(String rawvalue, Locale locale) {
        try {
            String s = rawvalue.trim();
            Character ds = this.getDecimalSeparator(locale);
            if (ds != null && s.charAt(0) == ds.charValue()) {
                return true;
            }
            return this.startWithAnyChar(s, START_DECIMAL);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private Character getDecimalSeparator(Locale locale) {
        if (this.decimalSeparator != null) {
            return this.decimalSeparator;
        }
        DecimalFormatSymbols x = new DecimalFormatSymbols(locale);
        this.decimalSeparator = Character.valueOf(x.getDecimalSeparator());
        return this.decimalSeparator;
    }

    private boolean startWithAnyChar(String s, char[] chars) {
        char c = s.charAt(0);
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != c) continue;
            return true;
        }
        return false;
    }

    private static class PossibleDataType {
        public boolean possibleInt = true;
        public boolean possibleFloat = true;
        public boolean possibleDouble = true;
        public boolean possibleDecimal = true;
        public boolean possibleLong = true;
        public boolean possibleURL = true;
        public boolean possibleDate = true;
        public boolean possibleTime = true;
        public boolean possibleTimestamp = true;
        public boolean possibleGeometry = true;
        public boolean hasData = false;

        private PossibleDataType() {
        }
    }

    private static class DetectedValueImpl
    implements DetectedValue {
        private int type;
        private int displaySize;
        private int integerDigits;
        private int decimalDigits;
        private boolean blank;

        private DetectedValueImpl() {
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public int getDisplaySize() {
            return this.displaySize;
        }

        @Override
        public int getPrecision() {
            return this.decimalDigits + this.integerDigits;
        }

        @Override
        public int getScale() {
            return this.decimalDigits;
        }

        @Override
        public boolean isBlank() {
            return this.blank;
        }
    }

    public static interface DetectedValue {
        public int getType();

        public int getDisplaySize();

        public int getPrecision();

        public int getScale();

        public boolean isBlank();
    }

    public static interface Rows {
        public List<String> nextRowValues();
    }
}

