/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader;

import javax.json.JsonArray;
import javax.json.JsonObject;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleReaderPointAttributeEmulator
implements FeatureAttributeEmulator {
    private static final Logger logger = LoggerFactory.getLogger(SimpleReaderPointAttributeEmulator.class);
    private static final int XNAME = 0;
    private static final int YNAME = 1;
    private static final int ZNAME = 2;
    private GeometryManager geommgr;
    private String[] fieldNames;
    private Coercion toDouble;
    private DataType dataType;
    private int errorcount = 0;
    private IProjection projection;

    public SimpleReaderPointAttributeEmulator() {
    }

    public SimpleReaderPointAttributeEmulator(String[] pointDimensionNames) {
        this(pointDimensionNames, null);
    }

    public SimpleReaderPointAttributeEmulator(String[] pointDimensionNames, IProjection projection) {
        if (pointDimensionNames.length > 2) {
            this.fieldNames = new String[3];
            this.fieldNames[2] = pointDimensionNames[2];
        } else {
            this.fieldNames = new String[2];
        }
        this.fieldNames[0] = pointDimensionNames[0];
        this.fieldNames[1] = pointDimensionNames[1];
        this.geommgr = GeometryLocator.getGeometryManager();
        DataTypesManager datatypeManager = ToolsLocator.getDataTypesManager();
        this.toDouble = datatypeManager.getCoercion(7);
        this.dataType = datatypeManager.get(66);
        this.projection = projection;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public Object get(Feature feature) {
        try {
            Object valueX = feature.get(this.fieldNames[0]);
            valueX = this.toDouble.coerce(valueX);
            if (valueX == null) {
                return null;
            }
            Object valueY = feature.get(this.fieldNames[1]);
            if ((valueY = this.toDouble.coerce(valueY)) == null) {
                return null;
            }
            Object valueZ = null;
            if (this.fieldNames.length > 2 && (valueZ = this.toDouble.coerce(feature.get(this.fieldNames[2]))) == null) {
                return null;
            }
            double x = (Double)valueX;
            double y = (Double)valueY;
            Point point = this.geommgr.createPoint(x, y, 1);
            if (this.fieldNames.length > 2) {
                double z = (Double)valueZ;
                point.setCoordinateAt(2, z);
            }
            point.setProjection(this.projection);
            return point;
        }
        catch (Exception ex) {
            if (++this.errorcount < 5) {
                logger.warn("[" + this.errorcount + "] Can't create point in CSV provider. XNAME='" + this.fieldNames[0] + "', YNAME='" + this.fieldNames[0] + "' feature=" + feature.toString(), (Throwable)ex);
            }
            return null;
        }
    }

    public void set(EditableFeature feature, Object value) {
        if (value == null) {
            return;
        }
        Point point = value instanceof MultiPoint ? (Point)((MultiPoint)value).getPrimitiveAt(0) : (Point)value;
        feature.set(this.fieldNames[0], (Object)point.getX());
        feature.set(this.fieldNames[1], (Object)point.getY());
        if (this.fieldNames.length > 2) {
            feature.set(this.fieldNames[2], (Object)point.getCoordinateAt(2));
        }
    }

    public boolean allowSetting() {
        return true;
    }

    public String[] getRequiredFieldNames() {
        return this.fieldNames;
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add_class((Object)this);
        builder.add("fieldNames", (Object[])this.fieldNames);
        return builder;
    }

    public void fromJson(JsonObject json) {
        JsonArray jsonFieldNames = json.getJsonArray("fieldNames");
        this.fieldNames = new String[jsonFieldNames.size()];
        for (int i = 0; i < jsonFieldNames.size(); ++i) {
            this.fieldNames[0] = jsonFieldNames.getString(i);
        }
        this.geommgr = GeometryLocator.getGeometryManager();
        DataTypesManager datatypeManager = ToolsLocator.getDataTypesManager();
        this.toDouble = datatypeManager.getCoercion(7);
        this.dataType = datatypeManager.get(66);
    }
}

