/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadRuntimeException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureProviderIterator;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureSetProvider;
import org.gvsig.fmap.dal.feature.spi.AbstractFeatureStoreProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.store.simplereader.AbstractFeatureProviderLoadedOnDemand;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreProvider;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.tools.exception.BaseException;

public class SimpleReaderSetProvider
extends AbstractFeatureSetProvider {
    public SimpleReaderSetProvider(SimpleReaderStoreProvider store, FeatureQuery query, FeatureType providerFeatureType, FeatureType featureType) throws DataException {
        super((AbstractFeatureStoreProvider)store, query, providerFeatureType, featureType);
    }

    protected SimpleReaderStoreProvider getStore() {
        return (SimpleReaderStoreProvider)super.getStore();
    }

    protected SpatialIndex getSpatialIndex(String name) {
        return this.getStore().getSpatialIndex(name);
    }

    protected String getStoreFullName() {
        try {
            return this.getStore().getFullName();
        }
        catch (Throwable th) {
            return "unknown";
        }
    }

    public boolean canFilter() {
        return false;
    }

    public boolean canIterateFromIndex() {
        return true;
    }

    public boolean canOrder() {
        return false;
    }

    public long getSize() throws DataException {
        return this.getStore().getFeatureCount();
    }

    public boolean isEmpty() throws DataException {
        return this.getSize() == 0L;
    }

    protected void doDispose() throws BaseException {
    }

    protected AbstractFeatureProviderIterator createIterator(long index) throws DataException {
        return new SimpleReaderIterator(this.getStore(), this.getQuery(), this.getProviderFeatureType(), index);
    }

    protected AbstractFeatureProviderIterator createFastIterator(long index) throws DataException {
        return new FastCSVIterator(this.getStore(), this.getQuery(), this.getProviderFeatureType(), index);
    }

    private class FastCSVIterator
    extends SimpleReaderIterator {
        protected FeatureProvider data;

        public FastCSVIterator(SimpleReaderStoreProvider store, FeatureQuery query, FeatureType type, long startOn) throws DataException {
            super(store, query, type, startOn);
            this.data = new SimpleReaderFeatureProvider(store, type);
        }

        @Override
        protected FeatureProvider internalNext() {
            if (this.spatialIndexIt != null) {
                Object oid = this.spatialIndexIt.next();
                this.data.setOID(oid);
            } else {
                if (this.index >= this.count) {
                    throw new NoSuchElementException();
                }
                this.data.setOID((Object)this.index++);
            }
            return this.data;
        }

        @Override
        protected void internalDispose() {
            super.internalDispose();
            this.data = null;
        }
    }

    private class SimpleReaderIterator
    extends AbstractFeatureProviderIterator {
        protected long index;
        protected FeatureType type;
        protected long count;
        protected final FeatureQuery query;
        protected Iterator spatialIndexIt;

        public SimpleReaderIterator(SimpleReaderStoreProvider store, FeatureQuery query, FeatureType type, long startOn) throws DataException {
            super((FeatureStoreProvider)store);
            this.index = startOn;
            this.type = type;
            this.query = query;
            this.count = store.getFeatureCount();
            if (this.query != null) {
                this.spatialIndexIt = SimpleReaderSetProvider.this.createSpatialIterator(store.getFeatureStore().getDefaultFeatureTypeQuietly(), query);
            }
        }

        protected SimpleReaderStoreProvider getFeatureStoreProvider() {
            return (SimpleReaderStoreProvider)super.getFeatureStoreProvider();
        }

        protected boolean internalHasNext() {
            if (this.spatialIndexIt != null) {
                return this.spatialIndexIt.hasNext();
            }
            return this.count > this.index;
        }

        protected FeatureProvider internalNext() {
            SimpleReaderFeatureProvider data = new SimpleReaderFeatureProvider(SimpleReaderSetProvider.this.getStore(), this.type);
            if (this.spatialIndexIt != null) {
                Object oid = this.spatialIndexIt.next();
                data.setOID(oid);
            } else {
                if (this.index >= this.count) {
                    throw new NoSuchElementException();
                }
                data.setOID(this.index++);
            }
            return data;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void internalDispose() {
            this.type = null;
        }

        protected void doDispose() throws BaseException {
        }
    }

    private static class SimpleReaderFeatureProvider
    extends AbstractFeatureProviderLoadedOnDemand {
        protected SimpleReaderStoreProvider store;

        public SimpleReaderFeatureProvider(SimpleReaderStoreProvider store, FeatureType type) {
            super(type);
            this.store = store;
        }

        @Override
        protected void doLoad() {
            long index = -1L;
            try {
                index = this.getOID();
                SimpleReaderStoreProvider.RowToFeatureTranslator translator = this.store.getRowToFeatureTranslator();
                List<String> row = this.store.getRowByIndex(index);
                translator.translate(index, row, (FeatureProvider)this);
            }
            catch (Throwable ex) {
                throw new ReadRuntimeException(this.getStoreFullName(), (Object)index, ex);
            }
        }

        public Long getOID() {
            return (Long)super.getOID();
        }

        public void setOID(long oid) {
            super.setOID(oid);
        }

        private String getStoreFullName() {
            try {
                return this.store.getFullName();
            }
            catch (Exception ex) {
                return "unknown";
            }
        }

        @Override
        protected void warn(String message, Throwable t) {
            this.store.getTimedLogger().warn(message, t);
        }
    }
}

