/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader;

import java.io.File;
import java.util.Locale;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.basicformats.CPGFile;
import org.gvsig.basicformats.FormatsFile;
import org.gvsig.basicformats.PRJFile;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.spi.AbstractDataStoreParameters;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderFeatureTypeLoader;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.Tags;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleReaderStoreParameters
extends AbstractDataStoreParameters
implements OpenFeatureStoreParameters,
FilesystemStoreParameters {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SimpleReaderStoreParameters.class);
    protected static final String FILE = "file";
    protected static final String IGNOREERRORS = "ignoreErrors";
    protected static final String AUTOMATICTYPESDETECTION = "automaticTypesDetection";
    protected static final String CRS = "CRS";
    protected static final String FIELDTYPES = "fieldtypes";
    protected static final String CHARSET = "charset";
    protected static final String LOCALE = "locale";
    public static final String HEADER = "header";
    private static final String LIMIT = "limit";
    protected DelegatedDynObject parameters;
    protected FeatureType featureType;
    protected boolean all_fields_declare_type = false;

    public SimpleReaderStoreParameters(String parametersDefinitionName, String name) {
        this.parameters = (DelegatedDynObject)FileHelper.newParameters(parametersDefinitionName);
        this.setDynValue("ProviderName", name);
    }

    protected SimpleReaderFeatureTypeLoader getFeatureTypeLoader() {
        return null;
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.parameters;
    }

    public void setDynValue(String name, Object value) {
        super.setDynValue(name, value);
        this.featureType = null;
    }

    public Object getDynValue(String name) {
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)AUTOMATICTYPESDETECTION) && this.featureType != null && this.all_fields_declare_type) {
            return false;
        }
        return super.getDynValue(name);
    }

    public boolean isValid() {
        return SimpleReaderStoreParameters.getFileName((DynObject)this) != null;
    }

    @Override
    public File getFile() {
        return (File)this.getDynValue(FILE);
    }

    @Override
    public void setFile(File file) {
        this.setDynValue(FILE, file);
    }

    public static String getHeader(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(HEADER);
        if (StringUtils.isBlank((CharSequence)(s = StringEscapeUtils.unescapeJava((String)s)))) {
            return null;
        }
        return s;
    }

    public static String getDelimiter(String line) {
        if (StringUtils.isBlank((CharSequence)line)) {
            return null;
        }
        String sep = null;
        String seps = ",;-|@#/+$%&!:";
        for (int i = 0; i < seps.length(); ++i) {
            sep = seps.substring(i, 1);
            if (line.contains(seps.substring(i, 1))) break;
            sep = null;
        }
        return sep;
    }

    public static String[] getHeaders(DynObject dynobj) {
        String s = SimpleReaderStoreParameters.getHeader(dynobj);
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        String sep = SimpleReaderStoreParameters.getDelimiter(s);
        if (sep == null) {
            return null;
        }
        String[] ss = s.split("[" + sep + "]");
        return ss;
    }

    public static IProjection getCRS(DynObject dynobj) {
        return (IProjection)dynobj.getDynValue(CRS);
    }

    public static String getFileName(DynObject dynobj) {
        File f = (File)dynobj.getDynValue(FILE);
        if (f == null) {
            return null;
        }
        return f.getPath();
    }

    public static File getFile(DynObject dynobj) {
        File f = (File)dynobj.getDynValue(FILE);
        return f;
    }

    public static boolean isBlankOrDefaultLocale(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(LOCALE);
        if (StringUtils.isBlank((CharSequence)s)) {
            return true;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)"DEFAULT", (CharSequence)s.trim());
    }

    public static Locale getLocale(DynObject dynobj) {
        try {
            Locale locale;
            String s = (String)dynobj.getDynValue(LOCALE);
            if (StringUtils.isBlank((CharSequence)s)) {
                return null;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"DEFAULT", (CharSequence)s.trim())) {
                return Locale.getDefault();
            }
            String[] ss = s.split("-");
            switch (ss.length) {
                case 1: {
                    locale = new Locale(ss[0]);
                    break;
                }
                case 2: {
                    locale = new Locale(ss[0], ss[1]);
                    break;
                }
                default: {
                    locale = new Locale(ss[0], ss[1], ss[2]);
                }
            }
            return locale;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get locale from parameters.", (Throwable)ex);
            return null;
        }
    }

    public static String getCharset(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(CHARSET);
        return StringEscapeUtils.unescapeJava((String)s);
    }

    public static boolean getAutomaticTypesDetection(DynObject dynobj) {
        Boolean b = (Boolean)dynobj.getDynValue(AUTOMATICTYPESDETECTION);
        return BooleanUtils.isTrue((Boolean)b);
    }

    public static boolean getIgnoreErrors(DynObject dynobj) {
        Boolean b = (Boolean)dynobj.getDynValue(IGNOREERRORS);
        return BooleanUtils.isTrue((Boolean)b);
    }

    public static String getRawFieldTypes(DynObject dynobj) {
        String s = (String)dynobj.getDynValue(FIELDTYPES);
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s.trim();
    }

    public static String getRawFieldsDefinition(DynObject dynobj) {
        String s = (String)dynobj.getDynValue("fieldsDefinition");
        if (StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s.trim();
    }

    public static int getSkipLines(DynObject dynobj) {
        Integer n = (Integer)dynobj.getDynValue("skipLines");
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static int getLimit(DynObject dynobj) {
        Integer n = (Integer)dynobj.getDynValue(LIMIT);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public static FieldDefinition[] getFieldsDefinition(DynObject dynobj) {
        String definition = SimpleReaderStoreParameters.getRawFieldsDefinition(dynobj);
        if (definition == null) {
            return null;
        }
        int i = 0;
        try {
            String[] defs = StringUtils.split((String)definition);
            FieldDefinition[] fieldsDefinition = new FieldDefinition[defs.length];
            for (i = 0; i < defs.length; ++i) {
                fieldsDefinition[i] = new FieldDefinition(defs[i]);
            }
            return fieldsDefinition;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't recognize the format field definition '" + definition + "' (" + i + ").");
        }
    }

    public void validate() throws ValidateDataParametersException {
        File f = this.getFile();
        if (f != null) {
            CPGFile cpgfile;
            String charsetName;
            PRJFile prjfile;
            IProjection proj = null;
            FeatureType ftype = this.getFeatureType();
            if (ftype != null) {
                proj = ftype.getDefaultSRS();
                if (proj != null) {
                    this.setDynValue(CRS, proj);
                }
                Tags ftypeTags = ftype.getTags();
                for (String tagname : ftypeTags) {
                    if (!StringUtils.startsWithIgnoreCase((CharSequence)tagname, (CharSequence)"storeparameters.") && !StringUtils.startsWithIgnoreCase((CharSequence)tagname, (CharSequence)"csvparameters.")) continue;
                    String paramname = tagname.substring(14);
                    String paramvalue = ftypeTags.getString(tagname, null);
                    if (paramvalue == null) continue;
                    this.setDynValue(paramname, paramvalue);
                }
            }
            if (proj == null && (prjfile = FormatsFile.getPRJFile((File)f)) != null) {
                this.setDynValue(CRS, prjfile.getCRS());
            }
            if (StringUtils.isBlank((CharSequence)(charsetName = SimpleReaderStoreParameters.getCharset((DynObject)this))) && (cpgfile = FormatsFile.getCPGFile((File)f)) != null) {
                this.setDynValue(CHARSET, cpgfile.getCharsetName());
            }
        }
        super.validate();
    }

    protected FeatureType getFeatureType() {
        if (this.featureType == null) {
            try {
                SimpleReaderFeatureTypeLoader featureTypeLoader = this.getFeatureTypeLoader();
                if (featureTypeLoader != null) {
                    EditableFeatureType ftype = DALLocator.getDataManager().createFeatureType();
                    featureTypeLoader.loadFeatureType(ftype, false, null);
                    this.all_fields_declare_type = featureTypeLoader.isAllFieldsDeclareType();
                    this.featureType = ftype;
                }
            }
            catch (Exception ex) {
                LOGGER.debug("Can't detect feature of json file", (Throwable)ex);
            }
        }
        return this.featureType;
    }

    public String getSourceId() {
        return this.toString();
    }

    public static class FieldDefinition {
        private final int start;
        private final int end;

        public FieldDefinition(String def) {
            def = def.trim();
            String[] ss = def.split(":");
            this.start = Integer.parseInt(ss[0]);
            this.end = ss.length < 2 ? -1 : Integer.parseInt(ss[1]);
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean getToEndOfLine() {
            return this.end == -1;
        }
    }
}

