/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.CreateFeatureException;
import org.gvsig.fmap.dal.feature.exception.PerformEditingException;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureSetProvider;
import org.gvsig.fmap.dal.feature.spi.memory.AbstractMemoryStoreProvider;
import org.gvsig.fmap.dal.resource.Resource;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderFeatureTypeLoader;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderSetProvider;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderStoreParameters;
import org.gvsig.fmap.dal.store.simplereader.SimpleReaderUtils;
import org.gvsig.fmap.dal.store.simplereader.simplereaders.AbstractSimpleReader;
import org.gvsig.fmap.dal.store.simplereader.simplereaders.SimpleReader;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.SpatialIndexFactory;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.evaluator.AbstractEvaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.exception.NotYetImplemented;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.gvsig.tools.task.UserCancelTaskException;
import org.gvsig.tools.util.GetItemWithSize64;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleReaderStoreProvider
extends AbstractMemoryStoreProvider
implements ResourceConsumer {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SimpleReaderStoreProvider.class);
    private static FilteredLogger timedLogger;
    protected final ResourceProvider resource;
    protected long counterNewsOIDs = 0L;
    protected Map<String, Envelope> envelopes;
    protected boolean need_calculate_envelope = false;
    protected final SimpleTaskStatus taskStatus;
    protected FeatureType featureType;
    protected GetItemWithSize64<List<String>> virtualrows;
    protected RowToFeatureTranslator rowToFeatureTranslator;
    protected Map<String, SpatialIndex> spatialIndexes;

    public SimpleReaderStoreProvider(SimpleReaderStoreParameters parameters, DataStoreProviderServices storeServices, DynObject metadata) throws InitializeException {
        super((DataStoreParameters)parameters, storeServices, metadata);
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        this.taskStatus = manager.createDefaultSimpleTaskStatus(this.getProviderName());
        this.taskStatus.setAutoremove(true);
        this.envelopes = new HashMap<String, Envelope>();
        this.counterNewsOIDs = 0L;
        File file = this.getSimpleReaderParameters().getFile();
        this.resource = this.createResource("file", new Object[]{file.getAbsolutePath()});
        this.resource.addConsumer((ResourceConsumer)this);
        this.initializeFeatureTypes();
    }

    private SimpleReaderStoreParameters getSimpleReaderParameters() {
        return (SimpleReaderStoreParameters)this.getParameters();
    }

    public abstract String getProviderName();

    public boolean allowWrite() {
        return false;
    }

    protected String getFullFileName() {
        String s;
        try {
            s = this.getSimpleReaderParameters().getFile().getAbsolutePath();
        }
        catch (Exception e2) {
            s = "(unknow)";
        }
        return s;
    }

    public void open() throws OpenException {
        if (this.data != null) {
            return;
        }
        this.data = new ArrayList();
        this.resource.setData(new HashMap());
        this.counterNewsOIDs = 0L;
        try {
            this.loadFeatures();
        }
        catch (RuntimeException e) {
            LOGGER.debug("Can't load features from '" + this.getFullFileName() + "'.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.debug("Can't load features from '" + this.getFullFileName() + "'.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public DataServerExplorer getExplorer() throws ReadException {
        DataManager manager = DALLocator.getDataManager();
        try {
            FilesystemServerExplorerParameters params = (FilesystemServerExplorerParameters)manager.createServerExplorerParameters("FilesystemExplorer");
            params.setRoot(this.getSimpleReaderParameters().getFile().getParent());
            return manager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)params);
        }
        catch (Exception e) {
            throw new ReadException(this.getProviderName(), (Throwable)e);
        }
    }

    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator originalFeatureTypesUpdated) throws PerformEditingException {
        throw new UnsupportedOperationException();
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return true;
    }

    public int getOIDType() {
        return 5;
    }

    public boolean supportsAppendMode() {
        return false;
    }

    public void append(FeatureProvider featureProvider) {
        throw new UnsupportedOperationException();
    }

    public void beginAppend() throws DataException {
        throw new UnsupportedOperationException();
    }

    public void endAppend() {
        throw new UnsupportedOperationException();
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        throw new NotYetImplemented();
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        throw new NotYetImplemented();
    }

    public Object createNewOID() {
        return this.counterNewsOIDs++;
    }

    protected void initializeFeatureTypes() throws InitializeException {
        try {
            this.open();
        }
        catch (OpenException e) {
            throw new InitializeException(this.getProviderName(), (Throwable)e);
        }
    }

    public Envelope getEnvelope(String geomName) throws DataException {
        Envelope theEnv;
        Envelope env;
        this.open();
        if (geomName == null) {
            FeatureAttributeDescriptor geomdesc = this.featureType.getDefaultGeometryAttribute();
            geomName = geomdesc.getName();
        }
        if ((env = this.envelopes.get(geomName)) != null) {
            return env;
        }
        File data_file = SimpleReaderStoreParameters.getFile((DynObject)this.getSimpleReaderParameters());
        File bboxfile = this.getAuxFile("_" + geomName, "bbox");
        if (bboxfile.exists() && SimpleReaderUtils.isFileNewer(bboxfile, data_file) && (env = this.bboxFileLoad(bboxfile)) != null) {
            this.envelopes.put(geomName, env);
            return env;
        }
        if (!this.need_calculate_envelope) {
            return null;
        }
        try {
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.taskStatus.add();
            this.taskStatus.message(i18n.getTranslation("_Calculating_envelope"));
            FeatureStore fs = this.getFeatureStore();
            FeatureType ft = fs.getDefaultFeatureType();
            FeatureAttributeDescriptor fad = ft.getAttributeDescriptor(ft.getDefaultGeometryAttributeIndex());
            this.taskStatus.setRangeOfValues(0L, fs.getFeatureCount());
            theEnv = GeometryLocator.getGeometryManager().createEnvelope(fad.getGeomType().getSubType());
            String theGeomName = geomName;
            fs.accept(obj -> {
                this.taskStatus.incrementCurrentValue();
                if (this.taskStatus.isCancellationRequested()) {
                    this.taskStatus.cancel();
                    throw new VisitCanceledException();
                }
                Feature f = (Feature)obj;
                Geometry geom = f.getGeometry(theGeomName);
                if (geom != null) {
                    try {
                        Envelope envelope = geom.getEnvelope();
                        theEnv.add(envelope);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't calculate envelop of geometry in feature '" + Objects.toString(f.getReference()) + "'.", (Throwable)ex);
                    }
                }
            });
            this.bboxFileSave("_" + theGeomName, theEnv);
            this.taskStatus.terminate();
        }
        catch (VisitCanceledException e) {
            return null;
        }
        catch (BaseException e) {
            this.taskStatus.abort();
            LOGGER.warn("Can't calculate the envelope of file '" + this.getFullName() + "'.", (Throwable)e);
            return null;
        }
        this.need_calculate_envelope = false;
        return theEnv;
    }

    public Envelope getEnvelope() throws DataException {
        return this.getEnvelope(null);
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        IProjection pro;
        if ("Envelope".equalsIgnoreCase(name)) {
            try {
                return this.getEnvelope();
            }
            catch (DataException e) {
                return null;
            }
        }
        if ("CRS".equalsIgnoreCase(name) && (pro = SimpleReaderStoreParameters.getCRS((DynObject)this.getSimpleReaderParameters())) != null) {
            return pro;
        }
        return super.getDynValue(name);
    }

    public void resourceChanged(ResourceProvider resource) {
        this.getStoreServices().notifyChange("resourceChange_DataStore", (Resource)resource);
    }

    public Object getSourceId() {
        return this.getSimpleReaderParameters().getFile();
    }

    public String getName() {
        String name = this.getSimpleReaderParameters().getFile().getName();
        return FilenameUtils.getBaseName((String)name);
    }

    public String getFullName() {
        return this.getSimpleReaderParameters().getFile().getAbsolutePath();
    }

    public ResourceProvider getResource() {
        return this.resource;
    }

    private boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().length() == 0;
    }

    private void init(SimpleReaderStoreParameters parameters, DataStoreProviderServices storeServices) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected abstract SimpleReaderFeatureTypeLoader getFeatureTypeLoader();

    protected void loadFeatures() {
        InputStreamReader in = null;
        SimpleReader reader = null;
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            this.taskStatus.setTitle(this.getProviderName() + " " + this.getName());
            this.taskStatus.add();
            EditableFeatureType edftype = this.getStoreServices().createFeatureType(this.getName());
            SimpleReaderFeatureTypeLoader featureTypeLoader = this.getFeatureTypeLoader();
            featureTypeLoader.loadFeatureType(edftype, this.taskStatus);
            FeatureType ftype = edftype.getNotEditableCopy();
            this.setFeatureType(ftype);
            in = SimpleReaderUtils.openFile(this.getSimpleReaderParameters().getFile(), SimpleReaderStoreParameters.getCharset((DynObject)this.getSimpleReaderParameters()));
            reader = this.getSimpleReader(this.getSimpleReaderParameters(), in);
            if (featureTypeLoader.isFirstLineHeader()) {
                reader.getHeader();
            }
            this.rowToFeatureTranslator = new RowToFeatureTranslator(SimpleReaderStoreParameters.getIgnoreErrors((DynObject)this.getSimpleReaderParameters()));
            this.rowToFeatureTranslator.initialize(ftype);
            if (ftype.getDefaultGeometryAttributeName() != null) {
                this.need_calculate_envelope = true;
            }
            I18nManager i18n = ToolsLocator.getI18nManager();
            this.taskStatus.message(i18n.getTranslation("_Loading"));
            if (this.virtualrows != null && this.virtualrows instanceof Closeable) {
                IOUtils.closeQuietly((Closeable)((Closeable)this.virtualrows));
                this.virtualrows = null;
            }
            this.virtualrows = ((AbstractSimpleReader)reader).getVirtualRows(this.taskStatus);
            if (this.taskStatus.isCancellationRequested()) {
                throw new UserCancelTaskException();
            }
            if (this.virtualrows == null) {
                this.spatialIndexes = new HashMap<String, SpatialIndex>();
                this.taskStatus.message(i18n.getTranslation("_Loading"));
                this.taskStatus.setIndeterminate();
                List<String> row = reader.read();
                int skipLines = SimpleReaderStoreParameters.getSkipLines((DynObject)this.getSimpleReaderParameters());
                if (skipLines > 0) {
                    row = reader.skip(skipLines);
                }
                int limit = SimpleReaderStoreParameters.getLimit((DynObject)this.getSimpleReaderParameters());
                while (row != null) {
                    this.taskStatus.incrementCurrentValue();
                    if (this.taskStatus.isCancellationRequested()) {
                        this.taskStatus.cancel();
                        break;
                    }
                    FeatureProvider feature = this.createFeatureProvider(ftype);
                    this.rowToFeatureTranslator.translate(reader.getLine(), row, feature);
                    if (feature != null) {
                        for (FeatureAttributeDescriptor geomdesc : this.featureType) {
                            SpatialIndex theSpatialIndex;
                            if (geomdesc.getType() != 66) continue;
                            String geomName = geomdesc.getName();
                            Envelope theEnvelope = this.envelopes.get(geomName);
                            if (theEnvelope == null) {
                                theEnvelope = geomManager.createEnvelope(geomdesc.getGeomType().getSubType());
                                this.envelopes.put(geomName, theEnvelope);
                            }
                            if ((theSpatialIndex = this.spatialIndexes.get(geomName)) == null) {
                                String indexTypeName = "JTSQuadtree";
                                String extname = "qtree";
                                File indexfile = this.getAuxFile("_" + geomName, extname);
                                SpatialIndexFactory indexfactory = geomManager.getSpatialIndexFactory(indexTypeName);
                                DynObject params = indexfactory.createParameters();
                                params.setDynValue("file", (Object)indexfile);
                                theSpatialIndex = geomManager.createSpatialIndex(indexTypeName, params);
                                this.spatialIndexes.put(geomName, theSpatialIndex);
                            }
                            Object oid = null;
                            try {
                                oid = feature.getOID();
                                Geometry geom = (Geometry)feature.get(geomdesc.getName());
                                if (geom == null) continue;
                                theEnvelope.add(geom);
                                theSpatialIndex.insert(geom, oid);
                            }
                            catch (Throwable ex) {
                                LOGGER.debug("Can't insert feature '" + Objects.toString(oid) + "' in spatial index.", ex);
                            }
                        }
                    }
                    this.addFeatureProvider(feature);
                    if (limit > 0 && limit < this.data.size()) break;
                    row = reader.read();
                }
                for (SpatialIndex index : this.spatialIndexes.values()) {
                    index.flush();
                }
                this.bboxFileSave(this.envelopes);
                for (int i = 0; i < ftype.size(); ++i) {
                    if (this.rowToFeatureTranslator.getColumnSize(i) <= 0) continue;
                    EditableFeatureAttributeDescriptor efad = (EditableFeatureAttributeDescriptor)edftype.getAttributeDescriptor(i);
                    efad.setSize(this.rowToFeatureTranslator.getColumnSize(i));
                }
                ftype = edftype.getNotEditableCopy();
                this.setFeatureType(ftype);
            } else {
                this.loadOrCreateSpatialIndex();
            }
            if (this.taskStatus.isRunning()) {
                this.taskStatus.terminate();
            }
        }
        catch (UserCancelTaskException ex) {
            this.taskStatus.cancel();
            throw ex;
        }
        catch (Throwable ex) {
            this.taskStatus.abort();
            int lineno = 0;
            if (reader != null) {
                lineno = reader.getLine();
            }
            throw new RuntimeException("Problems reading file '" + this.getFullFileName() + "' near record " + lineno + ".", ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            this.taskStatus.remove();
        }
    }

    public void fixFeatureTypeFromParameters() {
        if (this.mustFixFeatureType() && this.featureType != null) {
            this.setFeatureType(this.featureType);
        }
    }

    protected boolean mustFixFeatureType() {
        FeatureStore theStore = this.getStoreServices().getFeatureStore();
        FeatureType ft = theStore.getDefaultFeatureTypeQuietly();
        String geomName = ft.getDefaultGeometryAttributeName();
        return StringUtils.isNotBlank((CharSequence)geomName) && this.featureType.getAttributeDescriptor(geomName) == null;
    }

    private void setFeatureType(FeatureType ftype) {
        try {
            ArrayList<FeatureType> ftypes = new ArrayList<FeatureType>();
            ftypes.add(ftype);
            this.featureType = ftype;
            if (this.getStoreServices().getDefaultFeatureType() == null) {
                this.getStoreServices().setFeatureTypes(ftypes, ftype);
                return;
            }
            if (this.mustFixFeatureType()) {
                this.getStoreServices().setFeatureTypes(ftypes, ftype);
            }
        }
        catch (DataException ex) {
            LOGGER.warn("Cant set feature type", (Throwable)ex);
        }
    }

    public FeatureSetProvider createSet(FeatureQuery query, FeatureType providerFeatureType, FeatureType featureType) throws DataException {
        this.open();
        if (this.virtualrows == null) {
            return super.createSet(query, providerFeatureType, featureType);
        }
        return new SimpleReaderSetProvider(this, query, providerFeatureType, featureType);
    }

    public FeatureSetProvider createSet(FeatureQuery query, FeatureType featureType) throws DataException {
        this.open();
        if (this.virtualrows == null) {
            return super.createSet(query, featureType);
        }
        return new SimpleReaderSetProvider(this, query, featureType, featureType);
    }

    public List<String> getRowByIndex(long index) {
        try {
            this.open();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't get row by index", ex);
        }
        if (this.virtualrows == null) {
            return null;
        }
        List line = (List)this.virtualrows.get64(index);
        return line;
    }

    public RowToFeatureTranslator getRowToFeatureTranslator() {
        if (this.rowToFeatureTranslator == null) {
            boolean ignore_errors = SimpleReaderStoreParameters.getIgnoreErrors((DynObject)this.getSimpleReaderParameters());
            this.rowToFeatureTranslator = new RowToFeatureTranslator(ignore_errors);
            this.rowToFeatureTranslator.initialize(this.featureType);
        }
        return this.rowToFeatureTranslator;
    }

    public long getFeatureCount() throws DataException {
        this.open();
        if (this.virtualrows == null) {
            return super.getFeatureCount();
        }
        return this.virtualrows.size64();
    }

    public long getDataSize() throws DataException {
        this.open();
        if (this.virtualrows == null) {
            return super.getDataSize();
        }
        return this.virtualrows.size64();
    }

    protected FeatureProvider internalGetFeatureProviderByReference(FeatureReferenceProviderServices reference) throws DataException {
        this.open();
        if (this.virtualrows == null) {
            return super.internalGetFeatureProviderByReference(reference);
        }
        int oid = ((Long)reference.getOID()).intValue();
        RowToFeatureTranslator translator = this.getRowToFeatureTranslator();
        FeatureProvider feature = this.createFeatureProvider(this.featureType);
        try {
            translator.translate(oid, (List)this.virtualrows.get64((long)oid), feature);
        }
        catch (Exception ex) {
            throw new CreateFeatureException((Throwable)ex, this.getName());
        }
        return feature;
    }

    protected void doDispose() throws BaseException {
        super.doDispose();
        if (this.virtualrows != null && this.virtualrows instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)this.virtualrows));
            this.virtualrows = null;
        }
    }

    public void refresh() throws OpenException {
        try {
            this.close();
        }
        catch (CloseException e) {
            throw new OpenException(this.getProviderName(), (Throwable)e);
        }
        this.open();
    }

    public void close() throws CloseException {
        super.close();
        this.data = null;
        if (this.virtualrows != null && this.virtualrows instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)this.virtualrows));
            this.virtualrows = null;
            this.envelopes = null;
            this.spatialIndexes = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOrCreateSpatialIndex() {
        FeatureSetProvider set = null;
        DisposableIterator it = null;
        try {
            if (this.virtualrows == null) {
                return;
            }
            this.spatialIndexes = new HashMap<String, SpatialIndex>();
            for (FeatureAttributeDescriptor geomdesc : this.featureType) {
                if (geomdesc.getType() != 66) continue;
                String indexTypeName = "JTSQuadtree";
                String extname = "qtree";
                String geomName = geomdesc.getName();
                Envelope env = this.bboxFileLoad("_" + geomName);
                File indexfile = this.getAuxFile("_" + geomName, extname);
                File data_file = SimpleReaderStoreParameters.getFile((DynObject)this.getSimpleReaderParameters());
                boolean createIndex = !indexfile.exists() || SimpleReaderUtils.isFileNewer(data_file, indexfile);
                GeometryManager geomManager = GeometryLocator.getGeometryManager();
                SpatialIndexFactory indexfactory = geomManager.getSpatialIndexFactory(indexTypeName);
                DynObject params = indexfactory.createParameters();
                params.setDynValue("file", (Object)indexfile);
                SpatialIndex index = geomManager.createSpatialIndex(indexTypeName, params);
                if (createIndex) {
                    I18nManager i18n = ToolsLocator.getI18nManager();
                    this.taskStatus.add();
                    this.taskStatus.message(i18n.getTranslation("_Creating_spatial_index") + " (" + geomName + ")");
                    this.taskStatus.setRangeOfValues(0L, this.virtualrows.size64());
                    this.taskStatus.setCurValue(0L);
                    Envelope theEnvelope = geomManager.createEnvelope(0);
                    set = this.createSet(null, this.featureType);
                    it = set.fastIterator();
                    while (it.hasNext()) {
                        this.taskStatus.incrementCurrentValue();
                        if (this.taskStatus.isCancellationRequested()) {
                            this.taskStatus.cancel();
                            LOGGER.info("Spatial index creation cancelled (" + this.getFullFileName() + ")");
                            break;
                        }
                        FeatureProvider f = (FeatureProvider)it.next();
                        if (f == null) continue;
                        Object oid = null;
                        try {
                            oid = f.getOID();
                            Geometry geom = (Geometry)f.get(geomdesc.getName());
                            if (geom == null) continue;
                            index.insert(geom, oid);
                            theEnvelope.add(geom);
                        }
                        catch (Throwable ex) {
                            LOGGER.debug("Can't insert feature '" + Objects.toString(oid) + "' in spatial index.", ex);
                        }
                    }
                    this.taskStatus.message(i18n.getTranslation("_Saving_spatial_index"));
                    this.taskStatus.setIndeterminate();
                    index.flush();
                    if (!theEnvelope.isEmpty()) {
                        this.bboxFileSave("_" + geomName, theEnvelope);
                    }
                    this.envelopes.put(geomName, theEnvelope);
                } else {
                    this.envelopes.put(geomName, env);
                }
                this.spatialIndexes.put(geomdesc.getName(), index);
            }
            this.taskStatus.terminate();
        }
        catch (Exception ex) {
            this.taskStatus.abort();
            LOGGER.warn("Can't create spatial index.", (Throwable)ex);
        }
        finally {
            DisposeUtils.disposeQuietly(it);
            DisposeUtils.disposeQuietly(set);
            this.taskStatus.remove();
        }
    }

    public File getAuxFile(String extension) {
        return this.getAuxFile(null, extension);
    }

    public File getAuxFile(String suffix, String extension) {
        File data_file = SimpleReaderStoreParameters.getFile((DynObject)this.getSimpleReaderParameters());
        if (data_file == null) {
            return null;
        }
        File index_file = StringUtils.isBlank((CharSequence)suffix) ? new File(FilenameUtils.removeExtension((String)data_file.getAbsolutePath()) + "." + extension) : new File(FilenameUtils.removeExtension((String)data_file.getAbsolutePath()) + suffix + "." + extension);
        return index_file;
    }

    public SpatialIndex getSpatialIndex(String geomName) {
        if (this.spatialIndexes == null) {
            return null;
        }
        return this.spatialIndexes.get(geomName);
    }

    public SpatialIndex getSpatialIndex() {
        if (this.spatialIndexes == null) {
            return null;
        }
        FeatureAttributeDescriptor geomdesc = this.featureType.getDefaultGeometryAttribute();
        if (geomdesc == null) {
            return null;
        }
        return this.spatialIndexes.get(geomdesc.getName());
    }

    protected void bboxFileSave(Map<String, Envelope> envelopes) {
        if (envelopes == null || envelopes.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Envelope> entry : envelopes.entrySet()) {
            String key = entry.getKey();
            Envelope val = entry.getValue();
            this.bboxFileSave("_" + key, val);
        }
    }

    protected void bboxFileSave(Envelope envelope) {
        this.bboxFileSave((String)null, envelope);
    }

    protected void bboxFileSave(String suffix, Envelope envelope) {
        File bboxfile = this.getAuxFile(suffix, "bbox");
        this.bboxFileSave(bboxfile, envelope);
    }

    protected void bboxFileSave(File bboxfile, Envelope envelope) {
        if (envelope == null || envelope.isEmpty()) {
            bboxfile.delete();
            return;
        }
        try {
            FileUtils.write((File)bboxfile, (CharSequence)envelope.getBox2D().convertToWKTQuietly(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't write bbox file '" + Objects.toString(bboxfile) + "'.", (Throwable)ex);
        }
    }

    protected Envelope bboxFileLoad(String suffix) {
        File bboxfile = this.getAuxFile(suffix, "bbox");
        return this.bboxFileLoad(bboxfile);
    }

    protected Envelope bboxFileLoad(File bboxfile) {
        try {
            String wkt;
            GeometryManager geomManager;
            Geometry geom;
            if (bboxfile.exists() && (geom = (geomManager = GeometryLocator.getGeometryManager()).createFrom(wkt = FileUtils.readFileToString((File)bboxfile, (Charset)StandardCharsets.UTF_8))) != null) {
                return geom.getEnvelope();
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't load bbox file", (Throwable)ex);
        }
        return null;
    }

    protected abstract SimpleReader getSimpleReader(SimpleReaderStoreParameters var1, Reader var2) throws IOException;

    public FilteredLogger getTimedLogger() {
        if (timedLogger == null) {
            timedLogger = new FilteredLogger(LOGGER, "AbstractFeatureProviderLoadedOnDemand", 5000L);
        }
        return timedLogger;
    }

    public static class RowToFeatureTranslator {
        private Coercion[] coercion;
        private CoercionContext[] coercionContext;
        private int[] sizes;
        private String[] names;
        private final boolean ignore_errors;
        private long count_errors;
        private FeatureType csvFeatureType;

        public RowToFeatureTranslator(boolean ignore_errors) {
            this.ignore_errors = ignore_errors;
            this.count_errors = 0L;
        }

        public int getColumnSize(int column) {
            return this.sizes[column];
        }

        public void initialize(FeatureType ftype) {
            this.csvFeatureType = ftype;
            int columns = this.csvFeatureType.size();
            this.names = new String[columns];
            this.coercion = new Coercion[columns];
            this.coercionContext = new CoercionContext[columns];
            this.sizes = new int[columns];
            int index = 0;
            for (int i = 0; i < this.csvFeatureType.size(); ++i) {
                FeatureAttributeDescriptor ad = this.csvFeatureType.getAttributeDescriptor(i);
                this.names[i] = null;
                if (ad.isComputed()) continue;
                this.names[index] = ad.getName();
                this.coercion[index] = ad.getCoercion();
                this.coercionContext[index] = ad.getCoercionContext();
                this.sizes[index] = ad.getSize();
                ++index;
            }
        }

        public void translate(long rowindex, List<String> row, FeatureProvider feature) throws Exception {
            String name;
            feature.setOID((Object)rowindex);
            for (int i = 0; i < this.names.length && (name = this.names[i]) != null; ++i) {
                String rawvalue = row.get(i);
                try {
                    int x;
                    int findex;
                    Object value = null;
                    if (this.coercion[i] != null) {
                        value = this.coercion[i].coerce((Object)rawvalue, this.coercionContext[i]);
                    }
                    if ((findex = feature.getType().getIndex(name)) >= 0) {
                        feature.set(findex, value);
                    }
                    if (this.sizes[i] < 0 || !(value instanceof String) && !(value instanceof URL) && !(value instanceof URI) && !(value instanceof File) || this.sizes[i] >= (x = value.toString().length())) continue;
                    this.sizes[i] = x;
                    continue;
                }
                catch (Exception ex) {
                    if (!this.ignore_errors) {
                        throw ex;
                    }
                    if (this.count_errors++ < 10L) {
                        LOGGER.warn("Can't load value of attribute " + name + "/" + i + " in row " + rowindex + ".", (Throwable)ex);
                    }
                    if (this.count_errors != 10L) continue;
                    LOGGER.info("Too many errors, suppress messages.");
                }
            }
        }
    }

    static class ToPointEvaluaror
    extends AbstractEvaluator {
        private static final Logger logger = LoggerFactory.getLogger(ToPointEvaluaror.class);
        private GeometryManager geommgr = null;
        private String xname = null;
        private String yname = null;
        private String zname = null;
        private final Coercion toDouble;
        private int errorcount = 0;

        ToPointEvaluaror(String[] pointDimensionNames) {
            this.xname = pointDimensionNames[0];
            this.yname = pointDimensionNames[1];
            if (pointDimensionNames.length > 2) {
                this.zname = pointDimensionNames[2];
            }
            this.geommgr = GeometryLocator.getGeometryManager();
            this.toDouble = ToolsLocator.getDataTypesManager().getCoercion(7);
        }

        public Object evaluate(EvaluatorData data) throws EvaluatorException {
            try {
                double x = (Double)this.toDouble.coerce(data.getDataValue(this.xname));
                double y = (Double)this.toDouble.coerce(data.getDataValue(this.yname));
                Point point = this.geommgr.createPoint(x, y, 1);
                if (this.zname != null) {
                    double z = (Double)this.toDouble.coerce(data.getDataValue(this.zname));
                    point.setCoordinateAt(2, z);
                }
                return point;
            }
            catch (Exception ex) {
                if (++this.errorcount < 5) {
                    logger.warn("[" + this.errorcount + "] Can't create point. XNAME='" + this.xname + "', YNAME='" + this.yname + "', ZNAME='" + this.zname + "', data=" + data.toString());
                }
                return null;
            }
        }

        public String getName() {
            return "ToPointEvaluaror";
        }
    }
}

