/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader.virtualrows;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;

public class LimitedReader
extends Reader {
    private final Reader delegated;
    private final int limit;
    private int count;

    public LimitedReader(Reader reader, int limit) {
        this.delegated = reader;
        this.limit = limit;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.count >= this.limit) {
            return -1;
        }
        if (this.count + len > this.limit) {
            len = this.limit - this.count;
        }
        if (len == 0) {
            return -1;
        }
        int n = this.delegated.read(cbuf, off, len);
        if (this.count + n <= this.limit) {
            this.count += n;
            return n;
        }
        return this.limit - this.count;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        return this.delegated.read(target);
    }

    @Override
    public int read() throws IOException {
        return this.delegated.read();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.delegated.read(cbuf);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegated.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this.delegated.ready();
    }

    @Override
    public boolean markSupported() {
        return this.delegated.markSupported();
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.delegated.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegated.reset();
    }
}

