/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.simplereader.virtualrows;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.AbstractList;
import org.apache.commons.io.IOUtils;
import org.gvsig.tools.util.GetItemWithSize64;
import org.gvsig.tools.util.SetItem;

public class RandomAccessFileIndex
extends AbstractList<Long>
implements Closeable,
GetItemWithSize64<Long>,
SetItem<Integer, Long> {
    private static final int SIZE_OF_LONG = 8;
    private static final int HEADER_SIZE = 20;
    private RandomAccessFile raf;
    private MappedByteBuffer fileByteBuffer;
    private LongBuffer buffer;
    private long sz;

    public RandomAccessFileIndex() {
    }

    public RandomAccessFileIndex(File f) throws IOException {
        this.open(f);
    }

    public RandomAccessFileIndex(RandomAccessFile raf) throws IOException {
        this.open(raf);
    }

    public void open(File f) throws IOException {
        RandomAccessFile theRaf = new RandomAccessFile(f, "r");
        this.open(theRaf);
    }

    public void open(RandomAccessFile raf) throws IOException {
        this.raf = raf;
        this.fileByteBuffer = this.raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.raf.length());
        this.buffer = this.fileByteBuffer.asLongBuffer();
        this.sz = this.buffer.limit() - 20;
    }

    public void create(File f, long sz) throws IOException {
        RandomAccessFile theRaf = new RandomAccessFile(f, "rw");
        this.create(theRaf, sz);
    }

    public void create(RandomAccessFile raf, long numElements) throws IOException {
        this.raf = raf;
        this.raf.setLength((numElements + 20L) * 8L);
        this.fileByteBuffer = this.raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.raf.length());
        this.buffer = this.fileByteBuffer.asLongBuffer();
        this.sz = this.buffer.limit() - 20;
    }

    public void setNumElements(long numElements) throws IOException {
        long size = (numElements + 20L) * 8L;
        this.fileByteBuffer.force();
        this.raf.setLength(size);
        this.sz = numElements;
    }

    @Override
    public void close() throws IOException {
        this.fileByteBuffer.force();
        IOUtils.closeQuietly((Closeable)this.raf);
        this.buffer = null;
        this.fileByteBuffer = null;
        this.sz = -1L;
    }

    public boolean isOpen() {
        return this.buffer != null;
    }

    @Override
    public Long get(int position) {
        position = this.checkIndex(position);
        return this.buffer.get(position + 20);
    }

    @Override
    public int size() {
        return (int)this.sz;
    }

    public long size64() {
        return this.sz;
    }

    public Long get64(long position) {
        position = this.checkIndex(position);
        return this.buffer.get((int)position + 20);
    }

    public void set(Integer position, Long value) {
        position = this.checkIndex(position.intValue());
        this.buffer.put(position + 20, value);
    }

    @Override
    public void set(int position, long value) {
        position = this.checkIndex(position);
        this.buffer.put(position + 20, value);
    }

    public void setHeader(int index, long value) {
        index = this.checkHeaderIndex(index);
        this.buffer.put(index, value);
    }

    public long getHeader(int index) {
        index = this.checkHeaderIndex(index);
        return this.buffer.get(index);
    }

    private int checkIndex(long index) {
        if (this.buffer == null) {
            throw new IllegalStateException("Index not open");
        }
        if (index < 0L) {
            index = (long)((int)this.sz) + index;
        }
        if (index < 0L || index >= this.sz) {
            throw new IllegalArgumentException("Index out of range (" + index + ")");
        }
        return (int)index;
    }

    private int checkHeaderIndex(int index) {
        if (this.buffer == null) {
            throw new IllegalStateException("Index not open");
        }
        if (index < 0) {
            index = 20 + index;
        }
        if (index < 0 || index >= 20) {
            throw new IllegalArgumentException("Index out of range (" + index + ")");
        }
        return index;
    }
}

