/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.app.wmtsclient;

import java.awt.Component;
import java.awt.geom.Point2D;
import javax.swing.JOptionPane;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.extension.AddLayer;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.raster.fmap.layers.Multiresolution;
import org.gvsig.raster.wmts.app.wmtsclient.WMTSPropsTocMenuEntry;
import org.gvsig.raster.wmts.app.wmtsclient.gui.wizard.WMTSWizard;
import org.gvsig.raster.wmts.app.wmtsclient.layer.DynObjectSetWMTSInfo;
import org.gvsig.raster.wmts.app.wmtsclient.layer.FLyrWMTS;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionBuilder;
import org.gvsig.tools.extensionpoint.ExtensionPoint;

public class WMTSClientExtension
extends Extension {
    public void initialize() {
        ExtensionPoint exPoint = ToolsLocator.getExtensionPointManager().add("View_TocActions");
        exPoint.append("WMTSPropsTocMenuEntry", "", (ExtensionBuilder)new WMTSPropsTocMenuEntry());
        AddLayer.addWizard(WMTSWizard.class);
        this.initilizeIcons();
        DynObjectSetWMTSInfo.registerDynClass();
    }

    public void postInitialize() {
        FLyrWMTS.registerPersistent();
    }

    public void execute(String actionCommand) {
        Envelope r;
        AbstractViewPanel theView = (AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow();
        MapControl mapCtrl = theView.getMapControl();
        ViewPort viewPort = mapCtrl.getViewPort();
        Multiresolution lyrMultires = null;
        FLayers lyrs = mapCtrl.getMapContext().getLayers();
        for (int i = 0; i < lyrs.getLayersCount(); ++i) {
            FLayer lyr = lyrs.getLayer(i);
            if (!(lyr instanceof FLyrWMTS)) continue;
            lyrMultires = (Multiresolution)lyr;
        }
        if (actionCommand.compareTo("NEXT_LEVEL") == 0 && !lyrMultires.increaseZoomLevel()) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), "max_zoom_reached");
            return;
        }
        if (actionCommand.compareTo("PREV_LEVEL") == 0 && !lyrMultires.decreaseZoomLevel()) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), "min_zoom_reached");
            return;
        }
        Point2D.Double center = new Point2D.Double(viewPort.getExtent().getCenterX(), viewPort.getExtent().getCenterY());
        try {
            r = lyrMultires.getCoordsInLevel((Point2D)center, lyrMultires.getZoomLevel(), viewPort.getImageWidth(), viewPort.getImageHeight());
        }
        catch (CreateEnvelopeException e) {
            return;
        }
        mapCtrl.getViewPort().setEnvelope(r);
        mapCtrl.invalidate();
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        IWindow window = PluginServices.getMDIManager().getActiveWindow();
        if (window instanceof AbstractViewPanel) {
            AbstractViewPanel theView = (AbstractViewPanel)window;
            MapControl mapCtrl = theView.getMapControl();
            FLayers lyrs = mapCtrl.getMapContext().getLayers();
            for (int i = 0; i < lyrs.getLayersCount(); ++i) {
                if (!(lyrs.getLayer(i) instanceof FLyrWMTS)) continue;
                return true;
            }
        }
        return false;
    }

    void initilizeIcons() {
        IconThemeHelper.registerIcon(null, (String)"level-plus", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"level-less", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"icon-layer-wmts", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"aplication-preferences-downarrow", (Object)((Object)this));
        IconThemeHelper.registerIcon(null, (String)"aplication-preferences-uparrow", (Object)((Object)this));
    }
}

