/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.app.wmtsclient.layer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.print.attribute.PrintRequestAttributeSet;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.ViewPortData;
import org.gvsig.fmap.dal.coverage.exception.FilePaletteException;
import org.gvsig.fmap.dal.coverage.exception.InfoByPointException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.IHasImageLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.fmap.layers.NotAvailableStateException;
import org.gvsig.raster.fmap.legend.ImageLegend;
import org.gvsig.raster.util.CancelTaskImpl;
import org.gvsig.raster.wmts.app.wmtsclient.layer.DynObjectSetWMTSInfo;
import org.gvsig.raster.wmts.io.WMTSDataParameters;
import org.gvsig.raster.wmts.io.WMTSServerExplorer;
import org.gvsig.raster.wmts.io.WMTSServerExplorerParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.persistence.exception.PersistenceRuntimeException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLyrWMTS
extends DefaultFLyrRaster
implements IHasImageLegend {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(FLyrWMTS.class);
    private List<WeakReference<Thread>> disableUpdateDrawVersion;
    private Envelope fullEnvelope = null;
    private boolean firstLoad = false;
    private RasterManager rManager = RasterLocator.getManager();
    private DataStoreParameters params = null;
    private WMTSServerExplorer wmtsExplorer = null;
    private boolean deleteCache = false;

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("FLyrWMTS_Persistent");
        if (definition == null) {
            if (manager.getDefinition(DefaultFLyrRaster.class) == null) {
                DefaultFLyrRaster.registerPersistence();
            }
            definition = manager.addDefinition(FLyrWMTS.class, "FLyrWMTS_Persistent", "FLyrWMTS Persistent Definition", null, null);
            definition.extend("Persistence", "FLyrRasterSE_Persistent");
        }
        DefaultFLyrRaster.registerPersistence((DynStruct)definition);
    }

    public FLyrWMTS() {
        this.updateDrawVersion();
        try {
            this.enableAwake();
        }
        catch (NotAvailableStateException e) {
            logger.error("Fallo el estado de open. Closed=" + this.isClosed() + " Awake=" + this.isAwake(), (Object)this, (Object)e);
        }
    }

    public static DataStore createDataStore(String host, IProjection srs) throws InitializeException {
        URI hostURI;
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        RasterDataParameters params = null;
        try {
            params = (RasterDataParameters)dataman.createServerExplorerParameters(WMTSServerExplorer.NAME);
        }
        catch (InitializeException e) {
            return null;
        }
        catch (ProviderNotRegisteredException e) {
            return null;
        }
        try {
            hostURI = new URI(host);
        }
        catch (URISyntaxException e1) {
            logger.warn("Can't create URI from " + host, (Throwable)e1);
            throw new InitializeException((Throwable)e1);
        }
        params.setURI(hostURI);
        params.setSRS(srs);
        try {
            return dataman.openStore(params.getDataStoreName(), (DataStoreParameters)params);
        }
        catch (ValidateDataParametersException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        try {
            super.loadFromState(state);
            this.setDataStore((DataStore)this.getDataStore());
        }
        catch (PersistenceRuntimeException e) {
            logger.debug("Unable to load store from persistence in layer: " + this.getName(), (Throwable)e);
            this.setAvailable(false);
            return;
        }
        catch (LoadLayerException e) {
            logger.debug("Unable to load store to layer: " + this.getName(), (Throwable)e);
            this.setAvailable(false);
            return;
        }
    }

    public void setDataStore(DataStore dataStore) throws LoadLayerException {
        this.dataStore = (RasterDataStore)dataStore;
        try {
            this.enableOpen();
        }
        catch (NotAvailableStateException e) {
            logger.error("Fallo el estado de open. Closed=" + this.isClosed() + " Awake=" + this.isAwake(), (Object)this, (Object)e);
        }
        if (this.dataStore != null) {
            this.setProjection(this.dataStore.getProjection());
            this.setFullExtent(this.dataStore.getExtent().toRectangle2D());
        }
    }

    public void draw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale) throws ReadException {
        if (this.recalcLevel) {
            double pixelSize = viewPort.getExtent().getWidth() / (double)viewPort.getImageWidth();
            this.zoomLevel = this.dataStore.getNearestLevel(pixelSize);
        }
        this.recalcLevel = true;
        if (!this.firstLoad) {
            try {
                this.initFilters();
                try {
                    if (!this.isOpen()) {
                        this.enableOpen();
                    }
                }
                catch (NotAvailableStateException e) {
                    throw new ReadException("Fallo el estado de open. Closed=" + this.isClosed() + " Awake=" + this.isAwake(), (Throwable)e);
                }
            }
            catch (FilePaletteException e) {
                throw new ReadException(e.getMessage(), (Throwable)e);
            }
            this.firstLoad = true;
        }
        this.enableStopped();
        if (this.isWithinScale(scale)) {
            Envelope adjustedExtent = viewPort.getAdjustedEnvelope();
            if (!adjustedExtent.intersects(this.getFullEnvelope())) {
                return;
            }
            Extent ext = this.rManager.getDataStructFactory().createExtent(adjustedExtent.getLowerCorner().getX(), adjustedExtent.getUpperCorner().getY(), adjustedExtent.getUpperCorner().getX(), adjustedExtent.getLowerCorner().getY());
            Dimension imgSz = viewPort.getImageSize();
            ViewPortData vp2 = this.rManager.getDataStructFactory().createViewPortData(viewPort.getProjection(), ext, (Dimension2D)imgSz);
            vp2.setMat(viewPort.getAffineTransform());
            vp2.setDPI((int)viewPort.getDPI());
            TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
            DefaultFLyrRaster.RasterTaskStatus taskStatus = new DefaultFLyrRaster.RasterTaskStatus((DefaultFLyrRaster)this, "Drawing " + this.getName() + "...", cancel);
            manager.add((TaskStatus)taskStatus);
            taskStatus.setAutoremove(true);
            try {
                WMTSDataParameters par = this.getWMTSParameters(this.getParameters());
                par.setWidth((int)viewPort.getImageSize().getWidth());
                par.setHeight((int)viewPort.getImageSize().getHeight());
                this.getRender().drawTiledService(g, vp2, (Dimension2D)viewPort.getImageSize(), (TaskStatus)taskStatus);
            }
            catch (ProcessInterruptedException e) {
                throw new ReadException("Problems drawing this layer: " + e.getMessage(), (Throwable)e);
            }
            catch (QueryException e) {
                throw new ReadException("Problems drawing this layer: " + e.getMessage(), (Throwable)e);
            }
            finally {
                taskStatus.terminate();
            }
        }
        this.disableStopped();
    }

    public void print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, PrintRequestAttributeSet properties) throws ReadException {
    }

    public void _print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale) throws ReadException {
        this.draw(null, g, viewPort, cancel, scale);
    }

    public void setFullExtent(Rectangle2D fullExtent) {
        this.setFullEnvelope(this.getEnvelopeFromRectable2D(fullExtent));
    }

    public void setFullEnvelope(Envelope envelope) {
        Envelope cur = this.getFullEnvelope();
        if (cur == envelope) {
            return;
        }
        if (cur != null && cur.equals(envelope)) {
            return;
        }
        this.fullEnvelope = envelope;
        this.updateDrawVersion();
    }

    public HashMap<String, Object> getProperties() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        WMTSDataParameters par = this.getWMTSParameters(this.getParameters());
        String layerName = par.getLayer().getTitle();
        try {
            info.put("name", this.getName());
            info.put("selectedLayer", layerName);
            info.put("host", par.getURI());
            info.put("srs", par.getSRSCode());
            info.put("imageformat", par.getImageFormat());
            info.put("infoformat", par.getInfoFormat());
            return info;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getTocImageIcon() {
        return "icon-layer-wmts";
    }

    public boolean isActionEnabled(int action) {
        switch (action) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 19: 
            case 21: 
            case 22: {
                return false;
            }
            case 20: {
                return true;
            }
        }
        return super.isActionEnabled(action);
    }

    public ILegend getLegend() {
        if (this.getDataStore() != null) {
            return new ImageLegend(this.getDataStore().getImageLegend());
        }
        return null;
    }

    public boolean isRemote() {
        return true;
    }

    public boolean overviewsSupport() {
        return false;
    }

    protected void updateDrawVersion() {
        if (this.disableUpdateDrawVersion != null) {
            Thread curThread = Thread.currentThread();
            Iterator<WeakReference<Thread>> iter = this.disableUpdateDrawVersion.iterator();
            while (iter.hasNext()) {
                Thread aThread = (Thread)iter.next().get();
                if (aThread == null) {
                    iter.remove();
                    continue;
                }
                if (!aThread.equals(curThread)) continue;
                return;
            }
        }
        super.updateDrawVersion();
    }

    protected void disableUpdateDrawVersion() {
        if (this.disableUpdateDrawVersion == null) {
            this.disableUpdateDrawVersion = new ArrayList<WeakReference<Thread>>();
        }
        this.disableUpdateDrawVersion.add(new WeakReference<Thread>(Thread.currentThread()));
    }

    protected void enableUpdateDrawVersion() {
        if (this.disableUpdateDrawVersion == null) {
            return;
        }
        Thread curThread = Thread.currentThread();
        Iterator<WeakReference<Thread>> iter = this.disableUpdateDrawVersion.iterator();
        while (iter.hasNext()) {
            Thread aThread = (Thread)iter.next().get();
            if (aThread == null) {
                iter.remove();
                continue;
            }
            if (!aThread.equals(curThread)) continue;
            iter.remove();
            break;
        }
    }

    private Rectangle2D.Double getRectable2DFromEnvelope(Envelope env) {
        return new Rectangle2D.Double(env.getMinimum(0), env.getMinimum(1), env.getLength(0), env.getLength(1));
    }

    private Envelope getEnvelopeFromRectable2D(Rectangle2D rect) {
        try {
            return geomManager.createEnvelope(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY(), 0);
        }
        catch (CreateEnvelopeException e) {
            logger.error("Error creating the envelope", (Throwable)e);
            return null;
        }
    }

    public String getFileFormat() {
        return "WMTS";
    }

    public Envelope getFullEnvelope() {
        ICoordTrans ct;
        Envelope rAux = this.fullEnvelope;
        if (rAux == null || rAux.getMaximum(0) - rAux.getMinimum(0) == 0.0 && rAux.getMaximum(1) - rAux.getMinimum(1) == 0.0) {
            try {
                rAux = geomManager.createEnvelope(0.0, 0.0, 100.0, 100.0, 0);
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the envelope", (Throwable)e);
            }
        }
        if ((ct = this.getCoordTrans()) != null) {
            Point2D pt1 = new Point2D.Double(rAux.getMinimum(0), rAux.getMinimum(1));
            Point2D pt2 = new Point2D.Double(rAux.getMaximum(0), rAux.getMaximum(1));
            pt1 = ct.convert(pt1, null);
            pt2 = ct.convert(pt2, null);
            try {
                rAux = geomManager.createEnvelope(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY(), 0);
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the envelope", (Throwable)e);
            }
        }
        return rAux;
    }

    public Extent getFullRasterExtent() {
        Envelope env = this.getFullEnvelope();
        double minx = env.getMinimum(0);
        double miny = env.getMinimum(1);
        double maxx = env.getMaximum(0);
        double maxy = env.getMaximum(1);
        Point2D.Double ul = new Point2D.Double(minx, maxy);
        Point2D.Double ur = new Point2D.Double(maxx, maxy);
        Point2D.Double ll = new Point2D.Double(minx, miny);
        Point2D.Double lr = new Point2D.Double(maxx, miny);
        return this.rManager.getDataStructFactory().createExtent((Point2D)ul, (Point2D)lr, (Point2D)ur, (Point2D)ll);
    }

    public DynObjectSet getInfo(java.awt.Point p, double tolerance, Cancellable cancel) throws LoadLayerException, DataException {
        return null;
    }

    public DynObjectSet getInfo(java.awt.Point p, double tolerance, Cancellable cancel, boolean fast) throws LoadLayerException, DataException {
        Point pReal = this.getMapContext().getViewPort().convertToMapPoint((Point2D)p);
        String fInfo = null;
        try {
            fInfo = this.getDataStore().getInfoByPoint(pReal.getX(), pReal.getY(), (ICancellable)new CancelTaskImpl(cancel));
        }
        catch (InfoByPointException e) {
            throw new LoadLayerException("Error in getInfoByPoint", (Throwable)e);
        }
        int type = 0;
        WMTSDataParameters wmtsParams = this.getWMTSParameters(this.params);
        if (wmtsParams.getInfoFormat() != null) {
            if (wmtsParams.getInfoFormat().compareTo("text/html") == 0) {
                type = 1;
            }
            if (wmtsParams.getInfoFormat().compareTo("application/vnd.ogc.gml") == 0) {
                type = 2;
            }
        }
        return new DynObjectSetWMTSInfo(fInfo, type);
    }

    public void setParameters(DataStoreParameters params) throws InitializeException {
        this.params = params;
        if (params instanceof TileDataParameters) {
            ((TileDataParameters)params).deleteCache(this.deleteCache);
        }
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            DataParameters p;
            DataStore dStore = dataman.openStore(params.getDataStoreName(), params);
            this.setDataStore(dStore);
            if (params instanceof WMTSDataParameters) {
                this.setName(((WMTSDataParameters)params).getURI().getPath());
            }
            if (params instanceof TileDataParameters && (p = ((TileDataParameters)params).getDataParameters()) instanceof WMTSDataParameters) {
                this.setName(((WMTSDataParameters)p).getURI().getPath());
            }
        }
        catch (ValidateDataParametersException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (InitializeException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (LoadLayerException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    public DataStoreParameters getParameters() {
        if (this.params == null) {
            DataManager datamanager = DALLocator.getDataManager();
            WMTSServerExplorerParameters explorerParams = null;
            try {
                explorerParams = (WMTSServerExplorerParameters)datamanager.createServerExplorerParameters(WMTSServerExplorer.NAME);
                explorerParams.setHost("");
                this.wmtsExplorer = (WMTSServerExplorer)datamanager.createServerExplorer((DataServerExplorerParameters)explorerParams);
                this.params = this.wmtsExplorer.getStoredParameters();
            }
            catch (InitializeException initializeException) {
            }
            catch (ProviderNotRegisteredException providerNotRegisteredException) {
            }
            catch (ValidateDataParametersException validateDataParametersException) {
                // empty catch block
            }
        }
        return this.getWMTSParameters(this.params);
    }

    private WMTSDataParameters getWMTSParameters(DataStoreParameters parameters) {
        DataParameters p;
        WMTSDataParameters params = null;
        if (parameters instanceof WMTSDataParameters) {
            params = (WMTSDataParameters)parameters;
        }
        if (parameters instanceof TileDataParameters && (p = ((TileDataParameters)parameters).getDataParameters()) instanceof WMTSDataParameters) {
            params = (WMTSDataParameters)p;
        }
        return params;
    }

    public void setExplorer(WMTSServerExplorer explorer) {
        this.wmtsExplorer = explorer;
    }

    public WMTSServerExplorer getExplorer() {
        return this.wmtsExplorer;
    }

    public Image getImageLegend() {
        return this.dataStore.getImageLegend();
    }

    public String getPathImage() {
        return null;
    }

    public FLayer cloneLayer() throws Exception {
        FLyrWMTS newLayer = (FLyrWMTS)this.cloneLayer0();
        newLayer.fullEnvelope = this.fullEnvelope;
        newLayer.params = this.params;
        return this.cloneLayer1(newLayer);
    }

    public void deleteCache(boolean deleteCache) {
        this.deleteCache = deleteCache;
    }
}

