/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import java.util.Vector;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Add;
import org.nfunk.jep.function.Multiply;
import org.nfunk.jep.function.PostfixMathCommand;

public class Dot
extends PostfixMathCommand {
    static Add add = new Add();
    static Multiply mul = new Multiply();

    public Dot() {
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e = stack.pop();
        Object e2 = stack.pop();
        stack.push(this.dot(e2, e));
    }

    public Object dot(Object object, Object object2) throws ParseException {
        if (object instanceof Vector && object2 instanceof Vector) {
            return this.dot((Vector)object, (Vector)object2);
        }
        throw new ParseException("Dot: Invalid parameter type, both arguments must be vectors");
    }

    public Object dot(Vector vector, Vector vector2) throws ParseException {
        if (vector.size() != vector2.size()) {
            throw new ParseException("Dot: both sides of dot must be same length");
        }
        int n = vector.size();
        if (n < 1) {
            throw new ParseException("Dot: empty vectors parsed");
        }
        Object object = mul.mul(vector.elementAt(0), vector2.elementAt(0));
        for (int i = 1; i < n; ++i) {
            object = add.add(object, mul.mul(vector.elementAt(i), vector2.elementAt(i)));
        }
        return object;
    }
}

