/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;

public class ImageSizePanel
extends JPanel
implements KeyListener,
MouseListener,
ActionListener,
FocusListener {
    private static final long serialVersionUID = 4810686805894198593L;
    private static final Icon iconSelected = IconThemeHelper.getImageIcon((String)"image-keep-ratio-enabled");
    private static final Icon iconUnselected = IconThemeHelper.getImageIcon((String)"image-keep-ratio-disabled");
    private JNumberSpinner widthTxt;
    private JNumberSpinner heightTxt;
    private double width;
    private double height;
    private JToggleButton lock;
    private double ratio;
    private boolean performing;
    private boolean locked = true;
    private ArrayList<ActionListener> listeners = new ArrayList();

    public ImageSizePanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagLayoutPanel aux = new GridBagLayoutPanel();
        this.setLayout(new BorderLayout());
        this.widthTxt = new JNumberSpinner(0.0, 5, 0.0, Double.MAX_VALUE, 1.0);
        aux.addComponent(Messages.getText((String)"width") + ":", (Component)this.widthTxt);
        this.heightTxt = new JNumberSpinner(0.0, 5, 0.0, Double.MAX_VALUE, 1.0);
        aux.addComponent(Messages.getText((String)"height") + ":", (Component)this.heightTxt);
        this.setLayout(new BorderLayout());
        this.add((Component)aux, "Center");
        JPanel lockPanel = new JPanel(null){
            private static final long serialVersionUID = -415551033800811412L;

            @Override
            protected void paintComponent(Graphics g) {
                int y1 = ImageSizePanel.this.widthTxt.getY() + ImageSizePanel.this.widthTxt.getHeight() / 2 - 3;
                int y2 = ImageSizePanel.this.heightTxt.getY() + ImageSizePanel.this.heightTxt.getHeight() / 2 + 3;
                g.setColor(Color.DARK_GRAY);
                g.drawLine(2, y1, this.getWidth() / 2 + 2, y1);
                g.drawLine(this.getWidth() / 2 + 2, y1, this.getWidth() / 2 + 2, y2);
                g.drawLine(2, y2, this.getWidth() / 2 + 2, y2);
                ImageSizePanel.this.lock.setBounds(3, ImageSizePanel.this.widthTxt.getY() + 13, this.getWidth() - 2, 22);
            }
        };
        lockPanel.setPreferredSize(new Dimension(20, 20));
        this.lock = new JToggleButton(){
            private static final long serialVersionUID = 1668046192113822412L;

            @Override
            protected void paintComponent(Graphics g) {
                this.setIcon(this.isSelected() ? iconSelected : iconUnselected);
                super.paintComponent(g);
            }
        };
        this.lock.setSelected(this.locked);
        lockPanel.add(this.lock);
        this.add((Component)lockPanel, "East");
        this.widthTxt.addKeyListener((KeyListener)this);
        this.widthTxt.addMouseListener((MouseListener)this);
        this.widthTxt.addActionListener((ActionListener)this);
        this.widthTxt.addFocusListener((FocusListener)this);
        this.heightTxt.addKeyListener((KeyListener)this);
        this.heightTxt.addMouseListener((MouseListener)this);
        this.heightTxt.addActionListener((ActionListener)this);
        this.heightTxt.addFocusListener((FocusListener)this);
        this.lock.addMouseListener(this);
    }

    public void setImageSize(double width, double height) {
        this.width = width;
        this.widthTxt.setDouble(width);
        this.height = height;
        this.heightTxt.setDouble(height);
        this.ratio = width / height;
    }

    public void setImageSize(Dimension sz) {
        this.setImageSize(sz.getWidth(), sz.getHeight());
    }

    public double[] getImageDimension() {
        double[] d = new double[]{this.width, this.height};
        return d;
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.doIt();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.doIt();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.doIt();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        e.consume();
        this.doIt();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doIt();
    }

    private void doIt() {
        if (!this.performing) {
            this.performing = true;
            if (this.locked != this.lock.isSelected()) {
                this.locked = this.lock.isSelected();
                this.ratio = this.widthTxt.getDouble() / this.heightTxt.getDouble();
            } else if (this.locked && this.width != this.widthTxt.getDouble()) {
                this.width = this.widthTxt.getDouble();
                this.height = this.width / this.ratio;
                this.height = Math.round(this.height * 100.0) / 100L;
                this.heightTxt.setDouble(this.height);
                this.fireActionPerformed();
            } else if (this.locked && this.height != this.heightTxt.getDouble()) {
                this.height = this.heightTxt.getDouble();
                this.width = this.height * this.ratio;
                this.width = Math.round(this.width * 100.0) / 100L;
                this.widthTxt.setDouble(this.width);
                this.fireActionPerformed();
            }
            this.performing = false;
        }
    }

    private void fireActionPerformed() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).actionPerformed(new ActionEvent(this, 0, "IMAGE_RESIZED"));
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.doIt();
    }
}

