/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import org.gvsig.app.gui.styling.SymbolEditor;
import org.gvsig.app.gui.styling.TypeSymbolEditor;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;

public abstract class AbstractTypeSymbolEditor
implements TypeSymbolEditor {
    protected SymbolEditor owner;
    private boolean applying = false;
    protected transient FeatureStore featureStore;
    private transient Feature sampleFeature;

    public AbstractTypeSymbolEditor(SymbolEditor owner) {
        this.owner = owner;
    }

    public final String toString() {
        return this.getName();
    }

    protected final void fireSymbolChangedEvent() {
        if (!this.applying) {
            this.applying = true;
            ISymbol sym = this.getLayer();
            if (sym != null) {
                if (sym instanceof CartographicSupport) {
                    CartographicSupport cs = (CartographicSupport)sym;
                    cs.setReferenceSystem(this.owner.getUnitsReferenceSystem());
                    cs.setUnit(this.owner.getUnit());
                }
                this.owner.setLayerToSymbol(sym);
                this.owner.refresh();
            }
            this.applying = false;
        }
    }

    public void setFeatureStore(FeatureStore store) {
        this.featureStore = store;
    }

    public Feature getSampleFeature() {
        if (this.sampleFeature == null && this.featureStore != null) {
            this.sampleFeature = this.featureStore.getSampleFeature();
        }
        return this.sampleFeature;
    }
}

