/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.gvsig.app.gui.styling.MyItem;
import org.gvsig.app.gui.styling.SymbolPreviewer;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.ISimpleMarkerSymbol;

public class JComboBoxSimpleMarkeStyles
extends JComboBox {
    private static final long serialVersionUID = 3018193423738880772L;
    private Color symColor = Color.BLACK;
    private Color outlineColor = Color.BLACK;
    private boolean outlined = false;
    static MyItem[] pointTypes = new MyItem[]{new MyItem(0), new MyItem(1), new MyItem(2), new MyItem(3), new MyItem(4), new MyItem(5), new MyItem(6), new MyItem(7), new MyItem(8)};

    public JComboBoxSimpleMarkeStyles() {
        this.removeAllItems();
        for (int i = 0; i < pointTypes.length; ++i) {
            this.addItem(pointTypes[i]);
        }
        this.setEditable(false);
        this.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                SymbolPreviewer preview = new SymbolPreviewer(true);
                ISimpleMarkerSymbol mySymbol = SymbologyLocator.getSymbologyManager().createSimpleMarkerSymbol();
                mySymbol.setColor(JComboBoxSimpleMarkeStyles.this.symColor);
                mySymbol.setOutlined(JComboBoxSimpleMarkeStyles.this.outlined);
                mySymbol.setOutlineColor(JComboBoxSimpleMarkeStyles.this.outlineColor);
                if (value instanceof MyItem) {
                    mySymbol.setStyle(((MyItem)value).style);
                } else {
                    mySymbol.setStyle(((Integer)value).intValue());
                }
                mySymbol.setUnit(-1);
                mySymbol.setSize(10.0);
                preview.setForeground(UIManager.getColor(isSelected ? "ComboBox.selectionForeground" : "ComboBox.foreground"));
                preview.setBackground(UIManager.getColor(isSelected ? "ComboBox.selectionBackground" : "ComboBox.background"));
                preview.setSymbol((ISymbol)mySymbol);
                preview.setSize(preview.getWidth(), 20);
                preview.setPreferredSize(new Dimension(preview.getWidth(), 20));
                return preview;
            }
        });
    }

    public void setSymbolColor(Color c) {
        this.symColor = c;
    }

    public void setOutlineColor(Color c) {
        this.outlined = c != null;
        this.outlineColor = c;
    }

    @Override
    public Object getSelectedItem() {
        return ((MyItem)super.getSelectedItem()).style;
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item instanceof Integer) {
            int myItem = (Integer)item;
            for (int i = 0; i < pointTypes.length; ++i) {
                if (myItem != JComboBoxSimpleMarkeStyles.pointTypes[i].style) continue;
                this.setSelectedIndex(i);
            }
        }
        super.setSelectedItem(item);
    }
}

