/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.gui.panels.ColorChooserPanel;
import org.gvsig.app.gui.styling.AbstractTypeSymbolEditor;
import org.gvsig.app.gui.styling.EditorTool;
import org.gvsig.app.gui.styling.JUrlFileChooser;
import org.gvsig.app.gui.styling.MarkerFillProperties;
import org.gvsig.app.gui.styling.SymbolEditor;
import org.gvsig.app.project.documents.view.legend.gui.JSymbolPreviewButton;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.IWarningSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JBlank;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IPictureFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;

public class PictureFill
extends AbstractTypeSymbolEditor
implements ActionListener {
    private JLabel lblFileName;
    private JLabel lblSelFileName;
    private ArrayList<JPanel> tabs = new ArrayList();
    private MarkerFillProperties fillProperties;
    private File picFile;
    private JNumberSpinner incrAngle;
    private JNumberSpinner incrScaleX;
    private JNumberSpinner incrScaleY;
    private ColorChooserPanel jccFillColor;
    private ILineSymbol outline;
    private JSymbolPreviewButton btnOutline;
    private JCheckBox useBorder;
    private JButton btnBrowseFile;
    private JButton btnBrowseFileSelected;
    private static final double DEGREE_TO_RADIANS = Math.PI / 180;
    private ActionListener chooseAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JLabel targetLbl;
            if (e.getSource().equals(PictureFill.this.btnBrowseFile)) {
                targetLbl = PictureFill.this.lblFileName;
                boolean isSelection = false;
            } else {
                targetLbl = PictureFill.this.lblSelFileName;
                boolean isSelection = true;
            }
            FileFilter ff = new FileFilter(){

                @Override
                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String fName = f.getAbsolutePath();
                    if (fName != null) {
                        return (fName = fName.toLowerCase()).endsWith(".png") || fName.endsWith(".gif") || fName.endsWith(".jpg") || fName.endsWith(".jpeg") || fName.endsWith(".bmp") || fName.endsWith(".svg");
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    return Messages.getText((String)"bitmap_and_svg_image_files");
                }
            };
            JUrlFileChooser jfc = new JUrlFileChooser(PictureFill.this.getName(), null);
            jfc.setFileFilter(ff);
            jfc.setFileSelectionMode(0);
            jfc.setSelectedFile(PictureFill.this.picFile);
            jfc.setMultiSelectionEnabled(false);
            int returnVal = jfc.showOpenDialog(PictureFill.this.owner);
            if (returnVal == 0) {
                URL url = jfc.getSelectedURL();
                if (url == null) {
                    return;
                }
                try {
                    targetLbl.setText(url.toURI().getPath());
                }
                catch (URISyntaxException e1) {
                    NotificationManager.addWarning((String)"URI Syntax error", (Throwable)e1);
                }
                PictureFill.this.fireSymbolChangedEvent();
            }
            boolean enabled = PictureFill.this.lblFileName.getText() != "";
            PictureFill.this.enableControls(PictureFill.this.lblFileName.getText() != "");
        }
    };

    public PictureFill(SymbolEditor owner) {
        super(owner);
        this.initialize();
    }

    private void initialize() {
        JPanel myTab = new JPanel(new FlowLayout(3, 5, 5));
        myTab.setName(Messages.getText((String)"picture_fill"));
        this.btnBrowseFile = new JButton(Messages.getText((String)"browse"));
        this.btnBrowseFile.addActionListener(this.chooseAction);
        this.btnBrowseFileSelected = new JButton(Messages.getText((String)"browse"));
        this.btnBrowseFileSelected.addActionListener(this.chooseAction);
        JPanel aux2 = new JPanel(new FlowLayout(0, 5, 5));
        JPanel auxLabelPic = new JPanel(new FlowLayout(0, 5, 5));
        JLabel lblName = new JLabel();
        lblName.setFont(lblName.getFont().deriveFont(1));
        lblName.setText(Messages.getText((String)"picture_file") + ":");
        auxLabelPic.add(lblName);
        aux2.add((Component)this.btnBrowseFile);
        this.lblFileName = new JLabel("");
        aux2.add(this.lblFileName);
        JPanel auxLabelSelPic = new JPanel(new FlowLayout(0, 5, 5));
        JLabel lblSelName = new JLabel();
        lblSelName.setFont(lblSelName.getFont().deriveFont(1));
        lblSelName.setText(Messages.getText((String)"selection_picture_file") + ":");
        auxLabelSelPic.add(lblSelName);
        JPanel aux4 = new JPanel(new FlowLayout(0, 5, 5));
        aux4.add((Component)this.btnBrowseFileSelected);
        this.lblSelFileName = new JLabel("");
        aux4.add(this.lblSelFileName);
        GridBagLayoutPanel aux = new GridBagLayoutPanel();
        aux.addComponent((Component)new JBlank(5, 5));
        aux.addComponent((Component)auxLabelPic);
        aux.addComponent((Component)aux2);
        aux.addComponent((Component)auxLabelSelPic);
        aux.addComponent((Component)aux4);
        aux2 = new JPanel(new GridLayout(1, 2, 20, 5));
        GridBagLayoutPanel aux3 = new GridBagLayoutPanel();
        this.incrAngle = new JNumberSpinner(0, 20);
        aux3.addComponent(Messages.getText((String)"angle") + ":", (Component)this.incrAngle);
        this.incrScaleX = new JNumberSpinner(1.0, 20, 0.01, Double.POSITIVE_INFINITY, 0.1);
        aux3.addComponent(Messages.getText((String)"scale") + "X:", (Component)this.incrScaleX);
        this.incrScaleX.setDouble(1.0);
        this.incrScaleY = new JNumberSpinner(1.0, 20, 0.01, Double.POSITIVE_INFINITY, 0.1);
        aux3.addComponent(Messages.getText((String)"scale") + "Y:", (Component)this.incrScaleY);
        this.incrScaleY.setDouble(1.0);
        aux2.add((Component)aux3);
        aux3 = new GridBagLayoutPanel();
        aux3.addComponent((Component)new JBlank(5, 5));
        aux3.addComponent((Component)new JLabel(Messages.getText((String)"fill_color") + ":"));
        aux3.addComponent((Component)new JBlank(5, 5));
        this.jccFillColor = new ColorChooserPanel(true, true);
        aux3.addComponent((Component)this.jccFillColor);
        this.jccFillColor.setAlpha(255);
        aux3.addComponent((Component)new JBlank(5, 5));
        aux3.addComponent((Component)new JBlank(5, 5));
        aux2.add((Component)aux3);
        aux.addComponent((Component)aux2);
        aux.addComponent((Component)new JBlank(10, 10));
        aux2 = new JPanel(new FlowLayout(0, 0, 0));
        this.btnOutline = new JSymbolPreviewButton(2);
        aux2.add(this.btnOutline);
        this.useBorder = new JCheckBox(Messages.getText((String)"use_outline"));
        aux.addComponent((Component)this.useBorder);
        aux.addComponent(Messages.getText((String)"outline") + ":", (Component)aux2);
        this.fillProperties = new MarkerFillProperties();
        myTab.add((Component)aux);
        this.fillProperties.addActionListener(this);
        this.incrAngle.addActionListener((ActionListener)this);
        this.incrScaleX.addActionListener((ActionListener)this);
        this.incrScaleY.addActionListener((ActionListener)this);
        this.jccFillColor.addActionListener((ActionListener)this);
        this.btnOutline.addActionListener(this);
        this.useBorder.addActionListener(this);
        this.tabs.add(myTab);
        this.tabs.add(this.fillProperties);
        this.enableControls(false);
    }

    @Override
    public EditorTool[] getEditorTools() {
        throw new Error("Not yet implemented!");
    }

    @Override
    public ISymbol getLayer() {
        IPictureFillSymbol sym = null;
        try {
            if (this.lblFileName.getText().equals("")) {
                sym = null;
            } else {
                sym = SymbologyLocator.getSymbologyManager().createPictureFillSymbol(new File(this.lblFileName.getText()).toURI().toURL(), null);
                if (!this.lblSelFileName.getText().equals("")) {
                    sym = SymbologyLocator.getSymbologyManager().createPictureFillSymbol(new File(this.lblFileName.getText()).toURI().toURL(), new File(this.lblSelFileName.getText()).toURI().toURL());
                }
                sym.setHasFill(this.jccFillColor.getUseColorisSelected());
                Color c = this.jccFillColor.getColor();
                if (c != null) {
                    c = new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
                }
                sym.setFillColor(c);
                sym.setHasOutline(this.useBorder.isSelected());
                this.outline = (ILineSymbol)this.btnOutline.getSymbol();
                sym.setOutline(this.outline);
                sym.setAngle(this.incrAngle.getDouble() * (Math.PI / 180));
                sym.setXScale(this.incrScaleX.getDouble());
                sym.setYScale(this.incrScaleY.getDouble());
                sym.setMarkerFillProperties(this.fillProperties.getMarkerFillProperties());
            }
        }
        catch (IOException e) {
            IWarningSymbol warning = MapContextLocator.getSymbolManager().getWarningSymbol(SymbolDrawingException.STR_UNSUPPORTED_SET_OF_SETTINGS, Messages.getText((String)"failed_acessing_files"), 0);
            return warning;
        }
        return sym;
    }

    @Override
    public String getName() {
        return Messages.getText((String)"picture_fill_symbol");
    }

    @Override
    public JPanel[] getTabs() {
        return this.tabs.toArray(new JPanel[this.tabs.size()]);
    }

    @Override
    public void refreshControls(ISymbol layer) {
        if (layer instanceof IPictureFillSymbol) {
            IPictureFillSymbol sym = (IPictureFillSymbol)layer;
            URL source = sym.getSource();
            if (source != null) {
                try {
                    this.lblFileName.setText(source.toURI().getPath());
                }
                catch (URISyntaxException e) {
                    NotificationManager.addWarning((String)"URI Syntax error", (Throwable)e);
                }
            } else {
                this.lblFileName.setText("");
            }
            URL selSource = sym.getSelectedSource();
            if (selSource != null) {
                try {
                    this.lblSelFileName.setText(selSource.toURI().getPath());
                }
                catch (URISyntaxException e) {
                    NotificationManager.addWarning((String)"URI Syntax error", (Throwable)e);
                }
            } else {
                this.lblSelFileName.setText("");
            }
            this.jccFillColor.setUseColorIsSelected(sym.hasFill());
            this.jccFillColor.setColor(sym.getFillColor());
            this.outline = sym.getOutline();
            this.btnOutline.setSymbol((ISymbol)this.outline);
            this.useBorder.setSelected(sym.hasOutline());
            this.incrAngle.setDouble(sym.getAngle() / (Math.PI / 180));
            this.incrScaleX.setDouble(sym.getXScale());
            this.incrScaleY.setDouble(sym.getYScale());
            this.fillProperties.setModel(sym.getMarkerFillProperties());
            this.enableControls(this.lblFileName.getText() != "");
        }
    }

    private void enableControls(boolean enabled) {
        this.btnBrowseFileSelected.setEnabled(enabled);
        this.incrAngle.setEnabled(enabled);
        this.incrScaleX.setEnabled(enabled);
        this.incrScaleY.setEnabled(enabled);
        this.incrAngle.setEnabled(enabled);
        this.incrScaleX.setEnabled(enabled);
        this.incrScaleY.setEnabled(enabled);
        this.jccFillColor.setEnabled(enabled);
        this.btnOutline.setEnabled(enabled);
        this.useBorder.setEnabled(enabled);
        this.fillProperties.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s.equals(this.jccFillColor)) {
            this.jccFillColor.getColor().getAlpha();
        }
        this.outline = (ILineSymbol)this.btnOutline.getSymbol();
        this.fireSymbolChangedEvent();
    }

    @Override
    public boolean canManageSymbol(ISymbol symbol) {
        return symbol instanceof IPictureFillSymbol;
    }
}

