/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.URL;
import org.gvsig.app.gui.styling.PictureMarker;
import org.gvsig.app.gui.styling.SymbolEditor;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.IWarningSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.IPictureLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IPictureMarkerSymbol;

public class PictureLine
extends PictureMarker {
    public PictureLine(SymbolEditor owner) {
        super(owner);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.colorLinePicker.setEditable(false);
        this.xoffsetExpPicker.setEditable(false);
        this.yoffsetExpPicker.setEditable(false);
        this.rotationExpPicker.setEditable(false);
        this.colorExpPicker.setEditable(false);
        this.view.txtColorLine.setEnabled(false);
        this.view.btnColorLine.setEnabled(false);
        this.view.txtColorLineExp.setEnabled(false);
        this.view.btnColorLineExpression.setEnabled(false);
        this.view.btnColorLineExpressionBookmarks.setEnabled(false);
        this.view.btnColorLineExpressionHistory.setEnabled(false);
        this.view.txtX.setEnabled(false);
        this.view.txtXOffset.setEnabled(false);
        this.view.btnXOffsetExpression.setEnabled(false);
        this.view.btnXOffsetExpressionBookmarks.setEnabled(false);
        this.view.btnXOffsetExpressionHistory.setEnabled(false);
        this.view.txtY.setEnabled(false);
        this.view.txtYOffset.setEnabled(false);
        this.view.btnYOffsetExpression.setEnabled(false);
        this.view.btnYOffsetExpressionBookmarks.setEnabled(false);
        this.view.btnYOffsetExpressionHistory.setEnabled(false);
        this.view.txtRotation.setEnabled(false);
        this.view.txtRotationExp.setEnabled(false);
        this.view.btnRotationExpression.setEnabled(false);
        this.view.btnRotationExpressionBookmarks.setEnabled(false);
        this.view.btnRotationExpressionHistory.setEnabled(false);
        this.view.chkDrawLineToOffset.setEnabled(false);
    }

    @Override
    public String getName() {
        return Messages.getText((String)"picture_line_symbol");
    }

    @Override
    public void refreshControls(ISymbol layer) {
        try {
            if (layer == null) {
                this.setValues(1.0, 0.0, 0.0, null, null, null, null, null, null, null, null, false);
            } else {
                IPictureLineSymbol sym = (IPictureLineSymbol)layer;
                this.setValues(sym.getLineWidth(), sym.getRotation(), sym.getOffset().getX(), sym.getOffset().getY(), sym.getSource(), sym.getSelectedSource(), sym.getSizeExpression(), sym.getOffsetXExpression(), sym.getOffsetYExpression(), sym.getLineToOffsetColor(), sym.getLineToOffsetColorExpression(), sym.getRotationExpression(), sym.isDrawLineToOffset());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Can't refresh picture line symbol panel.", (Throwable)ex);
        }
    }

    @Override
    protected void setValues(double size, double rotation, double xOffset, double yOffset, URL picture, URL selectedPicture, String sizeExpression, String offsetXExpression, String offsetYExpression, Color lineToOffsetColor, String lineToOffsetColorExpression, String rotationExpression, boolean isDrawLineToOffset) {
        super.setValues(size, rotation, xOffset, yOffset, picture, selectedPicture, sizeExpression, offsetXExpression, offsetYExpression, lineToOffsetColor, lineToOffsetColorExpression, rotationExpression, isDrawLineToOffset);
    }

    @Override
    public ISymbol getLayer() {
        try {
            IPictureLineSymbol layer = null;
            if (this.getPictureFile() != null) {
                layer = SymbologyLocator.getSymbologyManager().createPictureLineSymbol(this.getPictureURL(), this.getSelectedPictureURL());
                layer.setFeature(this.getSampleFeature());
                layer.setLineWidth(this.getSize());
                layer.setSizeExpression(ExpressionUtils.getPhrase((Expression)this.getSizeExpression()));
                layer.setOffset((Point2D)new Point2D.Double(this.getX(), this.getY()));
                layer.setRotation(Math.toRadians(this.getRotation()));
                layer.setRotationExpression(ExpressionUtils.getPhrase((Expression)this.getRotationExpression()));
                layer.setOffsetXExpression(ExpressionUtils.getPhrase((Expression)this.getXOffsetExpression()));
                layer.setOffsetYExpression(ExpressionUtils.getPhrase((Expression)this.getYOffsetExpression()));
                layer.setSizeExpression(ExpressionUtils.getPhrase((Expression)this.getSizeExpression()));
                layer.setDrawLineToOffset(this.isSelectedDrawLineToOffset());
                layer.setLineToOffsetColor(this.getLineToOffsetColor());
                layer.setLineToOffsetColorExpression(ExpressionUtils.getPhrase((Expression)this.getLineToOffsetColorExpression()));
            }
            return layer;
        }
        catch (IOException e) {
            IWarningSymbol warning = MapContextLocator.getSymbolManager().getWarningSymbol(SymbolDrawingException.STR_UNSUPPORTED_SET_OF_SETTINGS, Messages.getText((String)"failed_acessing_files"), 0);
            return warning;
        }
    }

    @Override
    public boolean canManageSymbol(ISymbol symbol) {
        return symbol instanceof IPictureMarkerSymbol;
    }
}

