/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.gvsig.svgsupport.SVGRenderer;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLDListBoxCellRenderer
extends JPanel
implements ListCellRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(SLDListBoxCellRenderer.class);
    private static final long serialVersionUID = 1458566622433802796L;
    private String str;
    private final SVGRenderer renderer;
    BufferedImage image;

    public SLDListBoxCellRenderer() {
        this.setOpaque(true);
        this.setLayout(new BorderLayout(3, 3));
        this.renderer = ToolsUtilLocator.getSVGSupportManager().createRenderer();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String selectedSymbol;
        this.str = selectedSymbol = value.toString();
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        try {
            this.renderer.setSource(new File(this.str));
        }
        catch (Exception ex) {
            LOG.warn("Can't draw svg from '" + this.str + "'.", (Throwable)ex);
        }
        String pet = selectedSymbol;
        this.setFont(list.getFont());
        this.repaint();
        return this;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        try {
            this.renderer.drawInsideRectangle((Graphics2D)g, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, (double)this.getWidth() - 1.0, (double)this.getHeight() - 1.0), true);
        }
        catch (Exception e) {
            Rectangle bounds = this.getBounds();
            JLabel errLbl = new JLabel("<html><b>Cannot render north</b></html>");
            errLbl.setPreferredSize(bounds.getSize());
            errLbl.setSize(bounds.getSize());
            errLbl.setBounds(bounds);
            errLbl.paint(g);
        }
    }
}

