/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.JComboBoxUnits;
import org.gvsig.app.gui.panels.ImageSizePanel;
import org.gvsig.app.gui.styling.JComboBoxUnitsReferenceSystem;
import org.gvsig.app.gui.styling.SelectorFilter;
import org.gvsig.app.gui.styling.StyleEditor;
import org.gvsig.app.gui.styling.StyleLibrary;
import org.gvsig.app.gui.styling.StylePreviewer;
import org.gvsig.app.gui.styling.StyleSelectorListModel;
import org.gvsig.app.gui.styling.SymbolPreviewer;
import org.gvsig.app.gui.styling.SymbolSelector;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.ILabelStyle;
import org.gvsig.fmap.mapcontext.rendering.symbols.styles.IStyle;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.gui.beans.controls.dnd.JDnDList;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleSelector
extends SymbolSelector {
    private static final Logger logger = LoggerFactory.getLogger(StyleSelector.class);
    private static final long serialVersionUID = -7476555713446755512L;
    private ImageSizePanel isp;

    public StyleSelector(IStyle style, int shapeType) throws IllegalArgumentException {
        this(style, shapeType, new SelectorFilter(){

            @Override
            public boolean accepts(Object obj) {
                return obj instanceof IStyle;
            }
        });
    }

    public StyleSelector(IStyle style, int shapeType, SelectorFilter filter) throws IllegalArgumentException {
        super(null, shapeType, filter, false);
        this.rootDir = new File(MapContextLocator.getSymbolManager().getSymbolPreferences().getSymbolLibraryPath());
        if (!this.rootDir.exists()) {
            this.rootDir.mkdir();
        }
        this.initialize(style);
        this.lblTitle.setText(Messages.getText((String)"label_styles"));
        this.treeRootName = Messages.getText((String)"style_library");
    }

    @Override
    protected void initialize(Object currentElement) throws IllegalArgumentException {
        this.library = new StyleLibrary(this.rootDir);
        this.setLayout(new BorderLayout());
        this.setSize(400, 221);
        this.add((Component)this.getJNorthPanel(), "North");
        this.add((Component)this.getJSplitPane(), "Center");
        this.add((Component)this.getJEastPanel(), "East");
        ActionListener okAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleSelector.this.accepted = true;
                PluginServices.getMDIManager().closeWindow((IWindow)StyleSelector.this);
            }
        };
        ActionListener cancelAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleSelector.this.setSymbol(null);
                PluginServices.getMDIManager().closeWindow((IWindow)StyleSelector.this);
            }
        };
        this.okCancelPanel = new AcceptCancelPanel();
        this.okCancelPanel.setOkButtonActionListener(okAction);
        this.okCancelPanel.setCancelButtonActionListener(cancelAction);
        this.add((Component)this.okCancelPanel, "South");
        this.libraryBrowser.setSelectionRow(0);
        SymbolSelector.SillyDragNDropAction dndAction = new SymbolSelector.SillyDragNDropAction();
        this.libraryBrowser.addMouseListener(dndAction);
        this.libraryBrowser.addMouseMotionListener(dndAction);
        this.getJListSymbols().addMouseListener(dndAction);
        this.getJListSymbols().addMouseMotionListener(dndAction);
        this.setSymbol(currentElement);
    }

    @Override
    public void setSymbol(Object style) {
        ((StylePreviewer)this.jPanelPreview).setStyle((IStyle)style);
        this.updateOptionsPanel();
    }

    @Override
    public Object getSelectedObject() {
        if (!this.accepted) {
            return null;
        }
        IStyle mySelectedElement = ((StylePreviewer)this.jPanelPreview).getStyle();
        if (mySelectedElement instanceof CartographicSupport) {
            CartographicSupport csSym = (CartographicSupport)mySelectedElement;
            csSym.setUnit(this.cmbUnits.getSelectedUnitIndex());
            csSym.setReferenceSystem(this.cmbReferenceSystem.getSelectedIndex());
        }
        return mySelectedElement;
    }

    @Override
    protected ListModel newListModel() {
        StyleSelectorListModel listModel = new StyleSelectorListModel(this.dir, this.sFilter, ".gvssty");
        return listModel;
    }

    @Override
    protected JPanel getJPanelOptions() {
        if (this.jPanelOptions == null) {
            this.jPanelOptions = new GridBagLayoutPanel();
            this.jPanelOptions.setBorder((Border)BorderFactory.createTitledBorder(null, Messages.getText((String)"options")));
            this.jPanelOptions.addComponent((Component)this.getImageSizePanel());
            this.cmbUnits = new JComboBoxUnits(true);
            this.jPanelOptions.addComponent(Messages.getText((String)"units"), (Component)this.cmbUnits);
            this.cmbReferenceSystem = new JComboBoxUnitsReferenceSystem();
            this.jPanelOptions.addComponent("", (Component)this.cmbReferenceSystem);
        }
        return this.jPanelOptions;
    }

    private ImageSizePanel getImageSizePanel() {
        if (this.isp == null) {
            this.isp = new ImageSizePanel();
            this.isp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ILabelStyle st = (ILabelStyle)StyleSelector.this.getSelectedObject();
                    if (st != null) {
                        double[] sz = StyleSelector.this.isp.getImageDimension();
                        st.setSize(sz[0], sz[1]);
                    }
                }
            });
        }
        return this.isp;
    }

    @Override
    protected void updateOptionsPanel() {
        IStyle s = ((StylePreviewer)this.jPanelPreview).getStyle();
        if (s instanceof ILabelStyle) {
            ILabelStyle lab = (ILabelStyle)s;
            Dimension sz = lab.getSize();
            this.getImageSizePanel().setImageSize(sz);
        }
    }

    @Override
    protected JList getJListSymbols() {
        if (this.jListSymbols == null) {
            this.jListSymbols = new JDnDList();
            this.jListSymbols.setSelectionMode(0);
            this.jListSymbols.setLayoutOrientation(2);
            this.jListSymbols.setVisibleRowCount(-1);
            this.jListSymbols.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    StyleSelector.this.setStyle(StyleSelector.this.jListSymbols.getSelectedValue());
                    StyleSelector.this.updateOptionsPanel();
                }
            });
            ListCellRenderer renderer = new ListCellRenderer(){
                private Color mySelectedBGColor = new Color(255, 145, 100, 255);

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    IStyle sty = (IStyle)value;
                    JPanel pnl = new JPanel();
                    BoxLayout layout = new BoxLayout(pnl, 1);
                    pnl.setLayout(layout);
                    Color bgColor = isSelected ? this.mySelectedBGColor : StyleSelector.this.getJListSymbols().getBackground();
                    pnl.setBackground(bgColor);
                    StylePreviewer sp = new StylePreviewer(StyleSelector.this.getSampleFeature());
                    sp.setShowOutline(false);
                    sp.setAlignmentX(0.5f);
                    sp.setPreferredSize(new Dimension(50, 50));
                    sp.setStyle(sty);
                    sp.setBackground(bgColor);
                    pnl.add(sp);
                    JLabel lbl = new JLabel(sty.getDescription());
                    lbl.setBackground(bgColor);
                    lbl.setAlignmentX(0.5f);
                    pnl.add(lbl);
                    return pnl;
                }
            };
            this.jListSymbols.setCellRenderer(renderer);
        }
        return this.jListSymbols;
    }

    protected void setStyle(Object selectedValue) {
        ((StylePreviewer)this.jPanelPreview).setStyle((IStyle)selectedValue);
        this.doLayout();
        this.repaint();
    }

    @Override
    protected void propertiesPressed() {
        StyleEditor se = new StyleEditor((IStyle)this.getSelectedObject());
        PluginServices.getMDIManager().addWindow((IWindow)se);
        this.setStyle(se.getStyle());
    }

    @Override
    protected void savePressed() {
        if (this.getSelectedObject() == null) {
            return;
        }
        JFileChooser jfc = new JFileChooser(this.rootDir);
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getAbsolutePath().toLowerCase().endsWith(".gvssty");
            }

            @Override
            public String getDescription() {
                return Messages.getText((String)"gvSIG_style_definition_file") + " (" + ".gvssty" + ")";
            }
        };
        jfc.setFileFilter(ff);
        JPanel accessory = new JPanel(new FlowLayout(3, 5, 5));
        accessory.add(new JLabel(Messages.getText((String)"enter_description")));
        JTextField txtDesc = new JTextField(25);
        txtDesc.setText(((IStyle)this.getSelectedObject()).getDescription());
        accessory.add(txtDesc);
        jfc.setAccessory(accessory);
        if (jfc.showSaveDialog(this) == 0) {
            int resp;
            String desc;
            String s;
            File targetFile = jfc.getSelectedFile();
            String fExtension = ".gvssty";
            if (txtDesc.getText() == null || txtDesc.getText().trim().equals("")) {
                s = targetFile.getAbsolutePath();
                desc = s.substring(s.lastIndexOf(File.separator) + 1).replaceAll(fExtension, "");
            } else {
                desc = txtDesc.getText().trim();
            }
            s = (IStyle)this.getSelectedObject();
            s.setDescription(desc);
            if (!targetFile.getAbsolutePath().toLowerCase().endsWith(fExtension)) {
                targetFile = new File(targetFile.getAbsolutePath() + fExtension);
            }
            if (targetFile.exists() && (resp = JOptionPane.showConfirmDialog((Component)PluginServices.getMainFrame(), Messages.getText((String)"fichero_ya_existe_seguro_desea_guardarlo"), Messages.getText((String)"guardar"), 0)) != 0) {
                return;
            }
            try {
                PersistenceManager pman = ToolsLocator.getPersistenceManager();
                PersistentState psta = pman.getState((Object)s, true);
                if (psta.getContext().getErrors() != null) {
                    throw psta.getContext().getErrors();
                }
                FileOutputStream fos = new FileOutputStream(targetFile);
                pman.saveState(psta, (OutputStream)fos);
                fos.close();
            }
            catch (Exception ex) {
                NotificationManager.addError((String)Messages.getText((String)"save_error"), (Throwable)ex);
            }
            this.getJListSymbols().setModel(this.newListModel());
        }
    }

    @Override
    protected void newPressed() {
        IStyle curr_sty = ((StylePreviewer)this.jPanelPreview).getStyle();
        if (curr_sty != null) {
            try {
                curr_sty = (IStyle)curr_sty.clone();
            }
            catch (Exception cnse) {
                logger.info("Unable to clone style. Creating a new empty SimpleLabelStyle...", (Throwable)cnse);
                curr_sty = SymbologyLocator.getSymbologyManager().createDefaultLabelStyle();
            }
        } else {
            curr_sty = SymbologyLocator.getSymbologyManager().createDefaultLabelStyle();
        }
        StyleEditor se = new StyleEditor(curr_sty);
        PluginServices.getMDIManager().addWindow((IWindow)se);
        this.setStyle(se.getStyle());
    }

    @Override
    protected SymbolPreviewer getJPanelPreview() {
        if (this.jPanelPreview == null) {
            this.jPanelPreview = new StylePreviewer(this.getSampleFeature());
            this.jPanelPreview.setPreferredSize(new Dimension(100, 100));
            this.jPanelPreview.setBorder(BorderFactory.createBevelBorder(1));
            ((StylePreviewer)this.jPanelPreview).setShowOutline(true);
        }
        return this.jPanelPreview;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.act) {
            return;
        }
        IStyle selectedElement = ((StylePreviewer)this.jPanelPreview).getStyle();
        this.performActionOn(selectedElement, e);
        this.repaint();
    }

    public int getUnit() {
        return this.cmbUnits.getSelectedUnitIndex();
    }

    public int getReferenceSystem() {
        return this.cmbReferenceSystem.getSelectedIndex();
    }

    public void setUnit(int unit) {
        this.cmbUnits.setSelectedUnitIndex(unit);
    }

    public void setReferenceSystem(int referenceSystem) {
        this.cmbReferenceSystem.setSelectedIndex(referenceSystem);
    }
}

