/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FileUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.app.gui.styling.ILibraryModel;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolException;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolPreferences;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentContext;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.spi.PersistentContextServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolLibrary
extends DefaultTreeModel
implements ILibraryModel {
    private static Logger logger = LoggerFactory.getLogger(SymbolLibrary.class);
    private static final long serialVersionUID = 6802576248214649793L;
    protected static String rootDirString;
    private File rootDir;
    private Vector<TreeModelListener> listeners = new Vector();
    private static SymbolLibrary instance;
    private SymbolManager manager;
    private FileFilter ff = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };

    public static SymbolLibrary getInstance() {
        SymbolPreferences preferences = SymbolLibrary.getPreferences();
        if (instance == null || !preferences.getSymbolLibraryPath().equals(rootDirString)) {
            rootDirString = preferences.getSymbolLibraryPath();
            instance = new SymbolLibrary(new File(rootDirString));
        }
        return instance;
    }

    private static SymbolPreferences getPreferences() {
        return MapContextLocator.getSymbolManager().getSymbolPreferences();
    }

    protected SymbolLibrary(File rootDir) {
        super(new DefaultMutableTreeNode(rootDir));
        rootDirString = Messages.getText((String)"symbol_library");
        this.rootDir = rootDir;
        this.manager = MapContextLocator.getSymbolManager();
    }

    @Override
    public Object getRoot() {
        return new DefaultMutableTreeNode(new MyFile(this.rootDir.getAbsolutePath()));
    }

    private File[] listFiles(File f, FileFilter ff) {
        File[] files = null;
        files = ff == null ? f.listFiles() : f.listFiles(ff);
        if (files != null) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        return files;
    }

    private File[] listFiles(File f) {
        return this.listFiles(f, null);
    }

    private int countFiles(File f, FileFilter ff) {
        File[] files = f.listFiles(ff);
        return files == null ? 0 : files.length;
    }

    @Override
    public int getChildCount(Object parent) {
        File f = null;
        f = parent instanceof DefaultMutableTreeNode ? (File)((DefaultMutableTreeNode)parent).getUserObject() : (File)parent;
        return this.countFiles(f, this.ff);
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public Object getChild(Object parent, int index) {
        File file = this.listFiles((File)((DefaultMutableTreeNode)parent).getUserObject(), this.ff)[index];
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new MyFile(file.getAbsolutePath()));
        node.setParent((DefaultMutableTreeNode)parent);
        return node;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null) {
            return -1;
        }
        File[] files = this.listFiles((File)((DefaultMutableTreeNode)parent).getUserObject(), this.ff);
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].equals(child)) continue;
            return i;
        }
        return -1;
    }

    private Object getChildFile(Object parent, int index) {
        File file = this.listFiles((File)((DefaultMutableTreeNode)parent).getUserObject())[index];
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new MyFile(file.getAbsolutePath()));
        node.setParent((DefaultMutableTreeNode)parent);
        return node;
    }

    private int getIndexOfChildFiles(Object parent, Object child) {
        if (parent == null) {
            return -1;
        }
        File[] files = this.listFiles((File)((DefaultMutableTreeNode)parent).getUserObject());
        for (int i = 0; files != null && i < files.length; ++i) {
            if (!files[i].getName().equals(child)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getElement(Object containerFolder, String elementName) {
        int index;
        if (containerFolder instanceof File) {
            containerFolder = new DefaultMutableTreeNode(containerFolder);
        }
        if ((index = this.getIndexOfChildFiles(containerFolder, elementName)) != -1) {
            return this.getChildFile(containerFolder, index);
        }
        for (int i = 0; i < this.getChildCount(containerFolder); ++i) {
            Object o = this.getElement(this.getChildFile(containerFolder, i), elementName);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public void addElement(Object element, String elementName, Object containerFolder) {
        if (element instanceof ISymbol) {
            int resp;
            File targetFile;
            ISymbol sym = (ISymbol)element;
            File folder = containerFolder == null ? this.rootDir : (File)containerFolder;
            try {
                sym = (ISymbol)SymbolLibrary.copyFilesToFolder(sym, folder, new HashMap());
            }
            catch (Exception exc) {
                logger.info("Error while copying symbol files.", (Throwable)exc);
                return;
            }
            String fExtension = SymbolLibrary.getPreferences().getSymbolFileExtension();
            if (!elementName.toLowerCase().endsWith(fExtension)) {
                elementName = elementName.concat(fExtension);
            }
            if ((targetFile = new File(folder, elementName)).exists() && (resp = JOptionPane.showConfirmDialog((Component)PluginServices.getMainFrame(), Messages.getText((String)"fichero_ya_existe_seguro_desea_guardarlo"), Messages.getText((String)"guardar"), 0)) != 0) {
                return;
            }
            try {
                MapContextLocator.getSymbolManager().saveSymbol(sym, elementName, folder, true);
            }
            catch (SymbolException e) {
                NotificationManager.addError((String)Messages.getText((String)"save_error"), (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException(Messages.getText((String)"adding_a_non_symbol_as_element"));
        }
    }

    @Override
    public void addFolder(Object parentFolder, String folderName) {
        if (parentFolder == null) {
            parentFolder = this.rootDir;
        }
        try {
            File fParentFolder = (File)((DefaultMutableTreeNode)parentFolder).getUserObject();
            File f = new File(fParentFolder.getAbsolutePath() + File.separator + folderName);
            if (!f.exists()) {
                f.mkdir();
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).treeNodesInserted(null);
            }
        }
        catch (ConcurrentModificationException cme) {
            cme.printStackTrace();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(Messages.getText((String)"invalid_folder_name"), e);
        }
    }

    @Override
    public void removeElement(Object element, Object containerFolder) {
        try {
            File fParentFolder = (File)containerFolder;
            File f = new File(fParentFolder.getAbsolutePath() + File.separator + (String)element);
            if (f.exists()) {
                this.deleteRecursively(f);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(Messages.getText((String)"invalid_folder_name"));
        }
    }

    private void deleteRecursively(File f) {
        if (f.isDirectory()) {
            FileUtils.deleteQuietly((File)f);
        }
        f.delete();
    }

    @Override
    public void removeFolder(Object folderToRemove) {
        try {
            File f = (File)folderToRemove;
            TreePath tp = this.treePathNode(f, this.rootDir);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(Messages.getText((String)"invalid_folder_name"));
        }
    }

    private TreePath treePathNode(File f, File startingNode) {
        for (int i = 0; i < this.getChildCount(startingNode); ++i) {
            File child = (File)this.getChild(startingNode, i);
            TreePath tp = this.treePathNode(f, child);
            if (tp == null) continue;
            if (startingNode != this.rootDir) {
                tp = tp.pathByAddingChild(startingNode);
            }
            return tp;
        }
        if (f.equals(startingNode)) {
            return new TreePath(f);
        }
        return null;
    }

    private void fireTreeNodesRemoved(TreePath removedObjectTreePath) {
        TreeModelEvent e = new TreeModelEvent((Object)this, removedObjectTreePath);
        Iterator<TreeModelListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().treeNodesRemoved(e);
        }
    }

    private static Object copyFilesToFolder(Object sym, File theFolder, Map processedFilesMap) throws Exception {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        PersistentState state = null;
        state = manager.getState(sym, true);
        PersistentContext context = state.getContext();
        List<PersistentState> states_list = SymbolLibrary.getList(context);
        int len = states_list.size();
        for (int i = 0; i < len; ++i) {
            PersistentState aState = states_list.get(i);
            DynStruct definition = aState.getDefinition();
            DynField[] fields = definition.getDynFields();
            File value_file = null;
            File value_file_new = null;
            URL value_url = null;
            URI value_uri = null;
            File donefile = null;
            Object value_obj = null;
            Object value_obj_new = null;
            for (DynField field : fields) {
                if (field.getType() == 13) {
                    value_file = aState.getFile(field.getName());
                    donefile = (File)processedFilesMap.get(value_file);
                    if (donefile == null) {
                        value_file_new = SymbolLibrary.copyFile(value_file, theFolder);
                        aState.set(field.getName(), value_file_new);
                        processedFilesMap.put(value_file, value_file_new);
                        continue;
                    }
                    aState.set(field.getName(), donefile);
                    continue;
                }
                if (field.getType() == 16) {
                    value_url = aState.getURL(field.getName());
                    if (!"FILE".equalsIgnoreCase(value_url.getProtocol())) continue;
                    File urlfile = FileUtils.toFile((URL)value_url);
                    donefile = (File)processedFilesMap.get(urlfile);
                    if (donefile == null) {
                        value_file_new = SymbolLibrary.copyFile(urlfile, theFolder);
                        value_url = value_file_new.toURI().toURL();
                        aState.set(field.getName(), value_url);
                        processedFilesMap.put(urlfile, value_file_new);
                        continue;
                    }
                    value_url = donefile.toURI().toURL();
                    aState.set(field.getName(), value_url);
                    continue;
                }
                if (field.getType() != 17 || (value_uri = aState.getURI(field.getName())).getScheme() != null && !"FILE".equalsIgnoreCase(value_uri.getScheme())) continue;
                File urifile = FileUtils.toFile((URL)value_uri.toURL());
                donefile = (File)processedFilesMap.get(urifile);
                if (donefile == null) {
                    value_file_new = SymbolLibrary.copyFile(urifile, theFolder);
                    value_uri = value_file_new.toURI();
                    aState.set(field.getName(), value_uri);
                    processedFilesMap.put(urifile, value_file_new);
                    continue;
                }
                value_uri = donefile.toURI();
                aState.set(field.getName(), value_uri);
            }
        }
        if (context instanceof PersistentContextServices) {
            ((PersistentContextServices)context).clear();
        }
        Object resp = manager.create(state);
        return resp;
    }

    private static List<PersistentState> getList(PersistentContext context) {
        Iterator iter = context.iterator();
        ArrayList<PersistentState> resp = new ArrayList<PersistentState>();
        while (iter.hasNext()) {
            resp.add((PersistentState)iter.next());
        }
        return resp;
    }

    private static File copyFile(File srcfile, File dstfolder) throws IOException {
        if (!(srcfile != null && dstfolder != null && srcfile.isFile() && dstfolder.isDirectory() && srcfile.exists())) {
            throw new IOException("Bad parameters in copyFile method (src='" + srcfile + "', target='" + dstfolder + "').");
        }
        if (srcfile.getParentFile().equals(dstfolder)) {
            return srcfile;
        }
        if (!dstfolder.exists()) {
            dstfolder.mkdirs();
        }
        String checkfile = dstfolder.getCanonicalPath() + File.separator + srcfile.getName();
        File aux = new File(checkfile);
        File targetFile = null;
        targetFile = aux.exists() ? SymbolLibrary.getAvailableFileName(dstfolder, srcfile.getName()) : aux;
        FileUtils.copyFile((File)srcfile, (File)targetFile);
        return targetFile;
    }

    private static File getAvailableFileName(File dstfolder, String name) throws IOException {
        int index = -1;
        boolean exists = true;
        String tryname = null;
        String checkfile = null;
        File tryfile = null;
        while (exists) {
            tryname = "" + ++index + "_" + name;
            checkfile = dstfolder.getCanonicalPath() + File.separator + tryname;
            tryfile = new File(checkfile);
            exists = tryfile.exists();
        }
        return tryfile;
    }

    static {
        instance = null;
    }

    final class MyFile
    extends File {
        private static final long serialVersionUID = 6332989815291224773L;

        public MyFile(String pathname) {
            super(pathname);
        }

        @Override
        public String toString() {
            String path = this.getAbsolutePath();
            if (path.equals(SymbolLibrary.this.rootDir.getAbsolutePath())) {
                return rootDirString;
            }
            return path.substring(path.lastIndexOf(File.separator) + 1, path.length());
        }
    }
}

