/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.styling;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.JComboBoxUnits;
import org.gvsig.app.gui.panels.ColorChooserPanel;
import org.gvsig.app.gui.styling.ILibraryModel;
import org.gvsig.app.gui.styling.JComboBoxUnitsReferenceSystem;
import org.gvsig.app.gui.styling.LibraryBrowser;
import org.gvsig.app.gui.styling.MultiShapeSymbolSelector;
import org.gvsig.app.gui.styling.SelectorFilter;
import org.gvsig.app.gui.styling.SymbolEditor;
import org.gvsig.app.gui.styling.SymbolLibrary;
import org.gvsig.app.gui.styling.SymbolPreviewer;
import org.gvsig.app.gui.styling.SymbolSelectorListModel;
import org.gvsig.app.project.documents.view.legend.gui.ISymbolSelector;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.fmap.mapcontext.rendering.symbols.ITextSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolPreferences;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.gui.beans.swing.JComboBoxFontSizes;
import org.gvsig.gui.beans.swing.JComboBoxFonts;
import org.gvsig.gui.beans.swing.JFileChooser;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IMultiLayerFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.IMultiLayerLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMultiLayerMarkerSymbol;
import org.gvsig.tools.dispose.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SymbolSelector
extends JPanel
implements ISymbolSelector,
ActionListener {
    private static final long serialVersionUID = -6405660392303659551L;
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(SymbolSelector.class);
    private JPanel jPanel = null;
    protected JScrollPane jScrollPane = null;
    private JScrollPane jScrollPane1 = null;
    private WindowInfo wi;
    private JSplitPane jSplitPane = null;
    protected AcceptCancelPanel okCancelPanel;
    private JPanel northPanel;
    private ColorChooserPanel jcc1;
    private ColorChooserPanel jcc2;
    private JNumberSpinner txtSize;
    private JNumberSpinner txtAngle;
    private JPanel jPanelButtons;
    private JButton btnProperties;
    private GeometryType shapeType;
    private JButton btnSaveSymbol;
    private JButton btnResetSymbol;
    private JButton btnNewSymbol;
    private JComboBoxFonts cmbFonts;
    private JToggleButton btnBold;
    private JToggleButton btnItalic;
    private JToggleButton btnUnderlined;
    protected JLabel lblTitle;
    protected File dir;
    protected File rootDir;
    protected SymbolPreviewer jPanelPreview = null;
    protected GridBagLayoutPanel jPanelOptions = null;
    protected JList jListSymbols = null;
    protected String treeRootName;
    protected ILibraryModel library;
    private JNumberSpinner txtWidth;
    protected boolean act = true;
    boolean accepted = true;
    private SymbolManager manager;
    private transient MutableObject<Feature> sampleFeature;
    protected SelectorFilter sFilter = new SelectorFilter(){
        private Geometry dummyPointGeom = null;
        private Geometry dummyLineGeom = null;
        private Geometry dummyPolygonGeom = null;
        private boolean isInitialized = false;

        @Override
        public boolean accepts(Object obj) {
            if (!this.isInitialized) {
                try {
                    this.dummyPointGeom = geomManager.createPoint(0.0, 0.0, 0);
                    this.dummyLineGeom = geomManager.createLine(0);
                    this.dummyPolygonGeom = geomManager.createPolygon(0);
                }
                catch (CreateGeometryException e) {
                    logger.error("Error creating a geometry", (Throwable)e);
                }
                this.isInitialized = true;
            }
            if (obj instanceof ISymbol) {
                ISymbol sym = (ISymbol)obj;
                Geometry compareGeometry = null;
                if (SymbolSelector.this.shapeType.isTypeOf(1) || SymbolSelector.this.shapeType.isTypeOf(7)) {
                    compareGeometry = this.dummyPointGeom;
                } else if (SymbolSelector.this.shapeType.isTypeOf(2) || SymbolSelector.this.shapeType.isTypeOf(8)) {
                    compareGeometry = this.dummyLineGeom;
                } else if (SymbolSelector.this.shapeType.isTypeOf(3) || SymbolSelector.this.shapeType.isTypeOf(9)) {
                    compareGeometry = this.dummyPolygonGeom;
                }
                if (compareGeometry != null) {
                    return sym.isSuitableFor(compareGeometry);
                }
            }
            return false;
        }
    };
    protected JComboBoxUnits cmbUnits;
    protected JComboBoxUnitsReferenceSystem cmbReferenceSystem;
    private JComboBoxFontSizes cmbFontSize;
    protected LibraryBrowser libraryBrowser;
    private SymbolSelectorListModel listModel;
    private FeatureStore featureStore;

    private void initialize(Object currentElement, GeometryType shapeType, boolean initialize) throws IllegalArgumentException {
        this.manager = MapContextLocator.getSymbolManager();
        if (currentElement != null && currentElement instanceof ISymbol) {
            ISymbol sym = (ISymbol)currentElement;
            try {
                currentElement = sym.clone();
            }
            catch (CloneNotSupportedException e) {
                NotificationManager.addWarning((String)"Symbol layer", (Throwable)e);
            }
            String string = sym.getDescription();
        }
        this.shapeType = shapeType;
        this.rootDir = new File(this.manager.getSymbolPreferences().getSymbolLibraryPath());
        if (!this.rootDir.exists()) {
            this.rootDir.mkdir();
        }
        this.treeRootName = Messages.getText((String)"symbol_library");
        if (initialize) {
            this.initialize(currentElement);
        }
    }

    protected SymbolSelector(Object symbol, GeometryType shapeType, SelectorFilter filter, boolean initialize) throws IllegalArgumentException {
        this.initialize(symbol, shapeType, initialize);
        this.sFilter = filter;
    }

    protected SymbolSelector(Object symbol, GeometryType shapeType, boolean initialize) throws IllegalArgumentException {
        this.initialize(symbol, shapeType, initialize);
    }

    protected SymbolSelector(Object symbol, int shapeType, SelectorFilter filter, boolean initialize) throws IllegalArgumentException {
        try {
            GeometryType geometryType = geomManager.getGeometryType(shapeType, 0);
            this.initialize(symbol, geometryType, initialize);
        }
        catch (Exception e1) {
            logger.error("Impossible to get the geometry type", (Throwable)e1);
        }
        this.sFilter = filter;
    }

    protected void initialize(Object currentElement) throws IllegalArgumentException {
        this.library = new SymbolLibrary(this.rootDir);
        this.setLayout(new BorderLayout());
        this.setSize(400, 221);
        this.add((Component)this.getJNorthPanel(), "North");
        this.add((Component)this.getJSplitPane(), "Center");
        this.add((Component)this.getJEastPanel(), "East");
        ActionListener okAction = e -> {
            if (this.listModel != null) {
                this.listModel.dispose();
            }
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        };
        ActionListener cancelAction = e -> {
            this.accepted = false;
            this.setSymbol(null);
            if (this.listModel != null) {
                this.listModel.dispose();
            }
            PluginServices.getMDIManager().closeWindow((IWindow)this);
        };
        this.okCancelPanel = new AcceptCancelPanel();
        this.okCancelPanel.setOkButtonActionListener(okAction);
        this.okCancelPanel.setCancelButtonActionListener(cancelAction);
        this.add((Component)this.okCancelPanel, "South");
        this.libraryBrowser.setSelectionRow(0);
        SillyDragNDropAction dndAction = new SillyDragNDropAction();
        this.libraryBrowser.addMouseListener(dndAction);
        this.libraryBrowser.addMouseMotionListener(dndAction);
        this.getJListSymbols().addMouseListener(dndAction);
        this.getJListSymbols().addMouseMotionListener(dndAction);
        this.setSymbol(currentElement);
    }

    protected ListModel newListModel() {
        this.listModel = new SymbolSelectorListModel(this.dir, this.sFilter, this.manager.getSymbolPreferences().getSymbolFileExtension());
        return this.listModel;
    }

    protected JPanel getJNorthPanel() throws IllegalArgumentException {
        if (this.northPanel == null) {
            String text = "";
            if (this.shapeType.isTypeOf(1) || this.shapeType.isTypeOf(7)) {
                text = Messages.getText((String)"point_symbols");
            } else if (this.shapeType.isTypeOf(2) || this.shapeType.isTypeOf(8)) {
                text = Messages.getText((String)"line_symbols");
            } else if (this.shapeType.isTypeOf(3) || this.shapeType.isTypeOf(9)) {
                text = Messages.getText((String)"polygon_symbols");
            } else {
                throw new IllegalArgumentException(Messages.getText((String)"shape_type_not_yet_supported"));
            }
            this.northPanel = new JPanel(new FlowLayout(3));
            this.lblTitle = new JLabel(text);
            this.lblTitle.setFont(this.lblTitle.getFont().deriveFont(1));
            this.northPanel.add(this.lblTitle);
        }
        return this.northPanel;
    }

    protected JList getJListSymbols() {
        if (this.jListSymbols == null) {
            this.jListSymbols = new JList();
            this.jListSymbols.setSelectionMode(0);
            this.jListSymbols.setLayoutOrientation(2);
            this.jListSymbols.setVisibleRowCount(-1);
            this.jListSymbols.addListSelectionListener(e -> {
                if (this.jListSymbols.getSelectedValue() != null) {
                    ISymbol selSym = null;
                    try {
                        selSym = (ISymbol)((ISymbol)this.jListSymbols.getSelectedValue()).clone();
                    }
                    catch (CloneNotSupportedException ex) {
                        NotificationManager.addWarning((String)"Symbol layer", (Throwable)ex);
                    }
                    this.setSymbol(selSym);
                    this.updateOptionsPanel();
                }
            });
            ListCellRenderer renderer = new ListCellRenderer(){
                private final Color mySelectedBGColor = new Color(255, 145, 100, 255);

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    ISymbol sym = (ISymbol)value;
                    JPanel pnl = new JPanel();
                    BoxLayout layout = new BoxLayout(pnl, 1);
                    pnl.setLayout(layout);
                    Color bgColor = isSelected ? this.mySelectedBGColor : SymbolSelector.this.getJListSymbols().getBackground();
                    pnl.setBackground(bgColor);
                    SymbolPreviewer sp = new SymbolPreviewer(SymbolSelector.this.getSampleFeature(), true);
                    sp.setAlignmentX(0.5f);
                    sp.setPreferredSize(new Dimension(50, 50));
                    sp.setSymbol(sym);
                    sp.setBackground(bgColor);
                    pnl.add(sp);
                    String desc = sym.getDescription();
                    if (desc == null) {
                        desc = "[" + Messages.getText((String)"no_desc") + "]";
                    }
                    JLabel lbl = new JLabel(desc);
                    lbl.setBackground(bgColor);
                    lbl.setAlignmentX(0.5f);
                    pnl.add(lbl);
                    return pnl;
                }
            };
            this.jListSymbols.setCellRenderer(renderer);
        }
        return this.jListSymbols;
    }

    protected void updateOptionsPanel() throws IllegalArgumentException {
        ISymbol mySelectedElement = this.jPanelPreview.getSymbol();
        this.act = false;
        if (mySelectedElement instanceof CartographicSupport) {
            CartographicSupport cs = (CartographicSupport)mySelectedElement;
            this.cmbUnits.setSelectedUnitIndex(cs.getUnit());
            this.cmbReferenceSystem.setSelectedIndex(cs.getReferenceSystem());
        }
        if (mySelectedElement instanceof IMultiLayerSymbol && ((IMultiLayerSymbol)mySelectedElement).getLayerCount() == 1) {
            mySelectedElement = ((IMultiLayerSymbol)mySelectedElement).getLayer(0);
        }
        try {
            this.jcc1.setEnabled(mySelectedElement != null);
            this.jcc2.setEnabled(mySelectedElement != null);
            if (mySelectedElement instanceof IMultiLayerSymbol) {
                this.jcc1.setColor(Color.WHITE);
                this.jcc2.setColor(Color.WHITE);
                this.jcc1.setEnabled(false);
                this.jcc2.setEnabled(false);
            }
            if (this.shapeType.isTypeOf(1) || this.shapeType.isTypeOf(7)) {
                IMarkerSymbol m = (IMarkerSymbol)mySelectedElement;
                this.txtSize.setEnabled(m != null);
                this.txtAngle.setEnabled(m != null);
                if (m != null) {
                    this.jcc1.setColor(m.getColor());
                    this.txtSize.setDouble(m.getSize());
                    this.txtAngle.setDouble(Math.toDegrees(m.getRotation()));
                }
            }
            if (this.shapeType.isTypeOf(2) || this.shapeType.isTypeOf(8)) {
                ILineSymbol l = (ILineSymbol)mySelectedElement;
                this.txtSize.setEnabled(l != null);
                if (l != null) {
                    this.jcc1.setColor(l.getColor());
                    this.jcc1.setAlpha(l.getAlpha());
                    this.txtSize.setDouble(l.getLineWidth());
                }
            }
            if (this.shapeType.isTypeOf(3) || this.shapeType.isTypeOf(9)) {
                IFillSymbol f = (IFillSymbol)mySelectedElement;
                this.txtWidth.setEnabled(f != null);
                this.cmbReferenceSystem.setEnabled(f != null);
                this.cmbUnits.setEnabled(f != null);
                if (f != null) {
                    this.jcc1.setUseColorIsSelected(f.hasFill());
                    this.jcc1.setColor(f.getFillColor());
                    this.jcc1.setAlpha(f.getFillAlpha());
                    this.jcc2.setUseColorIsSelected(f.hasOutline());
                    ILineSymbol outline = f.getOutline();
                    if (outline != null) {
                        this.jcc2.setColor(outline.getColor());
                        this.jcc2.setAlpha(outline.getAlpha());
                        this.txtWidth.setDouble(outline.getLineWidth());
                    }
                    if (f instanceof IMultiLayerFillSymbol) {
                        this.txtWidth.setEnabled(false);
                        this.cmbReferenceSystem.setEnabled(false);
                        this.cmbUnits.setEnabled(false);
                    }
                }
            }
        }
        catch (Exception npEx) {
            throw new IllegalArgumentException(npEx);
        }
        this.act = true;
    }

    protected JPanel getJEastPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getJPanelOptions(), "Center");
            JPanel aux = new JPanel(new FlowLayout(1, 5, 5));
            aux.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"preview")));
            aux.add(this.getJPanelPreview());
            this.jPanel.add((Component)aux, "North");
            this.jPanel.add(this.getJPanelOptions());
            aux = new JPanel(new FlowLayout(2, 5, 5));
            aux.add(this.getJPanelButtons());
            this.jPanel.add((Component)aux, "South");
        }
        return this.jPanel;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            this.jPanelButtons = new JPanel();
            GridLayout layout = new GridLayout();
            layout.setColumns(1);
            layout.setVgap(5);
            this.jPanelButtons.add((Component)this.getBtnNewSymbol());
            this.jPanelButtons.add((Component)this.getBtnSaveSymbol());
            this.jPanelButtons.add((Component)this.getBtnResetSymbol());
            this.jPanelButtons.add((Component)this.getBtnProperties());
            layout.setRows(this.jPanelButtons.getComponentCount());
            this.jPanelButtons.setLayout(layout);
        }
        return this.jPanelButtons;
    }

    private JButton getBtnNewSymbol() {
        if (this.btnNewSymbol == null) {
            this.btnNewSymbol = new JButton();
            this.btnNewSymbol.setName("btnNewSymbol");
            this.btnNewSymbol.setText(Messages.getText((String)"new"));
            this.btnNewSymbol.addActionListener((ActionListener)this);
        }
        return this.btnNewSymbol;
    }

    private JButton getBtnResetSymbol() {
        if (this.btnResetSymbol == null) {
            this.btnResetSymbol = new JButton();
            this.btnResetSymbol.setName("btnResetSymbol");
            this.btnResetSymbol.setText(Messages.getText((String)"reset"));
            this.btnResetSymbol.addActionListener((ActionListener)this);
        }
        return this.btnResetSymbol;
    }

    private JButton getBtnSaveSymbol() {
        if (this.btnSaveSymbol == null) {
            this.btnSaveSymbol = new JButton();
            this.btnSaveSymbol.setName("btnSaveSymbol");
            this.btnSaveSymbol.setText(Messages.getText((String)"save"));
            this.btnSaveSymbol.addActionListener((ActionListener)this);
        }
        return this.btnSaveSymbol;
    }

    private JButton getBtnProperties() {
        if (this.btnProperties == null) {
            this.btnProperties = new JButton();
            this.btnProperties.setName("btnProperties");
            this.btnProperties.setText(Messages.getText((String)"properties"));
            this.btnProperties.addActionListener((ActionListener)this);
        }
        return this.btnProperties;
    }

    protected JScrollPane getLeftJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(80, 130));
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.libraryBrowser = new LibraryBrowser(this.library);
            this.libraryBrowser.addTreeSelectionListener(e -> {
                if (this.libraryBrowser.getLastSelectedPathComponent() == null) {
                    return;
                }
                this.dir = (File)((DefaultMutableTreeNode)this.libraryBrowser.getLastSelectedPathComponent()).getUserObject();
                if (this.dir == null) {
                    return;
                }
                ListModel model = this.jListSymbols.getModel();
                if (model != null && model instanceof Disposable) {
                    ((Disposable)model).dispose();
                }
                this.jListSymbols.setModel(this.newListModel());
            });
            this.jScrollPane.setViewportView(this.libraryBrowser);
        }
        return this.jScrollPane;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getJListSymbols());
        }
        return this.jScrollPane1;
    }

    protected SymbolPreviewer getJPanelPreview() {
        if (this.jPanelPreview == null) {
            this.jPanelPreview = new SymbolPreviewer(this.getSampleFeature());
            this.jPanelPreview.setPreferredSize(new Dimension(100, 100));
            this.jPanelPreview.setBorder(BorderFactory.createBevelBorder(1));
        }
        return this.jPanelPreview;
    }

    protected JPanel getJPanelOptions() {
        if (this.jPanelOptions == null) {
            this.jPanelOptions = new GridBagLayoutPanel();
            this.jPanelOptions.setBorder((Border)BorderFactory.createTitledBorder(null, Messages.getText((String)"options")));
            this.jcc2 = new ColorChooserPanel(true, true);
            this.jcc2.setAlpha(255);
            if (this.shapeType.isTypeOf(1) || this.shapeType.isTypeOf(7)) {
                this.jcc1 = new ColorChooserPanel(true);
                this.jPanelOptions.addComponent(Messages.getText((String)"Color") + ":", (Component)this.jcc1);
                this.txtSize = new JNumberSpinner(3.0, 3, 0.0, Double.MAX_VALUE, 1.0, 2);
                this.jPanelOptions.addComponent(Messages.getText((String)"size") + ":", (Component)this.txtSize);
                this.cmbUnits = new JComboBoxUnits();
                this.jPanelOptions.addComponent(Messages.getText((String)"units") + ":", (Component)this.cmbUnits);
                this.cmbReferenceSystem = new JComboBoxUnitsReferenceSystem();
                this.jPanelOptions.addComponent("", (Component)this.cmbReferenceSystem);
                this.txtAngle = new JNumberSpinner(0.0, 3, -180.0, 180.0, 1.0, 2);
                this.jPanelOptions.addComponent(Messages.getText((String)"angle") + " (" + Messages.getText((String)"degree") + "):", (Component)this.txtAngle);
            } else if (this.shapeType.isTypeOf(2) || this.shapeType.isTypeOf(8)) {
                this.jcc1 = new ColorChooserPanel(true);
                this.jPanelOptions.addComponent(Messages.getText((String)"Color") + ":", (Component)this.jcc1);
                this.txtSize = new JNumberSpinner(3.0, 3, 0.0, Double.MAX_VALUE, 1.0, 2);
                this.jPanelOptions.addComponent(Messages.getText((String)"width") + ":", (Component)this.txtSize);
                this.cmbUnits = new JComboBoxUnits();
                this.jPanelOptions.addComponent(Messages.getText((String)"units") + ":", (Component)this.cmbUnits);
                this.cmbReferenceSystem = new JComboBoxUnitsReferenceSystem();
                this.jPanelOptions.addComponent("", (Component)this.cmbReferenceSystem);
            } else if (this.shapeType.isTypeOf(3) || this.shapeType.isTypeOf(9)) {
                this.jcc1 = new ColorChooserPanel(true, true);
                this.jPanelOptions.addComponent(Messages.getText((String)"fill_color") + ":", (Component)this.jcc1);
                this.jPanelOptions.addComponent(Messages.getText((String)"outline_color") + ":", (Component)this.jcc2);
                this.txtWidth = new JNumberSpinner(3.0, 3, 0.0, Double.MAX_VALUE, 1.0, 2);
                this.jPanelOptions.addComponent(Messages.getText((String)"outline_width"), (Component)this.txtWidth);
                this.cmbUnits = new JComboBoxUnits();
                this.jPanelOptions.addComponent(Messages.getText((String)"units") + ":", (Component)this.cmbUnits);
                this.cmbReferenceSystem = new JComboBoxUnitsReferenceSystem();
                this.jPanelOptions.addComponent("", (Component)this.cmbReferenceSystem);
            }
            this.jcc1.setAlpha(255);
            if (this.txtSize != null) {
                this.txtSize.addActionListener((ActionListener)this);
            }
            if (this.cmbUnits != null) {
                this.cmbUnits.addActionListener((ActionListener)this);
            }
            if (this.cmbReferenceSystem != null) {
                this.cmbReferenceSystem.addActionListener(this);
            }
            if (this.jcc1 != null) {
                this.jcc1.addActionListener((ActionListener)this);
            }
            if (this.jcc2 != null) {
                this.jcc2.addActionListener((ActionListener)this);
            }
            if (this.txtWidth != null) {
                this.txtWidth.addActionListener((ActionListener)this);
            }
            if (this.cmbFontSize != null) {
                this.cmbFontSize.addActionListener((ActionListener)this);
            }
            if (this.txtAngle != null) {
                this.txtAngle.addActionListener((ActionListener)this);
            }
        }
        return this.jPanelOptions;
    }

    private JToggleButton getBtnUnderlined() {
        if (this.btnUnderlined == null) {
            this.btnUnderlined = new JToggleButton(PluginServices.getIconTheme().get("underline-icon"));
        }
        return this.btnUnderlined;
    }

    private JToggleButton getBtnItalic() {
        if (this.btnItalic == null) {
            this.btnItalic = new JToggleButton(PluginServices.getIconTheme().get("italic-icon"));
        }
        return this.btnItalic;
    }

    private JToggleButton getBtnBold() {
        if (this.btnBold == null) {
            this.btnBold = new JToggleButton(PluginServices.getIconTheme().get("bold-icon"));
        }
        return this.btnBold;
    }

    private JComboBoxFonts getCmbFonts() {
        if (this.cmbFonts == null) {
            this.cmbFonts = new JComboBoxFonts();
        }
        return this.cmbFonts;
    }

    public WindowInfo getWindowInfo() {
        if (this.wi == null) {
            this.wi = new WindowInfo(9);
            this.wi.setWidth(706);
            this.wi.setHeight(500);
            this.wi.setTitle(Messages.getText((String)"symbol_selector"));
        }
        return this.wi;
    }

    protected JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setDividerLocation(200);
            this.jSplitPane.setResizeWeight(0.4);
            this.jSplitPane.setLeftComponent(this.getLeftJScrollPane());
            this.jSplitPane.setRightComponent(this.getJScrollPane1());
        }
        return this.jSplitPane;
    }

    @Override
    public Object getSelectedObject() {
        if (!this.accepted) {
            return null;
        }
        ISymbol mySelectedElement = this.jPanelPreview.getSymbol();
        if (mySelectedElement instanceof IMultiLayerSymbol && ((IMultiLayerSymbol)mySelectedElement).getLayerCount() == 1) {
            return ((IMultiLayerSymbol)mySelectedElement).getLayer(0);
        }
        if (mySelectedElement instanceof CartographicSupport) {
            CartographicSupport csSym = (CartographicSupport)mySelectedElement;
            csSym.setUnit(this.cmbUnits.getSelectedUnitIndex());
            csSym.setReferenceSystem(this.cmbReferenceSystem.getSelectedIndex());
        }
        return mySelectedElement;
    }

    @Override
    public void setSymbol(Object symbol) {
        this.jPanelPreview.setSymbol((ISymbol)symbol);
        this.updateOptionsPanel();
    }

    protected void propertiesPressed() {
        IMultiLayerSymbol mSym;
        ISymbol mySelectedElement = this.jPanelPreview.getSymbol();
        if (mySelectedElement == null) {
            return;
        }
        ISymbol clonedSymbol = null;
        try {
            clonedSymbol = (ISymbol)mySelectedElement.clone();
        }
        catch (CloneNotSupportedException e) {
            NotificationManager.addWarning((String)"Symbol layer", (Throwable)e);
        }
        SymbolEditor se = new SymbolEditor(clonedSymbol, this.shapeType);
        se.setFeatureStore(this.featureStore);
        SwingUtilities.invokeLater(() -> se.refresh());
        PluginServices.getMDIManager().addWindow((IWindow)se);
        ISymbol symbol = se.getSymbol();
        if (symbol instanceof IMultiLayerSymbol && (mSym = (IMultiLayerSymbol)symbol).getLayerCount() == 1) {
            symbol = mSym.getLayer(0);
        }
        this.setSymbol(symbol);
    }

    protected void newPressed() {
        ISymbol curr_sym = this.jPanelPreview.getSymbol();
        if (curr_sym != null) {
            try {
                curr_sym = (ISymbol)curr_sym.clone();
            }
            catch (Exception cnse) {
                logger.info("Unable to clone symbol. This can cause an empty symbol if user cancels dialog.", (Throwable)cnse);
            }
        }
        SymbolEditor se = new SymbolEditor(curr_sym, this.shapeType);
        se.setFeatureStore(this.featureStore);
        PluginServices.getMDIManager().addWindow((IWindow)se);
        this.setSymbol(se.getSymbol());
    }

    protected void resetPressed() {
        this.setSymbol(null);
    }

    protected void savePressed() {
        Object selected = this.getSelectedObject();
        if (this.getSelectedObject() == null) {
            return;
        }
        final SymbolPreferences preferences = this.manager.getSymbolPreferences();
        JFileChooser jfc = new JFileChooser("SYMBOL_SELECTOR_FILECHOOSER", this.rootDir);
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getAbsolutePath().toLowerCase().endsWith(preferences.getSymbolFileExtension()) || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return Messages.getText((String)"gvSIG_symbol_definition_file").concat(" (*").concat(preferences.getSymbolFileExtension()).concat(")");
            }
        };
        jfc.setFileFilter(ff);
        JPanel accessory = new JPanel(new FlowLayout(3, 5, 5));
        accessory.add(new JLabel(Messages.getText((String)"enter_description")));
        JTextField txtDesc = new JTextField(25);
        if (selected instanceof ISymbol) {
            txtDesc.setText(((ISymbol)selected).getDescription());
        }
        if (selected instanceof ISymbol_v2 && !StringUtils.isEmpty((CharSequence)((ISymbol_v2)selected).getID())) {
            jfc.setSelectedFile(new File(((ISymbol_v2)selected).getID()));
        }
        accessory.add(txtDesc);
        jfc.setAccessory((JComponent)accessory);
        if (jfc.showSaveDialog((Component)this) == 0) {
            String desc;
            String s;
            File targetFile = jfc.getSelectedFile();
            if (txtDesc.getText() == null || txtDesc.getText().trim().equals("")) {
                s = targetFile.getAbsolutePath();
                desc = s.substring(s.lastIndexOf(File.separator) + 1).replaceAll(preferences.getSymbolFileExtension(), "");
            } else {
                desc = txtDesc.getText().trim();
            }
            s = (ISymbol)this.getSelectedObject();
            s.setDescription(desc);
            String symbolFileName = targetFile.getAbsolutePath().substring(targetFile.getAbsolutePath().lastIndexOf(File.separator) + 1, targetFile.getAbsolutePath().length());
            File targetDir = new File(targetFile.getAbsolutePath().substring(0, targetFile.getAbsolutePath().lastIndexOf(File.separator)));
            this.library.addElement(s, symbolFileName, targetDir);
            this.getJListSymbols().setModel(this.newListModel());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.act) {
            return;
        }
        ISymbol selectedElement = this.jPanelPreview.getSymbol();
        this.performActionOn(selectedElement, e);
        this.repaint();
    }

    protected void performActionOn(Object selectedElement, ActionEvent e) {
        JComponent comp = (JComponent)e.getSource();
        if (comp.equals(this.getBtnProperties())) {
            this.propertiesPressed();
        } else if (comp.equals(this.getBtnNewSymbol())) {
            this.newPressed();
        } else if (comp.equals(this.getBtnResetSymbol())) {
            this.resetPressed();
        } else if (comp.equals(this.getBtnSaveSymbol())) {
            this.savePressed();
        } else if (comp.equals(this.jcc1)) {
            if (selectedElement == null) {
                return;
            }
            Color c = this.jcc1.getColor();
            if (selectedElement instanceof IMarkerSymbol) {
                IMarkerSymbol m = (IMarkerSymbol)selectedElement;
                if (m instanceof IMultiLayerMarkerSymbol) {
                    IMultiLayerMarkerSymbol mm = (IMultiLayerMarkerSymbol)m;
                    mm.setAlpha(this.jcc1.getAlpha());
                } else {
                    m.setColor(c);
                }
            }
            if (selectedElement instanceof ILineSymbol) {
                ILineSymbol l = (ILineSymbol)selectedElement;
                if (l instanceof IMultiLayerLineSymbol) {
                    IMultiLayerLineSymbol ml = (IMultiLayerLineSymbol)l;
                    ml.setAlpha(this.jcc1.getAlpha());
                } else {
                    l.setLineColor(c);
                }
            }
            if (selectedElement instanceof IFillSymbol) {
                IFillSymbol f = (IFillSymbol)selectedElement;
                f.setHasFill(this.jcc1.getUseColorisSelected());
                f.setFillColor(c);
            }
            if (selectedElement instanceof ITextSymbol) {
                ITextSymbol t = (ITextSymbol)selectedElement;
                t.setTextColor(c);
            }
        } else if (comp.equals(this.jcc2)) {
            if (selectedElement == null) {
                return;
            }
            Color c = this.jcc2.getColor();
            if (selectedElement instanceof IFillSymbol) {
                IFillSymbol f = (IFillSymbol)selectedElement;
                ILineSymbol outline = f.getOutline();
                f.setHasOutline(this.jcc2.getUseColorisSelected());
                if (outline != null) {
                    ILineSymbol l = outline;
                    if (l instanceof IMultiLayerLineSymbol && c != null) {
                        IMultiLayerLineSymbol ml = (IMultiLayerLineSymbol)l;
                        ml.setAlpha(c.getAlpha());
                    } else {
                        l.setLineColor(c);
                    }
                }
            }
        } else if (comp.equals(this.txtSize)) {
            double s = this.txtSize.getDouble();
            if (selectedElement instanceof IMarkerSymbol) {
                IMarkerSymbol m = (IMarkerSymbol)selectedElement;
                m.setSize(s);
                ISymbol sm = m.getSymbolForSelection();
                if (sm != null && sm instanceof IMarkerSymbol) {
                    ((IMarkerSymbol)sm).setSize(s);
                }
            }
            if (selectedElement instanceof ILineSymbol) {
                ILineSymbol l = (ILineSymbol)selectedElement;
                l.setLineWidth(s);
                ISymbol sl = l.getSymbolForSelection();
                if (sl != null && sl instanceof ILineSymbol) {
                    ((ILineSymbol)sl).setLineWidth(s);
                }
            }
        } else if (comp.equals(this.cmbUnits)) {
            if (selectedElement instanceof CartographicSupport) {
                CartographicSupport cs = (CartographicSupport)selectedElement;
                cs.setUnit(this.cmbUnits.getSelectedUnitIndex());
            }
        } else if (comp.equals(this.cmbReferenceSystem)) {
            if (selectedElement instanceof CartographicSupport) {
                CartographicSupport cs = (CartographicSupport)selectedElement;
                cs.setReferenceSystem(this.cmbReferenceSystem.getSelectedIndex());
            }
        } else if (comp.equals(this.txtWidth)) {
            IFillSymbol f;
            ILineSymbol outline;
            double w = this.txtWidth.getDouble();
            if (selectedElement instanceof IFillSymbol && (outline = (f = (IFillSymbol)selectedElement).getOutline()) != null) {
                outline.setLineWidth(w);
            }
        } else if (comp.equals(this.cmbFontSize)) {
            double s = ((Integer)this.cmbFontSize.getSelectedItem()).doubleValue();
            if (selectedElement instanceof ITextSymbol) {
                ITextSymbol t = (ITextSymbol)selectedElement;
                t.setFontSize(s);
            }
        } else if (comp.equals(this.txtAngle)) {
            double a = Math.toRadians(this.txtAngle.getDouble());
            if (selectedElement instanceof IMarkerSymbol) {
                IMarkerSymbol m = (IMarkerSymbol)selectedElement;
                m.setRotation(a);
            }
        }
    }

    public static ISymbolSelector createSymbolBrowser() {
        return MultiShapeSymbolSelector.createSymbolBrowser();
    }

    public static ISymbolSelector createSymbolSelector(Object currSymbol, int shapeType) {
        return SymbolSelector.createSymbolSelector(currSymbol, shapeType, null);
    }

    public static ISymbolSelector createSymbolSelector(Object currSymbol, int shapeType, SelectorFilter filter) {
        GeometryType geometryType = null;
        try {
            geometryType = geomManager.getGeometryType(shapeType, 0);
        }
        catch (Exception e) {
            logger.error("Impossible to get the geometry type", (Throwable)e);
        }
        JPanel selector = filter == null ? (shapeType == 0 ? new MultiShapeSymbolSelector(currSymbol) : new SymbolSelector(currSymbol, geometryType, true)) : (shapeType == 0 ? new MultiShapeSymbolSelector(currSymbol) : new SymbolSelector(currSymbol, geometryType, filter, true));
        return selector;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    @Override
    public void setFeatureStore(FeatureStore store) {
        this.featureStore = store;
        if (this.featureStore != null) {
            this.sampleFeature.setValue((Object)this.featureStore.getSampleFeature());
        }
    }

    public MutableObject<Feature> getSampleFeature() {
        if (this.sampleFeature == null) {
            this.sampleFeature = new MutableObject();
            if (this.featureStore != null) {
                this.sampleFeature.setValue((Object)this.featureStore.getSampleFeature());
            }
        }
        return this.sampleFeature;
    }

    class SillyDragNDropAction
    implements MouseListener,
    MouseMotionListener {
        private boolean doDrop = false;
        private Object selected;
        private File sourceFolder;

        SillyDragNDropAction() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getSource().equals(SymbolSelector.this.getJListSymbols())) {
                this.selected = SymbolSelector.this.getJListSymbols().getSelectedValue();
                this.doDrop = this.selected != null;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)SymbolSelector.this.libraryBrowser.getLastSelectedPathComponent();
                if (node.getUserObject() instanceof File) {
                    this.sourceFolder = (File)node.getUserObject();
                }
            }
            e.consume();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.doDrop && e.getSource().equals(SymbolSelector.this.getJListSymbols())) {
                Point p = new Point(SymbolSelector.this.getJListSymbols().getLocation().x - e.getPoint().x, SymbolSelector.this.getJListSymbols().getLocation().y + e.getPoint().y);
                if (SymbolSelector.this.libraryBrowser.getBounds().contains(p)) {
                    File destFolder = SymbolSelector.this.libraryBrowser.getElementBellow(p);
                    if (destFolder != null) {
                        ISymbol sym = (ISymbol)this.selected;
                        int move = 1088;
                        SymbolSelector.this.library.addElement(sym, sym.getDescription(), destFolder);
                        if ((e.getModifiers() & move) != 0) {
                            SymbolSelector.this.library.removeElement(sym, this.sourceFolder);
                        }
                    }
                    SymbolSelector.this.libraryBrowser.refresh();
                }
            }
            this.doDrop = false;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (e.getSource().equals(SymbolSelector.this.getJListSymbols())) {
                Point p = new Point(SymbolSelector.this.getJListSymbols().getLocation().x - e.getPoint().x, SymbolSelector.this.getJListSymbols().getLocation().y + e.getPoint().y);
                if (SymbolSelector.this.libraryBrowser.getBounds().contains(p)) {
                    SymbolSelector.this.libraryBrowser.setSelectedElementBellow(p);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

