/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.gui;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.gvsig.app.gui.styling.SymbolPreviewer;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;

public class TableSymbolCellRenderer
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = -1340848936814244749L;
    private Border unselectedBorder = null;
    private Border selectedBorder = null;
    private boolean isBordered = true;
    protected SymbolPreviewer preview = new SymbolPreviewer(true);

    public TableSymbolCellRenderer(boolean isBordered) {
        this.isBordered = isBordered;
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.preview.setSymbol((ISymbol)value);
        if (isSelected) {
            this.preview.setBackground(table.getBackground());
            this.setBackground(table.getBackground());
        }
        if (this.isBordered) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        return this.preview;
    }
}

