/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.swing.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ITextSymbol;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingService;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.CreateEditingBehaviorException;
import org.gvsig.vectorediting.lib.api.exceptions.VectorEditingException;
import org.gvsig.vectorediting.swing.api.EditingContext;
import org.gvsig.vectorediting.swing.api.EditingSwingLocator;
import org.gvsig.vectorediting.swing.api.EditingSwingManager;
import org.gvsig.vectorediting.swing.api.contextmenu.EditingContextMenu;
import org.gvsig.vectorediting.swing.impl.DefaultEditingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEditingBehavior
extends Behavior {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEditingBehavior.class);
    private DefaultEditingContext editingContext;
    private Point adjustedPoint;
    private static final Image imageCursor = new BufferedImage(32, 32, 2);

    public DefaultEditingBehavior(DefaultEditingContext editingContext) throws CreateEditingBehaviorException {
        if (editingContext.getMapControl() != null) {
            this.editingContext = editingContext;
            this.setMapControl(editingContext.getMapControl());
        }
    }

    public ToolListener getListener() {
        return new ToolListener(){

            public boolean cancelDrawing() {
                return false;
            }

            public Image getImageCursor() {
                return imageCursor;
            }
        };
    }

    public void mouseClicked(MouseEvent e) {
        ViewPort vp = this.editingContext.getMapControl().getViewPort();
        EditingServiceParameter currentParam = this.editingContext.getCurrentParam();
        EditingService activeService = this.editingContext.getActiveService();
        if (activeService != null && currentParam != null) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                Set typesOfParam = currentParam.getTypes();
                if (typesOfParam.contains(EditingServiceParameter.TYPE.LIST_POSITIONS) && e.getClickCount() == 2) {
                    this.editingContext.finishService();
                    return;
                }
                Point point = null;
                Point2D point2D = this.getMapControl().getMapAdjustedPoint();
                if (point2D == null) {
                    point2D = this.getMapControl().getAdjustedPoint();
                    point = vp.convertToMapPoint(point2D);
                } else {
                    try {
                        point = GeometryLocator.getGeometryManager().createPoint(point2D.getX(), point2D.getY(), 0);
                    }
                    catch (BaseException ex) {
                        logger.warn("Can't create point geometry from " + point2D.toString());
                    }
                }
                try {
                    this.editingContext.setValue(currentParam, this.ortoPoint(point), true);
                }
                catch (VectorEditingException ex) {
                    I18nManager i18nManager = ToolsLocator.getI18nManager();
                    this.editingContext.showConsoleMessage(i18nManager.getTranslation("invalid_option"));
                }
            } else if (SwingUtilities.isRightMouseButton(e)) {
                EditingSwingManager swingManager = EditingSwingLocator.getSwingManager();
                EditingContextMenu contextMenu = swingManager.getContextualMenu((Component)this.getMapControl(), value -> this.editingContext.textEntered((String)value), currentParam, (EditingContext)this.editingContext);
                contextMenu.show((Component)this.getMapControl(), e.getX(), e.getY());
            }
        }
    }

    private Point ortoPoint(Point point) {
        if (this.editingContext.getDrawMode() == 0) {
            return point;
        }
        Point refPoint = (Point)this.editingContext.getContextSymbolTable().value("$p");
        if (refPoint == null) {
            return point;
        }
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        EuclideanLine2D line = euclideanManager.createLine2D(refPoint.getX(), refPoint.getY(), point.getX(), point.getY());
        double m = line.getSlope();
        Point result = Math.abs(m) <= 1.0 ? GeometryUtils.createPoint((double)point.getX(), (double)refPoint.getY()) : GeometryUtils.createPoint((double)refPoint.getX(), (double)point.getY());
        return result;
    }

    public void mouseEntered(MouseEvent e) throws BehaviorException {
    }

    public void mouseMoved(MouseEvent e) throws BehaviorException {
        ViewPort vp = this.editingContext.getMapControl().getViewPort();
        this.adjustedPoint = vp.convertToMapPoint(e.getX(), e.getY());
    }

    public void mousePressed(MouseEvent e) throws BehaviorException {
    }

    public void mouseReleased(MouseEvent e) throws BehaviorException {
    }

    public void paintComponent(MapControlDrawer mapControlDrawer) {
        super.paintComponent(mapControlDrawer);
        if (this.editingContext.getActiveService() == null || this.adjustedPoint == null) {
            return;
        }
        DrawingStatus helperGeo = null;
        try {
            helperGeo = this.editingContext.getActiveService().getDrawingStatus(this.ortoPoint(this.adjustedPoint));
        }
        catch (VectorEditingException e) {
            logger.info("An error ocurred when draw service geometries", (Throwable)e);
        }
        if (helperGeo != null) {
            for (DrawingStatus.Status status : helperGeo.getStatus()) {
                Geometry geom;
                ISymbol symbol = status.getSymbol();
                if (symbol == null) {
                    symbol = MapControlLocator.getMapControlManager().getAxisReferenceSymbol();
                }
                if (symbol instanceof ITextSymbol) {
                    ((ITextSymbol)symbol).setText(status.getText());
                }
                if ((geom = status.getGeometry()) == null) continue;
                if (geom.getGeometryType().isTypeOf(7)) {
                    MultiPoint multipoint = (MultiPoint)geom;
                    for (Geometry geometry : multipoint) {
                        this.editingContext.getMapControl().getMapControlDrawer().draw(geometry, symbol);
                    }
                    continue;
                }
                this.editingContext.getMapControl().getMapControlDrawer().draw(geom, symbol);
            }
            this.editingContext.notifyDrawingStatus(helperGeo, this.editingContext.getActiveService());
        }
    }

    static {
        Graphics g = imageCursor.getGraphics();
        int size1 = 15;
        int x = 16;
        int y = 16;
        g.setColor(Color.MAGENTA);
        g.drawLine(x - size1, y, x + size1, y);
        g.drawLine(x, y - size1, x, y + size1);
        g.drawRect(x - 6, y - 6, 12, 12);
        g.drawRect(x - 3, y - 3, 6, 6);
    }
}

