/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.swing.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.AbstractManager;
import org.gvsig.tools.service.Service;
import org.gvsig.tools.service.ServiceException;
import org.gvsig.tools.service.spi.ProviderManager;
import org.gvsig.utils.console.ResponseListener;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.swing.api.EditingContext;
import org.gvsig.vectorediting.swing.api.EditingSwingManager;
import org.gvsig.vectorediting.swing.api.JPointPanel;
import org.gvsig.vectorediting.swing.api.console.EditingConsole;
import org.gvsig.vectorediting.swing.api.contextmenu.AcceptValueListener;
import org.gvsig.vectorediting.swing.api.contextmenu.EditingContextMenu;
import org.gvsig.vectorediting.swing.impl.DefaultEditingContext;
import org.gvsig.vectorediting.swing.impl.console.DefaultEditingConsole;
import org.gvsig.vectorediting.swing.impl.contextmenu.DefaultDynamicEditingPointPanel;
import org.gvsig.vectorediting.swing.impl.contextmenu.DefaultEditingContextMenu;

public class DefaultEditingSwingManager
extends AbstractManager
implements EditingSwingManager {
    Map<MapContext, EditingContext> editingContexts = new WeakHashMap<MapContext, EditingContext>();

    public DefaultEditingSwingManager() {
        super((ProviderManager)EditingProviderLocator.getProviderManager());
    }

    public EditingContext getEditingContext(MapControl mapControl) {
        MapContext mapContext = mapControl.getMapContext();
        if (this.editingContexts.containsKey(mapContext)) {
            EditingContext editingContext = this.editingContexts.get(mapContext);
            if (editingContext.getMapControl() != null) {
                return editingContext;
            }
            this.editingContexts.remove(mapContext);
        }
        return null;
    }

    private JPanel getExplanationPanel(String question, String action, String description) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        JPanel resp = new JPanel(new BorderLayout(10, 10));
        JLabel topLabel = new JLabel(question);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints cc = new GridBagConstraints();
        cc.gridx = 0;
        cc.gridy = 0;
        cc.anchor = 17;
        cc.insets = new Insets(3, 6, 3, 6);
        Font boldf = mainPanel.getFont().deriveFont(1);
        JLabel lbl = new JLabel(action);
        lbl.setFont(boldf);
        mainPanel.add((Component)lbl, cc);
        cc.gridx = 1;
        mainPanel.add((Component)new JLabel(description), cc);
        cc.gridx = 0;
        cc.gridy = 1;
        lbl = new JLabel(i18nManager.getTranslation("discard"));
        lbl.setFont(boldf);
        mainPanel.add((Component)lbl, cc);
        cc.gridx = 1;
        mainPanel.add((Component)new JLabel(i18nManager.getTranslation("discard_and_loose_changes")), cc);
        cc.gridx = 0;
        cc.gridy = 2;
        lbl = new JLabel(i18nManager.getTranslation("continue"));
        lbl.setFont(boldf);
        mainPanel.add((Component)lbl, cc);
        cc.gridx = 1;
        mainPanel.add((Component)new JLabel(i18nManager.getTranslation("do_not_save_yet_stay_in_editing_mode")), cc);
        resp.add((Component)mainPanel, "Center");
        resp.add((Component)topLabel, "North");
        return resp;
    }

    public Service getService(DynObject parameters) throws ServiceException {
        return null;
    }

    public void registerEditingContext(MapControl mapControl) {
        MapContext mapContext = mapControl.getMapContext();
        if (!this.editingContexts.containsKey(mapContext)) {
            DefaultEditingContext editingContext = new DefaultEditingContext(mapControl);
            this.editingContexts.put(mapContext, editingContext);
        } else {
            EditingContext editingContext = this.editingContexts.get(mapContext);
            editingContext.setMapControl(mapControl);
        }
    }

    public int showPanelExportOrDiscard(MapControl parent, String name) {
        String firstDesc;
        String firstLabel;
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        Object[] options = new Object[]{i18nManager.getTranslation("export"), "       " + i18nManager.getTranslation("discard") + "       ", i18nManager.getTranslation("continue")};
        String question = i18nManager.getTranslation("can_not_write_layer");
        JPanel explanation_panel = this.getExplanationPanel(question, firstLabel = i18nManager.getTranslation("export"), firstDesc = i18nManager.getTranslation("export_to_another_format"));
        int resp = JOptionPane.showOptionDialog((Component)parent, explanation_panel, i18nManager.getTranslation("end_editing"), 1, 3, null, options, options[2]);
        if (resp == 1) {
            return 1;
        }
        if (resp == 0) {
            return 2;
        }
        return 0;
    }

    public int showPanelSaveOrDiscard(MapControl parent, String name) {
        String firstDesc;
        String firstLabel;
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        Object[] options = new Object[]{i18nManager.getTranslation("save"), "       " + i18nManager.getTranslation("discard") + "       ", i18nManager.getTranslation("continue")};
        String question = i18nManager.getTranslation("ask_save_layer");
        JPanel explanation_panel = this.getExplanationPanel(question = question + " '" + name + "'?", firstLabel = i18nManager.getTranslation("save"), firstDesc = i18nManager.getTranslation("save_changes_performed"));
        int resp = JOptionPane.showOptionDialog((Component)parent, explanation_panel, i18nManager.getTranslation("end_editing"), 1, 3, null, options, options[2]);
        if (resp == 0) {
            return 3;
        }
        if (resp == 1) {
            return 1;
        }
        return 0;
    }

    public EditingContextMenu getContextualMenu(Component parent, AcceptValueListener listener, EditingServiceParameter parameter, EditingContext context) {
        DefaultEditingContextMenu contextMenu = new DefaultEditingContextMenu(parent, listener, parameter, context);
        return contextMenu;
    }

    public EditingConsole getEditingConsole(ResponseListener listener) {
        return new DefaultEditingConsole(listener);
    }

    public EditingConsole getEditingConsole(List<ResponseListener> listeners) {
        return new DefaultEditingConsole(listeners);
    }

    public DynObject createServiceParameters(String serviceName) throws ServiceException {
        return super.createServiceParameters(serviceName);
    }

    public JPointPanel createPointPanel(EditingContext editingContext) {
        return new DefaultDynamicEditingPointPanel(editingContext, null);
    }
}

