/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.swing.impl.contextmenu;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.DataTypeUtils;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PolylineBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PolylineListener;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.vectorediting.lib.api.EditingService;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.swing.api.EditingContext;
import org.gvsig.vectorediting.swing.api.contextmenu.AcceptValueListener;
import org.gvsig.vectorediting.swing.api.contextmenu.EditingContextMenu;
import org.gvsig.vectorediting.swing.impl.contextmenu.DefaultDynamicEditingPointPanel;
import org.gvsig.vectorediting.swing.impl.contextmenu.DefaultEditingValuePanel;
import org.gvsig.vectorediting.swing.impl.contextmenu.DistanceListener;
import org.gvsig.vectorediting.swing.impl.contextmenu.EditingContextMenuView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEditingContextMenu
extends EditingContextMenuView
implements EditingContextMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEditingContextMenu.class);
    private static final long serialVersionUID = -3207749321400180897L;
    private final AcceptValueListener listener;
    private final Component parent;
    private final EditingServiceParameter parameter;
    private final EditingContext context;

    public DefaultEditingContextMenu(Component parent, AcceptValueListener listener, EditingServiceParameter parameter, EditingContext context) {
        this.listener = listener;
        this.parent = parent;
        this.parameter = parameter;
        this.context = context;
        this.initActions();
    }

    private void initActions() {
        EditingService service = this.context.getActiveService();
        List parameters = service.getParameters();
        this.initAction(this.parameter, this.listener);
        this.add(new JSeparator(0));
        boolean thereAreOptionalParameters = false;
        for (EditingServiceParameter param : parameters) {
            if (param.equals(this.parameter) || !param.isOptional() || !service.isEnabled(param)) continue;
            thereAreOptionalParameters = true;
            this.initAction(param, value -> {
                try {
                    if (param.getOptions2() != null) {
                        this.context.setValue(param, value);
                    } else {
                        this.context.setValue(param, (Object)((String)value));
                    }
                    this.context.nextParameter();
                }
                catch (InvalidEntryException ex) {
                    LOGGER.warn("Invalid value", (Throwable)ex);
                }
            });
        }
        if (thereAreOptionalParameters) {
            this.add(new JSeparator(0));
        }
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        AbstractAction action = new AbstractAction(i18nManager.getTranslation("cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultEditingContextMenu.this.listener.acceptValue(null);
            }
        };
        this.add(action);
        ((JComponent)this.parent).add(this);
    }

    private void initAction(final EditingServiceParameter param, final AcceptValueListener listener) {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        for (EditingServiceParameter.TYPE type : param.getTypes()) {
            switch (type) {
                case OPTION: {
                    AbstractAction action;
                    JMenu submenu = null;
                    if (param != this.parameter) {
                        EditingService service = this.context.getActiveService();
                        Iterator value = service.getValue(param);
                        StringBuilder builder = new StringBuilder();
                        builder.append(i18nManager.getTranslation(param.getName()));
                        if (value != null) {
                            try {
                                builder.append(" (");
                                EditingServiceParameterOptions opts = param.getOptions2();
                                if (opts != null) {
                                    builder.append(i18nManager.getTranslation(opts.getLabel(value)));
                                } else {
                                    builder.append(i18nManager.getTranslation((String)DataTypeUtils.coerce((int)8, value)));
                                }
                                builder.append(")");
                            }
                            catch (CoercionException ex) {
                                LOGGER.warn("Can't coerce '" + Objects.toString(value) + "' to String", (Throwable)ex);
                            }
                        }
                        submenu = new JMenu(builder.toString());
                    }
                    Map options = param.getOptions();
                    if (param.getOptions() == null) {
                        for (final EditingServiceParameterOptions.ParameterOption option : param.getOptions2()) {
                            String label = i18nManager.getTranslation(option.getLabel());
                            action = new AbstractAction(label){
                                EditingServiceParameterOptions.ParameterOption opt;
                                {
                                    super(x0);
                                    this.opt = option;
                                }

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    listener.acceptValue((Object)this.opt.getConsoleValue());
                                }
                            };
                            if (submenu != null) {
                                submenu.add(action);
                                continue;
                            }
                            this.add(action);
                        }
                    } else {
                        for (String key : options.keySet()) {
                            String value = i18nManager.getTranslation((String)options.get(key));
                            action = new AbstractAction(value){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    String key = (String)this.getValue("key");
                                    listener.acceptValue((Object)key);
                                }
                            };
                            action.putValue("key", key);
                            if (submenu != null) {
                                submenu.add(action);
                                continue;
                            }
                            this.add(action);
                        }
                    }
                    if (submenu == null) break;
                    this.add(submenu);
                    break;
                }
                case VALUE: {
                    String name = i18nManager.getTranslation(param.getName()) + " (" + i18nManager.getTranslation("value") + ")";
                    AbstractAction action = new AbstractAction(name){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String value = DefaultEditingContextMenu.this.showValueDialog(param);
                            if (StringUtils.isNotEmpty((CharSequence)value)) {
                                listener.acceptValue((Object)value);
                            }
                        }
                    };
                    this.add(action);
                    break;
                }
                case POSITION: 
                case LIST_POSITIONS: {
                    String name = i18nManager.getTranslation(param.getName()) + " (" + i18nManager.getTranslation("point") + ")";
                    AbstractAction action = new AbstractAction(name){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            String value = DefaultEditingContextMenu.this.showPointDialog(param);
                            if (value != null) {
                                listener.acceptValue((Object)value);
                            }
                        }
                    };
                    this.add(action);
                    break;
                }
                case DISTANCE: {
                    String name = i18nManager.getTranslation(param.getName()) + " (" + i18nManager.getTranslation("_graphic_distance") + ")";
                    final MapControl mapCtrl = this.context.getMapControl();
                    String currentTool = mapCtrl.getCurrentTool();
                    DistanceListener mli = new DistanceListener(mapCtrl, listener);
                    PolylineBehavior polylineBehavior = new PolylineBehavior((PolylineListener)mli);
                    mapCtrl.addBehavior("distance", (Behavior)polylineBehavior);
                    AbstractAction action = new AbstractAction(name){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            mapCtrl.setTool("distance");
                        }
                    };
                    this.add(action);
                    break;
                }
            }
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    private String showPointDialog(EditingServiceParameter parameter) {
        GeometryType geomType = this.context.getGeometryType();
        Object defaultValue = parameter.getDefaultValue();
        Point defaultPoint = null;
        if (defaultValue instanceof Point) {
            defaultPoint = (Point)defaultValue;
        }
        DefaultDynamicEditingPointPanel pointPanel = new DefaultDynamicEditingPointPanel(this.context, defaultPoint);
        if (defaultPoint != null) {
            for (int i = 0; i < defaultPoint.getDimension(); ++i) {
                pointPanel.setValue(i, String.valueOf(defaultPoint.getCoordinateAt(i)));
            }
        }
        String title = ToolsLocator.getI18nManager().getTranslation(parameter.getName());
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = winmanager.createDialog((JComponent)pointPanel, title, null, 3);
        dialog.show(WindowManager.MODE.DIALOG);
        if (dialog.getAction() == 1) {
            StringBuilder stb = new StringBuilder();
            for (int i = 0; i < geomType.getDimension(); ++i) {
                String value = pointPanel.getValue(i);
                stb.append(value);
                if (i >= geomType.getDimension() - 1) continue;
                stb.append(",");
            }
            return stb.toString();
        }
        return null;
    }

    private String showValueDialog(EditingServiceParameter parameter) {
        DefaultEditingValuePanel valuePanel = new DefaultEditingValuePanel();
        String title = ToolsLocator.getI18nManager().getTranslation(parameter.getName());
        WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog dialog = winmanager.createDialog((JComponent)valuePanel, title, null, 3);
        dialog.show(WindowManager.MODE.DIALOG);
        if (dialog.getAction() == 1) {
            return valuePanel.getValue();
        }
        return null;
    }
}

