/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.combine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.complex.Complex;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class CombineEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private static final int HAS_POINT = 1;
    private static final int HAS_CURVE = 2;
    private static final int HAS_SURFACE = 4;
    private final EditingServiceParameter selectionParameter;
    private final FeatureStore featureStore;
    private FeatureSelection featureSelection;

    public CombineEditingProvider(DynObject parameters, ProviderServices services) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selectionParameter = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
    }

    public EditingServiceParameter next() {
        if (this.featureSelection == null) {
            return this.selectionParameter;
        }
        return null;
    }

    public boolean mustRestartAtFinish() {
        return false;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        return null;
    }

    public void stop() throws StopServiceException {
        DisposeUtils.disposeQuietly((Disposable)this.featureSelection);
        this.featureSelection = null;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selectionParameter);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        FeatureSelection fSelection;
        if (parameter == this.selectionParameter && value instanceof FeatureSelection && (fSelection = (FeatureSelection)value).getSelectedCount() > 1L) {
            DisposableIterator it = null;
            try {
                it = fSelection.fastIterator();
                Feature feature = (Feature)it.next();
                GeometryType geometryType = feature.getDefaultGeometry().getGeometryType();
                while (it.hasNext()) {
                    GeometryType featureGeoType;
                    feature = (Feature)it.next();
                    if (!(geometryType.isTypeOf(2) || geometryType.isTypeOf(8) ? !(featureGeoType = feature.getDefaultGeometry().getGeometryType()).isTypeOf(2) && !featureGeoType.isTypeOf(8) : (geometryType.isTypeOf(3) || geometryType.isTypeOf(3)) && !(featureGeoType = feature.getDefaultGeometry().getGeometryType()).isTypeOf(3) && !featureGeoType.isTypeOf(9))) continue;
                    throw new InvalidEntryException(null);
                }
                DisposeUtils.disposeQuietly((Disposable)this.featureSelection);
                ToolsLocator.getDisposableManager().bind((Disposable)fSelection);
                this.featureSelection = fSelection;
                return;
            }
            catch (DataException e) {
                throw new InvalidEntryException((Throwable)e);
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)it);
            }
        }
        throw new InvalidEntryException(null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Geometry finish() throws FinishServiceException {
        DisposableIterator it;
        Geometry combinedGeometry;
        block28: {
            if (this.featureSelection == null) return null;
            combinedGeometry = null;
            it = null;
            EditingProviderServices editingProviderServices = this.getProviderServices();
            int resultType = 0;
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                MultiPoint multiPoint = geometryManager.createMultiPoint(subtype);
                MultiCurve multiCurve = geometryManager.createMultiCurve(subtype);
                MultiSurface multiSurface = geometryManager.createMultiSurface(subtype);
                it = this.featureSelection.fastIterator();
                while (it.hasNext()) {
                    Feature tmpFeature = (Feature)it.next();
                    Geometry geom = tmpFeature.getDefaultGeometry();
                    if (geom.getGeometryType().isTypeOf(1) || geom.getGeometryType().isTypeOf(7)) {
                        multiPoint.addPrimitives(geom);
                        resultType |= 1;
                        continue;
                    }
                    if (geom.getGeometryType().isTypeOf(2) || geom.getGeometryType().isTypeOf(8)) {
                        multiCurve.addPrimitives(geom);
                        resultType |= 2;
                        continue;
                    }
                    if (geom.getGeometryType().isTypeOf(3) || geom.getGeometryType().isTypeOf(9)) {
                        multiSurface.addPrimitives(geom);
                        resultType |= 4;
                        continue;
                    }
                    if (!geom.getGeometryType().isTypeOf(17)) continue;
                    Complex complex = (Complex)geom;
                    for (Geometry geom1 : complex) {
                        if (geom1.getGeometryType().isTypeOf(1) || geom1.getGeometryType().isTypeOf(7)) {
                            multiPoint.addPrimitives(geom1);
                            resultType |= 1;
                            continue;
                        }
                        if (geom1.getGeometryType().isTypeOf(2) || geom1.getGeometryType().isTypeOf(8)) {
                            multiCurve.addPrimitives(geom1);
                            resultType |= 2;
                            continue;
                        }
                        if (!geom1.getGeometryType().isTypeOf(3) && !geom1.getGeometryType().isTypeOf(9)) continue;
                        multiSurface.addPrimitives(geom1);
                        resultType |= 4;
                    }
                }
                GeometryType storeGeomType = editingProviderServices.getGeomType(this.featureStore);
                if (resultType > 4 || resultType == 3) {
                    if (storeGeomType.getType() != 17 && storeGeomType.getType() != 0) {
                        throw new FinishServiceException("_The_resulting_geometry_is_not_valid_for_the_store", null);
                    }
                    combinedGeometry = geometryManager.create(17, subtype);
                    Complex complex = (Complex)combinedGeometry;
                    if ((resultType & 1) == 1) {
                        complex.addPrimitives(multiPoint.union());
                        break block28;
                    }
                    if ((resultType & 2) == 2) {
                        complex.addPrimitives(multiCurve.dissolve());
                        break block28;
                    }
                    if ((resultType & 4) == 4) {
                        complex.addPrimitives(multiSurface.union());
                    }
                    break block28;
                }
                switch (resultType) {
                    case 1: {
                        if (!(storeGeomType.isTypeOf(0) || storeGeomType.isTypeOf(1) || storeGeomType.isTypeOf(7))) {
                            throw new FinishServiceException("The resulting geometry is not valid for the store.", "_The_resulting_geometry_is_not_valid_for_the_store", null);
                        }
                        combinedGeometry = multiPoint.union();
                        if (storeGeomType.isTypeOf(1) && combinedGeometry.getGeometryType().isTypeOf(7)) {
                            throw new FinishServiceException("The resulting geometry is not valid for the store.", "_The_resulting_geometry_is_not_valid_for_the_store", null);
                        }
                        if (!storeGeomType.isTypeOf(7) || !combinedGeometry.getGeometryType().isTypeOf(1)) break;
                        MultiPoint tmpMultiPoint = geometryManager.createMultiPoint(subtype);
                        tmpMultiPoint.addPrimitives(combinedGeometry);
                        combinedGeometry = tmpMultiPoint;
                        break;
                    }
                    case 2: {
                        if (!(storeGeomType.isTypeOf(0) || storeGeomType.isTypeOf(2) || storeGeomType.isTypeOf(8))) {
                            throw new FinishServiceException("The resulting geometry is not valid for the store.", "_The_resulting_geometry_is_not_valid_for_the_store", null);
                        }
                        combinedGeometry = multiCurve.dissolve();
                        if (storeGeomType.isTypeOf(2) && combinedGeometry.getGeometryType().isTypeOf(8)) {
                            throw new FinishServiceException("The resulting geometry is not valid for the store.", "_The_resulting_geometry_is_not_valid_for_the_store", null);
                        }
                        if (!storeGeomType.isTypeOf(8) || !combinedGeometry.getGeometryType().isTypeOf(2)) break;
                        MultiCurve tmpMultiCurve = geometryManager.createMultiCurve(subtype);
                        tmpMultiCurve.addPrimitives(combinedGeometry);
                        combinedGeometry = tmpMultiCurve;
                        break;
                    }
                    case 4: {
                        if (!(storeGeomType.isTypeOf(0) || storeGeomType.isTypeOf(3) || storeGeomType.isTypeOf(9))) {
                            throw new FinishServiceException("The resulting geometry is not valid for the store.", "_The_resulting_geometry_is_not_valid_for_the_store", null);
                        }
                        combinedGeometry = multiSurface.union();
                        if (storeGeomType.isTypeOf(3) && combinedGeometry.getGeometryType().isTypeOf(9)) {
                            throw new FinishServiceException("The resulting geometry is not valid for the store.", "_The_resulting_geometry_is_not_valid_for_the_store", null);
                        }
                        if (!storeGeomType.isTypeOf(9) || !combinedGeometry.getGeometryType().isTypeOf(3)) break;
                        MultiSurface tmpMultiSurface = geometryManager.createMultiSurface(subtype);
                        tmpMultiSurface.addPrimitives(combinedGeometry);
                        combinedGeometry = tmpMultiSurface;
                        break;
                    }
                }
            }
            catch (FinishServiceException e) {
                try {
                    throw e;
                    catch (BaseException e2) {
                        throw new FinishServiceException((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(it);
                    throw throwable;
                }
            }
        }
        DisposeUtils.disposeQuietly((Disposable)it);
        return combinedGeometry;
    }

    public void finishAndStore() throws FinishServiceException {
        Geometry geometry = this.finish();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        FeatureType featureType = null;
        EditableFeature eFeature = null;
        try {
            eFeature = this.featureStore.createNewFeature();
            featureType = this.featureStore.getDefaultFeatureType();
        }
        catch (DataException e) {
            throw new FinishServiceException((Throwable)e);
        }
        Iterator typeIterator = featureType.iterator();
        while (typeIterator.hasNext()) {
            boolean insertValue = true;
            FeatureAttributeDescriptor attribute = (FeatureAttributeDescriptor)typeIterator.next();
            if (attribute.isPrimaryKey()) continue;
            DisposableIterator featureIterator = null;
            try {
                featureIterator = this.featureSelection.fastIterator();
                Feature feature = (Feature)featureIterator.next();
                featureIterator.dispose();
                featureIterator = this.featureSelection.fastIterator(1L);
                Object value = feature.get(attribute.getName());
                if (value == null) continue;
                while (featureIterator.hasNext()) {
                    Feature nextFeature = (Feature)featureIterator.next();
                    Object nextValue = nextFeature.get(attribute.getName());
                    if (nextValue != null && value.equals(nextValue)) continue;
                    insertValue = false;
                    break;
                }
                if (!insertValue) continue;
                eFeature.set(attribute.getName(), value);
            }
            catch (DataException e) {
                throw new FinishServiceException((Throwable)e);
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)featureIterator);
            }
        }
        eFeature.setDefaultGeometry(geometry);
        editingProviderServices.insertFeatureIntoFeatureStore((Feature)eFeature, this.featureStore);
        try {
            this.featureSelection.accept(obj -> {
                Feature feature = (Feature)obj;
                editingProviderServices.deleteFeatureFromFeatureStore(feature, this.featureStore);
            });
            this.featureStore.getFeatureSelection().deselectAll();
        }
        catch (BaseException e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    public void start() throws StartServiceException, InvalidEntryException {
        FeatureSelection selected = null;
        if (this.featureStore != null) {
            try {
                selected = this.featureStore.getFeatureSelection();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            if (selected.getSelectedCount() > 1L) {
                try {
                    this.setValue(selected);
                }
                catch (InvalidEntryException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        }
    }

    public String getName() {
        return "modify-combine";
    }

    public Object getValue(EditingServiceParameter parameter) {
        if (parameter == this.selectionParameter) {
            return this.featureSelection;
        }
        return null;
    }
}

