/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.join;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class JoinEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter selectionParameter;
    private final FeatureStore featureStore;
    private FeatureSelection featureSelection;

    public JoinEditingProvider(DynObject parameters, ProviderServices services) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selectionParameter = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
    }

    public EditingServiceParameter next() {
        if (this.featureSelection == null) {
            return this.selectionParameter;
        }
        return null;
    }

    public boolean mustRestartAtFinish() {
        return false;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        return null;
    }

    public void stop() throws StopServiceException {
        DisposeUtils.disposeQuietly((Disposable)this.featureSelection);
        this.featureSelection = null;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selectionParameter);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        FeatureSelection fSelection;
        if (parameter == this.selectionParameter && value instanceof FeatureSelection && (fSelection = (FeatureSelection)value).getSelectedCount() > 1L) {
            DisposableIterator it = null;
            try {
                it = fSelection.fastIterator();
                Feature feature = (Feature)it.next();
                GeometryType geometryType = feature.getDefaultGeometry().getGeometryType();
                while (it.hasNext()) {
                    GeometryType featureGeoType;
                    feature = (Feature)it.next();
                    if (!(geometryType.isTypeOf(2) || geometryType.isTypeOf(8) ? !(featureGeoType = feature.getDefaultGeometry().getGeometryType()).isTypeOf(2) && !featureGeoType.isTypeOf(8) : (geometryType.isTypeOf(3) || geometryType.isTypeOf(3)) && !(featureGeoType = feature.getDefaultGeometry().getGeometryType()).isTypeOf(3) && !featureGeoType.isTypeOf(9))) continue;
                    throw new InvalidEntryException(null);
                }
                DisposeUtils.disposeQuietly((Disposable)this.featureSelection);
                ToolsLocator.getDisposableManager().bind((Disposable)fSelection);
                this.featureSelection = fSelection;
                return;
            }
            catch (DataException e) {
                throw new InvalidEntryException((Throwable)e);
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)it);
            }
        }
        throw new InvalidEntryException(null);
    }

    public Geometry finish() throws FinishServiceException {
        if (this.featureSelection != null) {
            Geometry joinedGeometry;
            DisposableIterator it = null;
            try {
                it = this.featureSelection.fastIterator();
                Feature feature = (Feature)it.next();
                joinedGeometry = feature.getDefaultGeometry();
                while (it.hasNext()) {
                    Feature tmpFeature = (Feature)it.next();
                    joinedGeometry = joinedGeometry.union(tmpFeature.getDefaultGeometry());
                }
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)it);
            }
            return joinedGeometry;
        }
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        Geometry geometry = this.finish();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        FeatureType featureType = null;
        EditableFeature eFeature = null;
        try {
            eFeature = this.featureStore.createNewFeature();
            featureType = this.featureStore.getDefaultFeatureType();
        }
        catch (DataException e) {
            throw new FinishServiceException((Throwable)e);
        }
        Iterator typeIterator = featureType.iterator();
        while (typeIterator.hasNext()) {
            boolean insertValue = true;
            FeatureAttributeDescriptor attribute = (FeatureAttributeDescriptor)typeIterator.next();
            if (attribute.isPrimaryKey()) continue;
            DisposableIterator featureIterator = null;
            try {
                featureIterator = this.featureSelection.fastIterator();
                Feature feature = (Feature)featureIterator.next();
                featureIterator.dispose();
                featureIterator = this.featureSelection.fastIterator(1L);
                Object value = feature.get(attribute.getName());
                if (value == null) continue;
                while (featureIterator.hasNext()) {
                    Feature nextFeature = (Feature)featureIterator.next();
                    Object nextValue = nextFeature.get(attribute.getName());
                    if (nextValue != null && value.equals(nextValue)) continue;
                    insertValue = false;
                    break;
                }
                if (!insertValue) continue;
                eFeature.set(attribute.getName(), value);
            }
            catch (DataException e) {
                throw new FinishServiceException((Throwable)e);
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)featureIterator);
            }
        }
        eFeature.setDefaultGeometry(geometry);
        editingProviderServices.insertFeatureIntoFeatureStore((Feature)eFeature, this.featureStore);
        try {
            this.featureSelection.accept(obj -> {
                Feature feature = (Feature)obj;
                editingProviderServices.deleteFeatureFromFeatureStore(feature, this.featureStore);
            });
            this.featureStore.getFeatureSelection().deselectAll();
        }
        catch (BaseException e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    public void start() throws StartServiceException, InvalidEntryException {
        FeatureSelection selected = null;
        if (this.featureStore != null) {
            try {
                selected = this.featureStore.getFeatureSelection();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            if (selected.getSelectedCount() > 1L) {
                try {
                    this.setValue(selected);
                }
                catch (InvalidEntryException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        }
    }

    public String getName() {
        return "modify-join";
    }

    public Object getValue(EditingServiceParameter parameter) {
        if (parameter == this.selectionParameter) {
            return this.featureSelection;
        }
        return null;
    }
}

