/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.daltransform.swing.impl;

import java.awt.Color;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.daltransform.swing.JDataTransformList;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreTransform;
import org.gvsig.fmap.dal.feature.FeatureStoreTransforms;

public class DefaultJDataTransformList
extends JDataTransformList {
    private static final long serialVersionUID = 3179282558802329381L;
    private FeatureStore store;
    private JList l;
    DefaultListModel model;

    public DefaultJDataTransformList(FeatureStore store) {
        this.store = store;
        this.createComponents();
    }

    private void createComponents() {
        FeatureStoreTransforms transforms = this.store.getTransforms();
        this.model = new DefaultListModel();
        for (int i = 0; i < transforms.size(); ++i) {
            this.model.addElement(new ItemData(transforms.getTransform(i)));
        }
        this.l = new JList(this.model);
        this.l.setSelectionMode(0);
        this.add(this.l);
        this.setBackground(Color.WHITE);
    }

    @Override
    public void addListSelectionListener(ListSelectionListener actionListener) {
        this.l.addListSelectionListener(new ListSelectionListenerWrapper(this, actionListener));
    }

    @Override
    public FeatureStoreTransform getSelected() {
        if (this.l != null && this.l.getSelectedValue() != null) {
            return ((ItemData)this.l.getSelectedValue()).getTransform();
        }
        return null;
    }

    @Override
    public void remove(FeatureStoreTransform transform) {
        this.store.getTransforms().remove(transform);
        this.model.removeElement(new ItemData(transform));
    }

    @Override
    public void addTransforms(FeatureStoreTransforms transforms) {
        for (int i = 0; i < transforms.size(); ++i) {
            this.model.addElement(new ItemData(transforms.getTransform(i)));
        }
    }

    @Override
    public void removeAllTransforms() {
        this.model.removeAllElements();
    }

    @Override
    public void changeStore(FeatureStore featureStore) {
        this.store = featureStore;
    }

    @Override
    public int getTransformsCount() {
        return this.model.getSize();
    }

    @Override
    public boolean isLastTransform(FeatureStoreTransform selectedTransform) {
        ItemData selectedTransformItem = new ItemData(selectedTransform);
        ItemData lastTransformItem = (ItemData)this.model.get(this.model.size() - 1);
        return selectedTransformItem.equals(lastTransformItem);
    }

    @Override
    public int getSelectedIndex() {
        return this.l.getSelectedIndex();
    }

    private class ItemData {
        public FeatureStoreTransform transform;

        ItemData(FeatureStoreTransform transform) {
            this.transform = transform;
        }

        public String toString() {
            return this.transform.getName();
        }

        public FeatureStoreTransform getTransform() {
            return this.transform;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ItemData)) {
                return false;
            }
            return this.transform.equals(((ItemData)obj).transform);
        }
    }

    private class ListSelectionEventWrapper
    extends ListSelectionEvent {
        private static final long serialVersionUID = -8159225017709144435L;

        public ListSelectionEventWrapper(ListSelectionEvent e, DefaultJDataTransformList transformList) {
            super(transformList, e.getFirstIndex(), e.getLastIndex(), e.getValueIsAdjusting());
        }
    }

    private class ListSelectionListenerWrapper
    implements ListSelectionListener {
        private DefaultJDataTransformList list;
        private ListSelectionListener listListener;

        public ListSelectionListenerWrapper(DefaultJDataTransformList list, ListSelectionListener listListener) {
            this.list = list;
            this.listListener = listListener;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.listListener.valueChanged(new ListSelectionEventWrapper(e, this.list));
        }
    }
}

