/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.daltransform.swing.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.daltransform.DataTransformLocator;
import org.gvsig.daltransform.swing.JDataTransformList;
import org.gvsig.daltransform.swing.JDialogDataTransformList;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureStoreTransforms;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.usability.UsabilitySwingManager;

public class DefaultJDialogDataTransformList
extends JDialogDataTransformList {
    private static final long serialVersionUID = 8666781163497235054L;
    private JDataTransformList transforms = null;
    private JButton botonEliminar;
    private JButton botonCerrar;
    private JComboBox comboBox;

    public DefaultJDialogDataTransformList() {
        this.initComponents();
        this.createGUI();
    }

    private void initComponents() {
        MyComboBoxModel comboModel = new MyComboBoxModel(this.getAllStores());
        this.comboBox = new JComboBox(comboModel);
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox jcmbType = (JComboBox)e.getSource();
                MyComboBoxModel model = (MyComboBoxModel)jcmbType.getModel();
                DefaultJDialogDataTransformList.this.updatePanel(model.getSelected().getStore());
            }
        });
        if (comboModel.getSize() > 0) {
            this.transforms = DataTransformLocator.getDataTransformManager().createJDataTransformList(comboModel.get(0).getStore());
            comboModel.setSelectedItem(comboModel.get(0));
        }
        if (this.transforms != null) {
            this.transforms.addListSelectionListener(new ListSelectionHandler());
        }
    }

    private List<MyComboBoxItem> getAllStores() {
        ArrayList<MyComboBoxItem> stores = new ArrayList<MyComboBoxItem>();
        ApplicationManager application = ApplicationLocator.getManager();
        Project project = application.getCurrentProject();
        List views = project.getDocuments(ViewManager.TYPENAME);
        for (Document doc : views) {
            ViewDocument viewDocument = (ViewDocument)doc;
            FLayer[] layers = viewDocument.getMapContext().getLayers().getVisibles();
            if (layers.length <= 1) continue;
            for (int i = 1; i < layers.length; ++i) {
                if (!(layers[i] instanceof FLyrVect)) continue;
                FLyrVect layer = (FLyrVect)layers[i];
                stores.add(new MyComboBoxItem(layer.getName(), layer.getFeatureStore()));
            }
        }
        List tables = project.getDocuments(TableManager.TYPENAME);
        for (Document doc : tables) {
            TableDocument tableDocument = (TableDocument)doc;
            stores.add(new MyComboBoxItem(doc.getName(), tableDocument.getStore()));
        }
        return stores;
    }

    private void createGUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(15, 15, 15, 15));
        UsabilitySwingManager usabilitymanager = ToolsSwingLocator.getUsabilitySwingManager();
        JLabel layerText = new JLabel(Messages.getText((String)"select_layer"));
        JLabel transformText = new JLabel(Messages.getText((String)"select_transform"));
        JPanel botones = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)layerText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.comboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 2, 5, 2);
        this.add((Component)transformText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        if (this.transforms != null) {
            JScrollPane scroller = new JScrollPane(this.transforms);
            this.add((Component)scroller, gridBagConstraints);
        } else {
            JPanel emptyPanel = new JPanel();
            this.add((Component)emptyPanel, gridBagConstraints);
        }
        botones.setLayout(new FlowLayout(2, 5, 0));
        this.botonCerrar = usabilitymanager.createJButton((Action)new ActionClose(this));
        this.botonCerrar.setText(Messages.getText((String)"close"));
        this.botonEliminar = usabilitymanager.createJButton((Action)new ActionRemove(this));
        this.botonEliminar.setText(Messages.getText((String)"remove"));
        botones.add(this.botonEliminar);
        botones.add(this.botonCerrar);
        this.botonEliminar.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 2, 2, 2);
        this.add((Component)botones, gridBagConstraints);
        this.botonEliminar.setEnabled(false);
        this.updatePanel(null);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(250, 300);
    }

    private void updatePanel(FeatureStore store) {
        if (this.transforms != null) {
            if (store != null) {
                FeatureStoreTransforms layerTransforms = store.getTransforms();
                this.transforms.changeStore(store);
                this.transforms.removeAllTransforms();
                this.transforms.addTransforms(layerTransforms);
            }
            if (this.transforms.getSelected() != null) {
                this.botonEliminar.setEnabled(this.transforms.getTransformsCount() > 0);
            }
        } else {
            this.botonEliminar.setEnabled(false);
        }
    }

    @Override
    public void setDeleteButton(boolean active) {
        this.botonEliminar.setEnabled(active);
    }

    private class ActionClose
    implements Action {
        private DefaultJDialogDataTransformList parent;

        public ActionClose(DefaultJDialogDataTransformList parent) {
            this.parent = parent;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public Object getValue(String key) {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parent.setVisible(false);
        }
    }

    private class ActionRemove
    implements Action {
        private DefaultJDialogDataTransformList parent;

        public ActionRemove(DefaultJDialogDataTransformList parent) {
            this.parent = parent;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public Object getValue(String key) {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.parent.transforms.getSelected() != null) {
                this.parent.transforms.remove(this.parent.transforms.getSelected());
            }
            DefaultJDialogDataTransformList.this.updatePanel(null);
        }
    }

    class ListSelectionHandler
    implements ListSelectionListener {
        ListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (DefaultJDialogDataTransformList.this.transforms != null && DefaultJDialogDataTransformList.this.transforms.getSelected() != null && DefaultJDialogDataTransformList.this.transforms.isLastTransform(DefaultJDialogDataTransformList.this.transforms.getSelected())) {
                DefaultJDialogDataTransformList.this.botonEliminar.setEnabled(true);
                return;
            }
            DefaultJDialogDataTransformList.this.botonEliminar.setEnabled(false);
        }
    }

    private class MyComboBoxModel
    implements ComboBoxModel {
        private List<MyComboBoxItem> items = new ArrayList<MyComboBoxItem>();
        private MyComboBoxItem selected = null;

        public MyComboBoxModel(List<MyComboBoxItem> items) {
            this.items.addAll(items);
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        public MyComboBoxItem getSelected() {
            return this.selected;
        }

        @Override
        public void setSelectedItem(Object arg0) {
            this.selected = (MyComboBoxItem)arg0;
        }

        @Override
        public Object getElementAt(int arg0) {
            return this.items.get(arg0);
        }

        public MyComboBoxItem get(int arg0) {
            return this.items.get(arg0);
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        public void removeListDataListener(ListDataListener arg0) {
        }

        @Override
        public void addListDataListener(ListDataListener arg0) {
        }
    }

    private class MyComboBoxItem {
        private String label;
        private FeatureStore store;

        MyComboBoxItem(String label, FeatureStore store) {
            this.label = label;
            this.store = store;
        }

        public String toString() {
            return this.label;
        }

        public FeatureStore getStore() {
            return this.store;
        }
    }
}

